/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters results based on entity metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filters implements SdkPojo, Serializable, ToCopyableBuilder<Filters.Builder, Filters> {
    private static final SdkField<List<String>> TEXT_LOCALES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TextLocales")
            .getter(getter(Filters::textLocalesAsStrings))
            .setter(setter(Builder::textLocalesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextLocales").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONTENT_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContentCategories")
            .getter(getter(Filters::contentCategoriesAsStrings))
            .setter(setter(Builder::contentCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(Filters::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(Filters::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SearchPrincipalType>> PRINCIPALS_FIELD = SdkField
            .<List<SearchPrincipalType>> builder(MarshallingType.LIST)
            .memberName("Principals")
            .getter(getter(Filters::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchPrincipalType> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchPrincipalType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ANCESTOR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AncestorIds")
            .getter(getter(Filters::ancestorIds))
            .setter(setter(Builder::ancestorIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AncestorIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SEARCH_COLLECTION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SearchCollectionTypes")
            .getter(getter(Filters::searchCollectionTypesAsStrings))
            .setter(setter(Builder::searchCollectionTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCollectionTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LongRangeType> SIZE_RANGE_FIELD = SdkField.<LongRangeType> builder(MarshallingType.SDK_POJO)
            .memberName("SizeRange").getter(getter(Filters::sizeRange)).setter(setter(Builder::sizeRange))
            .constructor(LongRangeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeRange").build()).build();

    private static final SdkField<DateRangeType> CREATED_RANGE_FIELD = SdkField.<DateRangeType> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedRange").getter(getter(Filters::createdRange)).setter(setter(Builder::createdRange))
            .constructor(DateRangeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedRange").build()).build();

    private static final SdkField<DateRangeType> MODIFIED_RANGE_FIELD = SdkField
            .<DateRangeType> builder(MarshallingType.SDK_POJO).memberName("ModifiedRange").getter(getter(Filters::modifiedRange))
            .setter(setter(Builder::modifiedRange)).constructor(DateRangeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_LOCALES_FIELD,
            CONTENT_CATEGORIES_FIELD, RESOURCE_TYPES_FIELD, LABELS_FIELD, PRINCIPALS_FIELD, ANCESTOR_IDS_FIELD,
            SEARCH_COLLECTION_TYPES_FIELD, SIZE_RANGE_FIELD, CREATED_RANGE_FIELD, MODIFIED_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> textLocales;

    private final List<String> contentCategories;

    private final List<String> resourceTypes;

    private final List<String> labels;

    private final List<SearchPrincipalType> principals;

    private final List<String> ancestorIds;

    private final List<String> searchCollectionTypes;

    private final LongRangeType sizeRange;

    private final DateRangeType createdRange;

    private final DateRangeType modifiedRange;

    private Filters(BuilderImpl builder) {
        this.textLocales = builder.textLocales;
        this.contentCategories = builder.contentCategories;
        this.resourceTypes = builder.resourceTypes;
        this.labels = builder.labels;
        this.principals = builder.principals;
        this.ancestorIds = builder.ancestorIds;
        this.searchCollectionTypes = builder.searchCollectionTypes;
        this.sizeRange = builder.sizeRange;
        this.createdRange = builder.createdRange;
        this.modifiedRange = builder.modifiedRange;
    }

    /**
     * <p>
     * Filters by the locale of the content or comment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextLocales} method.
     * </p>
     * 
     * @return Filters by the locale of the content or comment.
     */
    public final List<LanguageCodeType> textLocales() {
        return TextLocaleTypeListCopier.copyStringToEnum(textLocales);
    }

    /**
     * For responses, this returns true if the service returned a value for the TextLocales property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTextLocales() {
        return textLocales != null && !(textLocales instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters by the locale of the content or comment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextLocales} method.
     * </p>
     * 
     * @return Filters by the locale of the content or comment.
     */
    public final List<String> textLocalesAsStrings() {
        return textLocales;
    }

    /**
     * <p>
     * Filters by content category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContentCategories} method.
     * </p>
     * 
     * @return Filters by content category.
     */
    public final List<ContentCategoryType> contentCategories() {
        return SearchContentCategoryTypeListCopier.copyStringToEnum(contentCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the ContentCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContentCategories() {
        return contentCategories != null && !(contentCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters by content category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContentCategories} method.
     * </p>
     * 
     * @return Filters by content category.
     */
    public final List<String> contentCategoriesAsStrings() {
        return contentCategories;
    }

    /**
     * <p>
     * Filters based on entity type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return Filters based on entity type.
     */
    public final List<SearchResourceType> resourceTypes() {
        return SearchResourceTypeListCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters based on entity type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return Filters based on entity type.
     */
    public final List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by labels using exact match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return Filter by labels using exact match.
     */
    public final List<String> labels() {
        return labels;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter based on UserIds or GroupIds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipals} method.
     * </p>
     * 
     * @return Filter based on UserIds or GroupIds.
     */
    public final List<SearchPrincipalType> principals() {
        return principals;
    }

    /**
     * For responses, this returns true if the service returned a value for the AncestorIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAncestorIds() {
        return ancestorIds != null && !(ancestorIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter based on resource’s path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAncestorIds} method.
     * </p>
     * 
     * @return Filter based on resource’s path.
     */
    public final List<String> ancestorIds() {
        return ancestorIds;
    }

    /**
     * <p>
     * Filter based on file groupings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearchCollectionTypes} method.
     * </p>
     * 
     * @return Filter based on file groupings.
     */
    public final List<SearchCollectionType> searchCollectionTypes() {
        return SearchCollectionTypeListCopier.copyStringToEnum(searchCollectionTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SearchCollectionTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSearchCollectionTypes() {
        return searchCollectionTypes != null && !(searchCollectionTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter based on file groupings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearchCollectionTypes} method.
     * </p>
     * 
     * @return Filter based on file groupings.
     */
    public final List<String> searchCollectionTypesAsStrings() {
        return searchCollectionTypes;
    }

    /**
     * <p>
     * Filter based on size (in bytes).
     * </p>
     * 
     * @return Filter based on size (in bytes).
     */
    public final LongRangeType sizeRange() {
        return sizeRange;
    }

    /**
     * <p>
     * Filter based on resource’s creation timestamp.
     * </p>
     * 
     * @return Filter based on resource’s creation timestamp.
     */
    public final DateRangeType createdRange() {
        return createdRange;
    }

    /**
     * <p>
     * Filter based on resource’s modified timestamp.
     * </p>
     * 
     * @return Filter based on resource’s modified timestamp.
     */
    public final DateRangeType modifiedRange() {
        return modifiedRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTextLocales() ? textLocalesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContentCategories() ? contentCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipals() ? principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAncestorIds() ? ancestorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchCollectionTypes() ? searchCollectionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sizeRange());
        hashCode = 31 * hashCode + Objects.hashCode(createdRange());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters) obj;
        return hasTextLocales() == other.hasTextLocales() && Objects.equals(textLocalesAsStrings(), other.textLocalesAsStrings())
                && hasContentCategories() == other.hasContentCategories()
                && Objects.equals(contentCategoriesAsStrings(), other.contentCategoriesAsStrings())
                && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings()) && hasLabels() == other.hasLabels()
                && Objects.equals(labels(), other.labels()) && hasPrincipals() == other.hasPrincipals()
                && Objects.equals(principals(), other.principals()) && hasAncestorIds() == other.hasAncestorIds()
                && Objects.equals(ancestorIds(), other.ancestorIds())
                && hasSearchCollectionTypes() == other.hasSearchCollectionTypes()
                && Objects.equals(searchCollectionTypesAsStrings(), other.searchCollectionTypesAsStrings())
                && Objects.equals(sizeRange(), other.sizeRange()) && Objects.equals(createdRange(), other.createdRange())
                && Objects.equals(modifiedRange(), other.modifiedRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filters").add("TextLocales", hasTextLocales() ? textLocalesAsStrings() : null)
                .add("ContentCategories", hasContentCategories() ? contentCategoriesAsStrings() : null)
                .add("ResourceTypes", hasResourceTypes() ? resourceTypesAsStrings() : null)
                .add("Labels", hasLabels() ? labels() : null).add("Principals", hasPrincipals() ? principals() : null)
                .add("AncestorIds", hasAncestorIds() ? ancestorIds() : null)
                .add("SearchCollectionTypes", hasSearchCollectionTypes() ? searchCollectionTypesAsStrings() : null)
                .add("SizeRange", sizeRange()).add("CreatedRange", createdRange()).add("ModifiedRange", modifiedRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextLocales":
            return Optional.ofNullable(clazz.cast(textLocalesAsStrings()));
        case "ContentCategories":
            return Optional.ofNullable(clazz.cast(contentCategoriesAsStrings()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "Principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "AncestorIds":
            return Optional.ofNullable(clazz.cast(ancestorIds()));
        case "SearchCollectionTypes":
            return Optional.ofNullable(clazz.cast(searchCollectionTypesAsStrings()));
        case "SizeRange":
            return Optional.ofNullable(clazz.cast(sizeRange()));
        case "CreatedRange":
            return Optional.ofNullable(clazz.cast(createdRange()));
        case "ModifiedRange":
            return Optional.ofNullable(clazz.cast(modifiedRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filters> {
        /**
         * <p>
         * Filters by the locale of the content or comment.
         * </p>
         * 
         * @param textLocales
         *        Filters by the locale of the content or comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textLocalesWithStrings(Collection<String> textLocales);

        /**
         * <p>
         * Filters by the locale of the content or comment.
         * </p>
         * 
         * @param textLocales
         *        Filters by the locale of the content or comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textLocalesWithStrings(String... textLocales);

        /**
         * <p>
         * Filters by the locale of the content or comment.
         * </p>
         * 
         * @param textLocales
         *        Filters by the locale of the content or comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textLocales(Collection<LanguageCodeType> textLocales);

        /**
         * <p>
         * Filters by the locale of the content or comment.
         * </p>
         * 
         * @param textLocales
         *        Filters by the locale of the content or comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textLocales(LanguageCodeType... textLocales);

        /**
         * <p>
         * Filters by content category.
         * </p>
         * 
         * @param contentCategories
         *        Filters by content category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentCategoriesWithStrings(Collection<String> contentCategories);

        /**
         * <p>
         * Filters by content category.
         * </p>
         * 
         * @param contentCategories
         *        Filters by content category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentCategoriesWithStrings(String... contentCategories);

        /**
         * <p>
         * Filters by content category.
         * </p>
         * 
         * @param contentCategories
         *        Filters by content category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentCategories(Collection<ContentCategoryType> contentCategories);

        /**
         * <p>
         * Filters by content category.
         * </p>
         * 
         * @param contentCategories
         *        Filters by content category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentCategories(ContentCategoryType... contentCategories);

        /**
         * <p>
         * Filters based on entity type.
         * </p>
         * 
         * @param resourceTypes
         *        Filters based on entity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * Filters based on entity type.
         * </p>
         * 
         * @param resourceTypes
         *        Filters based on entity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * Filters based on entity type.
         * </p>
         * 
         * @param resourceTypes
         *        Filters based on entity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<SearchResourceType> resourceTypes);

        /**
         * <p>
         * Filters based on entity type.
         * </p>
         * 
         * @param resourceTypes
         *        Filters based on entity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(SearchResourceType... resourceTypes);

        /**
         * <p>
         * Filter by labels using exact match.
         * </p>
         * 
         * @param labels
         *        Filter by labels using exact match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * Filter by labels using exact match.
         * </p>
         * 
         * @param labels
         *        Filter by labels using exact match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * <p>
         * Filter based on UserIds or GroupIds.
         * </p>
         * 
         * @param principals
         *        Filter based on UserIds or GroupIds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<SearchPrincipalType> principals);

        /**
         * <p>
         * Filter based on UserIds or GroupIds.
         * </p>
         * 
         * @param principals
         *        Filter based on UserIds or GroupIds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(SearchPrincipalType... principals);

        /**
         * <p>
         * Filter based on UserIds or GroupIds.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workdocs.model.SearchPrincipalType.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.workdocs.model.SearchPrincipalType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workdocs.model.SearchPrincipalType.Builder#build()} is called
         * immediately and its result is passed to {@link #principals(List<SearchPrincipalType>)}.
         * 
         * @param principals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workdocs.model.SearchPrincipalType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principals(java.util.Collection<SearchPrincipalType>)
         */
        Builder principals(Consumer<SearchPrincipalType.Builder>... principals);

        /**
         * <p>
         * Filter based on resource’s path.
         * </p>
         * 
         * @param ancestorIds
         *        Filter based on resource’s path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ancestorIds(Collection<String> ancestorIds);

        /**
         * <p>
         * Filter based on resource’s path.
         * </p>
         * 
         * @param ancestorIds
         *        Filter based on resource’s path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ancestorIds(String... ancestorIds);

        /**
         * <p>
         * Filter based on file groupings.
         * </p>
         * 
         * @param searchCollectionTypes
         *        Filter based on file groupings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCollectionTypesWithStrings(Collection<String> searchCollectionTypes);

        /**
         * <p>
         * Filter based on file groupings.
         * </p>
         * 
         * @param searchCollectionTypes
         *        Filter based on file groupings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCollectionTypesWithStrings(String... searchCollectionTypes);

        /**
         * <p>
         * Filter based on file groupings.
         * </p>
         * 
         * @param searchCollectionTypes
         *        Filter based on file groupings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCollectionTypes(Collection<SearchCollectionType> searchCollectionTypes);

        /**
         * <p>
         * Filter based on file groupings.
         * </p>
         * 
         * @param searchCollectionTypes
         *        Filter based on file groupings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCollectionTypes(SearchCollectionType... searchCollectionTypes);

        /**
         * <p>
         * Filter based on size (in bytes).
         * </p>
         * 
         * @param sizeRange
         *        Filter based on size (in bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeRange(LongRangeType sizeRange);

        /**
         * <p>
         * Filter based on size (in bytes).
         * </p>
         * This is a convenience method that creates an instance of the {@link LongRangeType.Builder} avoiding the need
         * to create one manually via {@link LongRangeType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LongRangeType.Builder#build()} is called immediately and its
         * result is passed to {@link #sizeRange(LongRangeType)}.
         * 
         * @param sizeRange
         *        a consumer that will call methods on {@link LongRangeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeRange(LongRangeType)
         */
        default Builder sizeRange(Consumer<LongRangeType.Builder> sizeRange) {
            return sizeRange(LongRangeType.builder().applyMutation(sizeRange).build());
        }

        /**
         * <p>
         * Filter based on resource’s creation timestamp.
         * </p>
         * 
         * @param createdRange
         *        Filter based on resource’s creation timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRange(DateRangeType createdRange);

        /**
         * <p>
         * Filter based on resource’s creation timestamp.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateRangeType.Builder} avoiding the need
         * to create one manually via {@link DateRangeType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateRangeType.Builder#build()} is called immediately and its
         * result is passed to {@link #createdRange(DateRangeType)}.
         * 
         * @param createdRange
         *        a consumer that will call methods on {@link DateRangeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdRange(DateRangeType)
         */
        default Builder createdRange(Consumer<DateRangeType.Builder> createdRange) {
            return createdRange(DateRangeType.builder().applyMutation(createdRange).build());
        }

        /**
         * <p>
         * Filter based on resource’s modified timestamp.
         * </p>
         * 
         * @param modifiedRange
         *        Filter based on resource’s modified timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedRange(DateRangeType modifiedRange);

        /**
         * <p>
         * Filter based on resource’s modified timestamp.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateRangeType.Builder} avoiding the need
         * to create one manually via {@link DateRangeType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateRangeType.Builder#build()} is called immediately and its
         * result is passed to {@link #modifiedRange(DateRangeType)}.
         * 
         * @param modifiedRange
         *        a consumer that will call methods on {@link DateRangeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modifiedRange(DateRangeType)
         */
        default Builder modifiedRange(Consumer<DateRangeType.Builder> modifiedRange) {
            return modifiedRange(DateRangeType.builder().applyMutation(modifiedRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> textLocales = DefaultSdkAutoConstructList.getInstance();

        private List<String> contentCategories = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private List<SearchPrincipalType> principals = DefaultSdkAutoConstructList.getInstance();

        private List<String> ancestorIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> searchCollectionTypes = DefaultSdkAutoConstructList.getInstance();

        private LongRangeType sizeRange;

        private DateRangeType createdRange;

        private DateRangeType modifiedRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            textLocalesWithStrings(model.textLocales);
            contentCategoriesWithStrings(model.contentCategories);
            resourceTypesWithStrings(model.resourceTypes);
            labels(model.labels);
            principals(model.principals);
            ancestorIds(model.ancestorIds);
            searchCollectionTypesWithStrings(model.searchCollectionTypes);
            sizeRange(model.sizeRange);
            createdRange(model.createdRange);
            modifiedRange(model.modifiedRange);
        }

        public final Collection<String> getTextLocales() {
            if (textLocales instanceof SdkAutoConstructList) {
                return null;
            }
            return textLocales;
        }

        public final void setTextLocales(Collection<String> textLocales) {
            this.textLocales = TextLocaleTypeListCopier.copy(textLocales);
        }

        @Override
        public final Builder textLocalesWithStrings(Collection<String> textLocales) {
            this.textLocales = TextLocaleTypeListCopier.copy(textLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textLocalesWithStrings(String... textLocales) {
            textLocalesWithStrings(Arrays.asList(textLocales));
            return this;
        }

        @Override
        public final Builder textLocales(Collection<LanguageCodeType> textLocales) {
            this.textLocales = TextLocaleTypeListCopier.copyEnumToString(textLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textLocales(LanguageCodeType... textLocales) {
            textLocales(Arrays.asList(textLocales));
            return this;
        }

        public final Collection<String> getContentCategories() {
            if (contentCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return contentCategories;
        }

        public final void setContentCategories(Collection<String> contentCategories) {
            this.contentCategories = SearchContentCategoryTypeListCopier.copy(contentCategories);
        }

        @Override
        public final Builder contentCategoriesWithStrings(Collection<String> contentCategories) {
            this.contentCategories = SearchContentCategoryTypeListCopier.copy(contentCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentCategoriesWithStrings(String... contentCategories) {
            contentCategoriesWithStrings(Arrays.asList(contentCategories));
            return this;
        }

        @Override
        public final Builder contentCategories(Collection<ContentCategoryType> contentCategories) {
            this.contentCategories = SearchContentCategoryTypeListCopier.copyEnumToString(contentCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentCategories(ContentCategoryType... contentCategories) {
            contentCategories(Arrays.asList(contentCategories));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = SearchResourceTypeListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = SearchResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<SearchResourceType> resourceTypes) {
            this.resourceTypes = SearchResourceTypeListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(SearchResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getLabels() {
            if (labels instanceof SdkAutoConstructList) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SearchLabelListCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SearchLabelListCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final List<SearchPrincipalType.Builder> getPrincipals() {
            List<SearchPrincipalType.Builder> result = SearchPrincipalTypeListCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipals(Collection<SearchPrincipalType.BuilderImpl> principals) {
            this.principals = SearchPrincipalTypeListCopier.copyFromBuilder(principals);
        }

        @Override
        public final Builder principals(Collection<SearchPrincipalType> principals) {
            this.principals = SearchPrincipalTypeListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(SearchPrincipalType... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<SearchPrincipalType.Builder>... principals) {
            principals(Stream.of(principals).map(c -> SearchPrincipalType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAncestorIds() {
            if (ancestorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ancestorIds;
        }

        public final void setAncestorIds(Collection<String> ancestorIds) {
            this.ancestorIds = SearchAncestorIdListCopier.copy(ancestorIds);
        }

        @Override
        public final Builder ancestorIds(Collection<String> ancestorIds) {
            this.ancestorIds = SearchAncestorIdListCopier.copy(ancestorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ancestorIds(String... ancestorIds) {
            ancestorIds(Arrays.asList(ancestorIds));
            return this;
        }

        public final Collection<String> getSearchCollectionTypes() {
            if (searchCollectionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return searchCollectionTypes;
        }

        public final void setSearchCollectionTypes(Collection<String> searchCollectionTypes) {
            this.searchCollectionTypes = SearchCollectionTypeListCopier.copy(searchCollectionTypes);
        }

        @Override
        public final Builder searchCollectionTypesWithStrings(Collection<String> searchCollectionTypes) {
            this.searchCollectionTypes = SearchCollectionTypeListCopier.copy(searchCollectionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchCollectionTypesWithStrings(String... searchCollectionTypes) {
            searchCollectionTypesWithStrings(Arrays.asList(searchCollectionTypes));
            return this;
        }

        @Override
        public final Builder searchCollectionTypes(Collection<SearchCollectionType> searchCollectionTypes) {
            this.searchCollectionTypes = SearchCollectionTypeListCopier.copyEnumToString(searchCollectionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchCollectionTypes(SearchCollectionType... searchCollectionTypes) {
            searchCollectionTypes(Arrays.asList(searchCollectionTypes));
            return this;
        }

        public final LongRangeType.Builder getSizeRange() {
            return sizeRange != null ? sizeRange.toBuilder() : null;
        }

        public final void setSizeRange(LongRangeType.BuilderImpl sizeRange) {
            this.sizeRange = sizeRange != null ? sizeRange.build() : null;
        }

        @Override
        public final Builder sizeRange(LongRangeType sizeRange) {
            this.sizeRange = sizeRange;
            return this;
        }

        public final DateRangeType.Builder getCreatedRange() {
            return createdRange != null ? createdRange.toBuilder() : null;
        }

        public final void setCreatedRange(DateRangeType.BuilderImpl createdRange) {
            this.createdRange = createdRange != null ? createdRange.build() : null;
        }

        @Override
        public final Builder createdRange(DateRangeType createdRange) {
            this.createdRange = createdRange;
            return this;
        }

        public final DateRangeType.Builder getModifiedRange() {
            return modifiedRange != null ? modifiedRange.toBuilder() : null;
        }

        public final void setModifiedRange(DateRangeType.BuilderImpl modifiedRange) {
            this.modifiedRange = modifiedRange != null ? modifiedRange.build() : null;
        }

        @Override
        public final Builder modifiedRange(DateRangeType modifiedRange) {
            this.modifiedRange = modifiedRange;
            return this;
        }

        @Override
        public Filters build() {
            return new Filters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
