/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for Amazon AppIntegrations to automatically ingest content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppIntegrationsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AppIntegrationsConfiguration.Builder, AppIntegrationsConfiguration> {
    private static final SdkField<String> APP_INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appIntegrationArn").getter(getter(AppIntegrationsConfiguration::appIntegrationArn))
            .setter(setter(Builder::appIntegrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appIntegrationArn").build()).build();

    private static final SdkField<List<String>> OBJECT_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("objectFields")
            .getter(getter(AppIntegrationsConfiguration::objectFields))
            .setter(setter(Builder::objectFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INTEGRATION_ARN_FIELD,
            OBJECT_FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appIntegrationArn;

    private final List<String> objectFields;

    private AppIntegrationsConfiguration(BuilderImpl builder) {
        this.appIntegrationArn = builder.appIntegrationArn;
        this.objectFields = builder.objectFields;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <a href=
     * "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
     * > Salesforce</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not
     * provided, including at least <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>,
     * <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code> as source fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
     * ServiceNow</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not
     * provided, including at least <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>,
     * <code>workflow_state</code>, and <code>active</code> as source fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/"> Zendesk</a>,
     * your AppIntegrations DataIntegration must have an ObjectConfiguration if <code>objectFields</code> is not
     * provided, including at least <code>id</code>, <code>title</code>, <code>updated_at</code>, and <code>draft</code>
     * as source fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <a href=
     * "https://learn.microsoft.com/en-us/sharepoint/dev/sp-add-ins/sharepoint-net-server-csom-jsom-and-rest-api-index">
     * SharePoint</a>, your AppIntegrations DataIntegration must have a FileConfiguration, including only file
     * extensions that are among <code>docx</code>, <code>pdf</code>, <code>html</code>, <code>htm</code>, and
     * <code>txt</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <a href=
     *         "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
     *         > Salesforce</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields
     *         is not provided, including at least <code>Id</code>, <code>ArticleNumber</code>,
     *         <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code> as
     *         source fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
     *         ServiceNow</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is
     *         not provided, including at least <code>number</code>, <code>short_description</code>,
     *         <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code> as source fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">
     *         Zendesk</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if
     *         <code>objectFields</code> is not provided, including at least <code>id</code>, <code>title</code>,
     *         <code>updated_at</code>, and <code>draft</code> as source fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href=
     *         "https://learn.microsoft.com/en-us/sharepoint/dev/sp-add-ins/sharepoint-net-server-csom-jsom-and-rest-api-index"
     *         > SharePoint</a>, your AppIntegrations DataIntegration must have a FileConfiguration, including only file
     *         extensions that are among <code>docx</code>, <code>pdf</code>, <code>html</code>, <code>htm</code>, and
     *         <code>txt</code>.
     *         </p>
     *         </li>
     */
    public final String appIntegrationArn() {
        return appIntegrationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObjectFields() {
        return objectFields != null && !(objectFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fields from the source that are made available to your agents in Wisdom. Optional if ObjectConfiguration is
     * included in the provided DataIntegration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <a href=
     * "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
     * > Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>,
     * <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
     * ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>,
     * <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/"> Zendesk</a>, you
     * must include at least <code>id</code>, <code>title</code>, <code>updated_at</code>, and <code>draft</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Make sure to include additional fields. These fields are indexed and used to source recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectFields} method.
     * </p>
     * 
     * @return The fields from the source that are made available to your agents in Wisdom. Optional if
     *         ObjectConfiguration is included in the provided DataIntegration. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <a href=
     *         "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
     *         > Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>,
     *         <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
     *         ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>,
     *         <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">
     *         Zendesk</a>, you must include at least <code>id</code>, <code>title</code>, <code>updated_at</code>, and
     *         <code>draft</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Make sure to include additional fields. These fields are indexed and used to source recommendations.
     */
    public final List<String> objectFields() {
        return objectFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appIntegrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectFields() ? objectFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppIntegrationsConfiguration)) {
            return false;
        }
        AppIntegrationsConfiguration other = (AppIntegrationsConfiguration) obj;
        return Objects.equals(appIntegrationArn(), other.appIntegrationArn()) && hasObjectFields() == other.hasObjectFields()
                && Objects.equals(objectFields(), other.objectFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppIntegrationsConfiguration").add("AppIntegrationArn", appIntegrationArn())
                .add("ObjectFields", hasObjectFields() ? objectFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appIntegrationArn":
            return Optional.ofNullable(clazz.cast(appIntegrationArn()));
        case "objectFields":
            return Optional.ofNullable(clazz.cast(objectFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppIntegrationsConfiguration, T> g) {
        return obj -> g.apply((AppIntegrationsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppIntegrationsConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <a href=
         * "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
         * > Salesforce</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is
         * not provided, including at least <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>,
         * <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code> as source fields.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
         * ServiceNow</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not
         * provided, including at least <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>,
         * <code>workflow_state</code>, and <code>active</code> as source fields.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/"> Zendesk</a>,
         * your AppIntegrations DataIntegration must have an ObjectConfiguration if <code>objectFields</code> is not
         * provided, including at least <code>id</code>, <code>title</code>, <code>updated_at</code>, and
         * <code>draft</code> as source fields.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <a href=
         * "https://learn.microsoft.com/en-us/sharepoint/dev/sp-add-ins/sharepoint-net-server-csom-jsom-and-rest-api-index"
         * > SharePoint</a>, your AppIntegrations DataIntegration must have a FileConfiguration, including only file
         * extensions that are among <code>docx</code>, <code>pdf</code>, <code>html</code>, <code>htm</code>, and
         * <code>txt</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param appIntegrationArn
         *        The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting
         *        content.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <a href=
         *        "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
         *        > Salesforce</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if
         *        objectFields is not provided, including at least <code>Id</code>, <code>ArticleNumber</code>,
         *        <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>
         *        as source fields.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <a
         *        href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
         *        ServiceNow</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields
         *        is not provided, including at least <code>number</code>, <code>short_description</code>,
         *        <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code> as source fields.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">
         *        Zendesk</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if
         *        <code>objectFields</code> is not provided, including at least <code>id</code>, <code>title</code>,
         *        <code>updated_at</code>, and <code>draft</code> as source fields.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <a href=
         *        "https://learn.microsoft.com/en-us/sharepoint/dev/sp-add-ins/sharepoint-net-server-csom-jsom-and-rest-api-index"
         *        > SharePoint</a>, your AppIntegrations DataIntegration must have a FileConfiguration, including only
         *        file extensions that are among <code>docx</code>, <code>pdf</code>, <code>html</code>,
         *        <code>htm</code>, and <code>txt</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appIntegrationArn(String appIntegrationArn);

        /**
         * <p>
         * The fields from the source that are made available to your agents in Wisdom. Optional if ObjectConfiguration
         * is included in the provided DataIntegration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <a href=
         * "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
         * > Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>,
         * <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
         * ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>,
         * <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/"> Zendesk</a>,
         * you must include at least <code>id</code>, <code>title</code>, <code>updated_at</code>, and
         * <code>draft</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Make sure to include additional fields. These fields are indexed and used to source recommendations.
         * </p>
         * 
         * @param objectFields
         *        The fields from the source that are made available to your agents in Wisdom. Optional if
         *        ObjectConfiguration is included in the provided DataIntegration. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <a href=
         *        "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
         *        > Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>,
         *        <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <a
         *        href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
         *        ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>,
         *        <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">
         *        Zendesk</a>, you must include at least <code>id</code>, <code>title</code>, <code>updated_at</code>,
         *        and <code>draft</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Make sure to include additional fields. These fields are indexed and used to source recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectFields(Collection<String> objectFields);

        /**
         * <p>
         * The fields from the source that are made available to your agents in Wisdom. Optional if ObjectConfiguration
         * is included in the provided DataIntegration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <a href=
         * "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
         * > Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>,
         * <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
         * ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>,
         * <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/"> Zendesk</a>,
         * you must include at least <code>id</code>, <code>title</code>, <code>updated_at</code>, and
         * <code>draft</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Make sure to include additional fields. These fields are indexed and used to source recommendations.
         * </p>
         * 
         * @param objectFields
         *        The fields from the source that are made available to your agents in Wisdom. Optional if
         *        ObjectConfiguration is included in the provided DataIntegration. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <a href=
         *        "https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"
         *        > Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>,
         *        <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <a
         *        href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">
         *        ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>,
         *        <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">
         *        Zendesk</a>, you must include at least <code>id</code>, <code>title</code>, <code>updated_at</code>,
         *        and <code>draft</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Make sure to include additional fields. These fields are indexed and used to source recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectFields(String... objectFields);
    }

    static final class BuilderImpl implements Builder {
        private String appIntegrationArn;

        private List<String> objectFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppIntegrationsConfiguration model) {
            appIntegrationArn(model.appIntegrationArn);
            objectFields(model.objectFields);
        }

        public final String getAppIntegrationArn() {
            return appIntegrationArn;
        }

        public final void setAppIntegrationArn(String appIntegrationArn) {
            this.appIntegrationArn = appIntegrationArn;
        }

        @Override
        public final Builder appIntegrationArn(String appIntegrationArn) {
            this.appIntegrationArn = appIntegrationArn;
            return this;
        }

        public final Collection<String> getObjectFields() {
            if (objectFields instanceof SdkAutoConstructList) {
                return null;
            }
            return objectFields;
        }

        public final void setObjectFields(Collection<String> objectFields) {
            this.objectFields = ObjectFieldsListCopier.copy(objectFields);
        }

        @Override
        public final Builder objectFields(Collection<String> objectFields) {
            this.objectFields = ObjectFieldsListCopier.copy(objectFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectFields(String... objectFields) {
            objectFields(Arrays.asList(objectFields));
            return this;
        }

        @Override
        public AppIntegrationsConfiguration build() {
            return new AppIntegrationsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
