/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CheckStatus {
    OKAY("OKAY"),
    WARNING("WARNING"),
    ERROR("ERROR"),
    NOT_AVAILABLE("NOT_AVAILABLE"),
    FETCH_FAILED("FETCH_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CheckStatus> VALUE_MAP;
    private final String value;

    private CheckStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CheckStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CheckStatus> knownValues() {
        EnumSet<CheckStatus> knownValues = EnumSet.allOf(CheckStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CheckStatus.class, CheckStatus::toString);
    }
}

