/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Risk {
    UNANSWERED("UNANSWERED"),
    HIGH("HIGH"),
    MEDIUM("MEDIUM"),
    NONE("NONE"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Risk> VALUE_MAP;
    private final String value;

    private Risk(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Risk fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Risk> knownValues() {
        EnumSet<Risk> knownValues = EnumSet.allOf(Risk.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Risk.class, Risk::toString);
    }
}

