/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.ProfileOwnerType;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfilesRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, ListProfilesRequest> {
    private static final SdkField<String> PROFILE_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileNamePrefix").getter(ListProfilesRequest.getter(ListProfilesRequest::profileNamePrefix)).setter(ListProfilesRequest.setter(Builder::profileNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProfileNamePrefix").build()}).build();
    private static final SdkField<String> PROFILE_OWNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileOwnerType").getter(ListProfilesRequest.getter(ListProfilesRequest::profileOwnerTypeAsString)).setter(ListProfilesRequest.setter(Builder::profileOwnerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProfileOwnerType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProfilesRequest.getter(ListProfilesRequest::nextToken)).setter(ListProfilesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListProfilesRequest.getter(ListProfilesRequest::maxResults)).setter(ListProfilesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_PREFIX_FIELD, PROFILE_OWNER_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String profileNamePrefix;
    private final String profileOwnerType;
    private final String nextToken;
    private final Integer maxResults;

    private ListProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.profileNamePrefix = builder.profileNamePrefix;
        this.profileOwnerType = builder.profileOwnerType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String profileNamePrefix() {
        return this.profileNamePrefix;
    }

    public final ProfileOwnerType profileOwnerType() {
        return ProfileOwnerType.fromValue(this.profileOwnerType);
    }

    public final String profileOwnerTypeAsString() {
        return this.profileOwnerType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileOwnerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilesRequest)) {
            return false;
        }
        ListProfilesRequest other = (ListProfilesRequest)((Object)obj);
        return Objects.equals(this.profileNamePrefix(), other.profileNamePrefix()) && Objects.equals(this.profileOwnerTypeAsString(), other.profileOwnerTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfilesRequest").add("ProfileNamePrefix", (Object)this.profileNamePrefix()).add("ProfileOwnerType", (Object)this.profileOwnerTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.profileNamePrefix()));
            }
            case "ProfileOwnerType": {
                return Optional.ofNullable(clazz.cast(this.profileOwnerTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilesRequest, T> g) {
        return obj -> g.apply((ListProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String profileNamePrefix;
        private String profileOwnerType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilesRequest model) {
            super(model);
            this.profileNamePrefix(model.profileNamePrefix);
            this.profileOwnerType(model.profileOwnerType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getProfileNamePrefix() {
            return this.profileNamePrefix;
        }

        public final void setProfileNamePrefix(String profileNamePrefix) {
            this.profileNamePrefix = profileNamePrefix;
        }

        @Override
        public final Builder profileNamePrefix(String profileNamePrefix) {
            this.profileNamePrefix = profileNamePrefix;
            return this;
        }

        public final String getProfileOwnerType() {
            return this.profileOwnerType;
        }

        public final void setProfileOwnerType(String profileOwnerType) {
            this.profileOwnerType = profileOwnerType;
        }

        @Override
        public final Builder profileOwnerType(String profileOwnerType) {
            this.profileOwnerType = profileOwnerType;
            return this;
        }

        @Override
        public final Builder profileOwnerType(ProfileOwnerType profileOwnerType) {
            this.profileOwnerType(profileOwnerType == null ? null : profileOwnerType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfilesRequest build() {
            return new ListProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfilesRequest> {
        public Builder profileNamePrefix(String var1);

        public Builder profileOwnerType(String var1);

        public Builder profileOwnerType(ProfileOwnerType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

