/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.LensMetric;
import software.amazon.awssdk.services.wellarchitected.model.LensMetricsCopier;
import software.amazon.awssdk.services.wellarchitected.model.MetricType;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsolidatedReportMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsolidatedReportMetric> {
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricType").getter(ConsolidatedReportMetric.getter(ConsolidatedReportMetric::metricTypeAsString)).setter(ConsolidatedReportMetric.setter(Builder::metricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(ConsolidatedReportMetric.getter(ConsolidatedReportMetric::riskCountsAsStrings)).setter(ConsolidatedReportMetric.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ConsolidatedReportMetric.getter(ConsolidatedReportMetric::workloadId)).setter(ConsolidatedReportMetric.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(ConsolidatedReportMetric.getter(ConsolidatedReportMetric::workloadName)).setter(ConsolidatedReportMetric.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> WORKLOAD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadArn").getter(ConsolidatedReportMetric.getter(ConsolidatedReportMetric::workloadArn)).setter(ConsolidatedReportMetric.setter(Builder::workloadArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadArn").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ConsolidatedReportMetric.getter(ConsolidatedReportMetric::updatedAt)).setter(ConsolidatedReportMetric.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<List<LensMetric>> LENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Lenses").getter(ConsolidatedReportMetric.getter(ConsolidatedReportMetric::lenses)).setter(ConsolidatedReportMetric.setter(Builder::lenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LensMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LENSES_APPLIED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LensesAppliedCount").getter(ConsolidatedReportMetric.getter(ConsolidatedReportMetric::lensesAppliedCount)).setter(ConsolidatedReportMetric.setter(Builder::lensesAppliedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensesAppliedCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_TYPE_FIELD, RISK_COUNTS_FIELD, WORKLOAD_ID_FIELD, WORKLOAD_NAME_FIELD, WORKLOAD_ARN_FIELD, UPDATED_AT_FIELD, LENSES_FIELD, LENSES_APPLIED_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metricType;
    private final Map<String, Integer> riskCounts;
    private final String workloadId;
    private final String workloadName;
    private final String workloadArn;
    private final Instant updatedAt;
    private final List<LensMetric> lenses;
    private final Integer lensesAppliedCount;

    private ConsolidatedReportMetric(BuilderImpl builder) {
        this.metricType = builder.metricType;
        this.riskCounts = builder.riskCounts;
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
        this.workloadArn = builder.workloadArn;
        this.updatedAt = builder.updatedAt;
        this.lenses = builder.lenses;
        this.lensesAppliedCount = builder.lensesAppliedCount;
    }

    public final MetricType metricType() {
        return MetricType.fromValue(this.metricType);
    }

    public final String metricTypeAsString() {
        return this.metricType;
    }

    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public final boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final String workloadArn() {
        return this.workloadArn;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasLenses() {
        return this.lenses != null && !(this.lenses instanceof SdkAutoConstructList);
    }

    public final List<LensMetric> lenses() {
        return this.lenses;
    }

    public final Integer lensesAppliedCount() {
        return this.lensesAppliedCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLenses() ? this.lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lensesAppliedCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedReportMetric)) {
            return false;
        }
        ConsolidatedReportMetric other = (ConsolidatedReportMetric)obj;
        return Objects.equals(this.metricTypeAsString(), other.metricTypeAsString()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings()) && Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.workloadArn(), other.workloadArn()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasLenses() == other.hasLenses() && Objects.equals(this.lenses(), other.lenses()) && Objects.equals(this.lensesAppliedCount(), other.lensesAppliedCount());
    }

    public final String toString() {
        return ToString.builder((String)"ConsolidatedReportMetric").add("MetricType", (Object)this.metricTypeAsString()).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).add("WorkloadId", (Object)this.workloadId()).add("WorkloadName", (Object)this.workloadName()).add("WorkloadArn", (Object)this.workloadArn()).add("UpdatedAt", (Object)this.updatedAt()).add("Lenses", this.hasLenses() ? this.lenses() : null).add("LensesAppliedCount", (Object)this.lensesAppliedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricType": {
                return Optional.ofNullable(clazz.cast(this.metricTypeAsString()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "WorkloadArn": {
                return Optional.ofNullable(clazz.cast(this.workloadArn()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Lenses": {
                return Optional.ofNullable(clazz.cast(this.lenses()));
            }
            case "LensesAppliedCount": {
                return Optional.ofNullable(clazz.cast(this.lensesAppliedCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConsolidatedReportMetric, T> g) {
        return obj -> g.apply((ConsolidatedReportMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricType;
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();
        private String workloadId;
        private String workloadName;
        private String workloadArn;
        private Instant updatedAt;
        private List<LensMetric> lenses = DefaultSdkAutoConstructList.getInstance();
        private Integer lensesAppliedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidatedReportMetric model) {
            this.metricType(model.metricType);
            this.riskCountsWithStrings(model.riskCounts);
            this.workloadId(model.workloadId);
            this.workloadName(model.workloadName);
            this.workloadArn(model.workloadArn);
            this.updatedAt(model.updatedAt);
            this.lenses(model.lenses);
            this.lensesAppliedCount(model.lensesAppliedCount);
        }

        public final String getMetricType() {
            return this.metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(MetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getWorkloadArn() {
            return this.workloadArn;
        }

        public final void setWorkloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
        }

        @Override
        public final Builder workloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<LensMetric.Builder> getLenses() {
            List<LensMetric.Builder> result = LensMetricsCopier.copyToBuilder(this.lenses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLenses(Collection<LensMetric.BuilderImpl> lenses) {
            this.lenses = LensMetricsCopier.copyFromBuilder(lenses);
        }

        @Override
        public final Builder lenses(Collection<LensMetric> lenses) {
            this.lenses = LensMetricsCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(LensMetric ... lenses) {
            this.lenses(Arrays.asList(lenses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(Consumer<LensMetric.Builder> ... lenses) {
            this.lenses(Stream.of(lenses).map(c -> (LensMetric)((LensMetric.Builder)LensMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getLensesAppliedCount() {
            return this.lensesAppliedCount;
        }

        public final void setLensesAppliedCount(Integer lensesAppliedCount) {
            this.lensesAppliedCount = lensesAppliedCount;
        }

        @Override
        public final Builder lensesAppliedCount(Integer lensesAppliedCount) {
            this.lensesAppliedCount = lensesAppliedCount;
            return this;
        }

        public ConsolidatedReportMetric build() {
            return new ConsolidatedReportMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsolidatedReportMetric> {
        public Builder metricType(String var1);

        public Builder metricType(MetricType var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);

        public Builder workloadId(String var1);

        public Builder workloadName(String var1);

        public Builder workloadArn(String var1);

        public Builder updatedAt(Instant var1);

        public Builder lenses(Collection<LensMetric> var1);

        public Builder lenses(LensMetric ... var1);

        public Builder lenses(Consumer<LensMetric.Builder> ... var1);

        public Builder lensesAppliedCount(Integer var1);
    }
}

