/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PillarReviewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PillarReviewSummary> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(PillarReviewSummary.getter(PillarReviewSummary::pillarId)).setter(PillarReviewSummary.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> PILLAR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarName").getter(PillarReviewSummary.getter(PillarReviewSummary::pillarName)).setter(PillarReviewSummary.setter(Builder::pillarName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarName").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(PillarReviewSummary.getter(PillarReviewSummary::notes)).setter(PillarReviewSummary.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(PillarReviewSummary.getter(PillarReviewSummary::riskCountsAsStrings)).setter(PillarReviewSummary.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD, PILLAR_NAME_FIELD, NOTES_FIELD, RISK_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pillarId;
    private final String pillarName;
    private final String notes;
    private final Map<String, Integer> riskCounts;

    private PillarReviewSummary(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.pillarName = builder.pillarName;
        this.notes = builder.notes;
        this.riskCounts = builder.riskCounts;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String pillarName() {
        return this.pillarName;
    }

    public final String notes() {
        return this.notes;
    }

    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public final boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PillarReviewSummary)) {
            return false;
        }
        PillarReviewSummary other = (PillarReviewSummary)obj;
        return Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.pillarName(), other.pillarName()) && Objects.equals(this.notes(), other.notes()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PillarReviewSummary").add("PillarId", (Object)this.pillarId()).add("PillarName", (Object)this.pillarName()).add("Notes", (Object)this.notes()).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "PillarName": {
                return Optional.ofNullable(clazz.cast(this.pillarName()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PillarReviewSummary, T> g) {
        return obj -> g.apply((PillarReviewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pillarId;
        private String pillarName;
        private String notes;
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PillarReviewSummary model) {
            this.pillarId(model.pillarId);
            this.pillarName(model.pillarName);
            this.notes(model.notes);
            this.riskCountsWithStrings(model.riskCounts);
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        public final String getPillarName() {
            return this.pillarName;
        }

        @Override
        public final Builder pillarName(String pillarName) {
            this.pillarName = pillarName;
            return this;
        }

        public final void setPillarName(String pillarName) {
            this.pillarName = pillarName;
        }

        public final String getNotes() {
            return this.notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        public PillarReviewSummary build() {
            return new PillarReviewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PillarReviewSummary> {
        public Builder pillarId(String var1);

        public Builder pillarName(String var1);

        public Builder notes(String var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);
    }
}

