/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group with
 * your rules, then provide the ARN of the rule group in this statement.
 * </p>
 * <p>
 * You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a <code>NotStatement</code> or
 * <code>OrStatement</code>. You cannot use a rule group reference statement inside another rule group. You can only
 * reference a rule group as a top-level statement within a rule that you define in a web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupReferenceStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupReferenceStatement.Builder, RuleGroupReferenceStatement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(RuleGroupReferenceStatement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<List<ExcludedRule>> EXCLUDED_RULES_FIELD = SdkField
            .<List<ExcludedRule>> builder(MarshallingType.LIST)
            .memberName("ExcludedRules")
            .getter(getter(RuleGroupReferenceStatement::excludedRules))
            .setter(setter(Builder::excludedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExcludedRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExcludedRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RuleActionOverride>> RULE_ACTION_OVERRIDES_FIELD = SdkField
            .<List<RuleActionOverride>> builder(MarshallingType.LIST)
            .memberName("RuleActionOverrides")
            .getter(getter(RuleGroupReferenceStatement::ruleActionOverrides))
            .setter(setter(Builder::ruleActionOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleActionOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleActionOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleActionOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            EXCLUDED_RULES_FIELD, RULE_ACTION_OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<ExcludedRule> excludedRules;

    private final List<RuleActionOverride> ruleActionOverrides;

    private RuleGroupReferenceStatement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.excludedRules = builder.excludedRules;
        this.ruleActionOverrides = builder.ruleActionOverrides;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entity.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludedRules() {
        return excludedRules != null && !(excludedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules in the referenced rule group whose actions are set to <code>Count</code>.
     * </p>
     * <note>
     * <p>
     * Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting, including
     * <code>Count</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedRules} method.
     * </p>
     * 
     * @return Rules in the referenced rule group whose actions are set to <code>Count</code>. </p> <note>
     *         <p>
     *         Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting,
     *         including <code>Count</code>.
     *         </p>
     */
    public final List<ExcludedRule> excludedRules() {
        return excludedRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleActionOverrides property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleActionOverrides() {
        return ruleActionOverrides != null && !(ruleActionOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Action settings to use in the place of the rule actions that are configured inside the rule group. You specify
     * one override for each rule whose action you want to change.
     * </p>
     * <p>
     * You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and
     * then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can
     * also permanently override some or all actions, to modify how the rule group manages your web traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleActionOverrides} method.
     * </p>
     * 
     * @return Action settings to use in the place of the rule actions that are configured inside the rule group. You
     *         specify one override for each rule whose action you want to change. </p>
     *         <p>
     *         You can use overrides for testing, for example you can override all of rule actions to <code>Count</code>
     *         and then monitor the resulting count metrics to understand how the rule group would handle your web
     *         traffic. You can also permanently override some or all actions, to modify how the rule group manages your
     *         web traffic.
     */
    public final List<RuleActionOverride> ruleActionOverrides() {
        return ruleActionOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedRules() ? excludedRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleActionOverrides() ? ruleActionOverrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupReferenceStatement)) {
            return false;
        }
        RuleGroupReferenceStatement other = (RuleGroupReferenceStatement) obj;
        return Objects.equals(arn(), other.arn()) && hasExcludedRules() == other.hasExcludedRules()
                && Objects.equals(excludedRules(), other.excludedRules())
                && hasRuleActionOverrides() == other.hasRuleActionOverrides()
                && Objects.equals(ruleActionOverrides(), other.ruleActionOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupReferenceStatement").add("ARN", arn())
                .add("ExcludedRules", hasExcludedRules() ? excludedRules() : null)
                .add("RuleActionOverrides", hasRuleActionOverrides() ? ruleActionOverrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ExcludedRules":
            return Optional.ofNullable(clazz.cast(excludedRules()));
        case "RuleActionOverrides":
            return Optional.ofNullable(clazz.cast(ruleActionOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupReferenceStatement, T> g) {
        return obj -> g.apply((RuleGroupReferenceStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupReferenceStatement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the entity.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Rules in the referenced rule group whose actions are set to <code>Count</code>.
         * </p>
         * <note>
         * <p>
         * Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting, including
         * <code>Count</code>.
         * </p>
         * </note>
         * 
         * @param excludedRules
         *        Rules in the referenced rule group whose actions are set to <code>Count</code>. </p> <note>
         *        <p>
         *        Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting,
         *        including <code>Count</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedRules(Collection<ExcludedRule> excludedRules);

        /**
         * <p>
         * Rules in the referenced rule group whose actions are set to <code>Count</code>.
         * </p>
         * <note>
         * <p>
         * Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting, including
         * <code>Count</code>.
         * </p>
         * </note>
         * 
         * @param excludedRules
         *        Rules in the referenced rule group whose actions are set to <code>Count</code>. </p> <note>
         *        <p>
         *        Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting,
         *        including <code>Count</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedRules(ExcludedRule... excludedRules);

        /**
         * <p>
         * Rules in the referenced rule group whose actions are set to <code>Count</code>.
         * </p>
         * <note>
         * <p>
         * Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting, including
         * <code>Count</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.ExcludedRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.ExcludedRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.ExcludedRule.Builder#build()} is called immediately and
         * its result is passed to {@link #excludedRules(List<ExcludedRule>)}.
         * 
         * @param excludedRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.ExcludedRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludedRules(java.util.Collection<ExcludedRule>)
         */
        Builder excludedRules(Consumer<ExcludedRule.Builder>... excludedRules);

        /**
         * <p>
         * Action settings to use in the place of the rule actions that are configured inside the rule group. You
         * specify one override for each rule whose action you want to change.
         * </p>
         * <p>
         * You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and
         * then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You
         * can also permanently override some or all actions, to modify how the rule group manages your web traffic.
         * </p>
         * 
         * @param ruleActionOverrides
         *        Action settings to use in the place of the rule actions that are configured inside the rule group. You
         *        specify one override for each rule whose action you want to change. </p>
         *        <p>
         *        You can use overrides for testing, for example you can override all of rule actions to
         *        <code>Count</code> and then monitor the resulting count metrics to understand how the rule group would
         *        handle your web traffic. You can also permanently override some or all actions, to modify how the rule
         *        group manages your web traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleActionOverrides(Collection<RuleActionOverride> ruleActionOverrides);

        /**
         * <p>
         * Action settings to use in the place of the rule actions that are configured inside the rule group. You
         * specify one override for each rule whose action you want to change.
         * </p>
         * <p>
         * You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and
         * then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You
         * can also permanently override some or all actions, to modify how the rule group manages your web traffic.
         * </p>
         * 
         * @param ruleActionOverrides
         *        Action settings to use in the place of the rule actions that are configured inside the rule group. You
         *        specify one override for each rule whose action you want to change. </p>
         *        <p>
         *        You can use overrides for testing, for example you can override all of rule actions to
         *        <code>Count</code> and then monitor the resulting count metrics to understand how the rule group would
         *        handle your web traffic. You can also permanently override some or all actions, to modify how the rule
         *        group manages your web traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleActionOverrides(RuleActionOverride... ruleActionOverrides);

        /**
         * <p>
         * Action settings to use in the place of the rule actions that are configured inside the rule group. You
         * specify one override for each rule whose action you want to change.
         * </p>
         * <p>
         * You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and
         * then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You
         * can also permanently override some or all actions, to modify how the rule group manages your web traffic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.RuleActionOverride.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.wafv2.model.RuleActionOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.RuleActionOverride.Builder#build()} is called immediately
         * and its result is passed to {@link #ruleActionOverrides(List<RuleActionOverride>)}.
         * 
         * @param ruleActionOverrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.RuleActionOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleActionOverrides(java.util.Collection<RuleActionOverride>)
         */
        Builder ruleActionOverrides(Consumer<RuleActionOverride.Builder>... ruleActionOverrides);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<ExcludedRule> excludedRules = DefaultSdkAutoConstructList.getInstance();

        private List<RuleActionOverride> ruleActionOverrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupReferenceStatement model) {
            arn(model.arn);
            excludedRules(model.excludedRules);
            ruleActionOverrides(model.ruleActionOverrides);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<ExcludedRule.Builder> getExcludedRules() {
            List<ExcludedRule.Builder> result = ExcludedRulesCopier.copyToBuilder(this.excludedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludedRules(Collection<ExcludedRule.BuilderImpl> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copyFromBuilder(excludedRules);
        }

        @Override
        public final Builder excludedRules(Collection<ExcludedRule> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copy(excludedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(ExcludedRule... excludedRules) {
            excludedRules(Arrays.asList(excludedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(Consumer<ExcludedRule.Builder>... excludedRules) {
            excludedRules(Stream.of(excludedRules).map(c -> ExcludedRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RuleActionOverride.Builder> getRuleActionOverrides() {
            List<RuleActionOverride.Builder> result = RuleActionOverridesCopier.copyToBuilder(this.ruleActionOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleActionOverrides(Collection<RuleActionOverride.BuilderImpl> ruleActionOverrides) {
            this.ruleActionOverrides = RuleActionOverridesCopier.copyFromBuilder(ruleActionOverrides);
        }

        @Override
        public final Builder ruleActionOverrides(Collection<RuleActionOverride> ruleActionOverrides) {
            this.ruleActionOverrides = RuleActionOverridesCopier.copy(ruleActionOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleActionOverrides(RuleActionOverride... ruleActionOverrides) {
            ruleActionOverrides(Arrays.asList(ruleActionOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleActionOverrides(Consumer<RuleActionOverride.Builder>... ruleActionOverrides) {
            ruleActionOverrides(Stream.of(ruleActionOverrides).map(c -> RuleActionOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RuleGroupReferenceStatement build() {
            return new RuleGroupReferenceStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
