/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single match condition for a <a>Filter</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<ActionCondition> ACTION_CONDITION_FIELD = SdkField
            .<ActionCondition> builder(MarshallingType.SDK_POJO).memberName("ActionCondition")
            .getter(getter(Condition::actionCondition)).setter(setter(Builder::actionCondition))
            .constructor(ActionCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionCondition").build()).build();

    private static final SdkField<LabelNameCondition> LABEL_NAME_CONDITION_FIELD = SdkField
            .<LabelNameCondition> builder(MarshallingType.SDK_POJO).memberName("LabelNameCondition")
            .getter(getter(Condition::labelNameCondition)).setter(setter(Builder::labelNameCondition))
            .constructor(LabelNameCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelNameCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_CONDITION_FIELD,
            LABEL_NAME_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActionCondition actionCondition;

    private final LabelNameCondition labelNameCondition;

    private Condition(BuilderImpl builder) {
        this.actionCondition = builder.actionCondition;
        this.labelNameCondition = builder.labelNameCondition;
    }

    /**
     * <p>
     * A single action condition. This is the action setting that a log record must contain in order to meet the
     * condition.
     * </p>
     * 
     * @return A single action condition. This is the action setting that a log record must contain in order to meet the
     *         condition.
     */
    public final ActionCondition actionCondition() {
        return actionCondition;
    }

    /**
     * <p>
     * A single label name condition. This is the fully qualified label name that a log record must contain in order to
     * meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix
     * identifies the rule group or web ACL context of the rule that added the label.
     * </p>
     * 
     * @return A single label name condition. This is the fully qualified label name that a log record must contain in
     *         order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name.
     *         The prefix identifies the rule group or web ACL context of the rule that added the label.
     */
    public final LabelNameCondition labelNameCondition() {
        return labelNameCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionCondition());
        hashCode = 31 * hashCode + Objects.hashCode(labelNameCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(actionCondition(), other.actionCondition())
                && Objects.equals(labelNameCondition(), other.labelNameCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Condition").add("ActionCondition", actionCondition())
                .add("LabelNameCondition", labelNameCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionCondition":
            return Optional.ofNullable(clazz.cast(actionCondition()));
        case "LabelNameCondition":
            return Optional.ofNullable(clazz.cast(labelNameCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * A single action condition. This is the action setting that a log record must contain in order to meet the
         * condition.
         * </p>
         * 
         * @param actionCondition
         *        A single action condition. This is the action setting that a log record must contain in order to meet
         *        the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionCondition(ActionCondition actionCondition);

        /**
         * <p>
         * A single action condition. This is the action setting that a log record must contain in order to meet the
         * condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionCondition.Builder} avoiding the
         * need to create one manually via {@link ActionCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #actionCondition(ActionCondition)}.
         * 
         * @param actionCondition
         *        a consumer that will call methods on {@link ActionCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionCondition(ActionCondition)
         */
        default Builder actionCondition(Consumer<ActionCondition.Builder> actionCondition) {
            return actionCondition(ActionCondition.builder().applyMutation(actionCondition).build());
        }

        /**
         * <p>
         * A single label name condition. This is the fully qualified label name that a log record must contain in order
         * to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix
         * identifies the rule group or web ACL context of the rule that added the label.
         * </p>
         * 
         * @param labelNameCondition
         *        A single label name condition. This is the fully qualified label name that a log record must contain
         *        in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label
         *        name. The prefix identifies the rule group or web ACL context of the rule that added the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelNameCondition(LabelNameCondition labelNameCondition);

        /**
         * <p>
         * A single label name condition. This is the fully qualified label name that a log record must contain in order
         * to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix
         * identifies the rule group or web ACL context of the rule that added the label.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelNameCondition.Builder} avoiding the
         * need to create one manually via {@link LabelNameCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelNameCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #labelNameCondition(LabelNameCondition)}.
         * 
         * @param labelNameCondition
         *        a consumer that will call methods on {@link LabelNameCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelNameCondition(LabelNameCondition)
         */
        default Builder labelNameCondition(Consumer<LabelNameCondition.Builder> labelNameCondition) {
            return labelNameCondition(LabelNameCondition.builder().applyMutation(labelNameCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActionCondition actionCondition;

        private LabelNameCondition labelNameCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            actionCondition(model.actionCondition);
            labelNameCondition(model.labelNameCondition);
        }

        public final ActionCondition.Builder getActionCondition() {
            return actionCondition != null ? actionCondition.toBuilder() : null;
        }

        public final void setActionCondition(ActionCondition.BuilderImpl actionCondition) {
            this.actionCondition = actionCondition != null ? actionCondition.build() : null;
        }

        @Override
        public final Builder actionCondition(ActionCondition actionCondition) {
            this.actionCondition = actionCondition;
            return this;
        }

        public final LabelNameCondition.Builder getLabelNameCondition() {
            return labelNameCondition != null ? labelNameCondition.toBuilder() : null;
        }

        public final void setLabelNameCondition(LabelNameCondition.BuilderImpl labelNameCondition) {
            this.labelNameCondition = labelNameCondition != null ? labelNameCondition.build() : null;
        }

        @Override
        public final Builder labelNameCondition(LabelNameCondition labelNameCondition) {
            this.labelNameCondition = labelNameCondition;
            return this;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
