/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.wafv2.internal.Wafv2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse;
import software.amazon.awssdk.services.wafv2.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.wafv2.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlRequest;
import software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse;
import software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyRequest;
import software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyResponse;
import software.amazon.awssdk.services.wafv2.model.GetIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseRequest;
import software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseResponse;
import software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListApiKeysRequest;
import software.amazon.awssdk.services.wafv2.model.ListApiKeysResponse;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsRequest;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse;
import software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesRequest;
import software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesResponse;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsRequest;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsRequest;
import software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsResponse;
import software.amazon.awssdk.services.wafv2.model.PutPermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.PutPermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.TagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.TagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.WafAssociatedItemException;
import software.amazon.awssdk.services.wafv2.model.WafConfigurationWarningException;
import software.amazon.awssdk.services.wafv2.model.WafDuplicateItemException;
import software.amazon.awssdk.services.wafv2.model.WafExpiredManagedRuleGroupVersionException;
import software.amazon.awssdk.services.wafv2.model.WafInternalErrorException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidOperationException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidParameterException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidPermissionPolicyException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidResourceException;
import software.amazon.awssdk.services.wafv2.model.WafLimitsExceededException;
import software.amazon.awssdk.services.wafv2.model.WafLogDestinationPermissionIssueException;
import software.amazon.awssdk.services.wafv2.model.WafNonexistentItemException;
import software.amazon.awssdk.services.wafv2.model.WafOptimisticLockException;
import software.amazon.awssdk.services.wafv2.model.WafServiceLinkedRoleErrorException;
import software.amazon.awssdk.services.wafv2.model.WafSubscriptionNotFoundException;
import software.amazon.awssdk.services.wafv2.model.WafTagOperationException;
import software.amazon.awssdk.services.wafv2.model.WafTagOperationInternalErrorException;
import software.amazon.awssdk.services.wafv2.model.WafUnavailableEntityException;
import software.amazon.awssdk.services.wafv2.model.WafUnsupportedAggregateKeyTypeException;
import software.amazon.awssdk.services.wafv2.model.Wafv2Exception;
import software.amazon.awssdk.services.wafv2.transform.AssociateWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CheckCapacityRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateIpSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteFirewallManagerRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteIpSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeletePermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DescribeAllManagedProductsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DescribeManagedProductsByVendorRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DescribeManagedRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DisassociateWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GenerateMobileSdkReleaseUrlRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetDecryptedApiKeyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetIpSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetManagedRuleSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetMobileSdkReleaseRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetPermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetRateBasedStatementManagedKeysRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetSampledRequestsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetWebAclForResourceRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListApiKeysRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListAvailableManagedRuleGroupVersionsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListAvailableManagedRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListIpSetsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListLoggingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListManagedRuleSetsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListMobileSdkReleasesRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListRegexPatternSetsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListResourcesForWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListWebAcLsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.PutLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.PutManagedRuleSetVersionsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.PutPermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateIpSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateManagedRuleSetVersionExpiryDateRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateWebAclRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link Wafv2Client}.
 *
 * @see Wafv2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWafv2Client implements Wafv2Client {
    private static final Logger log = Logger.loggerFor(DefaultWafv2Client.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final Wafv2ServiceClientConfiguration serviceClientConfiguration;

    protected DefaultWafv2Client(Wafv2ServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a web ACL with a regional application resource, to protect the resource. A regional application can be
     * an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito
     * user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <p>
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate
     * a web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name
     * (ARN) of the web ACL. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     *
     * @param associateWebAclRequest
     * @return Result of the AssociateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafUnavailableEntityException
     *         WAF couldn’t retrieve a resource that you specified for this operation. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate. Verify the resources that you are specifying in
     *         your request parameters and then retry the operation.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.AssociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateWebAclResponse associateWebACL(AssociateWebAclRequest associateWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafUnavailableEntityException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateWebAclResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateWebAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateWebAclRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateWebAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWebACL");

            return clientHandler.execute(new ClientExecutionParams<AssociateWebAclRequest, AssociateWebAclResponse>()
                    .withOperationName("AssociateWebACL").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(associateWebAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateWebAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to
     * check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>.
     * </p>
     * <p>
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and
     * web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule.
     * Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule
     * group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity
     * units (WCU)</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param checkCapacityRequest
     * @return Result of the CheckCapacity operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         WAF couldn’t retrieve a resource that you specified for this operation. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate. Verify the resources that you are specifying in
     *         your request parameters and then retry the operation.
     * @throws WafSubscriptionNotFoundException
     *         You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it
     *         yet.
     * @throws WafExpiredManagedRuleGroupVersionException
     *         The operation failed because the specified version for the managed rule group has expired. You can
     *         retrieve the available versions for the managed rule group by calling
     *         <a>ListAvailableManagedRuleGroupVersions</a>.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CheckCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CheckCapacityResponse checkCapacity(CheckCapacityRequest checkCapacityRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafLimitsExceededException, WafInvalidResourceException,
            WafUnavailableEntityException, WafSubscriptionNotFoundException, WafExpiredManagedRuleGroupVersionException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CheckCapacityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CheckCapacityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(checkCapacityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, checkCapacityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CheckCapacity");

            return clientHandler.execute(new ClientExecutionParams<CheckCapacityRequest, CheckCapacityResponse>()
                    .withOperationName("CheckCapacity").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(checkCapacityRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CheckCapacityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an API key that contains a set of token domains.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * You can use a single key for up to 5 domains. After you generate a key, you can copy it for use in your
     * JavaScript integration.
     * </p>
     *
     * @param createApiKeyRequest
     * @return Result of the CreateAPIKey operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateAPIKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateAPIKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateApiKeyResponse createAPIKey(CreateApiKeyRequest createApiKeyRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidOperationException, WafLimitsExceededException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAPIKey");

            return clientHandler.execute(new ClientExecutionParams<CreateApiKeyRequest, CreateApiKeyResponse>()
                    .withOperationName("CreateAPIKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createApiKeyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or
     * ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can
     * configure WAF to block them using an IPSet that lists those IP addresses.
     * </p>
     *
     * @param createIpSetRequest
     * @return Result of the CreateIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIpSetResponse createIPSet(CreateIpSetRequest createIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException,
            WafTagOperationException, WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIpSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIPSet");

            return clientHandler.execute(new ClientExecutionParams<CreateIpSetRequest, CreateIpSetResponse>()
                    .withOperationName("CreateIPSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createIpSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIpSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <a>RegexPatternSet</a>, which you reference in a <a>RegexPatternSetReferenceStatement</a>, to have WAF
     * inspect a web request component for the specified patterns.
     * </p>
     *
     * @param createRegexPatternSetRequest
     * @return Result of the CreateRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateRegexPatternSetResponse createRegexPatternSet(CreateRegexPatternSetRequest createRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafDuplicateItemException,
            WafOptimisticLockException, WafLimitsExceededException, WafTagOperationException,
            WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRegexPatternSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRegexPatternSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRegexPatternSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRegexPatternSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRegexPatternSet");

            return clientHandler.execute(new ClientExecutionParams<CreateRegexPatternSetRequest, CreateRegexPatternSetResponse>()
                    .withOperationName("CreateRegexPatternSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createRegexPatternSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRegexPatternSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <a>RuleGroup</a> per the specifications provided.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return Result of the CreateRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafUnavailableEntityException
     *         WAF couldn’t retrieve a resource that you specified for this operation. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate. Verify the resources that you are specifying in
     *         your request parameters and then retry the operation.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafSubscriptionNotFoundException
     *         You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it
     *         yet.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRuleGroupResponse createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafDuplicateItemException,
            WafOptimisticLockException, WafLimitsExceededException, WafUnavailableEntityException, WafTagOperationException,
            WafTagOperationInternalErrorException, WafSubscriptionNotFoundException, WafNonexistentItemException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRuleGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRuleGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateRuleGroupRequest, CreateRuleGroupResponse>()
                    .withOperationName("CreateRuleGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createRuleGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <a>WebACL</a> per the specifications provided.
     * </p>
     * <p>
     * A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has a statement
     * that defines what to look for in web requests and an action that WAF applies to requests that match the
     * statement. In the web ACL, you assign a default action to take (allow, block) for any request that does not match
     * any of the rules. The rules in a web ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and
     * managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The
     * resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer,
     * an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified
     * Access instance.
     * </p>
     *
     * @param createWebAclRequest
     * @return Result of the CreateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         WAF couldn’t retrieve a resource that you specified for this operation. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate. Verify the resources that you are specifying in
     *         your request parameters and then retry the operation.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafSubscriptionNotFoundException
     *         You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it
     *         yet.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafConfigurationWarningException
     *         The operation failed because you are inspecting the web request body, headers, or cookies without
     *         specifying how to handle oversize components. Rules that inspect the body must either provide an
     *         <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).
     * @throws WafExpiredManagedRuleGroupVersionException
     *         The operation failed because the specified version for the managed rule group has expired. You can
     *         retrieve the available versions for the managed rule group by calling
     *         <a>ListAvailableManagedRuleGroupVersions</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWebAclResponse createWebACL(CreateWebAclRequest createWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException,
            WafInvalidResourceException, WafUnavailableEntityException, WafNonexistentItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, WafSubscriptionNotFoundException, WafInvalidOperationException,
            WafConfigurationWarningException, WafExpiredManagedRuleGroupVersionException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWebAclResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWebAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWebAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWebACL");

            return clientHandler.execute(new ClientExecutionParams<CreateWebAclRequest, CreateWebAclResponse>()
                    .withOperationName("CreateWebACL").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createWebAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWebAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes all rule groups that are managed by Firewall Manager for the specified web ACL.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     *
     * @param deleteFirewallManagerRuleGroupsRequest
     * @return Result of the DeleteFirewallManagerRuleGroups operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteFirewallManagerRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteFirewallManagerRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFirewallManagerRuleGroupsResponse deleteFirewallManagerRuleGroups(
            DeleteFirewallManagerRuleGroupsRequest deleteFirewallManagerRuleGroupsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafOptimisticLockException, WafInvalidOperationException,
            AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFirewallManagerRuleGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFirewallManagerRuleGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallManagerRuleGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteFirewallManagerRuleGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewallManagerRuleGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFirewallManagerRuleGroupsRequest, DeleteFirewallManagerRuleGroupsResponse>()
                            .withOperationName("DeleteFirewallManagerRuleGroups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteFirewallManagerRuleGroupsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFirewallManagerRuleGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>IPSet</a>.
     * </p>
     *
     * @param deleteIpSetRequest
     * @return Result of the DeleteIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafAssociatedItemException
     *         WAF couldn’t perform the operation because your resource is being used by another resource or it’s
     *         associated with another resource.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIpSetResponse deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafOptimisticLockException, WafAssociatedItemException,
            WafTagOperationException, WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIpSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIPSet");

            return clientHandler.execute(new ClientExecutionParams<DeleteIpSetRequest, DeleteIpSetResponse>()
                    .withOperationName("DeleteIPSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteIpSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIpSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the <a>LoggingConfiguration</a> from the specified web ACL.
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     * @return Result of the DeleteLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLoggingConfigurationResponse deleteLoggingConfiguration(
            DeleteLoggingConfigurationRequest deleteLoggingConfigurationRequest) throws WafInternalErrorException,
            WafNonexistentItemException, WafOptimisticLockException, WafInvalidParameterException, WafInvalidOperationException,
            AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLoggingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLoggingConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLoggingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLoggingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLoggingConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLoggingConfigurationRequest, DeleteLoggingConfigurationResponse>()
                            .withOperationName("DeleteLoggingConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteLoggingConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLoggingConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Permanently deletes an IAM policy from the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     *
     * @param deletePermissionPolicyRequest
     * @return Result of the DeletePermissionPolicy operation returned by the service.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeletePermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeletePermissionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeletePermissionPolicyResponse deletePermissionPolicy(DeletePermissionPolicyRequest deletePermissionPolicyRequest)
            throws WafNonexistentItemException, WafInternalErrorException, WafInvalidParameterException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePermissionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePermissionPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePermissionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePermissionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePermissionPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeletePermissionPolicyRequest, DeletePermissionPolicyResponse>()
                            .withOperationName("DeletePermissionPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deletePermissionPolicyRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeletePermissionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param deleteRegexPatternSetRequest
     * @return Result of the DeleteRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafAssociatedItemException
     *         WAF couldn’t perform the operation because your resource is being used by another resource or it’s
     *         associated with another resource.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteRegexPatternSetResponse deleteRegexPatternSet(DeleteRegexPatternSetRequest deleteRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafOptimisticLockException, WafAssociatedItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRegexPatternSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRegexPatternSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRegexPatternSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRegexPatternSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRegexPatternSet");

            return clientHandler.execute(new ClientExecutionParams<DeleteRegexPatternSetRequest, DeleteRegexPatternSetResponse>()
                    .withOperationName("DeleteRegexPatternSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteRegexPatternSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRegexPatternSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return Result of the DeleteRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafAssociatedItemException
     *         WAF couldn’t perform the operation because your resource is being used by another resource or it’s
     *         associated with another resource.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRuleGroupResponse deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafOptimisticLockException, WafAssociatedItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRuleGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRuleGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteRuleGroupRequest, DeleteRuleGroupResponse>()
                    .withOperationName("DeleteRuleGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteRuleGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>WebACL</a>.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     * <note>
     * <p>
     * Before deleting any web ACL, first disassociate it from all resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a list of the resources that are associated with a web ACL, use the following calls:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For regional resources, call <a>ListResourcesForWebACL</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon CloudFront distributions, use the CloudFront call <code>ListDistributionsByWebACLId</code>. For
     * information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html"
     * >ListDistributionsByWebACLId</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To disassociate a resource from a web ACL, use the following calls:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For regional resources, call <a>DisassociateWebACL</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon CloudFront distributions, provide an empty web ACL ID in the CloudFront call
     * <code>UpdateDistribution</code>. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteWebAclRequest
     * @return Result of the DeleteWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafAssociatedItemException
     *         WAF couldn’t perform the operation because your resource is being used by another resource or it’s
     *         associated with another resource.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWebAclResponse deleteWebACL(DeleteWebAclRequest deleteWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafOptimisticLockException, WafAssociatedItemException,
            WafTagOperationException, WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWebAclResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWebAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWebAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWebACL");

            return clientHandler.execute(new ClientExecutionParams<DeleteWebAclRequest, DeleteWebAclResponse>()
                    .withOperationName("DeleteWebACL").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteWebAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWebAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides high-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
     * Marketplace managed rule groups.
     * </p>
     *
     * @param describeAllManagedProductsRequest
     * @return Result of the DescribeAllManagedProducts operation returned by the service.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DescribeAllManagedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeAllManagedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAllManagedProductsResponse describeAllManagedProducts(
            DescribeAllManagedProductsRequest describeAllManagedProductsRequest) throws WafInvalidOperationException,
            WafInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAllManagedProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAllManagedProductsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAllManagedProductsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAllManagedProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAllManagedProducts");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAllManagedProductsRequest, DescribeAllManagedProductsResponse>()
                            .withOperationName("DescribeAllManagedProducts").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeAllManagedProductsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAllManagedProductsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides high-level information for the managed rule groups owned by a specific vendor.
     * </p>
     *
     * @param describeManagedProductsByVendorRequest
     * @return Result of the DescribeManagedProductsByVendor operation returned by the service.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DescribeManagedProductsByVendor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedProductsByVendor"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeManagedProductsByVendorResponse describeManagedProductsByVendor(
            DescribeManagedProductsByVendorRequest describeManagedProductsByVendorRequest) throws WafInvalidOperationException,
            WafInternalErrorException, WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeManagedProductsByVendorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeManagedProductsByVendorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeManagedProductsByVendorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeManagedProductsByVendorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeManagedProductsByVendor");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeManagedProductsByVendorRequest, DescribeManagedProductsByVendorResponse>()
                            .withOperationName("DescribeManagedProductsByVendor").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeManagedProductsByVendorRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeManagedProductsByVendorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     * </p>
     *
     * @param describeManagedRuleGroupRequest
     * @return Result of the DescribeManagedRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidResourceException
     *         WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafExpiredManagedRuleGroupVersionException
     *         The operation failed because the specified version for the managed rule group has expired. You can
     *         retrieve the available versions for the managed rule group by calling
     *         <a>ListAvailableManagedRuleGroupVersions</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DescribeManagedRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeManagedRuleGroupResponse describeManagedRuleGroup(
            DescribeManagedRuleGroupRequest describeManagedRuleGroupRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidResourceException, WafNonexistentItemException, WafInvalidOperationException,
            WafExpiredManagedRuleGroupVersionException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeManagedRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeManagedRuleGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeManagedRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeManagedRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeManagedRuleGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeManagedRuleGroupRequest, DescribeManagedRuleGroupResponse>()
                            .withOperationName("DescribeManagedRuleGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeManagedRuleGroupRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeManagedRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified regional application resource from any existing web ACL association. A resource can
     * have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon
     * API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon
     * Web Services Verified Access instance.
     * </p>
     * <p>
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To
     * disassociate a web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For
     * information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">
     * UpdateDistribution</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     *
     * @param disassociateWebAclRequest
     * @return Result of the DisassociateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DisassociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisassociateWebAclResponse disassociateWebACL(DisassociateWebAclRequest disassociateWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateWebAclResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateWebAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateWebAclRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateWebAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWebACL");

            return clientHandler.execute(new ClientExecutionParams<DisassociateWebAclRequest, DisassociateWebAclResponse>()
                    .withOperationName("DisassociateWebACL").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(disassociateWebAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateWebAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a presigned download URL for the specified release of the mobile SDK.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param generateMobileSdkReleaseUrlRequest
     * @return Result of the GenerateMobileSdkReleaseUrl operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GenerateMobileSdkReleaseUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GenerateMobileSdkReleaseUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GenerateMobileSdkReleaseUrlResponse generateMobileSdkReleaseUrl(
            GenerateMobileSdkReleaseUrlRequest generateMobileSdkReleaseUrlRequest) throws WafInternalErrorException,
            WafNonexistentItemException, WafInvalidParameterException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GenerateMobileSdkReleaseUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GenerateMobileSdkReleaseUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(generateMobileSdkReleaseUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, generateMobileSdkReleaseUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateMobileSdkReleaseUrl");

            return clientHandler
                    .execute(new ClientExecutionParams<GenerateMobileSdkReleaseUrlRequest, GenerateMobileSdkReleaseUrlResponse>()
                            .withOperationName("GenerateMobileSdkReleaseUrl").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(generateMobileSdkReleaseUrlRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GenerateMobileSdkReleaseUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns your API key in decrypted form. Use this to check the token domains that you have defined for the key.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param getDecryptedApiKeyRequest
     * @return Result of the GetDecryptedAPIKey operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafInvalidResourceException
     *         WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetDecryptedAPIKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetDecryptedAPIKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDecryptedApiKeyResponse getDecryptedAPIKey(GetDecryptedApiKeyRequest getDecryptedApiKeyRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafInvalidOperationException,
            WafInvalidResourceException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDecryptedApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDecryptedApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDecryptedApiKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDecryptedApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDecryptedAPIKey");

            return clientHandler.execute(new ClientExecutionParams<GetDecryptedApiKeyRequest, GetDecryptedApiKeyResponse>()
                    .withOperationName("GetDecryptedAPIKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getDecryptedApiKeyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDecryptedApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified <a>IPSet</a>.
     * </p>
     *
     * @param getIpSetRequest
     * @return Result of the GetIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetIpSetResponse getIPSet(GetIpSetRequest getIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIpSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIpSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIPSet");

            return clientHandler.execute(new ClientExecutionParams<GetIpSetRequest, GetIpSetResponse>()
                    .withOperationName("GetIPSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getIpSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIpSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the <a>LoggingConfiguration</a> for the specified web ACL.
     * </p>
     *
     * @param getLoggingConfigurationRequest
     * @return Result of the GetLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLoggingConfigurationResponse getLoggingConfiguration(GetLoggingConfigurationRequest getLoggingConfigurationRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafInvalidParameterException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLoggingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLoggingConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLoggingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoggingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoggingConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetLoggingConfigurationRequest, GetLoggingConfigurationResponse>()
                            .withOperationName("GetLoggingConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getLoggingConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetLoggingConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified managed rule set.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     *
     * @param getManagedRuleSetRequest
     * @return Result of the GetManagedRuleSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetManagedRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetManagedRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetManagedRuleSetResponse getManagedRuleSet(GetManagedRuleSetRequest getManagedRuleSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetManagedRuleSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetManagedRuleSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getManagedRuleSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getManagedRuleSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetManagedRuleSet");

            return clientHandler.execute(new ClientExecutionParams<GetManagedRuleSetRequest, GetManagedRuleSetResponse>()
                    .withOperationName("GetManagedRuleSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getManagedRuleSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetManagedRuleSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information for the specified mobile SDK release, including release notes and tags.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param getMobileSdkReleaseRequest
     * @return Result of the GetMobileSdkRelease operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetMobileSdkRelease
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetMobileSdkRelease" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMobileSdkReleaseResponse getMobileSdkRelease(GetMobileSdkReleaseRequest getMobileSdkReleaseRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafInvalidParameterException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMobileSdkReleaseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMobileSdkReleaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMobileSdkReleaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMobileSdkReleaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMobileSdkRelease");

            return clientHandler.execute(new ClientExecutionParams<GetMobileSdkReleaseRequest, GetMobileSdkReleaseResponse>()
                    .withOperationName("GetMobileSdkRelease").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getMobileSdkReleaseRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMobileSdkReleaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the IAM policy that is attached to the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     *
     * @param getPermissionPolicyRequest
     * @return Result of the GetPermissionPolicy operation returned by the service.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPermissionPolicyResponse getPermissionPolicy(GetPermissionPolicyRequest getPermissionPolicyRequest)
            throws WafNonexistentItemException, WafInternalErrorException, WafInvalidParameterException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPermissionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPermissionPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPermissionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPermissionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPermissionPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetPermissionPolicyRequest, GetPermissionPolicyResponse>()
                    .withOperationName("GetPermissionPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getPermissionPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPermissionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the IP addresses that are currently blocked by a rate-based rule instance. This is only available for
     * rate-based rules that aggregate solely on the IP address or on the forwarded IP address.
     * </p>
     * <p>
     * The maximum number of addresses that can be blocked for a single rate-based rule instance is 10,000. If more than
     * 10,000 addresses exceed the rate limit, those with the highest rates are blocked.
     * </p>
     * <p>
     * For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference
     * statement in your request, in addition to the rate-based rule name and the web ACL name.
     * </p>
     * <p>
     * WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule
     * group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the
     * rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference
     * statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web
     * requests and manages keys for this second usage completely independent of your first.
     * </p>
     *
     * @param getRateBasedStatementManagedKeysRequest
     * @return Result of the GetRateBasedStatementManagedKeys operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafUnsupportedAggregateKeyTypeException
     *         The rule that you've named doesn't aggregate solely on the IP address or solely on the forwarded IP
     *         address. This call is only available for rate-based rules with an <code>AggregateKeyType</code> setting
     *         of <code>IP</code> or <code>FORWARDED_IP</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRateBasedStatementManagedKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRateBasedStatementManagedKeysResponse getRateBasedStatementManagedKeys(
            GetRateBasedStatementManagedKeysRequest getRateBasedStatementManagedKeysRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafInvalidOperationException,
            WafUnsupportedAggregateKeyTypeException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRateBasedStatementManagedKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRateBasedStatementManagedKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRateBasedStatementManagedKeysRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRateBasedStatementManagedKeysRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRateBasedStatementManagedKeys");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRateBasedStatementManagedKeysRequest, GetRateBasedStatementManagedKeysResponse>()
                            .withOperationName("GetRateBasedStatementManagedKeys").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getRateBasedStatementManagedKeysRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRateBasedStatementManagedKeysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param getRegexPatternSetRequest
     * @return Result of the GetRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRegexPatternSetResponse getRegexPatternSet(GetRegexPatternSetRequest getRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRegexPatternSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRegexPatternSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRegexPatternSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRegexPatternSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRegexPatternSet");

            return clientHandler.execute(new ClientExecutionParams<GetRegexPatternSetRequest, GetRegexPatternSetResponse>()
                    .withOperationName("GetRegexPatternSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getRegexPatternSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRegexPatternSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param getRuleGroupRequest
     * @return Result of the GetRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRuleGroupResponse getRuleGroup(GetRuleGroupRequest getRuleGroupRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRuleGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRuleGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRuleGroup");

            return clientHandler.execute(new ClientExecutionParams<GetRuleGroupRequest, GetRuleGroupResponse>()
                    .withOperationName("GetRuleGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getRuleGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among
     * the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You
     * can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     * </p>
     * <p>
     * <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified.
     * However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time
     * range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the
     * actual period during which WAF selected the requests in the sample.
     * </p>
     *
     * @param getSampledRequestsRequest
     * @return Result of the GetSampledRequests operation returned by the service.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetSampledRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSampledRequestsResponse getSampledRequests(GetSampledRequestsRequest getSampledRequestsRequest)
            throws WafNonexistentItemException, WafInternalErrorException, WafInvalidParameterException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSampledRequestsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSampledRequestsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSampledRequestsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSampledRequestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSampledRequests");

            return clientHandler.execute(new ClientExecutionParams<GetSampledRequestsRequest, GetSampledRequestsResponse>()
                    .withOperationName("GetSampledRequests").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSampledRequestsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSampledRequestsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified <a>WebACL</a>.
     * </p>
     *
     * @param getWebAclRequest
     * @return Result of the GetWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWebAclResponse getWebACL(GetWebAclRequest getWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWebAclResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWebAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWebAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWebACL");

            return clientHandler.execute(new ClientExecutionParams<GetWebAclRequest, GetWebAclResponse>()
                    .withOperationName("GetWebACL").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getWebAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWebAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the <a>WebACL</a> for the specified resource.
     * </p>
     *
     * @param getWebAclForResourceRequest
     * @return Result of the GetWebACLForResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafUnavailableEntityException
     *         WAF couldn’t retrieve a resource that you specified for this operation. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate. Verify the resources that you are specifying in
     *         your request parameters and then retry the operation.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetWebACLForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetWebAclForResourceResponse getWebACLForResource(GetWebAclForResourceRequest getWebAclForResourceRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafInvalidParameterException,
            WafUnavailableEntityException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWebAclForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWebAclForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWebAclForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWebAclForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWebACLForResource");

            return clientHandler.execute(new ClientExecutionParams<GetWebAclForResourceRequest, GetWebAclForResourceResponse>()
                    .withOperationName("GetWebACLForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getWebAclForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWebAclForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the API keys that you've defined for the specified scope.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param listApiKeysRequest
     * @return Result of the ListAPIKeys operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafInvalidResourceException
     *         WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListAPIKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAPIKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListApiKeysResponse listAPIKeys(ListApiKeysRequest listApiKeysRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidOperationException, WafInvalidResourceException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListApiKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApiKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApiKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAPIKeys");

            return clientHandler.execute(new ClientExecutionParams<ListApiKeysRequest, ListApiKeysResponse>()
                    .withOperationName("ListAPIKeys").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listApiKeysRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListApiKeysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the available versions for the specified managed rule group.
     * </p>
     *
     * @param listAvailableManagedRuleGroupVersionsRequest
     * @return Result of the ListAvailableManagedRuleGroupVersions operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListAvailableManagedRuleGroupVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroupVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAvailableManagedRuleGroupVersionsResponse listAvailableManagedRuleGroupVersions(
            ListAvailableManagedRuleGroupVersionsRequest listAvailableManagedRuleGroupVersionsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAvailableManagedRuleGroupVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListAvailableManagedRuleGroupVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAvailableManagedRuleGroupVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAvailableManagedRuleGroupVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAvailableManagedRuleGroupVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAvailableManagedRuleGroupVersionsRequest, ListAvailableManagedRuleGroupVersionsResponse>()
                            .withOperationName("ListAvailableManagedRuleGroupVersions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(listAvailableManagedRuleGroupVersionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAvailableManagedRuleGroupVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web
     * Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're
     * subscribed to.
     * </p>
     *
     * @param listAvailableManagedRuleGroupsRequest
     * @return Result of the ListAvailableManagedRuleGroups operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListAvailableManagedRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAvailableManagedRuleGroupsResponse listAvailableManagedRuleGroups(
            ListAvailableManagedRuleGroupsRequest listAvailableManagedRuleGroupsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAvailableManagedRuleGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAvailableManagedRuleGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAvailableManagedRuleGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAvailableManagedRuleGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAvailableManagedRuleGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAvailableManagedRuleGroupsRequest, ListAvailableManagedRuleGroupsResponse>()
                            .withOperationName("ListAvailableManagedRuleGroups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(listAvailableManagedRuleGroupsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAvailableManagedRuleGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.
     * </p>
     *
     * @param listIpSetsRequest
     * @return Result of the ListIPSets operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIpSetsResponse listIPSets(ListIpSetsRequest listIpSetsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIpSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIpSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIpSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIpSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIPSets");

            return clientHandler.execute(new ClientExecutionParams<ListIpSetsRequest, ListIpSetsResponse>()
                    .withOperationName("ListIPSets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listIpSetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIpSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an array of your <a>LoggingConfiguration</a> objects.
     * </p>
     *
     * @param listLoggingConfigurationsRequest
     * @return Result of the ListLoggingConfigurations operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListLoggingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLoggingConfigurationsResponse listLoggingConfigurations(
            ListLoggingConfigurationsRequest listLoggingConfigurationsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLoggingConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLoggingConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLoggingConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLoggingConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLoggingConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListLoggingConfigurationsRequest, ListLoggingConfigurationsResponse>()
                            .withOperationName("ListLoggingConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(listLoggingConfigurationsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListLoggingConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the managed rule sets that you own.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     *
     * @param listManagedRuleSetsRequest
     * @return Result of the ListManagedRuleSets operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListManagedRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListManagedRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListManagedRuleSetsResponse listManagedRuleSets(ListManagedRuleSetsRequest listManagedRuleSetsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListManagedRuleSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListManagedRuleSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedRuleSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listManagedRuleSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedRuleSets");

            return clientHandler.execute(new ClientExecutionParams<ListManagedRuleSetsRequest, ListManagedRuleSetsResponse>()
                    .withOperationName("ListManagedRuleSets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listManagedRuleSetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListManagedRuleSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the available releases for the mobile SDK and the specified device platform.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param listMobileSdkReleasesRequest
     * @return Result of the ListMobileSdkReleases operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListMobileSdkReleases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListMobileSdkReleases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListMobileSdkReleasesResponse listMobileSdkReleases(ListMobileSdkReleasesRequest listMobileSdkReleasesRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMobileSdkReleasesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMobileSdkReleasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMobileSdkReleasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMobileSdkReleasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMobileSdkReleases");

            return clientHandler.execute(new ClientExecutionParams<ListMobileSdkReleasesRequest, ListMobileSdkReleasesResponse>()
                    .withOperationName("ListMobileSdkReleases").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listMobileSdkReleasesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMobileSdkReleasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.
     * </p>
     *
     * @param listRegexPatternSetsRequest
     * @return Result of the ListRegexPatternSets operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListRegexPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListRegexPatternSetsResponse listRegexPatternSets(ListRegexPatternSetsRequest listRegexPatternSetsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRegexPatternSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRegexPatternSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRegexPatternSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRegexPatternSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRegexPatternSets");

            return clientHandler.execute(new ClientExecutionParams<ListRegexPatternSetsRequest, ListRegexPatternSetsResponse>()
                    .withOperationName("ListRegexPatternSets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listRegexPatternSetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRegexPatternSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the
     * specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call
     * <code>ListDistributionsByWebACLId</code>.
     * </p>
     *
     * @param listResourcesForWebAclRequest
     * @return Result of the ListResourcesForWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListResourcesForWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListResourcesForWebAclResponse listResourcesForWebACL(ListResourcesForWebAclRequest listResourcesForWebAclRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafInvalidParameterException,
            WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourcesForWebAclResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourcesForWebAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourcesForWebAclRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourcesForWebAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourcesForWebACL");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourcesForWebAclRequest, ListResourcesForWebAclResponse>()
                            .withOperationName("ListResourcesForWebACL").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(listResourcesForWebAclRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResourcesForWebAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return Result of the ListRuleGroups operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRuleGroupsResponse listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRuleGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRuleGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRuleGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRuleGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRuleGroups");

            return clientHandler.execute(new ClientExecutionParams<ListRuleGroupsRequest, ListRuleGroupsResponse>()
                    .withOperationName("ListRuleGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listRuleGroupsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRuleGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the <a>TagInfoForResource</a> for the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and
     * regex pattern sets. You can't manage or view tags through the WAF console.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafTagOperationException, WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.
     * </p>
     *
     * @param listWebAcLsRequest
     * @return Result of the ListWebACLs operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListWebACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWebAcLsResponse listWebACLs(ListWebAcLsRequest listWebAcLsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWebAcLsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWebAcLsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWebAcLsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWebAcLsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWebACLs");

            return clientHandler.execute(new ClientExecutionParams<ListWebAcLsRequest, ListWebAcLsResponse>()
                    .withOperationName("ListWebACLs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listWebAcLsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWebAcLsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the
     * configuration provided.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces any mutable specifications that you already have for a logging configuration
     * with the ones that you provide to this call.
     * </p>
     * <p>
     * To modify an existing logging configuration, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetLoggingConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete logging configuration specification to this call
     * </p>
     * </li>
     * </ol>
     * </note> <note>
     * <p>
     * You can define one logging destination per web ACL.
     * </p>
     * </note>
     * <p>
     * You can access information about the traffic that WAF inspects using the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage
     * Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose.
     * </p>
     * <p>
     * The name that you give the destination must start with <code>aws-waf-logs-</code>. Depending on the type of
     * destination, you might need to configure additional settings or permissions.
     * </p>
     * <p>
     * For configuration requirements and pricing information for each destination type, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic</a> in the
     * <i>WAF Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.
     * </p>
     * </li>
     * </ol>
     * <p>
     * When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, WAF creates an
     * additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch
     * Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket
     * policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.
     * </p>
     * <p>
     * For additional information about web ACL logging, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a>
     * in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param putLoggingConfigurationRequest
     * @return Result of the PutLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafServiceLinkedRoleErrorException
     *         WAF is not able to access the service linked role. This can be caused by a previous
     *         <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20
     *         seconds. Please try your request again. The service linked role can also be locked by a previous
     *         <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you
     *         recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the
     *         request again. If you receive this same exception again, you will have to wait additional time until the
     *         role is unlocked.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafLogDestinationPermissionIssueException
     *         The operation failed because you don't have the permissions that your logging configuration requires. For
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web
     *         ACL traffic information</a> in the <i>WAF Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.PutLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutLoggingConfigurationResponse putLoggingConfiguration(PutLoggingConfigurationRequest putLoggingConfigurationRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafOptimisticLockException,
            WafServiceLinkedRoleErrorException, WafInvalidParameterException, WafInvalidOperationException,
            WafLimitsExceededException, WafLogDestinationPermissionIssueException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutLoggingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutLoggingConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putLoggingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLoggingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLoggingConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<PutLoggingConfigurationRequest, PutLoggingConfigurationResponse>()
                            .withOperationName("PutLoggingConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(putLoggingConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutLoggingConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines the versions of your managed rule set that you are offering to the customers. Customers see your
     * offerings as managed rule groups with versioning.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     * <p>
     * Customers retrieve their managed rule group list by calling <a>ListAvailableManagedRuleGroups</a>. The name that
     * you provide here for your managed rule set is the name the customer sees for the corresponding managed rule
     * group. Customers can retrieve the available versions for a managed rule group by calling
     * <a>ListAvailableManagedRuleGroupVersions</a>. You provide a rule group specification for each version. For each
     * managed rule set, you must specify a version that you recommend using.
     * </p>
     * <p>
     * To initiate the expiration of a managed rule group version, use <a>UpdateManagedRuleSetVersionExpiryDate</a>.
     * </p>
     *
     * @param putManagedRuleSetVersionsRequest
     * @return Result of the PutManagedRuleSetVersions operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.PutManagedRuleSetVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutManagedRuleSetVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutManagedRuleSetVersionsResponse putManagedRuleSetVersions(
            PutManagedRuleSetVersionsRequest putManagedRuleSetVersionsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafOptimisticLockException, WafInvalidOperationException,
            AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutManagedRuleSetVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutManagedRuleSetVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putManagedRuleSetVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putManagedRuleSetVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutManagedRuleSetVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<PutManagedRuleSetVersionsRequest, PutManagedRuleSetVersionsResponse>()
                            .withOperationName("PutManagedRuleSetVersions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(putManagedRuleSetVersionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutManagedRuleSetVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <p>
     * This action is subject to the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can attach only one policy with each <code>PutPermissionPolicy</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN in the request must be a valid WAF <a>RuleGroup</a> ARN and the rule group must exist in the same Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * The user making the request must be the owner of the rule group.
     * </p>
     * </li>
     * </ul>
     *
     * @param putPermissionPolicyRequest
     * @return Result of the PutPermissionPolicy operation returned by the service.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidPermissionPolicyException
     *         The operation failed because the specified policy isn't in the proper format. </p>
     *         <p>
     *         The policy specifications must conform to the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The policy must be composed using IAM Policy version 2012-10-17.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must include specifications for <code>Effect</code>, <code>Action</code>, and
     *         <code>Principal</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Effect</code> must specify <code>Allow</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and
     *         <code>wafv2:PutFirewallManagerRuleGroups</code> and may optionally specify
     *         <code>wafv2:GetRuleGroup</code>. WAF rejects any extra actions or wildcard actions in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must not include a <code>Resource</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.PutPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutPermissionPolicyResponse putPermissionPolicy(PutPermissionPolicyRequest putPermissionPolicyRequest)
            throws WafNonexistentItemException, WafInternalErrorException, WafInvalidParameterException,
            WafInvalidPermissionPolicyException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutPermissionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutPermissionPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putPermissionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putPermissionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutPermissionPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutPermissionPolicyRequest, PutPermissionPolicyResponse>()
                    .withOperationName("PutPermissionPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putPermissionPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutPermissionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and
     * regex pattern sets. You can't manage or view tags through the WAF console.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafLimitsExceededException, WafNonexistentItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with
     * Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be
     * "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon
     * Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, WafInvalidOperationException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified <a>IPSet</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the IP set with the ones
     * that you provide to this call.
     * </p>
     * <p>
     * To modify an IP set, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetIPSet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete IP set specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     *
     * @param updateIpSetRequest
     * @return Result of the UpdateIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafDuplicateItemException
     *         WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateIpSetResponse updateIPSet(UpdateIpSetRequest updateIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafDuplicateItemException, WafOptimisticLockException,
            WafLimitsExceededException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateIpSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIpSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIPSet");

            return clientHandler.execute(new ClientExecutionParams<UpdateIpSetRequest, UpdateIpSetResponse>()
                    .withOperationName("UpdateIPSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateIpSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateIpSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed
     * rule group version. After you initiate expiration for a version, WAF excludes it from the response to
     * <a>ListAvailableManagedRuleGroupVersions</a> for the managed rule group.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     *
     * @param updateManagedRuleSetVersionExpiryDateRequest
     * @return Result of the UpdateManagedRuleSetVersionExpiryDate operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateManagedRuleSetVersionExpiryDate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateManagedRuleSetVersionExpiryDate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateManagedRuleSetVersionExpiryDateResponse updateManagedRuleSetVersionExpiryDate(
            UpdateManagedRuleSetVersionExpiryDateRequest updateManagedRuleSetVersionExpiryDateRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafOptimisticLockException, WafInvalidOperationException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateManagedRuleSetVersionExpiryDateResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateManagedRuleSetVersionExpiryDateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateManagedRuleSetVersionExpiryDateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateManagedRuleSetVersionExpiryDateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateManagedRuleSetVersionExpiryDate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateManagedRuleSetVersionExpiryDateRequest, UpdateManagedRuleSetVersionExpiryDateResponse>()
                            .withOperationName("UpdateManagedRuleSetVersionExpiryDate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(updateManagedRuleSetVersionExpiryDateRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateManagedRuleSetVersionExpiryDateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified <a>RegexPatternSet</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the regex pattern set
     * with the ones that you provide to this call.
     * </p>
     * <p>
     * To modify a regex pattern set, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetRegexPatternSet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete regex pattern set specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     *
     * @param updateRegexPatternSetRequest
     * @return Result of the UpdateRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafDuplicateItemException
     *         WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateRegexPatternSetResponse updateRegexPatternSet(UpdateRegexPatternSetRequest updateRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException, WafInvalidOperationException,
            AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRegexPatternSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRegexPatternSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRegexPatternSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRegexPatternSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRegexPatternSet");

            return clientHandler.execute(new ClientExecutionParams<UpdateRegexPatternSetRequest, UpdateRegexPatternSetResponse>()
                    .withOperationName("UpdateRegexPatternSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateRegexPatternSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRegexPatternSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified <a>RuleGroup</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the rule group with the
     * ones that you provide to this call.
     * </p>
     * <p>
     * To modify a rule group, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetRuleGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete rule group specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return Result of the UpdateRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafDuplicateItemException
     *         WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafUnavailableEntityException
     *         WAF couldn’t retrieve a resource that you specified for this operation. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate. Verify the resources that you are specifying in
     *         your request parameters and then retry the operation.
     * @throws WafSubscriptionNotFoundException
     *         You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it
     *         yet.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafConfigurationWarningException
     *         The operation failed because you are inspecting the web request body, headers, or cookies without
     *         specifying how to handle oversize components. Rules that inspect the body must either provide an
     *         <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateRuleGroupResponse updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException, WafUnavailableEntityException,
            WafSubscriptionNotFoundException, WafInvalidOperationException, WafConfigurationWarningException,
            AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRuleGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRuleGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateRuleGroupRequest, UpdateRuleGroupResponse>()
                    .withOperationName("UpdateRuleGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateRuleGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified <a>WebACL</a>. While updating a web ACL, WAF provides continuous coverage to the resources
     * that you have associated with the web ACL.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the web ACL with the ones
     * that you provide to this call.
     * </p>
     * <p>
     * To modify a web ACL, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetWebACL</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete web ACL specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <p>
     * A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has a statement
     * that defines what to look for in web requests and an action that WAF applies to requests that match the
     * statement. In the web ACL, you assign a default action to take (allow, block) for any request that does not match
     * any of the rules. The rules in a web ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and
     * managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The
     * resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer,
     * an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified
     * Access instance.
     * </p>
     *
     * @param updateWebAclRequest
     * @return Result of the UpdateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         WAF couldn’t perform the operation because your resource doesn't exist. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate.
     * @throws WafDuplicateItemException
     *         WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         WAF couldn’t save your changes because you tried to update or delete a resource that has changed since
     *         you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and
     *         retry your operation.
     * @throws WafLimitsExceededException
     *         WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more
     *         information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF
     *         quotas</a> in the <i>WAF Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         WAF couldn’t retrieve a resource that you specified for this operation. If you've just created a resource
     *         that you're using in this operation, you might just need to wait a few minutes. It can take from a few
     *         seconds to a number of minutes for changes to propagate. Verify the resources that you are specifying in
     *         your request parameters and then retry the operation.
     * @throws WafSubscriptionNotFoundException
     *         You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it
     *         yet.
     * @throws WafInvalidOperationException
     *         The operation isn't valid.
     * @throws WafExpiredManagedRuleGroupVersionException
     *         The operation failed because the specified version for the managed rule group has expired. You can
     *         retrieve the available versions for the managed rule group by calling
     *         <a>ListAvailableManagedRuleGroupVersions</a>.
     * @throws WafConfigurationWarningException
     *         The operation failed because you are inspecting the web request body, headers, or cookies without
     *         specifying how to handle oversize components. Rules that inspect the body must either provide an
     *         <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateWebAclResponse updateWebACL(UpdateWebAclRequest updateWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafDuplicateItemException, WafOptimisticLockException,
            WafLimitsExceededException, WafInvalidResourceException, WafUnavailableEntityException,
            WafSubscriptionNotFoundException, WafInvalidOperationException, WafExpiredManagedRuleGroupVersionException,
            WafConfigurationWarningException, AwsServiceException, SdkClientException, Wafv2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWebAclResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWebAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWebAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWebACL");

            return clientHandler.execute(new ClientExecutionParams<UpdateWebAclRequest, UpdateWebAclResponse>()
                    .withOperationName("UpdateWebACL").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateWebAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWebAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        Wafv2ServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = Wafv2ServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(Wafv2Exception::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException")
                                .exceptionBuilderSupplier(WafUnavailableEntityException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException")
                                .exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFOptimisticLockException")
                                .exceptionBuilderSupplier(WafOptimisticLockException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException")
                                .exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException")
                                .exceptionBuilderSupplier(WafConfigurationWarningException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFAssociatedItemException")
                                .exceptionBuilderSupplier(WafAssociatedItemException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFLimitsExceededException")
                                .exceptionBuilderSupplier(WafLimitsExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFInvalidParameterException")
                                .exceptionBuilderSupplier(WafInvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFDuplicateItemException")
                                .exceptionBuilderSupplier(WafDuplicateItemException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFNonexistentItemException")
                                .exceptionBuilderSupplier(WafNonexistentItemException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException")
                                .exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException")
                                .exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException")
                                .exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFTagOperationException")
                                .exceptionBuilderSupplier(WafTagOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException")
                                .exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFInvalidOperationException")
                                .exceptionBuilderSupplier(WafInvalidOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFInternalErrorException")
                                .exceptionBuilderSupplier(WafInternalErrorException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException")
                                .exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WAFInvalidResourceException")
                                .exceptionBuilderSupplier(WafInvalidResourceException::builder).httpStatusCode(400).build());
    }

    @Override
    public final Wafv2ServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
