/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
 * </p>
 * <p>
 * This is part of the <code>AWSManagedRulesATPRuleSet</code> configuration in <code>ManagedRuleGroupConfig</code>.
 * </p>
 * <p>
 * In these settings, you specify how your application accepts login attempts by providing the request payload type and
 * the names of the fields within the request body where the username and password are provided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestInspection implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestInspection.Builder, RequestInspection> {
    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadType").getter(getter(RequestInspection::payloadTypeAsString))
            .setter(setter(Builder::payloadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()).build();

    private static final SdkField<UsernameField> USERNAME_FIELD_FIELD = SdkField
            .<UsernameField> builder(MarshallingType.SDK_POJO).memberName("UsernameField")
            .getter(getter(RequestInspection::usernameField)).setter(setter(Builder::usernameField))
            .constructor(UsernameField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameField").build()).build();

    private static final SdkField<PasswordField> PASSWORD_FIELD_FIELD = SdkField
            .<PasswordField> builder(MarshallingType.SDK_POJO).memberName("PasswordField")
            .getter(getter(RequestInspection::passwordField)).setter(setter(Builder::passwordField))
            .constructor(PasswordField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_TYPE_FIELD,
            USERNAME_FIELD_FIELD, PASSWORD_FIELD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String payloadType;

    private final UsernameField usernameField;

    private final PasswordField passwordField;

    private RequestInspection(BuilderImpl builder) {
        this.payloadType = builder.payloadType;
        this.usernameField = builder.usernameField;
        this.passwordField = builder.passwordField;
    }

    /**
     * <p>
     * The payload type for your login endpoint, either JSON or form encoded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The payload type for your login endpoint, either JSON or form encoded.
     * @see PayloadType
     */
    public final PayloadType payloadType() {
        return PayloadType.fromValue(payloadType);
    }

    /**
     * <p>
     * The payload type for your login endpoint, either JSON or form encoded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The payload type for your login endpoint, either JSON or form encoded.
     * @see PayloadType
     */
    public final String payloadTypeAsString() {
        return payloadType;
    }

    /**
     * <p>
     * The name of the field in the request payload that contains your customer's username.
     * </p>
     * <p>
     * How you specify this depends on the request inspection payload type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax,
     * see the Internet Engineering Task Force (IETF) documentation <a
     * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     * </p>
     * <p>
     * For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field
     * specification is <code>/form/username</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For form encoded payload types, use the HTML form names.
     * </p>
     * <p>
     * For example, for an HTML form with the input element named <code>username1</code>, the username field
     * specification is <code>username1</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the field in the request payload that contains your customer's username. </p>
     *         <p>
     *         How you specify this depends on the request inspection payload type.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
     *         syntax, see the Internet Engineering Task Force (IETF) documentation <a
     *         href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     *         </p>
     *         <p>
     *         For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username
     *         field specification is <code>/form/username</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For form encoded payload types, use the HTML form names.
     *         </p>
     *         <p>
     *         For example, for an HTML form with the input element named <code>username1</code>, the username field
     *         specification is <code>username1</code>
     *         </p>
     *         </li>
     */
    public final UsernameField usernameField() {
        return usernameField;
    }

    /**
     * <p>
     * The name of the field in the request payload that contains your customer's password.
     * </p>
     * <p>
     * How you specify this depends on the request inspection payload type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax,
     * see the Internet Engineering Task Force (IETF) documentation <a
     * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     * </p>
     * <p>
     * For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field
     * specification is <code>/form/password</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For form encoded payload types, use the HTML form names.
     * </p>
     * <p>
     * For example, for an HTML form with the input element named <code>password1</code>, the password field
     * specification is <code>password1</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the field in the request payload that contains your customer's password. </p>
     *         <p>
     *         How you specify this depends on the request inspection payload type.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
     *         syntax, see the Internet Engineering Task Force (IETF) documentation <a
     *         href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     *         </p>
     *         <p>
     *         For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password
     *         field specification is <code>/form/password</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For form encoded payload types, use the HTML form names.
     *         </p>
     *         <p>
     *         For example, for an HTML form with the input element named <code>password1</code>, the password field
     *         specification is <code>password1</code>.
     *         </p>
     *         </li>
     */
    public final PasswordField passwordField() {
        return passwordField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usernameField());
        hashCode = 31 * hashCode + Objects.hashCode(passwordField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestInspection)) {
            return false;
        }
        RequestInspection other = (RequestInspection) obj;
        return Objects.equals(payloadTypeAsString(), other.payloadTypeAsString())
                && Objects.equals(usernameField(), other.usernameField())
                && Objects.equals(passwordField(), other.passwordField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestInspection").add("PayloadType", payloadTypeAsString())
                .add("UsernameField", usernameField()).add("PasswordField", passwordField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PayloadType":
            return Optional.ofNullable(clazz.cast(payloadTypeAsString()));
        case "UsernameField":
            return Optional.ofNullable(clazz.cast(usernameField()));
        case "PasswordField":
            return Optional.ofNullable(clazz.cast(passwordField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestInspection, T> g) {
        return obj -> g.apply((RequestInspection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestInspection> {
        /**
         * <p>
         * The payload type for your login endpoint, either JSON or form encoded.
         * </p>
         * 
         * @param payloadType
         *        The payload type for your login endpoint, either JSON or form encoded.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder payloadType(String payloadType);

        /**
         * <p>
         * The payload type for your login endpoint, either JSON or form encoded.
         * </p>
         * 
         * @param payloadType
         *        The payload type for your login endpoint, either JSON or form encoded.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder payloadType(PayloadType payloadType);

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's username.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field
         * specification is <code>/form/username</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>username1</code>, the username field
         * specification is <code>username1</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param usernameField
         *        The name of the field in the request payload that contains your customer's username. </p>
         *        <p>
         *        How you specify this depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON
         *        Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the
         *        username field specification is <code>/form/username</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with the input element named <code>username1</code>, the username field
         *        specification is <code>username1</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameField(UsernameField usernameField);

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's username.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field
         * specification is <code>/form/username</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>username1</code>, the username field
         * specification is <code>username1</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link UsernameField.Builder} avoiding the need
         * to create one manually via {@link UsernameField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsernameField.Builder#build()} is called immediately and its
         * result is passed to {@link #usernameField(UsernameField)}.
         * 
         * @param usernameField
         *        a consumer that will call methods on {@link UsernameField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usernameField(UsernameField)
         */
        default Builder usernameField(Consumer<UsernameField.Builder> usernameField) {
            return usernameField(UsernameField.builder().applyMutation(usernameField).build());
        }

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's password.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field
         * specification is <code>/form/password</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>password1</code>, the password field
         * specification is <code>password1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param passwordField
         *        The name of the field in the request payload that contains your customer's password. </p>
         *        <p>
         *        How you specify this depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON
         *        Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the
         *        password field specification is <code>/form/password</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with the input element named <code>password1</code>, the password field
         *        specification is <code>password1</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordField(PasswordField passwordField);

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's password.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field
         * specification is <code>/form/password</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>password1</code>, the password field
         * specification is <code>password1</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link PasswordField.Builder} avoiding the need
         * to create one manually via {@link PasswordField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PasswordField.Builder#build()} is called immediately and its
         * result is passed to {@link #passwordField(PasswordField)}.
         * 
         * @param passwordField
         *        a consumer that will call methods on {@link PasswordField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passwordField(PasswordField)
         */
        default Builder passwordField(Consumer<PasswordField.Builder> passwordField) {
            return passwordField(PasswordField.builder().applyMutation(passwordField).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String payloadType;

        private UsernameField usernameField;

        private PasswordField passwordField;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestInspection model) {
            payloadType(model.payloadType);
            usernameField(model.usernameField);
            passwordField(model.passwordField);
        }

        public final String getPayloadType() {
            return payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(PayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final UsernameField.Builder getUsernameField() {
            return usernameField != null ? usernameField.toBuilder() : null;
        }

        public final void setUsernameField(UsernameField.BuilderImpl usernameField) {
            this.usernameField = usernameField != null ? usernameField.build() : null;
        }

        @Override
        public final Builder usernameField(UsernameField usernameField) {
            this.usernameField = usernameField;
            return this;
        }

        public final PasswordField.Builder getPasswordField() {
            return passwordField != null ? passwordField.toBuilder() : null;
        }

        public final void setPasswordField(PasswordField.BuilderImpl passwordField) {
            this.passwordField = passwordField != null ? passwordField.build() : null;
        }

        @Override
        public final Builder passwordField(PasswordField passwordField) {
            this.passwordField = passwordField;
            return this;
        }

        @Override
        public RequestInspection build() {
            return new RequestInspection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
