/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAllManagedProductsResponse extends Wafv2Response implements
        ToCopyableBuilder<DescribeAllManagedProductsResponse.Builder, DescribeAllManagedProductsResponse> {
    private static final SdkField<List<ManagedProductDescriptor>> MANAGED_PRODUCTS_FIELD = SdkField
            .<List<ManagedProductDescriptor>> builder(MarshallingType.LIST)
            .memberName("ManagedProducts")
            .getter(getter(DescribeAllManagedProductsResponse::managedProducts))
            .setter(setter(Builder::managedProducts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedProducts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedProductDescriptor> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedProductDescriptor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_PRODUCTS_FIELD));

    private final List<ManagedProductDescriptor> managedProducts;

    private DescribeAllManagedProductsResponse(BuilderImpl builder) {
        super(builder);
        this.managedProducts = builder.managedProducts;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedProducts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedProducts() {
        return managedProducts != null && !(managedProducts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * High-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services Marketplace
     * managed rule groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedProducts} method.
     * </p>
     * 
     * @return High-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
     *         Marketplace managed rule groups.
     */
    public final List<ManagedProductDescriptor> managedProducts() {
        return managedProducts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedProducts() ? managedProducts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAllManagedProductsResponse)) {
            return false;
        }
        DescribeAllManagedProductsResponse other = (DescribeAllManagedProductsResponse) obj;
        return hasManagedProducts() == other.hasManagedProducts() && Objects.equals(managedProducts(), other.managedProducts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAllManagedProductsResponse")
                .add("ManagedProducts", hasManagedProducts() ? managedProducts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedProducts":
            return Optional.ofNullable(clazz.cast(managedProducts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAllManagedProductsResponse, T> g) {
        return obj -> g.apply((DescribeAllManagedProductsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAllManagedProductsResponse> {
        /**
         * <p>
         * High-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
         * Marketplace managed rule groups.
         * </p>
         * 
         * @param managedProducts
         *        High-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
         *        Marketplace managed rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedProducts(Collection<ManagedProductDescriptor> managedProducts);

        /**
         * <p>
         * High-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
         * Marketplace managed rule groups.
         * </p>
         * 
         * @param managedProducts
         *        High-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
         *        Marketplace managed rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedProducts(ManagedProductDescriptor... managedProducts);

        /**
         * <p>
         * High-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
         * Marketplace managed rule groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor.Builder#build()} is called
         * immediately and its result is passed to {@link #managedProducts(List<ManagedProductDescriptor>)}.
         * 
         * @param managedProducts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedProducts(java.util.Collection<ManagedProductDescriptor>)
         */
        Builder managedProducts(Consumer<ManagedProductDescriptor.Builder>... managedProducts);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private List<ManagedProductDescriptor> managedProducts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAllManagedProductsResponse model) {
            super(model);
            managedProducts(model.managedProducts);
        }

        public final List<ManagedProductDescriptor.Builder> getManagedProducts() {
            List<ManagedProductDescriptor.Builder> result = ManagedProductDescriptorsCopier.copyToBuilder(this.managedProducts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedProducts(Collection<ManagedProductDescriptor.BuilderImpl> managedProducts) {
            this.managedProducts = ManagedProductDescriptorsCopier.copyFromBuilder(managedProducts);
        }

        @Override
        public final Builder managedProducts(Collection<ManagedProductDescriptor> managedProducts) {
            this.managedProducts = ManagedProductDescriptorsCopier.copy(managedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedProducts(ManagedProductDescriptor... managedProducts) {
            managedProducts(Arrays.asList(managedProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedProducts(Consumer<ManagedProductDescriptor.Builder>... managedProducts) {
            managedProducts(Stream.of(managedProducts).map(c -> ManagedProductDescriptor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAllManagedProductsResponse build() {
            return new DescribeAllManagedProductsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
