/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a <a>GetSqlInjectionMatchSet</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSqlInjectionMatchSetResponse extends WafResponse implements
        ToCopyableBuilder<GetSqlInjectionMatchSetResponse.Builder, GetSqlInjectionMatchSetResponse> {
    private static final SdkField<SqlInjectionMatchSet> SQL_INJECTION_MATCH_SET_FIELD = SdkField
            .<SqlInjectionMatchSet> builder(MarshallingType.SDK_POJO).memberName("SqlInjectionMatchSet")
            .getter(getter(GetSqlInjectionMatchSetResponse::sqlInjectionMatchSet)).setter(setter(Builder::sqlInjectionMatchSet))
            .constructor(SqlInjectionMatchSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchSet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SQL_INJECTION_MATCH_SET_FIELD));

    private final SqlInjectionMatchSet sqlInjectionMatchSet;

    private GetSqlInjectionMatchSetResponse(BuilderImpl builder) {
        super(builder);
        this.sqlInjectionMatchSet = builder.sqlInjectionMatchSet;
    }

    /**
     * <p>
     * Information about the <a>SqlInjectionMatchSet</a> that you specified in the <code>GetSqlInjectionMatchSet</code>
     * request. For more information, see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>SqlInjectionMatchSet</a>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an array of
     * <code>SqlInjectionMatchTuple</code> objects
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>SqlInjectionMatchTuple</a>: Each <code>SqlInjectionMatchTuple</code> object contains <code>FieldToMatch</code>
     * and <code>TextTransformation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the <a>SqlInjectionMatchSet</a> that you specified in the
     *         <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>SqlInjectionMatchSet</a>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an
     *         array of <code>SqlInjectionMatchTuple</code> objects
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>SqlInjectionMatchTuple</a>: Each <code>SqlInjectionMatchTuple</code> object contains
     *         <code>FieldToMatch</code> and <code>TextTransformation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     *         </p>
     *         </li>
     */
    public final SqlInjectionMatchSet sqlInjectionMatchSet() {
        return sqlInjectionMatchSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sqlInjectionMatchSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSqlInjectionMatchSetResponse)) {
            return false;
        }
        GetSqlInjectionMatchSetResponse other = (GetSqlInjectionMatchSetResponse) obj;
        return Objects.equals(sqlInjectionMatchSet(), other.sqlInjectionMatchSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSqlInjectionMatchSetResponse").add("SqlInjectionMatchSet", sqlInjectionMatchSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SqlInjectionMatchSet":
            return Optional.ofNullable(clazz.cast(sqlInjectionMatchSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSqlInjectionMatchSetResponse, T> g) {
        return obj -> g.apply((GetSqlInjectionMatchSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSqlInjectionMatchSetResponse> {
        /**
         * <p>
         * Information about the <a>SqlInjectionMatchSet</a> that you specified in the
         * <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>SqlInjectionMatchSet</a>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an array of
         * <code>SqlInjectionMatchTuple</code> objects
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>SqlInjectionMatchTuple</a>: Each <code>SqlInjectionMatchTuple</code> object contains
         * <code>FieldToMatch</code> and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param sqlInjectionMatchSet
         *        Information about the <a>SqlInjectionMatchSet</a> that you specified in the
         *        <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>SqlInjectionMatchSet</a>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an
         *        array of <code>SqlInjectionMatchTuple</code> objects
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>SqlInjectionMatchTuple</a>: Each <code>SqlInjectionMatchTuple</code> object contains
         *        <code>FieldToMatch</code> and <code>TextTransformation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlInjectionMatchSet(SqlInjectionMatchSet sqlInjectionMatchSet);

        /**
         * <p>
         * Information about the <a>SqlInjectionMatchSet</a> that you specified in the
         * <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>SqlInjectionMatchSet</a>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an array of
         * <code>SqlInjectionMatchTuple</code> objects
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>SqlInjectionMatchTuple</a>: Each <code>SqlInjectionMatchTuple</code> object contains
         * <code>FieldToMatch</code> and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link SqlInjectionMatchSet.Builder} avoiding
         * the need to create one manually via {@link SqlInjectionMatchSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqlInjectionMatchSet.Builder#build()} is called immediately and
         * its result is passed to {@link #sqlInjectionMatchSet(SqlInjectionMatchSet)}.
         * 
         * @param sqlInjectionMatchSet
         *        a consumer that will call methods on {@link SqlInjectionMatchSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlInjectionMatchSet(SqlInjectionMatchSet)
         */
        default Builder sqlInjectionMatchSet(Consumer<SqlInjectionMatchSet.Builder> sqlInjectionMatchSet) {
            return sqlInjectionMatchSet(SqlInjectionMatchSet.builder().applyMutation(sqlInjectionMatchSet).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private SqlInjectionMatchSet sqlInjectionMatchSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSqlInjectionMatchSetResponse model) {
            super(model);
            sqlInjectionMatchSet(model.sqlInjectionMatchSet);
        }

        public final SqlInjectionMatchSet.Builder getSqlInjectionMatchSet() {
            return sqlInjectionMatchSet != null ? sqlInjectionMatchSet.toBuilder() : null;
        }

        public final void setSqlInjectionMatchSet(SqlInjectionMatchSet.BuilderImpl sqlInjectionMatchSet) {
            this.sqlInjectionMatchSet = sqlInjectionMatchSet != null ? sqlInjectionMatchSet.build() : null;
        }

        @Override
        public final Builder sqlInjectionMatchSet(SqlInjectionMatchSet sqlInjectionMatchSet) {
            this.sqlInjectionMatchSet = sqlInjectionMatchSet;
            return this;
        }

        @Override
        public GetSqlInjectionMatchSetResponse build() {
            return new GetSqlInjectionMatchSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
