/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetByteMatchSetRequest extends WafRequest implements
        ToCopyableBuilder<GetByteMatchSetRequest.Builder, GetByteMatchSetRequest> {
    private static final SdkField<String> BYTE_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByteMatchSetId").getter(getter(GetByteMatchSetRequest::byteMatchSetId))
            .setter(setter(Builder::byteMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_MATCH_SET_ID_FIELD));

    private final String byteMatchSetId;

    private GetByteMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.byteMatchSetId = builder.byteMatchSetId;
    }

    /**
     * <p>
     * The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to get. <code>ByteMatchSetId</code> is
     * returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
     * </p>
     * 
     * @return The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to get.
     *         <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
     */
    public final String byteMatchSetId() {
        return byteMatchSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetByteMatchSetRequest)) {
            return false;
        }
        GetByteMatchSetRequest other = (GetByteMatchSetRequest) obj;
        return Objects.equals(byteMatchSetId(), other.byteMatchSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetByteMatchSetRequest").add("ByteMatchSetId", byteMatchSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByteMatchSetId":
            return Optional.ofNullable(clazz.cast(byteMatchSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetByteMatchSetRequest, T> g) {
        return obj -> g.apply((GetByteMatchSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetByteMatchSetRequest> {
        /**
         * <p>
         * The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to get. <code>ByteMatchSetId</code>
         * is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
         * </p>
         * 
         * @param byteMatchSetId
         *        The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to get.
         *        <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchSetId(String byteMatchSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String byteMatchSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetByteMatchSetRequest model) {
            super(model);
            byteMatchSetId(model.byteMatchSetId);
        }

        public final String getByteMatchSetId() {
            return byteMatchSetId;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetByteMatchSetRequest build() {
            return new GetByteMatchSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
