/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WafRuleType {
    REGULAR("REGULAR"),
    RATE_BASED("RATE_BASED"),
    GROUP("GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WafRuleType> VALUE_MAP;
    private final String value;

    private WafRuleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WafRuleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WafRuleType> knownValues() {
        EnumSet<WafRuleType> knownValues = EnumSet.allOf(WafRuleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WafRuleType.class, WafRuleType::toString);
    }
}

