/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ParameterExceptionField {
    CHANGE_ACTION("CHANGE_ACTION"),

    WAF_ACTION("WAF_ACTION"),

    WAF_OVERRIDE_ACTION("WAF_OVERRIDE_ACTION"),

    PREDICATE_TYPE("PREDICATE_TYPE"),

    IPSET_TYPE("IPSET_TYPE"),

    BYTE_MATCH_FIELD_TYPE("BYTE_MATCH_FIELD_TYPE"),

    SQL_INJECTION_MATCH_FIELD_TYPE("SQL_INJECTION_MATCH_FIELD_TYPE"),

    BYTE_MATCH_TEXT_TRANSFORMATION("BYTE_MATCH_TEXT_TRANSFORMATION"),

    BYTE_MATCH_POSITIONAL_CONSTRAINT("BYTE_MATCH_POSITIONAL_CONSTRAINT"),

    SIZE_CONSTRAINT_COMPARISON_OPERATOR("SIZE_CONSTRAINT_COMPARISON_OPERATOR"),

    GEO_MATCH_LOCATION_TYPE("GEO_MATCH_LOCATION_TYPE"),

    GEO_MATCH_LOCATION_VALUE("GEO_MATCH_LOCATION_VALUE"),

    RATE_KEY("RATE_KEY"),

    RULE_TYPE("RULE_TYPE"),

    NEXT_MARKER("NEXT_MARKER"),

    RESOURCE_ARN("RESOURCE_ARN"),

    TAGS("TAGS"),

    TAG_KEYS("TAG_KEYS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParameterExceptionField> VALUE_MAP = EnumUtils.uniqueIndex(ParameterExceptionField.class,
            ParameterExceptionField::toString);

    private final String value;

    private ParameterExceptionField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ParameterExceptionField corresponding to the value
     */
    public static ParameterExceptionField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ParameterExceptionField}s
     */
    public static Set<ParameterExceptionField> knownValues() {
        Set<ParameterExceptionField> knownValues = EnumSet.allOf(ParameterExceptionField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
