/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleResponse extends WafResponse implements
        ToCopyableBuilder<CreateRuleResponse.Builder, CreateRuleResponse> {
    private static final SdkField<Rule> RULE_FIELD = SdkField.<Rule> builder(MarshallingType.SDK_POJO).memberName("Rule")
            .getter(getter(CreateRuleResponse::rule)).setter(setter(Builder::rule)).constructor(Rule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(CreateRuleResponse::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RULE_FIELD, CHANGE_TOKEN_FIELD));

    private final Rule rule;

    private final String changeToken;

    private CreateRuleResponse(BuilderImpl builder) {
        super(builder);
        this.rule = builder.rule;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * The <a>Rule</a> returned in the <code>CreateRule</code> response.
     * </p>
     * 
     * @return The <a>Rule</a> returned in the <code>CreateRule</code> response.
     */
    public final Rule rule() {
        return rule;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also use this
     * value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also
     *         use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleResponse)) {
            return false;
        }
        CreateRuleResponse other = (CreateRuleResponse) obj;
        return Objects.equals(rule(), other.rule()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleResponse").add("Rule", rule()).add("ChangeToken", changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleResponse, T> g) {
        return obj -> g.apply((CreateRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleResponse> {
        /**
         * <p>
         * The <a>Rule</a> returned in the <code>CreateRule</code> response.
         * </p>
         * 
         * @param rule
         *        The <a>Rule</a> returned in the <code>CreateRule</code> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(Rule rule);

        /**
         * <p>
         * The <a>Rule</a> returned in the <code>CreateRule</code> response.
         * </p>
         * This is a convenience method that creates an instance of the {@link Rule.Builder} avoiding the need to create
         * one manually via {@link Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Rule.Builder#build()} is called immediately and its result is
         * passed to {@link #rule(Rule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(Rule)
         */
        default Builder rule(Consumer<Rule.Builder> rule) {
            return rule(Rule.builder().applyMutation(rule).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also use
         * this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also
         *        use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private Rule rule;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleResponse model) {
            super(model);
            rule(model.rule);
            changeToken(model.changeToken);
        }

        public final Rule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public CreateRuleResponse build() {
            return new CreateRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
