/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.ManagedKeysCopier;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRateBasedRuleManagedKeysResponse
extends WafResponse
implements ToCopyableBuilder<Builder, GetRateBasedRuleManagedKeysResponse> {
    private static final SdkField<List<String>> MANAGED_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ManagedKeys").getter(GetRateBasedRuleManagedKeysResponse.getter(GetRateBasedRuleManagedKeysResponse::managedKeys)).setter(GetRateBasedRuleManagedKeysResponse.setter(Builder::managedKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(GetRateBasedRuleManagedKeysResponse.getter(GetRateBasedRuleManagedKeysResponse::nextMarker)).setter(GetRateBasedRuleManagedKeysResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_KEYS_FIELD, NEXT_MARKER_FIELD));
    private final List<String> managedKeys;
    private final String nextMarker;

    private GetRateBasedRuleManagedKeysResponse(BuilderImpl builder) {
        super(builder);
        this.managedKeys = builder.managedKeys;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasManagedKeys() {
        return this.managedKeys != null && !(this.managedKeys instanceof SdkAutoConstructList);
    }

    public final List<String> managedKeys() {
        return this.managedKeys;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedKeys() ? this.managedKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedRuleManagedKeysResponse)) {
            return false;
        }
        GetRateBasedRuleManagedKeysResponse other = (GetRateBasedRuleManagedKeysResponse)((Object)obj);
        return this.hasManagedKeys() == other.hasManagedKeys() && Objects.equals(this.managedKeys(), other.managedKeys()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"GetRateBasedRuleManagedKeysResponse").add("ManagedKeys", this.hasManagedKeys() ? this.managedKeys() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedKeys": {
                return Optional.ofNullable(clazz.cast(this.managedKeys()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRateBasedRuleManagedKeysResponse, T> g) {
        return obj -> g.apply((GetRateBasedRuleManagedKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private List<String> managedKeys = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedRuleManagedKeysResponse model) {
            super(model);
            this.managedKeys(model.managedKeys);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<String> getManagedKeys() {
            if (this.managedKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.managedKeys;
        }

        public final void setManagedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
        }

        @Override
        public final Builder managedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedKeys(String ... managedKeys) {
            this.managedKeys(Arrays.asList(managedKeys));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public GetRateBasedRuleManagedKeysResponse build() {
            return new GetRateBasedRuleManagedKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRateBasedRuleManagedKeysResponse> {
        public Builder managedKeys(Collection<String> var1);

        public Builder managedKeys(String ... var1);

        public Builder nextMarker(String var1);
    }
}

