/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.GeoMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.GeoMatchSetSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGeoMatchSetsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListGeoMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListGeoMatchSetsResponse.getter(ListGeoMatchSetsResponse::nextMarker)).setter(ListGeoMatchSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<GeoMatchSetSummary>> GEO_MATCH_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GeoMatchSets").getter(ListGeoMatchSetsResponse.getter(ListGeoMatchSetsResponse::geoMatchSets)).setter(ListGeoMatchSetsResponse.setter(Builder::geoMatchSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeoMatchSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, GEO_MATCH_SETS_FIELD));
    private final String nextMarker;
    private final List<GeoMatchSetSummary> geoMatchSets;

    private ListGeoMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.geoMatchSets = builder.geoMatchSets;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasGeoMatchSets() {
        return this.geoMatchSets != null && !(this.geoMatchSets instanceof SdkAutoConstructList);
    }

    public final List<GeoMatchSetSummary> geoMatchSets() {
        return this.geoMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeoMatchSets() ? this.geoMatchSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoMatchSetsResponse)) {
            return false;
        }
        ListGeoMatchSetsResponse other = (ListGeoMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasGeoMatchSets() == other.hasGeoMatchSets() && Objects.equals(this.geoMatchSets(), other.geoMatchSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListGeoMatchSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("GeoMatchSets", this.hasGeoMatchSets() ? this.geoMatchSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "GeoMatchSets": {
                return Optional.ofNullable(clazz.cast(this.geoMatchSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGeoMatchSetsResponse, T> g) {
        return obj -> g.apply((ListGeoMatchSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<GeoMatchSetSummary> geoMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoMatchSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.geoMatchSets(model.geoMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<GeoMatchSetSummary.Builder> getGeoMatchSets() {
            List<GeoMatchSetSummary.Builder> result = GeoMatchSetSummariesCopier.copyToBuilder(this.geoMatchSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeoMatchSets(Collection<GeoMatchSetSummary.BuilderImpl> geoMatchSets) {
            this.geoMatchSets = GeoMatchSetSummariesCopier.copyFromBuilder(geoMatchSets);
        }

        @Override
        public final Builder geoMatchSets(Collection<GeoMatchSetSummary> geoMatchSets) {
            this.geoMatchSets = GeoMatchSetSummariesCopier.copy(geoMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchSets(GeoMatchSetSummary ... geoMatchSets) {
            this.geoMatchSets(Arrays.asList(geoMatchSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchSets(Consumer<GeoMatchSetSummary.Builder> ... geoMatchSets) {
            this.geoMatchSets(Stream.of(geoMatchSets).map(c -> (GeoMatchSetSummary)((GeoMatchSetSummary.Builder)GeoMatchSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListGeoMatchSetsResponse build() {
            return new ListGeoMatchSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGeoMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder geoMatchSets(Collection<GeoMatchSetSummary> var1);

        public Builder geoMatchSets(GeoMatchSetSummary ... var1);

        public Builder geoMatchSets(Consumer<GeoMatchSetSummary.Builder> ... var1);
    }
}

