/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceNetworkVpcAssociationRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<UpdateServiceNetworkVpcAssociationRequest.Builder, UpdateServiceNetworkVpcAssociationRequest> {
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(UpdateServiceNetworkVpcAssociationRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_NETWORK_VPC_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkVpcAssociationIdentifier")
            .getter(getter(UpdateServiceNetworkVpcAssociationRequest::serviceNetworkVpcAssociationIdentifier))
            .setter(setter(Builder::serviceNetworkVpcAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH)
                    .locationName("serviceNetworkVpcAssociationIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_IDS_FIELD,
            SERVICE_NETWORK_VPC_ASSOCIATION_IDENTIFIER_FIELD));

    private final List<String> securityGroupIds;

    private final String serviceNetworkVpcAssociationIdentifier;

    private UpdateServiceNetworkVpcAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceNetworkVpcAssociationIdentifier = builder.serviceNetworkVpcAssociationIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups. Once you add a security group, it cannot be removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of the security groups. Once you add a security group, it cannot be removed.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the association.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the association.
     */
    public final String serviceNetworkVpcAssociationIdentifier() {
        return serviceNetworkVpcAssociationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkVpcAssociationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceNetworkVpcAssociationRequest)) {
            return false;
        }
        UpdateServiceNetworkVpcAssociationRequest other = (UpdateServiceNetworkVpcAssociationRequest) obj;
        return hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(serviceNetworkVpcAssociationIdentifier(), other.serviceNetworkVpcAssociationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceNetworkVpcAssociationRequest")
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("ServiceNetworkVpcAssociationIdentifier", serviceNetworkVpcAssociationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "serviceNetworkVpcAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(serviceNetworkVpcAssociationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceNetworkVpcAssociationRequest, T> g) {
        return obj -> g.apply((UpdateServiceNetworkVpcAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateServiceNetworkVpcAssociationRequest> {
        /**
         * <p>
         * The IDs of the security groups. Once you add a security group, it cannot be removed.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups. Once you add a security group, it cannot be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the security groups. Once you add a security group, it cannot be removed.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups. Once you add a security group, it cannot be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the association.
         * </p>
         * 
         * @param serviceNetworkVpcAssociationIdentifier
         *        The ID or Amazon Resource Name (ARN) of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkVpcAssociationIdentifier(String serviceNetworkVpcAssociationIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String serviceNetworkVpcAssociationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceNetworkVpcAssociationRequest model) {
            super(model);
            securityGroupIds(model.securityGroupIds);
            serviceNetworkVpcAssociationIdentifier(model.serviceNetworkVpcAssociationIdentifier);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = UpdateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = UpdateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getServiceNetworkVpcAssociationIdentifier() {
            return serviceNetworkVpcAssociationIdentifier;
        }

        public final void setServiceNetworkVpcAssociationIdentifier(String serviceNetworkVpcAssociationIdentifier) {
            this.serviceNetworkVpcAssociationIdentifier = serviceNetworkVpcAssociationIdentifier;
        }

        @Override
        public final Builder serviceNetworkVpcAssociationIdentifier(String serviceNetworkVpcAssociationIdentifier) {
            this.serviceNetworkVpcAssociationIdentifier = serviceNetworkVpcAssociationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceNetworkVpcAssociationRequest build() {
            return new UpdateServiceNetworkVpcAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
