/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.DnsEntry;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNetworkServiceAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNetworkServiceAssociationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::arn)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::createdAt)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::createdBy)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainName").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::customDomainName)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()}).build();
    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsEntry").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::dnsEntry)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::dnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::id)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceArn)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceId").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceId)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceName)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkArn").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceNetworkArn)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkId").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceNetworkId)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkId").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkName").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceNetworkName)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceNetworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::statusAsString)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, CUSTOM_DOMAIN_NAME_FIELD, DNS_ENTRY_FIELD, ID_FIELD, SERVICE_ARN_FIELD, SERVICE_ID_FIELD, SERVICE_NAME_FIELD, SERVICE_NETWORK_ARN_FIELD, SERVICE_NETWORK_ID_FIELD, SERVICE_NETWORK_NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String createdBy;
    private final String customDomainName;
    private final DnsEntry dnsEntry;
    private final String id;
    private final String serviceArn;
    private final String serviceId;
    private final String serviceName;
    private final String serviceNetworkArn;
    private final String serviceNetworkId;
    private final String serviceNetworkName;
    private final String status;

    private ServiceNetworkServiceAssociationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.customDomainName = builder.customDomainName;
        this.dnsEntry = builder.dnsEntry;
        this.id = builder.id;
        this.serviceArn = builder.serviceArn;
        this.serviceId = builder.serviceId;
        this.serviceName = builder.serviceName;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.serviceNetworkId = builder.serviceNetworkId;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public final DnsEntry dnsEntry() {
        return this.dnsEntry;
    }

    public final String id() {
        return this.id;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceNetworkArn() {
        return this.serviceNetworkArn;
    }

    public final String serviceNetworkId() {
        return this.serviceNetworkId;
    }

    public final String serviceNetworkName() {
        return this.serviceNetworkName;
    }

    public final ServiceNetworkServiceAssociationStatus status() {
        return ServiceNetworkServiceAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNetworkServiceAssociationSummary)) {
            return false;
        }
        ServiceNetworkServiceAssociationSummary other = (ServiceNetworkServiceAssociationSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.customDomainName(), other.customDomainName()) && Objects.equals(this.dnsEntry(), other.dnsEntry()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(this.serviceNetworkId(), other.serviceNetworkId()) && Objects.equals(this.serviceNetworkName(), other.serviceNetworkName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceNetworkServiceAssociationSummary").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("CustomDomainName", (Object)this.customDomainName()).add("DnsEntry", (Object)this.dnsEntry()).add("Id", (Object)this.id()).add("ServiceArn", (Object)this.serviceArn()).add("ServiceId", (Object)this.serviceId()).add("ServiceName", (Object)this.serviceName()).add("ServiceNetworkArn", (Object)this.serviceNetworkArn()).add("ServiceNetworkId", (Object)this.serviceNetworkId()).add("ServiceNetworkName", (Object)this.serviceNetworkName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "customDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
            case "dnsEntry": {
                return Optional.ofNullable(clazz.cast(this.dnsEntry()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "serviceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "serviceNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkArn()));
            }
            case "serviceNetworkId": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkId()));
            }
            case "serviceNetworkName": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNetworkServiceAssociationSummary, T> g) {
        return obj -> g.apply((ServiceNetworkServiceAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String createdBy;
        private String customDomainName;
        private DnsEntry dnsEntry;
        private String id;
        private String serviceArn;
        private String serviceId;
        private String serviceName;
        private String serviceNetworkArn;
        private String serviceNetworkId;
        private String serviceNetworkName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNetworkServiceAssociationSummary model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.customDomainName(model.customDomainName);
            this.dnsEntry(model.dnsEntry);
            this.id(model.id);
            this.serviceArn(model.serviceArn);
            this.serviceId(model.serviceId);
            this.serviceName(model.serviceName);
            this.serviceNetworkArn(model.serviceNetworkArn);
            this.serviceNetworkId(model.serviceNetworkId);
            this.serviceNetworkName(model.serviceNetworkName);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return this.dnsEntry != null ? this.dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceNetworkArn() {
            return this.serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getServiceNetworkId() {
            return this.serviceNetworkId;
        }

        public final void setServiceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
        }

        @Override
        public final Builder serviceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
            return this;
        }

        public final String getServiceNetworkName() {
            return this.serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkServiceAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ServiceNetworkServiceAssociationSummary build() {
            return new ServiceNetworkServiceAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNetworkServiceAssociationSummary> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder customDomainName(String var1);

        public Builder dnsEntry(DnsEntry var1);

        default public Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return this.dnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(dnsEntry)).build());
        }

        public Builder id(String var1);

        public Builder serviceArn(String var1);

        public Builder serviceId(String var1);

        public Builder serviceName(String var1);

        public Builder serviceNetworkArn(String var1);

        public Builder serviceNetworkId(String var1);

        public Builder serviceNetworkName(String var1);

        public Builder status(String var1);

        public Builder status(ServiceNetworkServiceAssociationStatus var1);
    }
}

