/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.SecurityGroupListCopier;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkVpcAssociationStatus;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceNetworkVpcAssociationResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, GetServiceNetworkVpcAssociationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::arn)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::createdAt)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::createdBy)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::failureCode)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::failureMessage)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::id)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::lastUpdatedAt)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::securityGroupIds)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkArn").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::serviceNetworkArn)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::serviceNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkId").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::serviceNetworkId)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::serviceNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkId").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkName").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::serviceNetworkName)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::serviceNetworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::statusAsString)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcId").getter(GetServiceNetworkVpcAssociationResponse.getter(GetServiceNetworkVpcAssociationResponse::vpcId)).setter(GetServiceNetworkVpcAssociationResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, SECURITY_GROUP_IDS_FIELD, SERVICE_NETWORK_ARN_FIELD, SERVICE_NETWORK_ID_FIELD, SERVICE_NETWORK_NAME_FIELD, STATUS_FIELD, VPC_ID_FIELD));
    private final String arn;
    private final Instant createdAt;
    private final String createdBy;
    private final String failureCode;
    private final String failureMessage;
    private final String id;
    private final Instant lastUpdatedAt;
    private final List<String> securityGroupIds;
    private final String serviceNetworkArn;
    private final String serviceNetworkId;
    private final String serviceNetworkName;
    private final String status;
    private final String vpcId;

    private GetServiceNetworkVpcAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.serviceNetworkId = builder.serviceNetworkId;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.status = builder.status;
        this.vpcId = builder.vpcId;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String serviceNetworkArn() {
        return this.serviceNetworkArn;
    }

    public final String serviceNetworkId() {
        return this.serviceNetworkId;
    }

    public final String serviceNetworkName() {
        return this.serviceNetworkName;
    }

    public final ServiceNetworkVpcAssociationStatus status() {
        return ServiceNetworkVpcAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceNetworkVpcAssociationResponse)) {
            return false;
        }
        GetServiceNetworkVpcAssociationResponse other = (GetServiceNetworkVpcAssociationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(this.serviceNetworkId(), other.serviceNetworkId()) && Objects.equals(this.serviceNetworkName(), other.serviceNetworkName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"GetServiceNetworkVpcAssociationResponse").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("FailureCode", (Object)this.failureCode()).add("FailureMessage", (Object)this.failureMessage()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("ServiceNetworkArn", (Object)this.serviceNetworkArn()).add("ServiceNetworkId", (Object)this.serviceNetworkId()).add("ServiceNetworkName", (Object)this.serviceNetworkName()).add("Status", (Object)this.statusAsString()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "serviceNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkArn()));
            }
            case "serviceNetworkId": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkId()));
            }
            case "serviceNetworkName": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "vpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceNetworkVpcAssociationResponse, T> g) {
        return obj -> g.apply((GetServiceNetworkVpcAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String createdBy;
        private String failureCode;
        private String failureMessage;
        private String id;
        private Instant lastUpdatedAt;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String serviceNetworkArn;
        private String serviceNetworkId;
        private String serviceNetworkName;
        private String status;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceNetworkVpcAssociationResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.failureCode(model.failureCode);
            this.failureMessage(model.failureMessage);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.securityGroupIds(model.securityGroupIds);
            this.serviceNetworkArn(model.serviceNetworkArn);
            this.serviceNetworkId(model.serviceNetworkId);
            this.serviceNetworkName(model.serviceNetworkName);
            this.status(model.status);
            this.vpcId(model.vpcId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getServiceNetworkArn() {
            return this.serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getServiceNetworkId() {
            return this.serviceNetworkId;
        }

        public final void setServiceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
        }

        @Override
        public final Builder serviceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
            return this;
        }

        public final String getServiceNetworkName() {
            return this.serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkVpcAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public GetServiceNetworkVpcAssociationResponse build() {
            return new GetServiceNetworkVpcAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceNetworkVpcAssociationResponse> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serviceNetworkArn(String var1);

        public Builder serviceNetworkId(String var1);

        public Builder serviceNetworkName(String var1);

        public Builder status(String var1);

        public Builder status(ServiceNetworkVpcAssociationStatus var1);

        public Builder vpcId(String var1);
    }
}

