/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a target group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetGroupSummary.Builder, TargetGroupSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(TargetGroupSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(TargetGroupSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(TargetGroupSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(TargetGroupSummary::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(TargetGroupSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TargetGroupSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(TargetGroupSummary::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(TargetGroupSummary::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<List<String>> SERVICE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("serviceArns")
            .getter(getter(TargetGroupSummary::serviceArns))
            .setter(setter(Builder::serviceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TargetGroupSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(TargetGroupSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VPC_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcIdentifier").getter(getter(TargetGroupSummary::vpcIdentifier)).setter(setter(Builder::vpcIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            ID_FIELD, IP_ADDRESS_TYPE_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD, SERVICE_ARNS_FIELD,
            STATUS_FIELD, TYPE_FIELD, VPC_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String id;

    private final String ipAddressType;

    private final Instant lastUpdatedAt;

    private final String name;

    private final Integer port;

    private final String protocol;

    private final List<String> serviceArns;

    private final String status;

    private final String type;

    private final String vpcIdentifier;

    private TargetGroupSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.ipAddressType = builder.ipAddressType;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.serviceArns = builder.serviceArns;
        this.status = builder.status;
        this.type = builder.type;
        this.vpcIdentifier = builder.vpcIdentifier;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the target group.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the target group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the target group was created, specified in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the target group was created, specified in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the target group.
     * </p>
     * 
     * @return The ID of the target group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of IP address used for the target group. The possible values are <code>ipv4</code> and <code>ipv6</code>
     * . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The type of IP address used for the target group. The possible values are <code>ipv4</code> and
     *         <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
     *         <code>ipv4</code>.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The type of IP address used for the target group. The possible values are <code>ipv4</code> and <code>ipv6</code>
     * . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The type of IP address used for the target group. The possible values are <code>ipv4</code> and
     *         <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
     *         <code>ipv4</code>.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The date and time that the target group was last updated, specified in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the target group was last updated, specified in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the target group.
     * </p>
     * 
     * @return The name of the target group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The port of the target group.
     * </p>
     * 
     * @return The port of the target group.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The protocol of the target group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link TargetGroupProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the target group.
     * @see TargetGroupProtocol
     */
    public final TargetGroupProtocol protocol() {
        return TargetGroupProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol of the target group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link TargetGroupProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the target group.
     * @see TargetGroupProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceArns() {
        return serviceArns != null && !(serviceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Resource Names (ARNs) of the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceArns} method.
     * </p>
     * 
     * @return The list of Amazon Resource Names (ARNs) of the service.
     */
    public final List<String> serviceArns() {
        return serviceArns;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see TargetGroupStatus
     */
    public final TargetGroupStatus status() {
        return TargetGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see TargetGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The target group type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TargetGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The target group type.
     * @see TargetGroupType
     */
    public final TargetGroupType type() {
        return TargetGroupType.fromValue(type);
    }

    /**
     * <p>
     * The target group type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TargetGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The target group type.
     * @see TargetGroupType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ID of the VPC of the target group.
     * </p>
     * 
     * @return The ID of the VPC of the target group.
     */
    public final String vpcIdentifier() {
        return vpcIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceArns() ? serviceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupSummary)) {
            return false;
        }
        TargetGroupSummary other = (TargetGroupSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(id(), other.id()) && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(port(), other.port()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && hasServiceArns() == other.hasServiceArns() && Objects.equals(serviceArns(), other.serviceArns())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(vpcIdentifier(), other.vpcIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetGroupSummary").add("Arn", arn()).add("CreatedAt", createdAt()).add("Id", id())
                .add("IpAddressType", ipAddressTypeAsString()).add("LastUpdatedAt", lastUpdatedAt()).add("Name", name())
                .add("Port", port()).add("Protocol", protocolAsString())
                .add("ServiceArns", hasServiceArns() ? serviceArns() : null).add("Status", statusAsString())
                .add("Type", typeAsString()).add("VpcIdentifier", vpcIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "serviceArns":
            return Optional.ofNullable(clazz.cast(serviceArns()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "vpcIdentifier":
            return Optional.ofNullable(clazz.cast(vpcIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupSummary, T> g) {
        return obj -> g.apply((TargetGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetGroupSummary> {
        /**
         * <p>
         * The ARN (Amazon Resource Name) of the target group.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the target group was created, specified in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the target group was created, specified in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the target group.
         * </p>
         * 
         * @param id
         *        The ID of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of IP address used for the target group. The possible values are <code>ipv4</code> and
         * <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
         * <code>ipv4</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The type of IP address used for the target group. The possible values are <code>ipv4</code> and
         *        <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
         *        <code>ipv4</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The type of IP address used for the target group. The possible values are <code>ipv4</code> and
         * <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
         * <code>ipv4</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The type of IP address used for the target group. The possible values are <code>ipv4</code> and
         *        <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
         *        <code>ipv4</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The date and time that the target group was last updated, specified in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time that the target group was last updated, specified in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The name of the target group.
         * </p>
         * 
         * @param name
         *        The name of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The port of the target group.
         * </p>
         * 
         * @param port
         *        The port of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The protocol of the target group.
         * </p>
         * 
         * @param protocol
         *        The protocol of the target group.
         * @see TargetGroupProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol of the target group.
         * </p>
         * 
         * @param protocol
         *        The protocol of the target group.
         * @see TargetGroupProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupProtocol
         */
        Builder protocol(TargetGroupProtocol protocol);

        /**
         * <p>
         * The list of Amazon Resource Names (ARNs) of the service.
         * </p>
         * 
         * @param serviceArns
         *        The list of Amazon Resource Names (ARNs) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArns(Collection<String> serviceArns);

        /**
         * <p>
         * The list of Amazon Resource Names (ARNs) of the service.
         * </p>
         * 
         * @param serviceArns
         *        The list of Amazon Resource Names (ARNs) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArns(String... serviceArns);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see TargetGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see TargetGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupStatus
         */
        Builder status(TargetGroupStatus status);

        /**
         * <p>
         * The target group type.
         * </p>
         * 
         * @param type
         *        The target group type.
         * @see TargetGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupType
         */
        Builder type(String type);

        /**
         * <p>
         * The target group type.
         * </p>
         * 
         * @param type
         *        The target group type.
         * @see TargetGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupType
         */
        Builder type(TargetGroupType type);

        /**
         * <p>
         * The ID of the VPC of the target group.
         * </p>
         * 
         * @param vpcIdentifier
         *        The ID of the VPC of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIdentifier(String vpcIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String id;

        private String ipAddressType;

        private Instant lastUpdatedAt;

        private String name;

        private Integer port;

        private String protocol;

        private List<String> serviceArns = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String type;

        private String vpcIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            id(model.id);
            ipAddressType(model.ipAddressType);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            port(model.port);
            protocol(model.protocol);
            serviceArns(model.serviceArns);
            status(model.status);
            type(model.type);
            vpcIdentifier(model.vpcIdentifier);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TargetGroupProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Collection<String> getServiceArns() {
            if (serviceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceArns;
        }

        public final void setServiceArns(Collection<String> serviceArns) {
            this.serviceArns = ServiceArnListCopier.copy(serviceArns);
        }

        @Override
        public final Builder serviceArns(Collection<String> serviceArns) {
            this.serviceArns = ServiceArnListCopier.copy(serviceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceArns(String... serviceArns) {
            serviceArns(Arrays.asList(serviceArns));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TargetGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVpcIdentifier() {
            return vpcIdentifier;
        }

        public final void setVpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
        }

        @Override
        public final Builder vpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
            return this;
        }

        @Override
        public TargetGroupSummary build() {
            return new TargetGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
