/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessLogSubscriptionResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<CreateAccessLogSubscriptionResponse.Builder, CreateAccessLogSubscriptionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateAccessLogSubscriptionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(CreateAccessLogSubscriptionResponse::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateAccessLogSubscriptionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(CreateAccessLogSubscriptionResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(CreateAccessLogSubscriptionResponse::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DESTINATION_ARN_FIELD, ID_FIELD, RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD));

    private final String arn;

    private final String destinationArn;

    private final String id;

    private final String resourceArn;

    private final String resourceId;

    private CreateAccessLogSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.destinationArn = builder.destinationArn;
        this.id = builder.id;
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the access log subscription.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the access log subscription.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the log destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the log destination.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The ID of the access log subscription.
     * </p>
     * 
     * @return The ID of the access log subscription.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network or service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network or service.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ID of the service network or service.
     * </p>
     * 
     * @return The ID of the service network or service.
     */
    public final String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessLogSubscriptionResponse)) {
            return false;
        }
        CreateAccessLogSubscriptionResponse other = (CreateAccessLogSubscriptionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(id(), other.id()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessLogSubscriptionResponse").add("Arn", arn()).add("DestinationArn", destinationArn())
                .add("Id", id()).add("ResourceArn", resourceArn()).add("ResourceId", resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessLogSubscriptionResponse, T> g) {
        return obj -> g.apply((CreateAccessLogSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccessLogSubscriptionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the access log subscription.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the access log subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the log destination.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the log destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The ID of the access log subscription.
         * </p>
         * 
         * @param id
         *        The ID of the access log subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network or service.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the service network or service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ID of the service network or service.
         * </p>
         * 
         * @param resourceId
         *        The ID of the service network or service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String arn;

        private String destinationArn;

        private String id;

        private String resourceArn;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessLogSubscriptionResponse model) {
            super(model);
            arn(model.arn);
            destinationArn(model.destinationArn);
            id(model.id);
            resourceArn(model.resourceArn);
            resourceId(model.resourceId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public CreateAccessLogSubscriptionResponse build() {
            return new CreateAccessLogSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
