/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWatchlistResponse extends VoiceIdResponse implements
        ToCopyableBuilder<UpdateWatchlistResponse.Builder, UpdateWatchlistResponse> {
    private static final SdkField<Watchlist> WATCHLIST_FIELD = SdkField.<Watchlist> builder(MarshallingType.SDK_POJO)
            .memberName("Watchlist").getter(getter(UpdateWatchlistResponse::watchlist)).setter(setter(Builder::watchlist))
            .constructor(Watchlist::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Watchlist").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WATCHLIST_FIELD));

    private final Watchlist watchlist;

    private UpdateWatchlistResponse(BuilderImpl builder) {
        super(builder);
        this.watchlist = builder.watchlist;
    }

    /**
     * <p>
     * Details about the updated watchlist.
     * </p>
     * 
     * @return Details about the updated watchlist.
     */
    public final Watchlist watchlist() {
        return watchlist;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(watchlist());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWatchlistResponse)) {
            return false;
        }
        UpdateWatchlistResponse other = (UpdateWatchlistResponse) obj;
        return Objects.equals(watchlist(), other.watchlist());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWatchlistResponse").add("Watchlist", watchlist()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Watchlist":
            return Optional.ofNullable(clazz.cast(watchlist()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWatchlistResponse, T> g) {
        return obj -> g.apply((UpdateWatchlistResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VoiceIdResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWatchlistResponse> {
        /**
         * <p>
         * Details about the updated watchlist.
         * </p>
         * 
         * @param watchlist
         *        Details about the updated watchlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchlist(Watchlist watchlist);

        /**
         * <p>
         * Details about the updated watchlist.
         * </p>
         * This is a convenience method that creates an instance of the {@link Watchlist.Builder} avoiding the need to
         * create one manually via {@link Watchlist#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Watchlist.Builder#build()} is called immediately and its result
         * is passed to {@link #watchlist(Watchlist)}.
         * 
         * @param watchlist
         *        a consumer that will call methods on {@link Watchlist.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watchlist(Watchlist)
         */
        default Builder watchlist(Consumer<Watchlist.Builder> watchlist) {
            return watchlist(Watchlist.builder().applyMutation(watchlist).build());
        }
    }

    static final class BuilderImpl extends VoiceIdResponse.BuilderImpl implements Builder {
        private Watchlist watchlist;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWatchlistResponse model) {
            super(model);
            watchlist(model.watchlist);
        }

        public final Watchlist.Builder getWatchlist() {
            return watchlist != null ? watchlist.toBuilder() : null;
        }

        public final void setWatchlist(Watchlist.BuilderImpl watchlist) {
            this.watchlist = watchlist != null ? watchlist.build() : null;
        }

        @Override
        public final Builder watchlist(Watchlist watchlist) {
            this.watchlist = watchlist;
            return this;
        }

        @Override
        public UpdateWatchlistResponse build() {
            return new UpdateWatchlistResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
