/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of information about a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSummary implements SdkPojo, Serializable, ToCopyableBuilder<DomainSummary.Builder, DomainSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DomainSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DomainSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DomainSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DomainSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> DOMAIN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainStatus").getter(getter(DomainSummary::domainStatusAsString)).setter(setter(Builder::domainStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatus").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DomainSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerSideEncryptionConfiguration")
            .getter(getter(DomainSummary::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<ServerSideEncryptionUpdateDetails> SERVER_SIDE_ENCRYPTION_UPDATE_DETAILS_FIELD = SdkField
            .<ServerSideEncryptionUpdateDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ServerSideEncryptionUpdateDetails")
            .getter(getter(DomainSummary::serverSideEncryptionUpdateDetails))
            .setter(setter(Builder::serverSideEncryptionUpdateDetails))
            .constructor(ServerSideEncryptionUpdateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionUpdateDetails")
                    .build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DomainSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<WatchlistDetails> WATCHLIST_DETAILS_FIELD = SdkField
            .<WatchlistDetails> builder(MarshallingType.SDK_POJO).memberName("WatchlistDetails")
            .getter(getter(DomainSummary::watchlistDetails)).setter(setter(Builder::watchlistDetails))
            .constructor(WatchlistDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WatchlistDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOMAIN_STATUS_FIELD, NAME_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD,
            SERVER_SIDE_ENCRYPTION_UPDATE_DETAILS_FIELD, UPDATED_AT_FIELD, WATCHLIST_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String description;

    private final String domainId;

    private final String domainStatus;

    private final String name;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final ServerSideEncryptionUpdateDetails serverSideEncryptionUpdateDetails;

    private final Instant updatedAt;

    private final WatchlistDetails watchlistDetails;

    private DomainSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.domainStatus = builder.domainStatus;
        this.name = builder.name;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.serverSideEncryptionUpdateDetails = builder.serverSideEncryptionUpdateDetails;
        this.updatedAt = builder.updatedAt;
        this.watchlistDetails = builder.watchlistDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the domain.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the domain.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The timestamp of when the domain was created.
     * </p>
     * 
     * @return The timestamp of when the domain was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the domain.
     * </p>
     * 
     * @return The description of the domain.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the domain.
     * </p>
     * 
     * @return The identifier of the domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The current status of the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainStatus} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainStatusAsString}.
     * </p>
     * 
     * @return The current status of the domain.
     * @see DomainStatus
     */
    public final DomainStatus domainStatus() {
        return DomainStatus.fromValue(domainStatus);
    }

    /**
     * <p>
     * The current status of the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainStatus} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainStatusAsString}.
     * </p>
     * 
     * @return The current status of the domain.
     * @see DomainStatus
     */
    public final String domainStatusAsString() {
        return domainStatus;
    }

    /**
     * <p>
     * The client-provided name for the domain.
     * </p>
     * 
     * @return The client-provided name for the domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to encrypt
     * your data.
     * </p>
     * 
     * @return The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to
     *         encrypt your data.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * Details about the most recent server-side encryption configuration update. When the server-side encryption
     * configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this
     * update is complete, the domain's data can only be accessed using the new KMS key.
     * </p>
     * 
     * @return Details about the most recent server-side encryption configuration update. When the server-side
     *         encryption configuration is changed, dependency on the old KMS key is removed through an asynchronous
     *         process. When this update is complete, the domain's data can only be accessed using the new KMS key.
     */
    public final ServerSideEncryptionUpdateDetails serverSideEncryptionUpdateDetails() {
        return serverSideEncryptionUpdateDetails;
    }

    /**
     * <p>
     * The timestamp of when the domain was last updated.
     * </p>
     * 
     * @return The timestamp of when the domain was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Provides information about <code>watchlistDetails</code> and <code>DefaultWatchlistID</code>.
     * </p>
     * 
     * @return Provides information about <code>watchlistDetails</code> and <code>DefaultWatchlistID</code>.
     */
    public final WatchlistDetails watchlistDetails() {
        return watchlistDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionUpdateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(watchlistDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(domainStatusAsString(), other.domainStatusAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(serverSideEncryptionUpdateDetails(), other.serverSideEncryptionUpdateDetails())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(watchlistDetails(), other.watchlistDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("DomainStatus", domainStatusAsString())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("ServerSideEncryptionUpdateDetails", serverSideEncryptionUpdateDetails()).add("UpdatedAt", updatedAt())
                .add("WatchlistDetails", watchlistDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DomainStatus":
            return Optional.ofNullable(clazz.cast(domainStatusAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ServerSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "ServerSideEncryptionUpdateDetails":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionUpdateDetails()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "WatchlistDetails":
            return Optional.ofNullable(clazz.cast(watchlistDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSummary, T> g) {
        return obj -> g.apply((DomainSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the domain.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The timestamp of when the domain was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the domain.
         * </p>
         * 
         * @param description
         *        The description of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the domain.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The current status of the domain.
         * </p>
         * 
         * @param domainStatus
         *        The current status of the domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder domainStatus(String domainStatus);

        /**
         * <p>
         * The current status of the domain.
         * </p>
         * 
         * @param domainStatus
         *        The current status of the domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder domainStatus(DomainStatus domainStatus);

        /**
         * <p>
         * The client-provided name for the domain.
         * </p>
         * 
         * @param name
         *        The client-provided name for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to
         * encrypt your data.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to
         *        encrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to
         * encrypt your data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * Details about the most recent server-side encryption configuration update. When the server-side encryption
         * configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this
         * update is complete, the domain's data can only be accessed using the new KMS key.
         * </p>
         * 
         * @param serverSideEncryptionUpdateDetails
         *        Details about the most recent server-side encryption configuration update. When the server-side
         *        encryption configuration is changed, dependency on the old KMS key is removed through an asynchronous
         *        process. When this update is complete, the domain's data can only be accessed using the new KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionUpdateDetails(ServerSideEncryptionUpdateDetails serverSideEncryptionUpdateDetails);

        /**
         * <p>
         * Details about the most recent server-side encryption configuration update. When the server-side encryption
         * configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this
         * update is complete, the domain's data can only be accessed using the new KMS key.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionUpdateDetails.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionUpdateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionUpdateDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionUpdateDetails(ServerSideEncryptionUpdateDetails)}.
         * 
         * @param serverSideEncryptionUpdateDetails
         *        a consumer that will call methods on {@link ServerSideEncryptionUpdateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionUpdateDetails(ServerSideEncryptionUpdateDetails)
         */
        default Builder serverSideEncryptionUpdateDetails(
                Consumer<ServerSideEncryptionUpdateDetails.Builder> serverSideEncryptionUpdateDetails) {
            return serverSideEncryptionUpdateDetails(ServerSideEncryptionUpdateDetails.builder()
                    .applyMutation(serverSideEncryptionUpdateDetails).build());
        }

        /**
         * <p>
         * The timestamp of when the domain was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the domain was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Provides information about <code>watchlistDetails</code> and <code>DefaultWatchlistID</code>.
         * </p>
         * 
         * @param watchlistDetails
         *        Provides information about <code>watchlistDetails</code> and <code>DefaultWatchlistID</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchlistDetails(WatchlistDetails watchlistDetails);

        /**
         * <p>
         * Provides information about <code>watchlistDetails</code> and <code>DefaultWatchlistID</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link WatchlistDetails.Builder} avoiding the
         * need to create one manually via {@link WatchlistDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WatchlistDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #watchlistDetails(WatchlistDetails)}.
         * 
         * @param watchlistDetails
         *        a consumer that will call methods on {@link WatchlistDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watchlistDetails(WatchlistDetails)
         */
        default Builder watchlistDetails(Consumer<WatchlistDetails.Builder> watchlistDetails) {
            return watchlistDetails(WatchlistDetails.builder().applyMutation(watchlistDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String description;

        private String domainId;

        private String domainStatus;

        private String name;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private ServerSideEncryptionUpdateDetails serverSideEncryptionUpdateDetails;

        private Instant updatedAt;

        private WatchlistDetails watchlistDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            description(model.description);
            domainId(model.domainId);
            domainStatus(model.domainStatus);
            name(model.name);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            serverSideEncryptionUpdateDetails(model.serverSideEncryptionUpdateDetails);
            updatedAt(model.updatedAt);
            watchlistDetails(model.watchlistDetails);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainStatus() {
            return domainStatus;
        }

        public final void setDomainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
        }

        @Override
        public final Builder domainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        @Override
        public final Builder domainStatus(DomainStatus domainStatus) {
            this.domainStatus(domainStatus == null ? null : domainStatus.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final ServerSideEncryptionUpdateDetails.Builder getServerSideEncryptionUpdateDetails() {
            return serverSideEncryptionUpdateDetails != null ? serverSideEncryptionUpdateDetails.toBuilder() : null;
        }

        public final void setServerSideEncryptionUpdateDetails(
                ServerSideEncryptionUpdateDetails.BuilderImpl serverSideEncryptionUpdateDetails) {
            this.serverSideEncryptionUpdateDetails = serverSideEncryptionUpdateDetails != null ? serverSideEncryptionUpdateDetails
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionUpdateDetails(ServerSideEncryptionUpdateDetails serverSideEncryptionUpdateDetails) {
            this.serverSideEncryptionUpdateDetails = serverSideEncryptionUpdateDetails;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final WatchlistDetails.Builder getWatchlistDetails() {
            return watchlistDetails != null ? watchlistDetails.toBuilder() : null;
        }

        public final void setWatchlistDetails(WatchlistDetails.BuilderImpl watchlistDetails) {
            this.watchlistDetails = watchlistDetails != null ? watchlistDetails.build() : null;
        }

        @Override
        public final Builder watchlistDetails(WatchlistDetails watchlistDetails) {
            this.watchlistDetails = watchlistDetails;
            return this;
        }

        @Override
        public DomainSummary build() {
            return new DomainSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
