/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all the information about a speaker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Speaker implements SdkPojo, Serializable, ToCopyableBuilder<Speaker.Builder, Speaker> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Speaker::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> CUSTOMER_SPEAKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerSpeakerId").getter(getter(Speaker::customerSpeakerId))
            .setter(setter(Builder::customerSpeakerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerSpeakerId").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(Speaker::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> GENERATED_SPEAKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedSpeakerId").getter(getter(Speaker::generatedSpeakerId))
            .setter(setter(Builder::generatedSpeakerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedSpeakerId").build())
            .build();

    private static final SdkField<Instant> LAST_ACCESSED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAccessedAt").getter(getter(Speaker::lastAccessedAt)).setter(setter(Builder::lastAccessedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Speaker::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(Speaker::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CUSTOMER_SPEAKER_ID_FIELD, DOMAIN_ID_FIELD, GENERATED_SPEAKER_ID_FIELD, LAST_ACCESSED_AT_FIELD, STATUS_FIELD,
            UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String customerSpeakerId;

    private final String domainId;

    private final String generatedSpeakerId;

    private final Instant lastAccessedAt;

    private final String status;

    private final Instant updatedAt;

    private Speaker(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.customerSpeakerId = builder.customerSpeakerId;
        this.domainId = builder.domainId;
        this.generatedSpeakerId = builder.generatedSpeakerId;
        this.lastAccessedAt = builder.lastAccessedAt;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * A timestamp of when the speaker was created.
     * </p>
     * 
     * @return A timestamp of when the speaker was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The client-provided identifier for the speaker.
     * </p>
     * 
     * @return The client-provided identifier for the speaker.
     */
    public final String customerSpeakerId() {
        return customerSpeakerId;
    }

    /**
     * <p>
     * The identifier of the domain that contains the speaker.
     * </p>
     * 
     * @return The identifier of the domain that contains the speaker.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The service-generated identifier for the speaker.
     * </p>
     * 
     * @return The service-generated identifier for the speaker.
     */
    public final String generatedSpeakerId() {
        return generatedSpeakerId;
    }

    /**
     * <p>
     * The timestamp of when the speaker was last accessed for enrollment, re-enrollment or a successful authentication.
     * This timestamp is accurate to one hour.
     * </p>
     * 
     * @return The timestamp of when the speaker was last accessed for enrollment, re-enrollment or a successful
     *         authentication. This timestamp is accurate to one hour.
     */
    public final Instant lastAccessedAt() {
        return lastAccessedAt;
    }

    /**
     * <p>
     * The current status of the speaker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SpeakerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the speaker.
     * @see SpeakerStatus
     */
    public final SpeakerStatus status() {
        return SpeakerStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the speaker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SpeakerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the speaker.
     * @see SpeakerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp of the speaker's last update.
     * </p>
     * 
     * @return A timestamp of the speaker's last update.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(customerSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(generatedSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Speaker)) {
            return false;
        }
        Speaker other = (Speaker) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(customerSpeakerId(), other.customerSpeakerId())
                && Objects.equals(domainId(), other.domainId())
                && Objects.equals(generatedSpeakerId(), other.generatedSpeakerId())
                && Objects.equals(lastAccessedAt(), other.lastAccessedAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Speaker").add("CreatedAt", createdAt())
                .add("CustomerSpeakerId", customerSpeakerId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainId", domainId()).add("GeneratedSpeakerId", generatedSpeakerId())
                .add("LastAccessedAt", lastAccessedAt()).add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "CustomerSpeakerId":
            return Optional.ofNullable(clazz.cast(customerSpeakerId()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "GeneratedSpeakerId":
            return Optional.ofNullable(clazz.cast(generatedSpeakerId()));
        case "LastAccessedAt":
            return Optional.ofNullable(clazz.cast(lastAccessedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Speaker, T> g) {
        return obj -> g.apply((Speaker) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Speaker> {
        /**
         * <p>
         * A timestamp of when the speaker was created.
         * </p>
         * 
         * @param createdAt
         *        A timestamp of when the speaker was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The client-provided identifier for the speaker.
         * </p>
         * 
         * @param customerSpeakerId
         *        The client-provided identifier for the speaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerSpeakerId(String customerSpeakerId);

        /**
         * <p>
         * The identifier of the domain that contains the speaker.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain that contains the speaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The service-generated identifier for the speaker.
         * </p>
         * 
         * @param generatedSpeakerId
         *        The service-generated identifier for the speaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedSpeakerId(String generatedSpeakerId);

        /**
         * <p>
         * The timestamp of when the speaker was last accessed for enrollment, re-enrollment or a successful
         * authentication. This timestamp is accurate to one hour.
         * </p>
         * 
         * @param lastAccessedAt
         *        The timestamp of when the speaker was last accessed for enrollment, re-enrollment or a successful
         *        authentication. This timestamp is accurate to one hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedAt(Instant lastAccessedAt);

        /**
         * <p>
         * The current status of the speaker.
         * </p>
         * 
         * @param status
         *        The current status of the speaker.
         * @see SpeakerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeakerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the speaker.
         * </p>
         * 
         * @param status
         *        The current status of the speaker.
         * @see SpeakerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeakerStatus
         */
        Builder status(SpeakerStatus status);

        /**
         * <p>
         * A timestamp of the speaker's last update.
         * </p>
         * 
         * @param updatedAt
         *        A timestamp of the speaker's last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String customerSpeakerId;

        private String domainId;

        private String generatedSpeakerId;

        private Instant lastAccessedAt;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Speaker model) {
            createdAt(model.createdAt);
            customerSpeakerId(model.customerSpeakerId);
            domainId(model.domainId);
            generatedSpeakerId(model.generatedSpeakerId);
            lastAccessedAt(model.lastAccessedAt);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCustomerSpeakerId() {
            return customerSpeakerId;
        }

        public final void setCustomerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
        }

        @Override
        public final Builder customerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGeneratedSpeakerId() {
            return generatedSpeakerId;
        }

        public final void setGeneratedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
        }

        @Override
        public final Builder generatedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
            return this;
        }

        public final Instant getLastAccessedAt() {
            return lastAccessedAt;
        }

        public final void setLastAccessedAt(Instant lastAccessedAt) {
            this.lastAccessedAt = lastAccessedAt;
        }

        @Override
        public final Builder lastAccessedAt(Instant lastAccessedAt) {
            this.lastAccessedAt = lastAccessedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SpeakerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Speaker build() {
            return new Speaker(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
