/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthenticationDecision {
    ACCEPT("ACCEPT"),
    REJECT("REJECT"),
    NOT_ENOUGH_SPEECH("NOT_ENOUGH_SPEECH"),
    SPEAKER_NOT_ENROLLED("SPEAKER_NOT_ENROLLED"),
    SPEAKER_OPTED_OUT("SPEAKER_OPTED_OUT"),
    SPEAKER_ID_NOT_PROVIDED("SPEAKER_ID_NOT_PROVIDED"),
    SPEAKER_EXPIRED("SPEAKER_EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthenticationDecision> VALUE_MAP;
    private final String value;

    private AuthenticationDecision(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationDecision fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationDecision> knownValues() {
        EnumSet<AuthenticationDecision> knownValues = EnumSet.allOf(AuthenticationDecision.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthenticationDecision.class, AuthenticationDecision::toString);
    }
}

