/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.ClientIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCognitoUserPoolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateCognitoUserPoolConfiguration> {
    private static final SdkField<String> USER_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userPoolArn").getter(UpdateCognitoUserPoolConfiguration.getter(UpdateCognitoUserPoolConfiguration::userPoolArn)).setter(UpdateCognitoUserPoolConfiguration.setter(Builder::userPoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolArn").build()}).build();
    private static final SdkField<List<String>> CLIENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientIds").getter(UpdateCognitoUserPoolConfiguration.getter(UpdateCognitoUserPoolConfiguration::clientIds)).setter(UpdateCognitoUserPoolConfiguration.setter(Builder::clientIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ARN_FIELD, CLIENT_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userPoolArn;
    private final List<String> clientIds;

    private UpdateCognitoUserPoolConfiguration(BuilderImpl builder) {
        this.userPoolArn = builder.userPoolArn;
        this.clientIds = builder.clientIds;
    }

    public final String userPoolArn() {
        return this.userPoolArn;
    }

    public final boolean hasClientIds() {
        return this.clientIds != null && !(this.clientIds instanceof SdkAutoConstructList);
    }

    public final List<String> clientIds() {
        return this.clientIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientIds() ? this.clientIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCognitoUserPoolConfiguration)) {
            return false;
        }
        UpdateCognitoUserPoolConfiguration other = (UpdateCognitoUserPoolConfiguration)obj;
        return Objects.equals(this.userPoolArn(), other.userPoolArn()) && this.hasClientIds() == other.hasClientIds() && Objects.equals(this.clientIds(), other.clientIds());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCognitoUserPoolConfiguration").add("UserPoolArn", (Object)this.userPoolArn()).add("ClientIds", (Object)(this.clientIds() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userPoolArn": {
                return Optional.ofNullable(clazz.cast(this.userPoolArn()));
            }
            case "clientIds": {
                return Optional.ofNullable(clazz.cast(this.clientIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCognitoUserPoolConfiguration, T> g) {
        return obj -> g.apply((UpdateCognitoUserPoolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolArn;
        private List<String> clientIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCognitoUserPoolConfiguration model) {
            this.userPoolArn(model.userPoolArn);
            this.clientIds(model.clientIds);
        }

        public final String getUserPoolArn() {
            return this.userPoolArn;
        }

        public final void setUserPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
        }

        @Override
        public final Builder userPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
            return this;
        }

        public final Collection<String> getClientIds() {
            if (this.clientIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientIds;
        }

        public final void setClientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
        }

        @Override
        public final Builder clientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIds(String ... clientIds) {
            this.clientIds(Arrays.asList(clientIds));
            return this;
        }

        public UpdateCognitoUserPoolConfiguration build() {
            return new UpdateCognitoUserPoolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateCognitoUserPoolConfiguration> {
        public Builder userPoolArn(String var1);

        public Builder clientIds(Collection<String> var1);

        public Builder clientIds(String ... var1);
    }
}

