/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.ClientIdsCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.OpenIdIssuer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentitySourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentitySourceDetails> {
    private static final SdkField<List<String>> CLIENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientIds").getter(IdentitySourceDetails.getter(IdentitySourceDetails::clientIds)).setter(IdentitySourceDetails.setter(Builder::clientIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userPoolArn").getter(IdentitySourceDetails.getter(IdentitySourceDetails::userPoolArn)).setter(IdentitySourceDetails.setter(Builder::userPoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolArn").build()}).build();
    private static final SdkField<String> DISCOVERY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("discoveryUrl").getter(IdentitySourceDetails.getter(IdentitySourceDetails::discoveryUrl)).setter(IdentitySourceDetails.setter(Builder::discoveryUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryUrl").build()}).build();
    private static final SdkField<String> OPEN_ID_ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("openIdIssuer").getter(IdentitySourceDetails.getter(IdentitySourceDetails::openIdIssuerAsString)).setter(IdentitySourceDetails.setter(Builder::openIdIssuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIdIssuer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_IDS_FIELD, USER_POOL_ARN_FIELD, DISCOVERY_URL_FIELD, OPEN_ID_ISSUER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> clientIds;
    private final String userPoolArn;
    private final String discoveryUrl;
    private final String openIdIssuer;

    private IdentitySourceDetails(BuilderImpl builder) {
        this.clientIds = builder.clientIds;
        this.userPoolArn = builder.userPoolArn;
        this.discoveryUrl = builder.discoveryUrl;
        this.openIdIssuer = builder.openIdIssuer;
    }

    public final boolean hasClientIds() {
        return this.clientIds != null && !(this.clientIds instanceof SdkAutoConstructList);
    }

    public final List<String> clientIds() {
        return this.clientIds;
    }

    public final String userPoolArn() {
        return this.userPoolArn;
    }

    public final String discoveryUrl() {
        return this.discoveryUrl;
    }

    public final OpenIdIssuer openIdIssuer() {
        return OpenIdIssuer.fromValue(this.openIdIssuer);
    }

    public final String openIdIssuerAsString() {
        return this.openIdIssuer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientIds() ? this.clientIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIdIssuerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentitySourceDetails)) {
            return false;
        }
        IdentitySourceDetails other = (IdentitySourceDetails)obj;
        return this.hasClientIds() == other.hasClientIds() && Objects.equals(this.clientIds(), other.clientIds()) && Objects.equals(this.userPoolArn(), other.userPoolArn()) && Objects.equals(this.discoveryUrl(), other.discoveryUrl()) && Objects.equals(this.openIdIssuerAsString(), other.openIdIssuerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IdentitySourceDetails").add("ClientIds", (Object)(this.clientIds() == null ? null : "*** Sensitive Data Redacted ***")).add("UserPoolArn", (Object)this.userPoolArn()).add("DiscoveryUrl", (Object)this.discoveryUrl()).add("OpenIdIssuer", (Object)this.openIdIssuerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientIds": {
                return Optional.ofNullable(clazz.cast(this.clientIds()));
            }
            case "userPoolArn": {
                return Optional.ofNullable(clazz.cast(this.userPoolArn()));
            }
            case "discoveryUrl": {
                return Optional.ofNullable(clazz.cast(this.discoveryUrl()));
            }
            case "openIdIssuer": {
                return Optional.ofNullable(clazz.cast(this.openIdIssuerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentitySourceDetails, T> g) {
        return obj -> g.apply((IdentitySourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> clientIds = DefaultSdkAutoConstructList.getInstance();
        private String userPoolArn;
        private String discoveryUrl;
        private String openIdIssuer;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentitySourceDetails model) {
            this.clientIds(model.clientIds);
            this.userPoolArn(model.userPoolArn);
            this.discoveryUrl(model.discoveryUrl);
            this.openIdIssuer(model.openIdIssuer);
        }

        public final Collection<String> getClientIds() {
            if (this.clientIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientIds;
        }

        public final void setClientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
        }

        @Override
        public final Builder clientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIds(String ... clientIds) {
            this.clientIds(Arrays.asList(clientIds));
            return this;
        }

        public final String getUserPoolArn() {
            return this.userPoolArn;
        }

        public final void setUserPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
        }

        @Override
        public final Builder userPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
            return this;
        }

        public final String getDiscoveryUrl() {
            return this.discoveryUrl;
        }

        public final void setDiscoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
        }

        @Override
        public final Builder discoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
            return this;
        }

        public final String getOpenIdIssuer() {
            return this.openIdIssuer;
        }

        public final void setOpenIdIssuer(String openIdIssuer) {
            this.openIdIssuer = openIdIssuer;
        }

        @Override
        public final Builder openIdIssuer(String openIdIssuer) {
            this.openIdIssuer = openIdIssuer;
            return this;
        }

        @Override
        public final Builder openIdIssuer(OpenIdIssuer openIdIssuer) {
            this.openIdIssuer(openIdIssuer == null ? null : openIdIssuer.toString());
            return this;
        }

        public IdentitySourceDetails build() {
            return new IdentitySourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentitySourceDetails> {
        public Builder clientIds(Collection<String> var1);

        public Builder clientIds(String ... var1);

        public Builder userPoolArn(String var1);

        public Builder discoveryUrl(String var1);

        public Builder openIdIssuer(String var1);

        public Builder openIdIssuer(OpenIdIssuer var1);
    }
}

