/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.internal.UserAgentUtils;
import software.amazon.awssdk.services.translate.model.ListParallelDataRequest;
import software.amazon.awssdk.services.translate.model.ListParallelDataResponse;

public class ListParallelDataIterable
implements SdkIterable<ListParallelDataResponse> {
    private final TranslateClient client;
    private final ListParallelDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListParallelDataIterable(TranslateClient client, ListParallelDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListParallelDataResponseFetcher();
    }

    public Iterator<ListParallelDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListParallelDataResponseFetcher
    implements SyncPageFetcher<ListParallelDataResponse> {
        private ListParallelDataResponseFetcher() {
        }

        public boolean hasNextPage(ListParallelDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListParallelDataResponse nextPage(ListParallelDataResponse previousPage) {
            if (previousPage == null) {
                return ListParallelDataIterable.this.client.listParallelData(ListParallelDataIterable.this.firstRequest);
            }
            return ListParallelDataIterable.this.client.listParallelData((ListParallelDataRequest)((Object)ListParallelDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

