/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextTranslationJobFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextTranslationJobFilter> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(TextTranslationJobFilter.getter(TextTranslationJobFilter::jobName)).setter(TextTranslationJobFilter.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(TextTranslationJobFilter.getter(TextTranslationJobFilter::jobStatusAsString)).setter(TextTranslationJobFilter.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> SUBMITTED_BEFORE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmittedBeforeTime").getter(TextTranslationJobFilter.getter(TextTranslationJobFilter::submittedBeforeTime)).setter(TextTranslationJobFilter.setter(Builder::submittedBeforeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedBeforeTime").build()}).build();
    private static final SdkField<Instant> SUBMITTED_AFTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmittedAfterTime").getter(TextTranslationJobFilter.getter(TextTranslationJobFilter::submittedAfterTime)).setter(TextTranslationJobFilter.setter(Builder::submittedAfterTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedAfterTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_STATUS_FIELD, SUBMITTED_BEFORE_TIME_FIELD, SUBMITTED_AFTER_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final String jobStatus;
    private final Instant submittedBeforeTime;
    private final Instant submittedAfterTime;

    private TextTranslationJobFilter(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submittedBeforeTime = builder.submittedBeforeTime;
        this.submittedAfterTime = builder.submittedAfterTime;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final Instant submittedBeforeTime() {
        return this.submittedBeforeTime;
    }

    public final Instant submittedAfterTime() {
        return this.submittedAfterTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedBeforeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedAfterTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextTranslationJobFilter)) {
            return false;
        }
        TextTranslationJobFilter other = (TextTranslationJobFilter)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.submittedBeforeTime(), other.submittedBeforeTime()) && Objects.equals(this.submittedAfterTime(), other.submittedAfterTime());
    }

    public final String toString() {
        return ToString.builder((String)"TextTranslationJobFilter").add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("SubmittedBeforeTime", (Object)this.submittedBeforeTime()).add("SubmittedAfterTime", (Object)this.submittedAfterTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "SubmittedBeforeTime": {
                return Optional.ofNullable(clazz.cast(this.submittedBeforeTime()));
            }
            case "SubmittedAfterTime": {
                return Optional.ofNullable(clazz.cast(this.submittedAfterTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextTranslationJobFilter, T> g) {
        return obj -> g.apply((TextTranslationJobFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobStatus;
        private Instant submittedBeforeTime;
        private Instant submittedAfterTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TextTranslationJobFilter model) {
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.submittedBeforeTime(model.submittedBeforeTime);
            this.submittedAfterTime(model.submittedAfterTime);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getSubmittedBeforeTime() {
            return this.submittedBeforeTime;
        }

        public final void setSubmittedBeforeTime(Instant submittedBeforeTime) {
            this.submittedBeforeTime = submittedBeforeTime;
        }

        @Override
        public final Builder submittedBeforeTime(Instant submittedBeforeTime) {
            this.submittedBeforeTime = submittedBeforeTime;
            return this;
        }

        public final Instant getSubmittedAfterTime() {
            return this.submittedAfterTime;
        }

        public final void setSubmittedAfterTime(Instant submittedAfterTime) {
            this.submittedAfterTime = submittedAfterTime;
        }

        @Override
        public final Builder submittedAfterTime(Instant submittedAfterTime) {
            this.submittedAfterTime = submittedAfterTime;
            return this;
        }

        public TextTranslationJobFilter build() {
            return new TextTranslationJobFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextTranslationJobFilter> {
        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder submittedBeforeTime(Instant var1);

        public Builder submittedAfterTime(Instant var1);
    }
}

