/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Directionality {
    UNI("UNI"),
    MULTI("MULTI"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Directionality> VALUE_MAP;
    private final String value;

    private Directionality(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Directionality fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Directionality> knownValues() {
        EnumSet<Directionality> knownValues = EnumSet.allOf(Directionality.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Directionality.class, Directionality::toString);
    }
}

