/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfilesRequest extends TransferRequest implements
        ToCopyableBuilder<ListProfilesRequest.Builder, ListProfilesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListProfilesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> PROFILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileType").getter(getter(ListProfilesRequest::profileTypeAsString))
            .setter(setter(Builder::profileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, PROFILE_TYPE_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String profileType;

    private ListProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.profileType = builder.profileType;
    }

    /**
     * <p>
     * The maximum number of profiles to return.
     * </p>
     * 
     * @return The maximum number of profiles to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When there are additional results that were not returned, a <code>NextToken</code> parameter is returned. You can
     * use that value for a subsequent call to <code>ListProfiles</code> to continue listing results.
     * </p>
     * 
     * @return When there are additional results that were not returned, a <code>NextToken</code> parameter is returned.
     *         You can use that value for a subsequent call to <code>ListProfiles</code> to continue listing results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles. If
     * not supplied in the request, the command lists all types of profiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileType} will
     * return {@link ProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
     *         profiles. If not supplied in the request, the command lists all types of profiles.
     * @see ProfileType
     */
    public final ProfileType profileType() {
        return ProfileType.fromValue(profileType);
    }

    /**
     * <p>
     * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles. If
     * not supplied in the request, the command lists all types of profiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileType} will
     * return {@link ProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
     *         profiles. If not supplied in the request, the command lists all types of profiles.
     * @see ProfileType
     */
    public final String profileTypeAsString() {
        return profileType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(profileTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilesRequest)) {
            return false;
        }
        ListProfilesRequest other = (ListProfilesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(profileTypeAsString(), other.profileTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfilesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ProfileType", profileTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ProfileType":
            return Optional.ofNullable(clazz.cast(profileTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilesRequest, T> g) {
        return obj -> g.apply((ListProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListProfilesRequest> {
        /**
         * <p>
         * The maximum number of profiles to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of profiles to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When there are additional results that were not returned, a <code>NextToken</code> parameter is returned. You
         * can use that value for a subsequent call to <code>ListProfiles</code> to continue listing results.
         * </p>
         * 
         * @param nextToken
         *        When there are additional results that were not returned, a <code>NextToken</code> parameter is
         *        returned. You can use that value for a subsequent call to <code>ListProfiles</code> to continue
         *        listing results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles.
         * If not supplied in the request, the command lists all types of profiles.
         * </p>
         * 
         * @param profileType
         *        Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
         *        profiles. If not supplied in the request, the command lists all types of profiles.
         * @see ProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileType
         */
        Builder profileType(String profileType);

        /**
         * <p>
         * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles.
         * If not supplied in the request, the command lists all types of profiles.
         * </p>
         * 
         * @param profileType
         *        Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
         *        profiles. If not supplied in the request, the command lists all types of profiles.
         * @see ProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileType
         */
        Builder profileType(ProfileType profileType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String profileType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            profileType(model.profileType);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProfileType() {
            return profileType;
        }

        public final void setProfileType(String profileType) {
            this.profileType = profileType;
        }

        @Override
        public final Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        @Override
        public final Builder profileType(ProfileType profileType) {
            this.profileType(profileType == null ? null : profileType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfilesRequest build() {
            return new ListProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
