/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Info about the specific network instance.
 * </p>
 * <p>
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
 * life-cycle operations (like terminate, update, and delete) can be performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolNetworkInstanceInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ListSolNetworkInstanceInfo.Builder, ListSolNetworkInstanceInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ListSolNetworkInstanceInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ListSolNetworkInstanceInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ListSolNetworkInstanceMetadata> METADATA_FIELD = SdkField
            .<ListSolNetworkInstanceMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(ListSolNetworkInstanceInfo::metadata)).setter(setter(Builder::metadata))
            .constructor(ListSolNetworkInstanceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NS_INSTANCE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceDescription").getter(getter(ListSolNetworkInstanceInfo::nsInstanceDescription))
            .setter(setter(Builder::nsInstanceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceDescription").build())
            .build();

    private static final SdkField<String> NS_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceName").getter(getter(ListSolNetworkInstanceInfo::nsInstanceName))
            .setter(setter(Builder::nsInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceName").build()).build();

    private static final SdkField<String> NS_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsState").getter(getter(ListSolNetworkInstanceInfo::nsStateAsString)).setter(setter(Builder::nsState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsState").build()).build();

    private static final SdkField<String> NSD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nsdId")
            .getter(getter(ListSolNetworkInstanceInfo::nsdId)).setter(setter(Builder::nsdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdId").build()).build();

    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInfoId").getter(getter(ListSolNetworkInstanceInfo::nsdInfoId)).setter(setter(Builder::nsdInfoId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            METADATA_FIELD, NS_INSTANCE_DESCRIPTION_FIELD, NS_INSTANCE_NAME_FIELD, NS_STATE_FIELD, NSD_ID_FIELD,
            NSD_INFO_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final ListSolNetworkInstanceMetadata metadata;

    private final String nsInstanceDescription;

    private final String nsInstanceName;

    private final String nsState;

    private final String nsdId;

    private final String nsdInfoId;

    private ListSolNetworkInstanceInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.nsInstanceDescription = builder.nsInstanceDescription;
        this.nsInstanceName = builder.nsInstanceName;
        this.nsState = builder.nsState;
        this.nsdId = builder.nsdId;
        this.nsdInfoId = builder.nsdInfoId;
    }

    /**
     * <p>
     * Network instance ARN.
     * </p>
     * 
     * @return Network instance ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * ID of the network instance.
     * </p>
     * 
     * @return ID of the network instance.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The metadata of the network instance.
     * </p>
     * 
     * @return The metadata of the network instance.
     */
    public final ListSolNetworkInstanceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Human-readable description of the network instance.
     * </p>
     * 
     * @return Human-readable description of the network instance.
     */
    public final String nsInstanceDescription() {
        return nsInstanceDescription;
    }

    /**
     * <p>
     * Human-readable name of the network instance.
     * </p>
     * 
     * @return Human-readable name of the network instance.
     */
    public final String nsInstanceName() {
        return nsInstanceName;
    }

    /**
     * <p>
     * The state of the network instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsState} will
     * return {@link NsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsStateAsString}.
     * </p>
     * 
     * @return The state of the network instance.
     * @see NsState
     */
    public final NsState nsState() {
        return NsState.fromValue(nsState);
    }

    /**
     * <p>
     * The state of the network instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsState} will
     * return {@link NsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsStateAsString}.
     * </p>
     * 
     * @return The state of the network instance.
     * @see NsState
     */
    public final String nsStateAsString() {
        return nsState;
    }

    /**
     * <p>
     * ID of the network service descriptor in the network package.
     * </p>
     * 
     * @return ID of the network service descriptor in the network package.
     */
    public final String nsdId() {
        return nsdId;
    }

    /**
     * <p>
     * ID of the network service descriptor in the network package.
     * </p>
     * 
     * @return ID of the network service descriptor in the network package.
     */
    public final String nsdInfoId() {
        return nsdInfoId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(nsStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdId());
        hashCode = 31 * hashCode + Objects.hashCode(nsdInfoId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkInstanceInfo)) {
            return false;
        }
        ListSolNetworkInstanceInfo other = (ListSolNetworkInstanceInfo) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(metadata(), other.metadata())
                && Objects.equals(nsInstanceDescription(), other.nsInstanceDescription())
                && Objects.equals(nsInstanceName(), other.nsInstanceName())
                && Objects.equals(nsStateAsString(), other.nsStateAsString()) && Objects.equals(nsdId(), other.nsdId())
                && Objects.equals(nsdInfoId(), other.nsdInfoId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolNetworkInstanceInfo").add("Arn", arn()).add("Id", id()).add("Metadata", metadata())
                .add("NsInstanceDescription", nsInstanceDescription()).add("NsInstanceName", nsInstanceName())
                .add("NsState", nsStateAsString()).add("NsdId", nsdId()).add("NsdInfoId", nsdInfoId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsInstanceDescription":
            return Optional.ofNullable(clazz.cast(nsInstanceDescription()));
        case "nsInstanceName":
            return Optional.ofNullable(clazz.cast(nsInstanceName()));
        case "nsState":
            return Optional.ofNullable(clazz.cast(nsStateAsString()));
        case "nsdId":
            return Optional.ofNullable(clazz.cast(nsdId()));
        case "nsdInfoId":
            return Optional.ofNullable(clazz.cast(nsdInfoId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkInstanceInfo, T> g) {
        return obj -> g.apply((ListSolNetworkInstanceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListSolNetworkInstanceInfo> {
        /**
         * <p>
         * Network instance ARN.
         * </p>
         * 
         * @param arn
         *        Network instance ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * ID of the network instance.
         * </p>
         * 
         * @param id
         *        ID of the network instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The metadata of the network instance.
         * </p>
         * 
         * @param metadata
         *        The metadata of the network instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ListSolNetworkInstanceMetadata metadata);

        /**
         * <p>
         * The metadata of the network instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListSolNetworkInstanceMetadata.Builder}
         * avoiding the need to create one manually via {@link ListSolNetworkInstanceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListSolNetworkInstanceMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(ListSolNetworkInstanceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ListSolNetworkInstanceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ListSolNetworkInstanceMetadata)
         */
        default Builder metadata(Consumer<ListSolNetworkInstanceMetadata.Builder> metadata) {
            return metadata(ListSolNetworkInstanceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Human-readable description of the network instance.
         * </p>
         * 
         * @param nsInstanceDescription
         *        Human-readable description of the network instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceDescription(String nsInstanceDescription);

        /**
         * <p>
         * Human-readable name of the network instance.
         * </p>
         * 
         * @param nsInstanceName
         *        Human-readable name of the network instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceName(String nsInstanceName);

        /**
         * <p>
         * The state of the network instance.
         * </p>
         * 
         * @param nsState
         *        The state of the network instance.
         * @see NsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsState
         */
        Builder nsState(String nsState);

        /**
         * <p>
         * The state of the network instance.
         * </p>
         * 
         * @param nsState
         *        The state of the network instance.
         * @see NsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsState
         */
        Builder nsState(NsState nsState);

        /**
         * <p>
         * ID of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdId
         *        ID of the network service descriptor in the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdId(String nsdId);

        /**
         * <p>
         * ID of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdInfoId
         *        ID of the network service descriptor in the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInfoId(String nsdInfoId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private ListSolNetworkInstanceMetadata metadata;

        private String nsInstanceDescription;

        private String nsInstanceName;

        private String nsState;

        private String nsdId;

        private String nsdInfoId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkInstanceInfo model) {
            arn(model.arn);
            id(model.id);
            metadata(model.metadata);
            nsInstanceDescription(model.nsInstanceDescription);
            nsInstanceName(model.nsInstanceName);
            nsState(model.nsState);
            nsdId(model.nsdId);
            nsdInfoId(model.nsdInfoId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ListSolNetworkInstanceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ListSolNetworkInstanceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ListSolNetworkInstanceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceDescription() {
            return nsInstanceDescription;
        }

        public final void setNsInstanceDescription(String nsInstanceDescription) {
            this.nsInstanceDescription = nsInstanceDescription;
        }

        @Override
        public final Builder nsInstanceDescription(String nsInstanceDescription) {
            this.nsInstanceDescription = nsInstanceDescription;
            return this;
        }

        public final String getNsInstanceName() {
            return nsInstanceName;
        }

        public final void setNsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
        }

        @Override
        public final Builder nsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
            return this;
        }

        public final String getNsState() {
            return nsState;
        }

        public final void setNsState(String nsState) {
            this.nsState = nsState;
        }

        @Override
        public final Builder nsState(String nsState) {
            this.nsState = nsState;
            return this;
        }

        @Override
        public final Builder nsState(NsState nsState) {
            this.nsState(nsState == null ? null : nsState.toString());
            return this;
        }

        public final String getNsdId() {
            return nsdId;
        }

        public final void setNsdId(String nsdId) {
            this.nsdId = nsdId;
        }

        @Override
        public final Builder nsdId(String nsdId) {
            this.nsdId = nsdId;
            return this;
        }

        public final String getNsdInfoId() {
            return nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        @Override
        public ListSolNetworkInstanceInfo build() {
            return new ListSolNetworkInstanceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
