/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolFunctionInstancesResponse extends TnbResponse implements
        ToCopyableBuilder<ListSolFunctionInstancesResponse.Builder, ListSolFunctionInstancesResponse> {
    private static final SdkField<List<ListSolFunctionInstanceInfo>> FUNCTION_INSTANCES_FIELD = SdkField
            .<List<ListSolFunctionInstanceInfo>> builder(MarshallingType.LIST)
            .memberName("functionInstances")
            .getter(getter(ListSolFunctionInstancesResponse::functionInstances))
            .setter(setter(Builder::functionInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListSolFunctionInstanceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListSolFunctionInstanceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSolFunctionInstancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_INSTANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ListSolFunctionInstanceInfo> functionInstances;

    private final String nextToken;

    private ListSolFunctionInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.functionInstances = builder.functionInstances;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionInstances property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFunctionInstances() {
        return functionInstances != null && !(functionInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Network function instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionInstances} method.
     * </p>
     * 
     * @return Network function instances.
     */
    public final List<ListSolFunctionInstanceInfo> functionInstances() {
        return functionInstances;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionInstances() ? functionInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolFunctionInstancesResponse)) {
            return false;
        }
        ListSolFunctionInstancesResponse other = (ListSolFunctionInstancesResponse) obj;
        return hasFunctionInstances() == other.hasFunctionInstances()
                && Objects.equals(functionInstances(), other.functionInstances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolFunctionInstancesResponse")
                .add("FunctionInstances", hasFunctionInstances() ? functionInstances() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionInstances":
            return Optional.ofNullable(clazz.cast(functionInstances()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolFunctionInstancesResponse, T> g) {
        return obj -> g.apply((ListSolFunctionInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSolFunctionInstancesResponse> {
        /**
         * <p>
         * Network function instances.
         * </p>
         * 
         * @param functionInstances
         *        Network function instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionInstances(Collection<ListSolFunctionInstanceInfo> functionInstances);

        /**
         * <p>
         * Network function instances.
         * </p>
         * 
         * @param functionInstances
         *        Network function instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionInstances(ListSolFunctionInstanceInfo... functionInstances);

        /**
         * <p>
         * Network function instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.tnb.model.ListSolFunctionInstanceInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.tnb.model.ListSolFunctionInstanceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.tnb.model.ListSolFunctionInstanceInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #functionInstances(List<ListSolFunctionInstanceInfo>)}.
         * 
         * @param functionInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.tnb.model.ListSolFunctionInstanceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionInstances(java.util.Collection<ListSolFunctionInstanceInfo>)
         */
        Builder functionInstances(Consumer<ListSolFunctionInstanceInfo.Builder>... functionInstances);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private List<ListSolFunctionInstanceInfo> functionInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolFunctionInstancesResponse model) {
            super(model);
            functionInstances(model.functionInstances);
            nextToken(model.nextToken);
        }

        public final List<ListSolFunctionInstanceInfo.Builder> getFunctionInstances() {
            List<ListSolFunctionInstanceInfo.Builder> result = ListSolFunctionInstanceResourcesCopier
                    .copyToBuilder(this.functionInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionInstances(Collection<ListSolFunctionInstanceInfo.BuilderImpl> functionInstances) {
            this.functionInstances = ListSolFunctionInstanceResourcesCopier.copyFromBuilder(functionInstances);
        }

        @Override
        public final Builder functionInstances(Collection<ListSolFunctionInstanceInfo> functionInstances) {
            this.functionInstances = ListSolFunctionInstanceResourcesCopier.copy(functionInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionInstances(ListSolFunctionInstanceInfo... functionInstances) {
            functionInstances(Arrays.asList(functionInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionInstances(Consumer<ListSolFunctionInstanceInfo.Builder>... functionInstances) {
            functionInstances(Stream.of(functionInstances)
                    .map(c -> ListSolFunctionInstanceInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSolFunctionInstancesResponse build() {
            return new ListSolFunctionInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
