/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information parameters for a network operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolNetworkOperationsInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ListSolNetworkOperationsInfo.Builder, ListSolNetworkOperationsInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ListSolNetworkOperationsInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<ProblemDetails> ERROR_FIELD = SdkField.<ProblemDetails> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(ListSolNetworkOperationsInfo::error)).setter(setter(Builder::error))
            .constructor(ProblemDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ListSolNetworkOperationsInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> LCM_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lcmOperationType").getter(getter(ListSolNetworkOperationsInfo::lcmOperationTypeAsString))
            .setter(setter(Builder::lcmOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lcmOperationType").build()).build();

    private static final SdkField<ListSolNetworkOperationsMetadata> METADATA_FIELD = SdkField
            .<ListSolNetworkOperationsMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(ListSolNetworkOperationsInfo::metadata)).setter(setter(Builder::metadata))
            .constructor(ListSolNetworkOperationsMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceId").getter(getter(ListSolNetworkOperationsInfo::nsInstanceId))
            .setter(setter(Builder::nsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceId").build()).build();

    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationState").getter(getter(ListSolNetworkOperationsInfo::operationStateAsString))
            .setter(setter(Builder::operationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ERROR_FIELD,
            ID_FIELD, LCM_OPERATION_TYPE_FIELD, METADATA_FIELD, NS_INSTANCE_ID_FIELD, OPERATION_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final ProblemDetails error;

    private final String id;

    private final String lcmOperationType;

    private final ListSolNetworkOperationsMetadata metadata;

    private final String nsInstanceId;

    private final String operationState;

    private ListSolNetworkOperationsInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.error = builder.error;
        this.id = builder.id;
        this.lcmOperationType = builder.lcmOperationType;
        this.metadata = builder.metadata;
        this.nsInstanceId = builder.nsInstanceId;
        this.operationState = builder.operationState;
    }

    /**
     * <p>
     * Network operation ARN.
     * </p>
     * 
     * @return Network operation ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Error related to this specific network operation.
     * </p>
     * 
     * @return Error related to this specific network operation.
     */
    public final ProblemDetails error() {
        return error;
    }

    /**
     * <p>
     * ID of this network operation.
     * </p>
     * 
     * @return ID of this network operation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Type of lifecycle management network operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lcmOperationType}
     * will return {@link LcmOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lcmOperationTypeAsString}.
     * </p>
     * 
     * @return Type of lifecycle management network operation.
     * @see LcmOperationType
     */
    public final LcmOperationType lcmOperationType() {
        return LcmOperationType.fromValue(lcmOperationType);
    }

    /**
     * <p>
     * Type of lifecycle management network operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lcmOperationType}
     * will return {@link LcmOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lcmOperationTypeAsString}.
     * </p>
     * 
     * @return Type of lifecycle management network operation.
     * @see LcmOperationType
     */
    public final String lcmOperationTypeAsString() {
        return lcmOperationType;
    }

    /**
     * <p>
     * Metadata related to this network operation.
     * </p>
     * 
     * @return Metadata related to this network operation.
     */
    public final ListSolNetworkOperationsMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * ID of the network instance related to this operation.
     * </p>
     * 
     * @return ID of the network instance related to this operation.
     */
    public final String nsInstanceId() {
        return nsInstanceId;
    }

    /**
     * <p>
     * The state of the network operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationState}
     * will return {@link NsLcmOperationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationStateAsString}.
     * </p>
     * 
     * @return The state of the network operation.
     * @see NsLcmOperationState
     */
    public final NsLcmOperationState operationState() {
        return NsLcmOperationState.fromValue(operationState);
    }

    /**
     * <p>
     * The state of the network operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationState}
     * will return {@link NsLcmOperationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationStateAsString}.
     * </p>
     * 
     * @return The state of the network operation.
     * @see NsLcmOperationState
     */
    public final String operationStateAsString() {
        return operationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lcmOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(operationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkOperationsInfo)) {
            return false;
        }
        ListSolNetworkOperationsInfo other = (ListSolNetworkOperationsInfo) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(error(), other.error()) && Objects.equals(id(), other.id())
                && Objects.equals(lcmOperationTypeAsString(), other.lcmOperationTypeAsString())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(nsInstanceId(), other.nsInstanceId())
                && Objects.equals(operationStateAsString(), other.operationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolNetworkOperationsInfo").add("Arn", arn()).add("Error", error()).add("Id", id())
                .add("LcmOperationType", lcmOperationTypeAsString()).add("Metadata", metadata())
                .add("NsInstanceId", nsInstanceId()).add("OperationState", operationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lcmOperationType":
            return Optional.ofNullable(clazz.cast(lcmOperationTypeAsString()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsInstanceId":
            return Optional.ofNullable(clazz.cast(nsInstanceId()));
        case "operationState":
            return Optional.ofNullable(clazz.cast(operationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkOperationsInfo, T> g) {
        return obj -> g.apply((ListSolNetworkOperationsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListSolNetworkOperationsInfo> {
        /**
         * <p>
         * Network operation ARN.
         * </p>
         * 
         * @param arn
         *        Network operation ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Error related to this specific network operation.
         * </p>
         * 
         * @param error
         *        Error related to this specific network operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ProblemDetails error);

        /**
         * <p>
         * Error related to this specific network operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProblemDetails.Builder} avoiding the need
         * to create one manually via {@link ProblemDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProblemDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ProblemDetails)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ProblemDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ProblemDetails)
         */
        default Builder error(Consumer<ProblemDetails.Builder> error) {
            return error(ProblemDetails.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * ID of this network operation.
         * </p>
         * 
         * @param id
         *        ID of this network operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Type of lifecycle management network operation.
         * </p>
         * 
         * @param lcmOperationType
         *        Type of lifecycle management network operation.
         * @see LcmOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LcmOperationType
         */
        Builder lcmOperationType(String lcmOperationType);

        /**
         * <p>
         * Type of lifecycle management network operation.
         * </p>
         * 
         * @param lcmOperationType
         *        Type of lifecycle management network operation.
         * @see LcmOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LcmOperationType
         */
        Builder lcmOperationType(LcmOperationType lcmOperationType);

        /**
         * <p>
         * Metadata related to this network operation.
         * </p>
         * 
         * @param metadata
         *        Metadata related to this network operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ListSolNetworkOperationsMetadata metadata);

        /**
         * <p>
         * Metadata related to this network operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListSolNetworkOperationsMetadata.Builder}
         * avoiding the need to create one manually via {@link ListSolNetworkOperationsMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListSolNetworkOperationsMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(ListSolNetworkOperationsMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ListSolNetworkOperationsMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ListSolNetworkOperationsMetadata)
         */
        default Builder metadata(Consumer<ListSolNetworkOperationsMetadata.Builder> metadata) {
            return metadata(ListSolNetworkOperationsMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * ID of the network instance related to this operation.
         * </p>
         * 
         * @param nsInstanceId
         *        ID of the network instance related to this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceId(String nsInstanceId);

        /**
         * <p>
         * The state of the network operation.
         * </p>
         * 
         * @param operationState
         *        The state of the network operation.
         * @see NsLcmOperationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsLcmOperationState
         */
        Builder operationState(String operationState);

        /**
         * <p>
         * The state of the network operation.
         * </p>
         * 
         * @param operationState
         *        The state of the network operation.
         * @see NsLcmOperationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsLcmOperationState
         */
        Builder operationState(NsLcmOperationState operationState);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private ProblemDetails error;

        private String id;

        private String lcmOperationType;

        private ListSolNetworkOperationsMetadata metadata;

        private String nsInstanceId;

        private String operationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkOperationsInfo model) {
            arn(model.arn);
            error(model.error);
            id(model.id);
            lcmOperationType(model.lcmOperationType);
            metadata(model.metadata);
            nsInstanceId(model.nsInstanceId);
            operationState(model.operationState);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ProblemDetails.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ProblemDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ProblemDetails error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLcmOperationType() {
            return lcmOperationType;
        }

        public final void setLcmOperationType(String lcmOperationType) {
            this.lcmOperationType = lcmOperationType;
        }

        @Override
        public final Builder lcmOperationType(String lcmOperationType) {
            this.lcmOperationType = lcmOperationType;
            return this;
        }

        @Override
        public final Builder lcmOperationType(LcmOperationType lcmOperationType) {
            this.lcmOperationType(lcmOperationType == null ? null : lcmOperationType.toString());
            return this;
        }

        public final ListSolNetworkOperationsMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ListSolNetworkOperationsMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ListSolNetworkOperationsMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceId() {
            return nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final String getOperationState() {
            return operationState;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        @Override
        public final Builder operationState(NsLcmOperationState operationState) {
            this.operationState(operationState == null ? null : operationState.toString());
            return this;
        }

        @Override
        public ListSolNetworkOperationsInfo build() {
            return new ListSolNetworkOperationsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
