/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.tnb.model.OperationalState;
import software.amazon.awssdk.services.tnb.model.TnbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSolFunctionPackageRequest
extends TnbRequest
implements ToCopyableBuilder<Builder, UpdateSolFunctionPackageRequest> {
    private static final SdkField<String> OPERATIONAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationalState").getter(UpdateSolFunctionPackageRequest.getter(UpdateSolFunctionPackageRequest::operationalStateAsString)).setter(UpdateSolFunctionPackageRequest.setter(Builder::operationalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationalState").build()}).build();
    private static final SdkField<String> VNF_PKG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfPkgId").getter(UpdateSolFunctionPackageRequest.getter(UpdateSolFunctionPackageRequest::vnfPkgId)).setter(UpdateSolFunctionPackageRequest.setter(Builder::vnfPkgId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vnfPkgId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONAL_STATE_FIELD, VNF_PKG_ID_FIELD));
    private final String operationalState;
    private final String vnfPkgId;

    private UpdateSolFunctionPackageRequest(BuilderImpl builder) {
        super(builder);
        this.operationalState = builder.operationalState;
        this.vnfPkgId = builder.vnfPkgId;
    }

    public final OperationalState operationalState() {
        return OperationalState.fromValue(this.operationalState);
    }

    public final String operationalStateAsString() {
        return this.operationalState;
    }

    public final String vnfPkgId() {
        return this.vnfPkgId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.operationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfPkgId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSolFunctionPackageRequest)) {
            return false;
        }
        UpdateSolFunctionPackageRequest other = (UpdateSolFunctionPackageRequest)((Object)obj);
        return Objects.equals(this.operationalStateAsString(), other.operationalStateAsString()) && Objects.equals(this.vnfPkgId(), other.vnfPkgId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSolFunctionPackageRequest").add("OperationalState", (Object)this.operationalStateAsString()).add("VnfPkgId", (Object)this.vnfPkgId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operationalState": {
                return Optional.ofNullable(clazz.cast(this.operationalStateAsString()));
            }
            case "vnfPkgId": {
                return Optional.ofNullable(clazz.cast(this.vnfPkgId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSolFunctionPackageRequest, T> g) {
        return obj -> g.apply((UpdateSolFunctionPackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbRequest.BuilderImpl
    implements Builder {
        private String operationalState;
        private String vnfPkgId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSolFunctionPackageRequest model) {
            super(model);
            this.operationalState(model.operationalState);
            this.vnfPkgId(model.vnfPkgId);
        }

        public final String getOperationalState() {
            return this.operationalState;
        }

        public final void setOperationalState(String operationalState) {
            this.operationalState = operationalState;
        }

        @Override
        public final Builder operationalState(String operationalState) {
            this.operationalState = operationalState;
            return this;
        }

        @Override
        public final Builder operationalState(OperationalState operationalState) {
            this.operationalState(operationalState == null ? null : operationalState.toString());
            return this;
        }

        public final String getVnfPkgId() {
            return this.vnfPkgId;
        }

        public final void setVnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
        }

        @Override
        public final Builder vnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSolFunctionPackageRequest build() {
            return new UpdateSolFunctionPackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSolFunctionPackageRequest> {
        public Builder operationalState(String var1);

        public Builder operationalState(OperationalState var1);

        public Builder vnfPkgId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

