/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolNetworkPackageDescriptorResponse extends TnbResponse implements
        ToCopyableBuilder<GetSolNetworkPackageDescriptorResponse.Builder, GetSolNetworkPackageDescriptorResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(GetSolNetworkPackageDescriptorResponse::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<SdkBytes> NSD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("nsd")
            .getter(getter(GetSolNetworkPackageDescriptorResponse::nsd))
            .setter(setter(Builder::nsd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsd").build(), PayloadTrait.create())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, NSD_FIELD));

    private final String contentType;

    private final SdkBytes nsd;

    private GetSolNetworkPackageDescriptorResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.nsd = builder.nsd;
    }

    /**
     * <p>
     * Indicates the media type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link DescriptorContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Indicates the media type of the resource.
     * @see DescriptorContentType
     */
    public final DescriptorContentType contentType() {
        return DescriptorContentType.fromValue(contentType);
    }

    /**
     * <p>
     * Indicates the media type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link DescriptorContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Indicates the media type of the resource.
     * @see DescriptorContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * Contents of the network service descriptor in the network package.
     * </p>
     * 
     * @return Contents of the network service descriptor in the network package.
     */
    public final SdkBytes nsd() {
        return nsd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsd());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkPackageDescriptorResponse)) {
            return false;
        }
        GetSolNetworkPackageDescriptorResponse other = (GetSolNetworkPackageDescriptorResponse) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(nsd(), other.nsd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolNetworkPackageDescriptorResponse").add("ContentType", contentTypeAsString())
                .add("Nsd", nsd()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "nsd":
            return Optional.ofNullable(clazz.cast(nsd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkPackageDescriptorResponse, T> g) {
        return obj -> g.apply((GetSolNetworkPackageDescriptorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSolNetworkPackageDescriptorResponse> {
        /**
         * <p>
         * Indicates the media type of the resource.
         * </p>
         * 
         * @param contentType
         *        Indicates the media type of the resource.
         * @see DescriptorContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescriptorContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Indicates the media type of the resource.
         * </p>
         * 
         * @param contentType
         *        Indicates the media type of the resource.
         * @see DescriptorContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescriptorContentType
         */
        Builder contentType(DescriptorContentType contentType);

        /**
         * <p>
         * Contents of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsd
         *        Contents of the network service descriptor in the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsd(SdkBytes nsd);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String contentType;

        private SdkBytes nsd;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkPackageDescriptorResponse model) {
            super(model);
            contentType(model.contentType);
            nsd(model.nsd);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(DescriptorContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ByteBuffer getNsd() {
            return nsd == null ? null : nsd.asByteBuffer();
        }

        public final void setNsd(ByteBuffer nsd) {
            nsd(nsd == null ? null : SdkBytes.fromByteBuffer(nsd));
        }

        @Override
        public final Builder nsd(SdkBytes nsd) {
            this.nsd = nsd;
            return this;
        }

        @Override
        public GetSolNetworkPackageDescriptorResponse build() {
            return new GetSolNetworkPackageDescriptorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
