/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSolNetworkPackageContentResponse extends TnbResponse implements
        ToCopyableBuilder<PutSolNetworkPackageContentResponse.Builder, PutSolNetworkPackageContentResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(PutSolNetworkPackageContentResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PutSolNetworkPackageContentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<PutSolNetworkPackageContentMetadata> METADATA_FIELD = SdkField
            .<PutSolNetworkPackageContentMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(PutSolNetworkPackageContentResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(PutSolNetworkPackageContentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NSD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nsdId")
            .getter(getter(PutSolNetworkPackageContentResponse::nsdId)).setter(setter(Builder::nsdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdId").build()).build();

    private static final SdkField<String> NSD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdName").getter(getter(PutSolNetworkPackageContentResponse::nsdName)).setter(setter(Builder::nsdName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdName").build()).build();

    private static final SdkField<String> NSD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdVersion").getter(getter(PutSolNetworkPackageContentResponse::nsdVersion))
            .setter(setter(Builder::nsdVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdVersion").build()).build();

    private static final SdkField<List<String>> VNF_PKG_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vnfPkgIds")
            .getter(getter(PutSolNetworkPackageContentResponse::vnfPkgIds))
            .setter(setter(Builder::vnfPkgIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            METADATA_FIELD, NSD_ID_FIELD, NSD_NAME_FIELD, NSD_VERSION_FIELD, VNF_PKG_IDS_FIELD));

    private final String arn;

    private final String id;

    private final PutSolNetworkPackageContentMetadata metadata;

    private final String nsdId;

    private final String nsdName;

    private final String nsdVersion;

    private final List<String> vnfPkgIds;

    private PutSolNetworkPackageContentResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.nsdId = builder.nsdId;
        this.nsdName = builder.nsdName;
        this.nsdVersion = builder.nsdVersion;
        this.vnfPkgIds = builder.vnfPkgIds;
    }

    /**
     * <p>
     * Network package ARN.
     * </p>
     * 
     * @return Network package ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Network package ID.
     * </p>
     * 
     * @return Network package ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Network package metadata.
     * </p>
     * 
     * @return Network package metadata.
     */
    public final PutSolNetworkPackageContentMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Network service descriptor ID.
     * </p>
     * 
     * @return Network service descriptor ID.
     */
    public final String nsdId() {
        return nsdId;
    }

    /**
     * <p>
     * Network service descriptor name.
     * </p>
     * 
     * @return Network service descriptor name.
     */
    public final String nsdName() {
        return nsdName;
    }

    /**
     * <p>
     * Network service descriptor version.
     * </p>
     * 
     * @return Network service descriptor version.
     */
    public final String nsdVersion() {
        return nsdVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the VnfPkgIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVnfPkgIds() {
        return vnfPkgIds != null && !(vnfPkgIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Function package IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVnfPkgIds} method.
     * </p>
     * 
     * @return Function package IDs.
     */
    public final List<String> vnfPkgIds() {
        return vnfPkgIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsdId());
        hashCode = 31 * hashCode + Objects.hashCode(nsdName());
        hashCode = 31 * hashCode + Objects.hashCode(nsdVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasVnfPkgIds() ? vnfPkgIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSolNetworkPackageContentResponse)) {
            return false;
        }
        PutSolNetworkPackageContentResponse other = (PutSolNetworkPackageContentResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(nsdId(), other.nsdId())
                && Objects.equals(nsdName(), other.nsdName()) && Objects.equals(nsdVersion(), other.nsdVersion())
                && hasVnfPkgIds() == other.hasVnfPkgIds() && Objects.equals(vnfPkgIds(), other.vnfPkgIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSolNetworkPackageContentResponse").add("Arn", arn()).add("Id", id())
                .add("Metadata", metadata()).add("NsdId", nsdId()).add("NsdName", nsdName()).add("NsdVersion", nsdVersion())
                .add("VnfPkgIds", hasVnfPkgIds() ? vnfPkgIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsdId":
            return Optional.ofNullable(clazz.cast(nsdId()));
        case "nsdName":
            return Optional.ofNullable(clazz.cast(nsdName()));
        case "nsdVersion":
            return Optional.ofNullable(clazz.cast(nsdVersion()));
        case "vnfPkgIds":
            return Optional.ofNullable(clazz.cast(vnfPkgIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSolNetworkPackageContentResponse, T> g) {
        return obj -> g.apply((PutSolNetworkPackageContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSolNetworkPackageContentResponse> {
        /**
         * <p>
         * Network package ARN.
         * </p>
         * 
         * @param arn
         *        Network package ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Network package ID.
         * </p>
         * 
         * @param id
         *        Network package ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Network package metadata.
         * </p>
         * 
         * @param metadata
         *        Network package metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(PutSolNetworkPackageContentMetadata metadata);

        /**
         * <p>
         * Network package metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PutSolNetworkPackageContentMetadata.Builder} avoiding the need to create one manually via
         * {@link PutSolNetworkPackageContentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PutSolNetworkPackageContentMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(PutSolNetworkPackageContentMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link PutSolNetworkPackageContentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(PutSolNetworkPackageContentMetadata)
         */
        default Builder metadata(Consumer<PutSolNetworkPackageContentMetadata.Builder> metadata) {
            return metadata(PutSolNetworkPackageContentMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Network service descriptor ID.
         * </p>
         * 
         * @param nsdId
         *        Network service descriptor ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdId(String nsdId);

        /**
         * <p>
         * Network service descriptor name.
         * </p>
         * 
         * @param nsdName
         *        Network service descriptor name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdName(String nsdName);

        /**
         * <p>
         * Network service descriptor version.
         * </p>
         * 
         * @param nsdVersion
         *        Network service descriptor version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdVersion(String nsdVersion);

        /**
         * <p>
         * Function package IDs.
         * </p>
         * 
         * @param vnfPkgIds
         *        Function package IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgIds(Collection<String> vnfPkgIds);

        /**
         * <p>
         * Function package IDs.
         * </p>
         * 
         * @param vnfPkgIds
         *        Function package IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgIds(String... vnfPkgIds);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private PutSolNetworkPackageContentMetadata metadata;

        private String nsdId;

        private String nsdName;

        private String nsdVersion;

        private List<String> vnfPkgIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSolNetworkPackageContentResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            metadata(model.metadata);
            nsdId(model.nsdId);
            nsdName(model.nsdName);
            nsdVersion(model.nsdVersion);
            vnfPkgIds(model.vnfPkgIds);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final PutSolNetworkPackageContentMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(PutSolNetworkPackageContentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(PutSolNetworkPackageContentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsdId() {
            return nsdId;
        }

        public final void setNsdId(String nsdId) {
            this.nsdId = nsdId;
        }

        @Override
        public final Builder nsdId(String nsdId) {
            this.nsdId = nsdId;
            return this;
        }

        public final String getNsdName() {
            return nsdName;
        }

        public final void setNsdName(String nsdName) {
            this.nsdName = nsdName;
        }

        @Override
        public final Builder nsdName(String nsdName) {
            this.nsdName = nsdName;
            return this;
        }

        public final String getNsdVersion() {
            return nsdVersion;
        }

        public final void setNsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
        }

        @Override
        public final Builder nsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
            return this;
        }

        public final Collection<String> getVnfPkgIds() {
            if (vnfPkgIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vnfPkgIds;
        }

        public final void setVnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
        }

        @Override
        public final Builder vnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vnfPkgIds(String... vnfPkgIds) {
            vnfPkgIds(Arrays.asList(vnfPkgIds));
            return this;
        }

        @Override
        public PutSolNetworkPackageContentResponse build() {
            return new PutSolNetworkPackageContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
