/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data model for a batch load task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataModel implements SdkPojo, Serializable, ToCopyableBuilder<DataModel.Builder, DataModel> {
    private static final SdkField<String> TIME_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeColumn").getter(getter(DataModel::timeColumn)).setter(setter(Builder::timeColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeColumn").build()).build();

    private static final SdkField<String> TIME_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeUnit").getter(getter(DataModel::timeUnitAsString)).setter(setter(Builder::timeUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeUnit").build()).build();

    private static final SdkField<List<DimensionMapping>> DIMENSION_MAPPINGS_FIELD = SdkField
            .<List<DimensionMapping>> builder(MarshallingType.LIST)
            .memberName("DimensionMappings")
            .getter(getter(DataModel::dimensionMappings))
            .setter(setter(Builder::dimensionMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MultiMeasureMappings> MULTI_MEASURE_MAPPINGS_FIELD = SdkField
            .<MultiMeasureMappings> builder(MarshallingType.SDK_POJO).memberName("MultiMeasureMappings")
            .getter(getter(DataModel::multiMeasureMappings)).setter(setter(Builder::multiMeasureMappings))
            .constructor(MultiMeasureMappings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureMappings").build())
            .build();

    private static final SdkField<List<MixedMeasureMapping>> MIXED_MEASURE_MAPPINGS_FIELD = SdkField
            .<List<MixedMeasureMapping>> builder(MarshallingType.LIST)
            .memberName("MixedMeasureMappings")
            .getter(getter(DataModel::mixedMeasureMappings))
            .setter(setter(Builder::mixedMeasureMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedMeasureMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MixedMeasureMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(MixedMeasureMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MEASURE_NAME_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureNameColumn").getter(getter(DataModel::measureNameColumn))
            .setter(setter(Builder::measureNameColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureNameColumn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_COLUMN_FIELD,
            TIME_UNIT_FIELD, DIMENSION_MAPPINGS_FIELD, MULTI_MEASURE_MAPPINGS_FIELD, MIXED_MEASURE_MAPPINGS_FIELD,
            MEASURE_NAME_COLUMN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeColumn;

    private final String timeUnit;

    private final List<DimensionMapping> dimensionMappings;

    private final MultiMeasureMappings multiMeasureMappings;

    private final List<MixedMeasureMapping> mixedMeasureMappings;

    private final String measureNameColumn;

    private DataModel(BuilderImpl builder) {
        this.timeColumn = builder.timeColumn;
        this.timeUnit = builder.timeUnit;
        this.dimensionMappings = builder.dimensionMappings;
        this.multiMeasureMappings = builder.multiMeasureMappings;
        this.mixedMeasureMappings = builder.mixedMeasureMappings;
        this.measureNameColumn = builder.measureNameColumn;
    }

    /**
     * <p>
     * Source column to be mapped to time.
     * </p>
     * 
     * @return Source column to be mapped to time.
     */
    public final String timeColumn() {
        return timeColumn;
    }

    /**
     * <p>
     * The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds, nanoseconds,
     * or other supported values. Default is <code>MILLISECONDS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeUnit} will
     * return {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeUnitAsString}.
     * </p>
     * 
     * @return The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds,
     *         nanoseconds, or other supported values. Default is <code>MILLISECONDS</code>.
     * @see TimeUnit
     */
    public final TimeUnit timeUnit() {
        return TimeUnit.fromValue(timeUnit);
    }

    /**
     * <p>
     * The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds, nanoseconds,
     * or other supported values. Default is <code>MILLISECONDS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeUnit} will
     * return {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeUnitAsString}.
     * </p>
     * 
     * @return The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds,
     *         nanoseconds, or other supported values. Default is <code>MILLISECONDS</code>.
     * @see TimeUnit
     */
    public final String timeUnitAsString() {
        return timeUnit;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionMappings() {
        return dimensionMappings != null && !(dimensionMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Source to target mappings for dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionMappings} method.
     * </p>
     * 
     * @return Source to target mappings for dimensions.
     */
    public final List<DimensionMapping> dimensionMappings() {
        return dimensionMappings;
    }

    /**
     * <p>
     * Source to target mappings for multi-measure records.
     * </p>
     * 
     * @return Source to target mappings for multi-measure records.
     */
    public final MultiMeasureMappings multiMeasureMappings() {
        return multiMeasureMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the MixedMeasureMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMixedMeasureMappings() {
        return mixedMeasureMappings != null && !(mixedMeasureMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Source to target mappings for measures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMixedMeasureMappings} method.
     * </p>
     * 
     * @return Source to target mappings for measures.
     */
    public final List<MixedMeasureMapping> mixedMeasureMappings() {
        return mixedMeasureMappings;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String measureNameColumn() {
        return measureNameColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeColumn());
        hashCode = 31 * hashCode + Objects.hashCode(timeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionMappings() ? dimensionMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiMeasureMappings());
        hashCode = 31 * hashCode + Objects.hashCode(hasMixedMeasureMappings() ? mixedMeasureMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(measureNameColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataModel)) {
            return false;
        }
        DataModel other = (DataModel) obj;
        return Objects.equals(timeColumn(), other.timeColumn()) && Objects.equals(timeUnitAsString(), other.timeUnitAsString())
                && hasDimensionMappings() == other.hasDimensionMappings()
                && Objects.equals(dimensionMappings(), other.dimensionMappings())
                && Objects.equals(multiMeasureMappings(), other.multiMeasureMappings())
                && hasMixedMeasureMappings() == other.hasMixedMeasureMappings()
                && Objects.equals(mixedMeasureMappings(), other.mixedMeasureMappings())
                && Objects.equals(measureNameColumn(), other.measureNameColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataModel").add("TimeColumn", timeColumn()).add("TimeUnit", timeUnitAsString())
                .add("DimensionMappings", hasDimensionMappings() ? dimensionMappings() : null)
                .add("MultiMeasureMappings", multiMeasureMappings())
                .add("MixedMeasureMappings", hasMixedMeasureMappings() ? mixedMeasureMappings() : null)
                .add("MeasureNameColumn", measureNameColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeColumn":
            return Optional.ofNullable(clazz.cast(timeColumn()));
        case "TimeUnit":
            return Optional.ofNullable(clazz.cast(timeUnitAsString()));
        case "DimensionMappings":
            return Optional.ofNullable(clazz.cast(dimensionMappings()));
        case "MultiMeasureMappings":
            return Optional.ofNullable(clazz.cast(multiMeasureMappings()));
        case "MixedMeasureMappings":
            return Optional.ofNullable(clazz.cast(mixedMeasureMappings()));
        case "MeasureNameColumn":
            return Optional.ofNullable(clazz.cast(measureNameColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataModel, T> g) {
        return obj -> g.apply((DataModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataModel> {
        /**
         * <p>
         * Source column to be mapped to time.
         * </p>
         * 
         * @param timeColumn
         *        Source column to be mapped to time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeColumn(String timeColumn);

        /**
         * <p>
         * The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds,
         * nanoseconds, or other supported values. Default is <code>MILLISECONDS</code>.
         * </p>
         * 
         * @param timeUnit
         *        The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds,
         *        nanoseconds, or other supported values. Default is <code>MILLISECONDS</code>.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(String timeUnit);

        /**
         * <p>
         * The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds,
         * nanoseconds, or other supported values. Default is <code>MILLISECONDS</code>.
         * </p>
         * 
         * @param timeUnit
         *        The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds,
         *        nanoseconds, or other supported values. Default is <code>MILLISECONDS</code>.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(TimeUnit timeUnit);

        /**
         * <p>
         * Source to target mappings for dimensions.
         * </p>
         * 
         * @param dimensionMappings
         *        Source to target mappings for dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionMappings(Collection<DimensionMapping> dimensionMappings);

        /**
         * <p>
         * Source to target mappings for dimensions.
         * </p>
         * 
         * @param dimensionMappings
         *        Source to target mappings for dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionMappings(DimensionMapping... dimensionMappings);

        /**
         * <p>
         * Source to target mappings for dimensions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #dimensionMappings(List<DimensionMapping>)}.
         * 
         * @param dimensionMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionMappings(java.util.Collection<DimensionMapping>)
         */
        Builder dimensionMappings(Consumer<DimensionMapping.Builder>... dimensionMappings);

        /**
         * <p>
         * Source to target mappings for multi-measure records.
         * </p>
         * 
         * @param multiMeasureMappings
         *        Source to target mappings for multi-measure records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureMappings(MultiMeasureMappings multiMeasureMappings);

        /**
         * <p>
         * Source to target mappings for multi-measure records.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultiMeasureMappings.Builder} avoiding
         * the need to create one manually via {@link MultiMeasureMappings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiMeasureMappings.Builder#build()} is called immediately and
         * its result is passed to {@link #multiMeasureMappings(MultiMeasureMappings)}.
         * 
         * @param multiMeasureMappings
         *        a consumer that will call methods on {@link MultiMeasureMappings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiMeasureMappings(MultiMeasureMappings)
         */
        default Builder multiMeasureMappings(Consumer<MultiMeasureMappings.Builder> multiMeasureMappings) {
            return multiMeasureMappings(MultiMeasureMappings.builder().applyMutation(multiMeasureMappings).build());
        }

        /**
         * <p>
         * Source to target mappings for measures.
         * </p>
         * 
         * @param mixedMeasureMappings
         *        Source to target mappings for measures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedMeasureMappings(Collection<MixedMeasureMapping> mixedMeasureMappings);

        /**
         * <p>
         * Source to target mappings for measures.
         * </p>
         * 
         * @param mixedMeasureMappings
         *        Source to target mappings for measures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedMeasureMappings(MixedMeasureMapping... mixedMeasureMappings);

        /**
         * <p>
         * Source to target mappings for measures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamwrite.model.MixedMeasureMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.timestreamwrite.model.MixedMeasureMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamwrite.model.MixedMeasureMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #mixedMeasureMappings(List<MixedMeasureMapping>)}.
         * 
         * @param mixedMeasureMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamwrite.model.MixedMeasureMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedMeasureMappings(java.util.Collection<MixedMeasureMapping>)
         */
        Builder mixedMeasureMappings(Consumer<MixedMeasureMapping.Builder>... mixedMeasureMappings);

        /**
         * <p/>
         * 
         * @param measureNameColumn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureNameColumn(String measureNameColumn);
    }

    static final class BuilderImpl implements Builder {
        private String timeColumn;

        private String timeUnit;

        private List<DimensionMapping> dimensionMappings = DefaultSdkAutoConstructList.getInstance();

        private MultiMeasureMappings multiMeasureMappings;

        private List<MixedMeasureMapping> mixedMeasureMappings = DefaultSdkAutoConstructList.getInstance();

        private String measureNameColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataModel model) {
            timeColumn(model.timeColumn);
            timeUnit(model.timeUnit);
            dimensionMappings(model.dimensionMappings);
            multiMeasureMappings(model.multiMeasureMappings);
            mixedMeasureMappings(model.mixedMeasureMappings);
            measureNameColumn(model.measureNameColumn);
        }

        public final String getTimeColumn() {
            return timeColumn;
        }

        public final void setTimeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
        }

        @Override
        public final Builder timeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
            return this;
        }

        public final String getTimeUnit() {
            return timeUnit;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit == null ? null : timeUnit.toString());
            return this;
        }

        public final List<DimensionMapping.Builder> getDimensionMappings() {
            List<DimensionMapping.Builder> result = DimensionMappingsCopier.copyToBuilder(this.dimensionMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionMappings(Collection<DimensionMapping.BuilderImpl> dimensionMappings) {
            this.dimensionMappings = DimensionMappingsCopier.copyFromBuilder(dimensionMappings);
        }

        @Override
        public final Builder dimensionMappings(Collection<DimensionMapping> dimensionMappings) {
            this.dimensionMappings = DimensionMappingsCopier.copy(dimensionMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionMappings(DimensionMapping... dimensionMappings) {
            dimensionMappings(Arrays.asList(dimensionMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionMappings(Consumer<DimensionMapping.Builder>... dimensionMappings) {
            dimensionMappings(Stream.of(dimensionMappings).map(c -> DimensionMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MultiMeasureMappings.Builder getMultiMeasureMappings() {
            return multiMeasureMappings != null ? multiMeasureMappings.toBuilder() : null;
        }

        public final void setMultiMeasureMappings(MultiMeasureMappings.BuilderImpl multiMeasureMappings) {
            this.multiMeasureMappings = multiMeasureMappings != null ? multiMeasureMappings.build() : null;
        }

        @Override
        public final Builder multiMeasureMappings(MultiMeasureMappings multiMeasureMappings) {
            this.multiMeasureMappings = multiMeasureMappings;
            return this;
        }

        public final List<MixedMeasureMapping.Builder> getMixedMeasureMappings() {
            List<MixedMeasureMapping.Builder> result = MixedMeasureMappingListCopier.copyToBuilder(this.mixedMeasureMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMixedMeasureMappings(Collection<MixedMeasureMapping.BuilderImpl> mixedMeasureMappings) {
            this.mixedMeasureMappings = MixedMeasureMappingListCopier.copyFromBuilder(mixedMeasureMappings);
        }

        @Override
        public final Builder mixedMeasureMappings(Collection<MixedMeasureMapping> mixedMeasureMappings) {
            this.mixedMeasureMappings = MixedMeasureMappingListCopier.copy(mixedMeasureMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedMeasureMappings(MixedMeasureMapping... mixedMeasureMappings) {
            mixedMeasureMappings(Arrays.asList(mixedMeasureMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedMeasureMappings(Consumer<MixedMeasureMapping.Builder>... mixedMeasureMappings) {
            mixedMeasureMappings(Stream.of(mixedMeasureMappings).map(c -> MixedMeasureMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMeasureNameColumn() {
            return measureNameColumn;
        }

        public final void setMeasureNameColumn(String measureNameColumn) {
            this.measureNameColumn = measureNameColumn;
        }

        @Override
        public final Builder measureNameColumn(String measureNameColumn) {
            this.measureNameColumn = measureNameColumn;
            return this;
        }

        @Override
        public DataModel build() {
            return new DataModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
