/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.internal.UserAgentUtils;
import software.amazon.awssdk.services.textract.model.AdapterOverview;
import software.amazon.awssdk.services.textract.model.ListAdaptersRequest;
import software.amazon.awssdk.services.textract.model.ListAdaptersResponse;

public class ListAdaptersIterable
implements SdkIterable<ListAdaptersResponse> {
    private final TextractClient client;
    private final ListAdaptersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAdaptersIterable(TextractClient client, ListAdaptersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAdaptersResponseFetcher();
    }

    public Iterator<ListAdaptersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AdapterOverview> adapters() {
        Function<ListAdaptersResponse, Iterator> getIterator = response -> {
            if (response != null && response.adapters() != null) {
                return response.adapters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAdaptersResponseFetcher
    implements SyncPageFetcher<ListAdaptersResponse> {
        private ListAdaptersResponseFetcher() {
        }

        public boolean hasNextPage(ListAdaptersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAdaptersResponse nextPage(ListAdaptersResponse previousPage) {
            if (previousPage == null) {
                return ListAdaptersIterable.this.client.listAdapters(ListAdaptersIterable.this.firstRequest);
            }
            return ListAdaptersIterable.this.client.listAdapters((ListAdaptersRequest)((Object)ListAdaptersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

