/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.Document;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectDocumentTextRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, DetectDocumentTextRequest> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Document").getter(DetectDocumentTextRequest.getter(DetectDocumentTextRequest::document)).setter(DetectDocumentTextRequest.setter(Builder::document)).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD));
    private final Document document;

    private DetectDocumentTextRequest(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
    }

    public final Document document() {
        return this.document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDocumentTextRequest)) {
            return false;
        }
        DetectDocumentTextRequest other = (DetectDocumentTextRequest)((Object)obj);
        return Objects.equals(this.document(), other.document());
    }

    public final String toString() {
        return ToString.builder((String)"DetectDocumentTextRequest").add("Document", (Object)this.document()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectDocumentTextRequest, T> g) {
        return obj -> g.apply((DetectDocumentTextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private Document document;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectDocumentTextRequest model) {
            super(model);
            this.document(model.document);
        }

        public final Document.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectDocumentTextRequest build() {
            return new DetectDocumentTextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectDocumentTextRequest> {
        public Builder document(Document var1);

        default public Builder document(Consumer<Document.Builder> document) {
            return this.document((Document)((Document.Builder)Document.builder().applyMutation(document)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

