/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information extracted by an analysis operation after using StartLendingAnalysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Extraction implements SdkPojo, Serializable, ToCopyableBuilder<Extraction.Builder, Extraction> {
    private static final SdkField<LendingDocument> LENDING_DOCUMENT_FIELD = SdkField
            .<LendingDocument> builder(MarshallingType.SDK_POJO).memberName("LendingDocument")
            .getter(getter(Extraction::lendingDocument)).setter(setter(Builder::lendingDocument))
            .constructor(LendingDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LendingDocument").build()).build();

    private static final SdkField<ExpenseDocument> EXPENSE_DOCUMENT_FIELD = SdkField
            .<ExpenseDocument> builder(MarshallingType.SDK_POJO).memberName("ExpenseDocument")
            .getter(getter(Extraction::expenseDocument)).setter(setter(Builder::expenseDocument))
            .constructor(ExpenseDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpenseDocument").build()).build();

    private static final SdkField<IdentityDocument> IDENTITY_DOCUMENT_FIELD = SdkField
            .<IdentityDocument> builder(MarshallingType.SDK_POJO).memberName("IdentityDocument")
            .getter(getter(Extraction::identityDocument)).setter(setter(Builder::identityDocument))
            .constructor(IdentityDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENDING_DOCUMENT_FIELD,
            EXPENSE_DOCUMENT_FIELD, IDENTITY_DOCUMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final LendingDocument lendingDocument;

    private final ExpenseDocument expenseDocument;

    private final IdentityDocument identityDocument;

    private Extraction(BuilderImpl builder) {
        this.lendingDocument = builder.lendingDocument;
        this.expenseDocument = builder.expenseDocument;
        this.identityDocument = builder.identityDocument;
    }

    /**
     * <p>
     * Holds the structured data returned by AnalyzeDocument for lending documents.
     * </p>
     * 
     * @return Holds the structured data returned by AnalyzeDocument for lending documents.
     */
    public final LendingDocument lendingDocument() {
        return lendingDocument;
    }

    /**
     * Returns the value of the ExpenseDocument property for this object.
     * 
     * @return The value of the ExpenseDocument property for this object.
     */
    public final ExpenseDocument expenseDocument() {
        return expenseDocument;
    }

    /**
     * Returns the value of the IdentityDocument property for this object.
     * 
     * @return The value of the IdentityDocument property for this object.
     */
    public final IdentityDocument identityDocument() {
        return identityDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lendingDocument());
        hashCode = 31 * hashCode + Objects.hashCode(expenseDocument());
        hashCode = 31 * hashCode + Objects.hashCode(identityDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Extraction)) {
            return false;
        }
        Extraction other = (Extraction) obj;
        return Objects.equals(lendingDocument(), other.lendingDocument())
                && Objects.equals(expenseDocument(), other.expenseDocument())
                && Objects.equals(identityDocument(), other.identityDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Extraction").add("LendingDocument", lendingDocument()).add("ExpenseDocument", expenseDocument())
                .add("IdentityDocument", identityDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LendingDocument":
            return Optional.ofNullable(clazz.cast(lendingDocument()));
        case "ExpenseDocument":
            return Optional.ofNullable(clazz.cast(expenseDocument()));
        case "IdentityDocument":
            return Optional.ofNullable(clazz.cast(identityDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Extraction, T> g) {
        return obj -> g.apply((Extraction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Extraction> {
        /**
         * <p>
         * Holds the structured data returned by AnalyzeDocument for lending documents.
         * </p>
         * 
         * @param lendingDocument
         *        Holds the structured data returned by AnalyzeDocument for lending documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lendingDocument(LendingDocument lendingDocument);

        /**
         * <p>
         * Holds the structured data returned by AnalyzeDocument for lending documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link LendingDocument.Builder} avoiding the
         * need to create one manually via {@link LendingDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LendingDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #lendingDocument(LendingDocument)}.
         * 
         * @param lendingDocument
         *        a consumer that will call methods on {@link LendingDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lendingDocument(LendingDocument)
         */
        default Builder lendingDocument(Consumer<LendingDocument.Builder> lendingDocument) {
            return lendingDocument(LendingDocument.builder().applyMutation(lendingDocument).build());
        }

        /**
         * Sets the value of the ExpenseDocument property for this object.
         *
         * @param expenseDocument
         *        The new value for the ExpenseDocument property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expenseDocument(ExpenseDocument expenseDocument);

        /**
         * Sets the value of the ExpenseDocument property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExpenseDocument.Builder} avoiding the
         * need to create one manually via {@link ExpenseDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpenseDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #expenseDocument(ExpenseDocument)}.
         * 
         * @param expenseDocument
         *        a consumer that will call methods on {@link ExpenseDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expenseDocument(ExpenseDocument)
         */
        default Builder expenseDocument(Consumer<ExpenseDocument.Builder> expenseDocument) {
            return expenseDocument(ExpenseDocument.builder().applyMutation(expenseDocument).build());
        }

        /**
         * Sets the value of the IdentityDocument property for this object.
         *
         * @param identityDocument
         *        The new value for the IdentityDocument property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityDocument(IdentityDocument identityDocument);

        /**
         * Sets the value of the IdentityDocument property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IdentityDocument.Builder} avoiding the
         * need to create one manually via {@link IdentityDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #identityDocument(IdentityDocument)}.
         * 
         * @param identityDocument
         *        a consumer that will call methods on {@link IdentityDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityDocument(IdentityDocument)
         */
        default Builder identityDocument(Consumer<IdentityDocument.Builder> identityDocument) {
            return identityDocument(IdentityDocument.builder().applyMutation(identityDocument).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LendingDocument lendingDocument;

        private ExpenseDocument expenseDocument;

        private IdentityDocument identityDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(Extraction model) {
            lendingDocument(model.lendingDocument);
            expenseDocument(model.expenseDocument);
            identityDocument(model.identityDocument);
        }

        public final LendingDocument.Builder getLendingDocument() {
            return lendingDocument != null ? lendingDocument.toBuilder() : null;
        }

        public final void setLendingDocument(LendingDocument.BuilderImpl lendingDocument) {
            this.lendingDocument = lendingDocument != null ? lendingDocument.build() : null;
        }

        @Override
        public final Builder lendingDocument(LendingDocument lendingDocument) {
            this.lendingDocument = lendingDocument;
            return this;
        }

        public final ExpenseDocument.Builder getExpenseDocument() {
            return expenseDocument != null ? expenseDocument.toBuilder() : null;
        }

        public final void setExpenseDocument(ExpenseDocument.BuilderImpl expenseDocument) {
            this.expenseDocument = expenseDocument != null ? expenseDocument.build() : null;
        }

        @Override
        public final Builder expenseDocument(ExpenseDocument expenseDocument) {
            this.expenseDocument = expenseDocument;
            return this;
        }

        public final IdentityDocument.Builder getIdentityDocument() {
            return identityDocument != null ? identityDocument.toBuilder() : null;
        }

        public final void setIdentityDocument(IdentityDocument.BuilderImpl identityDocument) {
            this.identityDocument = identityDocument != null ? identityDocument.build() : null;
        }

        @Override
        public final Builder identityDocument(IdentityDocument identityDocument) {
            this.identityDocument = identityDocument;
            return this;
        }

        @Override
        public Extraction build() {
            return new Extraction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
