/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.BlockType;
import software.amazon.awssdk.services.textract.model.EntityType;
import software.amazon.awssdk.services.textract.model.EntityTypesCopier;
import software.amazon.awssdk.services.textract.model.Geometry;
import software.amazon.awssdk.services.textract.model.Query;
import software.amazon.awssdk.services.textract.model.Relationship;
import software.amazon.awssdk.services.textract.model.RelationshipListCopier;
import software.amazon.awssdk.services.textract.model.SelectionStatus;
import software.amazon.awssdk.services.textract.model.TextType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Block
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Block> {
    private static final SdkField<String> BLOCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockType").getter(Block.getter(Block::blockTypeAsString)).setter(Block.setter(Builder::blockType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockType").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(Block.getter(Block::confidence)).setter(Block.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(Block.getter(Block::text)).setter(Block.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> TEXT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextType").getter(Block.getter(Block::textTypeAsString)).setter(Block.setter(Builder::textType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextType").build()}).build();
    private static final SdkField<Integer> ROW_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RowIndex").getter(Block.getter(Block::rowIndex)).setter(Block.setter(Builder::rowIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowIndex").build()}).build();
    private static final SdkField<Integer> COLUMN_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ColumnIndex").getter(Block.getter(Block::columnIndex)).setter(Block.setter(Builder::columnIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnIndex").build()}).build();
    private static final SdkField<Integer> ROW_SPAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RowSpan").getter(Block.getter(Block::rowSpan)).setter(Block.setter(Builder::rowSpan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSpan").build()}).build();
    private static final SdkField<Integer> COLUMN_SPAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ColumnSpan").getter(Block.getter(Block::columnSpan)).setter(Block.setter(Builder::columnSpan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSpan").build()}).build();
    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(Block.getter(Block::geometry)).setter(Block.setter(Builder::geometry)).constructor(Geometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Block.getter(Block::id)).setter(Block.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<Relationship>> RELATIONSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Relationships").getter(Block.getter(Block::relationships)).setter(Block.setter(Builder::relationships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relationships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Relationship::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityTypes").getter(Block.getter(Block::entityTypesAsStrings)).setter(Block.setter(Builder::entityTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SELECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionStatus").getter(Block.getter(Block::selectionStatusAsString)).setter(Block.setter(Builder::selectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionStatus").build()}).build();
    private static final SdkField<Integer> PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Page").getter(Block.getter(Block::page)).setter(Block.setter(Builder::page)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()}).build();
    private static final SdkField<Query> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Query").getter(Block.getter(Block::query)).setter(Block.setter(Builder::query)).constructor(Query::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_TYPE_FIELD, CONFIDENCE_FIELD, TEXT_FIELD, TEXT_TYPE_FIELD, ROW_INDEX_FIELD, COLUMN_INDEX_FIELD, ROW_SPAN_FIELD, COLUMN_SPAN_FIELD, GEOMETRY_FIELD, ID_FIELD, RELATIONSHIPS_FIELD, ENTITY_TYPES_FIELD, SELECTION_STATUS_FIELD, PAGE_FIELD, QUERY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String blockType;
    private final Float confidence;
    private final String text;
    private final String textType;
    private final Integer rowIndex;
    private final Integer columnIndex;
    private final Integer rowSpan;
    private final Integer columnSpan;
    private final Geometry geometry;
    private final String id;
    private final List<Relationship> relationships;
    private final List<String> entityTypes;
    private final String selectionStatus;
    private final Integer page;
    private final Query query;

    private Block(BuilderImpl builder) {
        this.blockType = builder.blockType;
        this.confidence = builder.confidence;
        this.text = builder.text;
        this.textType = builder.textType;
        this.rowIndex = builder.rowIndex;
        this.columnIndex = builder.columnIndex;
        this.rowSpan = builder.rowSpan;
        this.columnSpan = builder.columnSpan;
        this.geometry = builder.geometry;
        this.id = builder.id;
        this.relationships = builder.relationships;
        this.entityTypes = builder.entityTypes;
        this.selectionStatus = builder.selectionStatus;
        this.page = builder.page;
        this.query = builder.query;
    }

    public final BlockType blockType() {
        return BlockType.fromValue(this.blockType);
    }

    public final String blockTypeAsString() {
        return this.blockType;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final String text() {
        return this.text;
    }

    public final TextType textType() {
        return TextType.fromValue(this.textType);
    }

    public final String textTypeAsString() {
        return this.textType;
    }

    public final Integer rowIndex() {
        return this.rowIndex;
    }

    public final Integer columnIndex() {
        return this.columnIndex;
    }

    public final Integer rowSpan() {
        return this.rowSpan;
    }

    public final Integer columnSpan() {
        return this.columnSpan;
    }

    public final Geometry geometry() {
        return this.geometry;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasRelationships() {
        return this.relationships != null && !(this.relationships instanceof SdkAutoConstructList);
    }

    public final List<Relationship> relationships() {
        return this.relationships;
    }

    public final List<EntityType> entityTypes() {
        return EntityTypesCopier.copyStringToEnum(this.entityTypes);
    }

    public final boolean hasEntityTypes() {
        return this.entityTypes != null && !(this.entityTypes instanceof SdkAutoConstructList);
    }

    public final List<String> entityTypesAsStrings() {
        return this.entityTypes;
    }

    public final SelectionStatus selectionStatus() {
        return SelectionStatus.fromValue(this.selectionStatus);
    }

    public final String selectionStatusAsString() {
        return this.selectionStatus;
    }

    public final Integer page() {
        return this.page;
    }

    public final Query query() {
        return this.query;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowSpan());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnSpan());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationships() ? this.relationships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityTypes() ? this.entityTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.page());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        return Objects.equals(this.blockTypeAsString(), other.blockTypeAsString()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.textTypeAsString(), other.textTypeAsString()) && Objects.equals(this.rowIndex(), other.rowIndex()) && Objects.equals(this.columnIndex(), other.columnIndex()) && Objects.equals(this.rowSpan(), other.rowSpan()) && Objects.equals(this.columnSpan(), other.columnSpan()) && Objects.equals(this.geometry(), other.geometry()) && Objects.equals(this.id(), other.id()) && this.hasRelationships() == other.hasRelationships() && Objects.equals(this.relationships(), other.relationships()) && this.hasEntityTypes() == other.hasEntityTypes() && Objects.equals(this.entityTypesAsStrings(), other.entityTypesAsStrings()) && Objects.equals(this.selectionStatusAsString(), other.selectionStatusAsString()) && Objects.equals(this.page(), other.page()) && Objects.equals(this.query(), other.query());
    }

    public final String toString() {
        return ToString.builder((String)"Block").add("BlockType", (Object)this.blockTypeAsString()).add("Confidence", (Object)this.confidence()).add("Text", (Object)this.text()).add("TextType", (Object)this.textTypeAsString()).add("RowIndex", (Object)this.rowIndex()).add("ColumnIndex", (Object)this.columnIndex()).add("RowSpan", (Object)this.rowSpan()).add("ColumnSpan", (Object)this.columnSpan()).add("Geometry", (Object)this.geometry()).add("Id", (Object)this.id()).add("Relationships", this.hasRelationships() ? this.relationships() : null).add("EntityTypes", this.hasEntityTypes() ? this.entityTypesAsStrings() : null).add("SelectionStatus", (Object)this.selectionStatusAsString()).add("Page", (Object)this.page()).add("Query", (Object)this.query()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockType": {
                return Optional.ofNullable(clazz.cast(this.blockTypeAsString()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "TextType": {
                return Optional.ofNullable(clazz.cast(this.textTypeAsString()));
            }
            case "RowIndex": {
                return Optional.ofNullable(clazz.cast(this.rowIndex()));
            }
            case "ColumnIndex": {
                return Optional.ofNullable(clazz.cast(this.columnIndex()));
            }
            case "RowSpan": {
                return Optional.ofNullable(clazz.cast(this.rowSpan()));
            }
            case "ColumnSpan": {
                return Optional.ofNullable(clazz.cast(this.columnSpan()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Relationships": {
                return Optional.ofNullable(clazz.cast(this.relationships()));
            }
            case "EntityTypes": {
                return Optional.ofNullable(clazz.cast(this.entityTypesAsStrings()));
            }
            case "SelectionStatus": {
                return Optional.ofNullable(clazz.cast(this.selectionStatusAsString()));
            }
            case "Page": {
                return Optional.ofNullable(clazz.cast(this.page()));
            }
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Block, T> g) {
        return obj -> g.apply((Block)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blockType;
        private Float confidence;
        private String text;
        private String textType;
        private Integer rowIndex;
        private Integer columnIndex;
        private Integer rowSpan;
        private Integer columnSpan;
        private Geometry geometry;
        private String id;
        private List<Relationship> relationships = DefaultSdkAutoConstructList.getInstance();
        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();
        private String selectionStatus;
        private Integer page;
        private Query query;

        private BuilderImpl() {
        }

        private BuilderImpl(Block model) {
            this.blockType(model.blockType);
            this.confidence(model.confidence);
            this.text(model.text);
            this.textType(model.textType);
            this.rowIndex(model.rowIndex);
            this.columnIndex(model.columnIndex);
            this.rowSpan(model.rowSpan);
            this.columnSpan(model.columnSpan);
            this.geometry(model.geometry);
            this.id(model.id);
            this.relationships(model.relationships);
            this.entityTypesWithStrings(model.entityTypes);
            this.selectionStatus(model.selectionStatus);
            this.page(model.page);
            this.query(model.query);
        }

        public final String getBlockType() {
            return this.blockType;
        }

        public final void setBlockType(String blockType) {
            this.blockType = blockType;
        }

        @Override
        public final Builder blockType(String blockType) {
            this.blockType = blockType;
            return this;
        }

        @Override
        public final Builder blockType(BlockType blockType) {
            this.blockType(blockType == null ? null : blockType.toString());
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getTextType() {
            return this.textType;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType == null ? null : textType.toString());
            return this;
        }

        public final Integer getRowIndex() {
            return this.rowIndex;
        }

        public final void setRowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public final Builder rowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
            return this;
        }

        public final Integer getColumnIndex() {
            return this.columnIndex;
        }

        public final void setColumnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public final Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            return this;
        }

        public final Integer getRowSpan() {
            return this.rowSpan;
        }

        public final void setRowSpan(Integer rowSpan) {
            this.rowSpan = rowSpan;
        }

        @Override
        public final Builder rowSpan(Integer rowSpan) {
            this.rowSpan = rowSpan;
            return this;
        }

        public final Integer getColumnSpan() {
            return this.columnSpan;
        }

        public final void setColumnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
        }

        @Override
        public final Builder columnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
            return this;
        }

        public final Geometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<Relationship.Builder> getRelationships() {
            List<Relationship.Builder> result = RelationshipListCopier.copyToBuilder(this.relationships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationships(Collection<Relationship.BuilderImpl> relationships) {
            this.relationships = RelationshipListCopier.copyFromBuilder(relationships);
        }

        @Override
        public final Builder relationships(Collection<Relationship> relationships) {
            this.relationships = RelationshipListCopier.copy(relationships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Relationship ... relationships) {
            this.relationships(Arrays.asList(relationships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Consumer<Relationship.Builder> ... relationships) {
            this.relationships(Stream.of(relationships).map(c -> (Relationship)((Relationship.Builder)Relationship.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEntityTypes() {
            if (this.entityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityTypes;
        }

        public final void setEntityTypes(Collection<String> entityTypes) {
            this.entityTypes = EntityTypesCopier.copy(entityTypes);
        }

        @Override
        public final Builder entityTypesWithStrings(Collection<String> entityTypes) {
            this.entityTypes = EntityTypesCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypesWithStrings(String ... entityTypes) {
            this.entityTypesWithStrings(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        public final Builder entityTypes(Collection<EntityType> entityTypes) {
            this.entityTypes = EntityTypesCopier.copyEnumToString(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityType ... entityTypes) {
            this.entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final String getSelectionStatus() {
            return this.selectionStatus;
        }

        public final void setSelectionStatus(String selectionStatus) {
            this.selectionStatus = selectionStatus;
        }

        @Override
        public final Builder selectionStatus(String selectionStatus) {
            this.selectionStatus = selectionStatus;
            return this;
        }

        @Override
        public final Builder selectionStatus(SelectionStatus selectionStatus) {
            this.selectionStatus(selectionStatus == null ? null : selectionStatus.toString());
            return this;
        }

        public final Integer getPage() {
            return this.page;
        }

        public final void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public final Builder page(Integer page) {
            this.page = page;
            return this;
        }

        public final Query.Builder getQuery() {
            return this.query != null ? this.query.toBuilder() : null;
        }

        public final void setQuery(Query.BuilderImpl query) {
            this.query = query != null ? query.build() : null;
        }

        @Override
        public final Builder query(Query query) {
            this.query = query;
            return this;
        }

        public Block build() {
            return new Block(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Block> {
        public Builder blockType(String var1);

        public Builder blockType(BlockType var1);

        public Builder confidence(Float var1);

        public Builder text(String var1);

        public Builder textType(String var1);

        public Builder textType(TextType var1);

        public Builder rowIndex(Integer var1);

        public Builder columnIndex(Integer var1);

        public Builder rowSpan(Integer var1);

        public Builder columnSpan(Integer var1);

        public Builder geometry(Geometry var1);

        default public Builder geometry(Consumer<Geometry.Builder> geometry) {
            return this.geometry((Geometry)((Geometry.Builder)Geometry.builder().applyMutation(geometry)).build());
        }

        public Builder id(String var1);

        public Builder relationships(Collection<Relationship> var1);

        public Builder relationships(Relationship ... var1);

        public Builder relationships(Consumer<Relationship.Builder> ... var1);

        public Builder entityTypesWithStrings(Collection<String> var1);

        public Builder entityTypesWithStrings(String ... var1);

        public Builder entityTypes(Collection<EntityType> var1);

        public Builder entityTypes(EntityType ... var1);

        public Builder selectionStatus(String var1);

        public Builder selectionStatus(SelectionStatus var1);

        public Builder page(Integer var1);

        public Builder query(Query var1);

        default public Builder query(Consumer<Query.Builder> query) {
            return this.query((Query)((Query.Builder)Query.builder().applyMutation(query)).build());
        }
    }
}

