/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateResourceRequest extends SyntheticsRequest implements
        ToCopyableBuilder<DisassociateResourceRequest.Builder, DisassociateResourceRequest> {
    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupIdentifier").getter(getter(DisassociateResourceRequest::groupIdentifier))
            .setter(setter(Builder::groupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("groupIdentifier").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DisassociateResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_IDENTIFIER_FIELD,
            RESOURCE_ARN_FIELD));

    private final String groupIdentifier;

    private final String resourceArn;

    private DisassociateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.groupIdentifier = builder.groupIdentifier;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * Specifies the group. You can specify the group name, the ARN, or the group ID as the <code>GroupIdentifier</code>
     * .
     * </p>
     * 
     * @return Specifies the group. You can specify the group name, the ARN, or the group ID as the
     *         <code>GroupIdentifier</code>.
     */
    public final String groupIdentifier() {
        return groupIdentifier;
    }

    /**
     * <p>
     * The ARN of the canary that you want to remove from the specified group.
     * </p>
     * 
     * @return The ARN of the canary that you want to remove from the specified group.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceRequest)) {
            return false;
        }
        DisassociateResourceRequest other = (DisassociateResourceRequest) obj;
        return Objects.equals(groupIdentifier(), other.groupIdentifier()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateResourceRequest").add("GroupIdentifier", groupIdentifier())
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupIdentifier":
            return Optional.ofNullable(clazz.cast(groupIdentifier()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceRequest, T> g) {
        return obj -> g.apply((DisassociateResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateResourceRequest> {
        /**
         * <p>
         * Specifies the group. You can specify the group name, the ARN, or the group ID as the
         * <code>GroupIdentifier</code>.
         * </p>
         * 
         * @param groupIdentifier
         *        Specifies the group. You can specify the group name, the ARN, or the group ID as the
         *        <code>GroupIdentifier</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIdentifier(String groupIdentifier);

        /**
         * <p>
         * The ARN of the canary that you want to remove from the specified group.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the canary that you want to remove from the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SyntheticsRequest.BuilderImpl implements Builder {
        private String groupIdentifier;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceRequest model) {
            super(model);
            groupIdentifier(model.groupIdentifier);
            resourceArn(model.resourceArn);
        }

        public final String getGroupIdentifier() {
            return groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateResourceRequest build() {
            return new DisassociateResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
