/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkflowExecutionRequest extends SwfRequest implements
        ToCopyableBuilder<DescribeWorkflowExecutionRequest.Builder, DescribeWorkflowExecutionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(DescribeWorkflowExecutionRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<WorkflowExecution> EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO).memberName("execution")
            .getter(getter(DescribeWorkflowExecutionRequest::execution)).setter(setter(Builder::execution))
            .constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DOMAIN_FIELD, EXECUTION_FIELD));

    private final String domain;

    private final WorkflowExecution execution;

    private DescribeWorkflowExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.execution = builder.execution;
    }

    /**
     * <p>
     * The name of the domain containing the workflow execution.
     * </p>
     * 
     * @return The name of the domain containing the workflow execution.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The workflow execution to describe.
     * </p>
     * 
     * @return The workflow execution to describe.
     */
    public final WorkflowExecution execution() {
        return execution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(execution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowExecutionRequest)) {
            return false;
        }
        DescribeWorkflowExecutionRequest other = (DescribeWorkflowExecutionRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(execution(), other.execution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkflowExecutionRequest").add("Domain", domain()).add("Execution", execution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "execution":
            return Optional.ofNullable(clazz.cast(execution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkflowExecutionRequest, T> g) {
        return obj -> g.apply((DescribeWorkflowExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkflowExecutionRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow execution.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The workflow execution to describe.
         * </p>
         * 
         * @param execution
         *        The workflow execution to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(WorkflowExecution execution);

        /**
         * <p>
         * The workflow execution to describe.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowExecution.Builder} avoiding the
         * need to create one manually via {@link WorkflowExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #execution(WorkflowExecution)}.
         * 
         * @param execution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execution(WorkflowExecution)
         */
        default Builder execution(Consumer<WorkflowExecution.Builder> execution) {
            return execution(WorkflowExecution.builder().applyMutation(execution).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private WorkflowExecution execution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowExecutionRequest model) {
            super(model);
            domain(model.domain);
            execution(model.execution);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final WorkflowExecution.Builder getExecution() {
            return execution != null ? execution.toBuilder() : null;
        }

        public final void setExecution(WorkflowExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public final Builder execution(WorkflowExecution execution) {
            this.execution = execution;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkflowExecutionRequest build() {
            return new DescribeWorkflowExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
