/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ContinueAsNewWorkflowExecutionFailedCause {
    UNHANDLED_DECISION("UNHANDLED_DECISION"),

    WORKFLOW_TYPE_DEPRECATED("WORKFLOW_TYPE_DEPRECATED"),

    WORKFLOW_TYPE_DOES_NOT_EXIST("WORKFLOW_TYPE_DOES_NOT_EXIST"),

    DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED("DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED"),

    DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED("DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED"),

    DEFAULT_TASK_LIST_UNDEFINED("DEFAULT_TASK_LIST_UNDEFINED"),

    DEFAULT_CHILD_POLICY_UNDEFINED("DEFAULT_CHILD_POLICY_UNDEFINED"),

    CONTINUE_AS_NEW_WORKFLOW_EXECUTION_RATE_EXCEEDED("CONTINUE_AS_NEW_WORKFLOW_EXECUTION_RATE_EXCEEDED"),

    OPERATION_NOT_PERMITTED("OPERATION_NOT_PERMITTED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContinueAsNewWorkflowExecutionFailedCause> VALUE_MAP = EnumUtils.uniqueIndex(
            ContinueAsNewWorkflowExecutionFailedCause.class, ContinueAsNewWorkflowExecutionFailedCause::toString);

    private final String value;

    private ContinueAsNewWorkflowExecutionFailedCause(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ContinueAsNewWorkflowExecutionFailedCause corresponding to the value
     */
    public static ContinueAsNewWorkflowExecutionFailedCause fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ContinueAsNewWorkflowExecutionFailedCause}s
     */
    public static Set<ContinueAsNewWorkflowExecutionFailedCause> knownValues() {
        Set<ContinueAsNewWorkflowExecutionFailedCause> knownValues = EnumSet
                .allOf(ContinueAsNewWorkflowExecutionFailedCause.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
