/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Event within a workflow execution. A history event can be one of these types:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>ActivityTaskCancelRequested</code> – A <code>RequestCancelActivityTask</code> decision was received by the
 * system.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ActivityTaskCanceled</code> – The activity task was successfully canceled.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ActivityTaskCompleted</code> – An activity worker successfully completed an activity task by calling
 * <a>RespondActivityTaskCompleted</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ActivityTaskFailed</code> – An activity worker failed an activity task by calling
 * <a>RespondActivityTaskFailed</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ActivityTaskScheduled</code> – An activity task was scheduled for execution.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ActivityTaskStarted</code> – The scheduled activity task was dispatched to a worker.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ActivityTaskTimedOut</code> – The activity task timed out.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CancelTimerFailed</code> – Failed to process CancelTimer decision. This happens when the decision isn't
 * configured properly, for example no timer exists with the specified timer Id.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CancelWorkflowExecutionFailed</code> – A request to cancel a workflow execution failed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ChildWorkflowExecutionCanceled</code> – A child workflow execution, started by this workflow execution, was
 * canceled and closed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ChildWorkflowExecutionCompleted</code> – A child workflow execution, started by this workflow execution,
 * completed successfully and was closed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ChildWorkflowExecutionFailed</code> – A child workflow execution, started by this workflow execution, failed to
 * complete successfully and was closed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ChildWorkflowExecutionStarted</code> – A child workflow execution was successfully started.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ChildWorkflowExecutionTerminated</code> – A child workflow execution, started by this workflow execution, was
 * terminated.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ChildWorkflowExecutionTimedOut</code> – A child workflow execution, started by this workflow execution, timed
 * out and was closed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CompleteWorkflowExecutionFailed</code> – The workflow execution failed to complete.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ContinueAsNewWorkflowExecutionFailed</code> – The workflow execution failed to complete after being continued
 * as a new workflow execution.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DecisionTaskCompleted</code> – The decider successfully completed a decision task by calling
 * <a>RespondDecisionTaskCompleted</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DecisionTaskScheduled</code> – A decision task was scheduled for the workflow execution.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DecisionTaskStarted</code> – The decision task was dispatched to a decider.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DecisionTaskTimedOut</code> – The decision task timed out.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ExternalWorkflowExecutionCancelRequested</code> – Request to cancel an external workflow execution was
 * successfully delivered to the target execution.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ExternalWorkflowExecutionSignaled</code> – A signal, requested by this workflow execution, was successfully
 * delivered to the target external workflow execution.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>FailWorkflowExecutionFailed</code> – A request to mark a workflow execution as failed, itself failed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>MarkerRecorded</code> – A marker was recorded in the workflow history as the result of a
 * <code>RecordMarker</code> decision.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RecordMarkerFailed</code> – A <code>RecordMarker</code> decision was returned as failed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RequestCancelActivityTaskFailed</code> – Failed to process RequestCancelActivityTask decision. This happens
 * when the decision isn't configured properly.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RequestCancelExternalWorkflowExecutionFailed</code> – Request to cancel an external workflow execution failed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RequestCancelExternalWorkflowExecutionInitiated</code> – A request was made to request the cancellation of an
 * external workflow execution.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ScheduleActivityTaskFailed</code> – Failed to process ScheduleActivityTask decision. This happens when the
 * decision isn't configured properly, for example the activity type specified isn't registered.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>SignalExternalWorkflowExecutionFailed</code> – The request to signal an external workflow execution failed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>SignalExternalWorkflowExecutionInitiated</code> – A request to signal an external workflow was made.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>StartActivityTaskFailed</code> – A scheduled activity task failed to start.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>StartChildWorkflowExecutionFailed</code> – Failed to process StartChildWorkflowExecution decision. This happens
 * when the decision isn't configured properly, for example the workflow type specified isn't registered.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>StartChildWorkflowExecutionInitiated</code> – A request was made to start a child workflow execution.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>StartTimerFailed</code> – Failed to process StartTimer decision. This happens when the decision isn't
 * configured properly, for example a timer already exists with the specified timer Id.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TimerCanceled</code> – A timer, previously started for this workflow execution, was successfully canceled.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TimerFired</code> – A timer, previously started for this workflow execution, fired.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TimerStarted</code> – A timer was started for the workflow execution due to a <code>StartTimer</code> decision.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionCancelRequested</code> – A request to cancel this workflow execution was made.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionCanceled</code> – The workflow execution was successfully canceled and closed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionCompleted</code> – The workflow execution was closed due to successful completion.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionContinuedAsNew</code> – The workflow execution was closed and a new execution of the same type
 * was created with the same workflowId.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionFailed</code> – The workflow execution closed due to a failure.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionSignaled</code> – An external signal was received for the workflow execution.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionStarted</code> – The workflow execution was started.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionTerminated</code> – The workflow execution was terminated.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WorkflowExecutionTimedOut</code> – The workflow execution was closed because a time out was exceeded.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistoryEvent implements SdkPojo, Serializable, ToCopyableBuilder<HistoryEvent.Builder, HistoryEvent> {
    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTimestamp").getter(getter(HistoryEvent::eventTimestamp)).setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(HistoryEvent::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<Long> EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("eventId")
            .getter(getter(HistoryEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<WorkflowExecutionStartedEventAttributes> WORKFLOW_EXECUTION_STARTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionStartedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionStartedEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionStartedEventAttributes))
            .setter(setter(Builder::workflowExecutionStartedEventAttributes))
            .constructor(WorkflowExecutionStartedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionStartedEventAttributes").build()).build();

    private static final SdkField<WorkflowExecutionCompletedEventAttributes> WORKFLOW_EXECUTION_COMPLETED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionCompletedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionCompletedEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionCompletedEventAttributes))
            .setter(setter(Builder::workflowExecutionCompletedEventAttributes))
            .constructor(WorkflowExecutionCompletedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionCompletedEventAttributes").build()).build();

    private static final SdkField<CompleteWorkflowExecutionFailedEventAttributes> COMPLETE_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<CompleteWorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("completeWorkflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::completeWorkflowExecutionFailedEventAttributes))
            .setter(setter(Builder::completeWorkflowExecutionFailedEventAttributes))
            .constructor(CompleteWorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("completeWorkflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<WorkflowExecutionFailedEventAttributes> WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionFailedEventAttributes))
            .setter(setter(Builder::workflowExecutionFailedEventAttributes))
            .constructor(WorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<FailWorkflowExecutionFailedEventAttributes> FAIL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<FailWorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("failWorkflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::failWorkflowExecutionFailedEventAttributes))
            .setter(setter(Builder::failWorkflowExecutionFailedEventAttributes))
            .constructor(FailWorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("failWorkflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<WorkflowExecutionTimedOutEventAttributes> WORKFLOW_EXECUTION_TIMED_OUT_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionTimedOutEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionTimedOutEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionTimedOutEventAttributes))
            .setter(setter(Builder::workflowExecutionTimedOutEventAttributes))
            .constructor(WorkflowExecutionTimedOutEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionTimedOutEventAttributes").build()).build();

    private static final SdkField<WorkflowExecutionCanceledEventAttributes> WORKFLOW_EXECUTION_CANCELED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionCanceledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionCanceledEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionCanceledEventAttributes))
            .setter(setter(Builder::workflowExecutionCanceledEventAttributes))
            .constructor(WorkflowExecutionCanceledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionCanceledEventAttributes").build()).build();

    private static final SdkField<CancelWorkflowExecutionFailedEventAttributes> CANCEL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<CancelWorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("cancelWorkflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::cancelWorkflowExecutionFailedEventAttributes))
            .setter(setter(Builder::cancelWorkflowExecutionFailedEventAttributes))
            .constructor(CancelWorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("cancelWorkflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<WorkflowExecutionContinuedAsNewEventAttributes> WORKFLOW_EXECUTION_CONTINUED_AS_NEW_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionContinuedAsNewEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionContinuedAsNewEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionContinuedAsNewEventAttributes))
            .setter(setter(Builder::workflowExecutionContinuedAsNewEventAttributes))
            .constructor(WorkflowExecutionContinuedAsNewEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionContinuedAsNewEventAttributes").build()).build();

    private static final SdkField<ContinueAsNewWorkflowExecutionFailedEventAttributes> CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ContinueAsNewWorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("continueAsNewWorkflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::continueAsNewWorkflowExecutionFailedEventAttributes))
            .setter(setter(Builder::continueAsNewWorkflowExecutionFailedEventAttributes))
            .constructor(ContinueAsNewWorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("continueAsNewWorkflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<WorkflowExecutionTerminatedEventAttributes> WORKFLOW_EXECUTION_TERMINATED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionTerminatedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionTerminatedEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionTerminatedEventAttributes))
            .setter(setter(Builder::workflowExecutionTerminatedEventAttributes))
            .constructor(WorkflowExecutionTerminatedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionTerminatedEventAttributes").build()).build();

    private static final SdkField<WorkflowExecutionCancelRequestedEventAttributes> WORKFLOW_EXECUTION_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionCancelRequestedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionCancelRequestedEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionCancelRequestedEventAttributes))
            .setter(setter(Builder::workflowExecutionCancelRequestedEventAttributes))
            .constructor(WorkflowExecutionCancelRequestedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionCancelRequestedEventAttributes").build()).build();

    private static final SdkField<DecisionTaskScheduledEventAttributes> DECISION_TASK_SCHEDULED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<DecisionTaskScheduledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("decisionTaskScheduledEventAttributes")
            .getter(getter(HistoryEvent::decisionTaskScheduledEventAttributes))
            .setter(setter(Builder::decisionTaskScheduledEventAttributes))
            .constructor(DecisionTaskScheduledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("decisionTaskScheduledEventAttributes").build()).build();

    private static final SdkField<DecisionTaskStartedEventAttributes> DECISION_TASK_STARTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<DecisionTaskStartedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("decisionTaskStartedEventAttributes")
            .getter(getter(HistoryEvent::decisionTaskStartedEventAttributes))
            .setter(setter(Builder::decisionTaskStartedEventAttributes))
            .constructor(DecisionTaskStartedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskStartedEventAttributes")
                    .build()).build();

    private static final SdkField<DecisionTaskCompletedEventAttributes> DECISION_TASK_COMPLETED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<DecisionTaskCompletedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("decisionTaskCompletedEventAttributes")
            .getter(getter(HistoryEvent::decisionTaskCompletedEventAttributes))
            .setter(setter(Builder::decisionTaskCompletedEventAttributes))
            .constructor(DecisionTaskCompletedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("decisionTaskCompletedEventAttributes").build()).build();

    private static final SdkField<DecisionTaskTimedOutEventAttributes> DECISION_TASK_TIMED_OUT_EVENT_ATTRIBUTES_FIELD = SdkField
            .<DecisionTaskTimedOutEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("decisionTaskTimedOutEventAttributes")
            .getter(getter(HistoryEvent::decisionTaskTimedOutEventAttributes))
            .setter(setter(Builder::decisionTaskTimedOutEventAttributes))
            .constructor(DecisionTaskTimedOutEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("decisionTaskTimedOutEventAttributes").build()).build();

    private static final SdkField<ActivityTaskScheduledEventAttributes> ACTIVITY_TASK_SCHEDULED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ActivityTaskScheduledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("activityTaskScheduledEventAttributes")
            .getter(getter(HistoryEvent::activityTaskScheduledEventAttributes))
            .setter(setter(Builder::activityTaskScheduledEventAttributes))
            .constructor(ActivityTaskScheduledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("activityTaskScheduledEventAttributes").build()).build();

    private static final SdkField<ActivityTaskStartedEventAttributes> ACTIVITY_TASK_STARTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ActivityTaskStartedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("activityTaskStartedEventAttributes")
            .getter(getter(HistoryEvent::activityTaskStartedEventAttributes))
            .setter(setter(Builder::activityTaskStartedEventAttributes))
            .constructor(ActivityTaskStartedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityTaskStartedEventAttributes")
                    .build()).build();

    private static final SdkField<ActivityTaskCompletedEventAttributes> ACTIVITY_TASK_COMPLETED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ActivityTaskCompletedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("activityTaskCompletedEventAttributes")
            .getter(getter(HistoryEvent::activityTaskCompletedEventAttributes))
            .setter(setter(Builder::activityTaskCompletedEventAttributes))
            .constructor(ActivityTaskCompletedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("activityTaskCompletedEventAttributes").build()).build();

    private static final SdkField<ActivityTaskFailedEventAttributes> ACTIVITY_TASK_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ActivityTaskFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("activityTaskFailedEventAttributes")
            .getter(getter(HistoryEvent::activityTaskFailedEventAttributes))
            .setter(setter(Builder::activityTaskFailedEventAttributes))
            .constructor(ActivityTaskFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityTaskFailedEventAttributes")
                    .build()).build();

    private static final SdkField<ActivityTaskTimedOutEventAttributes> ACTIVITY_TASK_TIMED_OUT_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ActivityTaskTimedOutEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("activityTaskTimedOutEventAttributes")
            .getter(getter(HistoryEvent::activityTaskTimedOutEventAttributes))
            .setter(setter(Builder::activityTaskTimedOutEventAttributes))
            .constructor(ActivityTaskTimedOutEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("activityTaskTimedOutEventAttributes").build()).build();

    private static final SdkField<ActivityTaskCanceledEventAttributes> ACTIVITY_TASK_CANCELED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ActivityTaskCanceledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("activityTaskCanceledEventAttributes")
            .getter(getter(HistoryEvent::activityTaskCanceledEventAttributes))
            .setter(setter(Builder::activityTaskCanceledEventAttributes))
            .constructor(ActivityTaskCanceledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("activityTaskCanceledEventAttributes").build()).build();

    private static final SdkField<ActivityTaskCancelRequestedEventAttributes> ACTIVITY_TASK_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ActivityTaskCancelRequestedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("activityTaskCancelRequestedEventAttributes")
            .getter(getter(HistoryEvent::activityTaskCancelRequestedEventAttributes))
            .setter(setter(Builder::activityTaskCancelRequestedEventAttributes))
            .constructor(ActivityTaskCancelRequestedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("activityTaskCancelRequestedEventAttributes").build()).build();

    private static final SdkField<WorkflowExecutionSignaledEventAttributes> WORKFLOW_EXECUTION_SIGNALED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<WorkflowExecutionSignaledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("workflowExecutionSignaledEventAttributes")
            .getter(getter(HistoryEvent::workflowExecutionSignaledEventAttributes))
            .setter(setter(Builder::workflowExecutionSignaledEventAttributes))
            .constructor(WorkflowExecutionSignaledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionSignaledEventAttributes").build()).build();

    private static final SdkField<MarkerRecordedEventAttributes> MARKER_RECORDED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<MarkerRecordedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("markerRecordedEventAttributes")
            .getter(getter(HistoryEvent::markerRecordedEventAttributes))
            .setter(setter(Builder::markerRecordedEventAttributes))
            .constructor(MarkerRecordedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("markerRecordedEventAttributes")
                    .build()).build();

    private static final SdkField<RecordMarkerFailedEventAttributes> RECORD_MARKER_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<RecordMarkerFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("recordMarkerFailedEventAttributes")
            .getter(getter(HistoryEvent::recordMarkerFailedEventAttributes))
            .setter(setter(Builder::recordMarkerFailedEventAttributes))
            .constructor(RecordMarkerFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordMarkerFailedEventAttributes")
                    .build()).build();

    private static final SdkField<TimerStartedEventAttributes> TIMER_STARTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<TimerStartedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("timerStartedEventAttributes")
            .getter(getter(HistoryEvent::timerStartedEventAttributes))
            .setter(setter(Builder::timerStartedEventAttributes))
            .constructor(TimerStartedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerStartedEventAttributes")
                    .build()).build();

    private static final SdkField<TimerFiredEventAttributes> TIMER_FIRED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<TimerFiredEventAttributes> builder(MarshallingType.SDK_POJO).memberName("timerFiredEventAttributes")
            .getter(getter(HistoryEvent::timerFiredEventAttributes)).setter(setter(Builder::timerFiredEventAttributes))
            .constructor(TimerFiredEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerFiredEventAttributes").build())
            .build();

    private static final SdkField<TimerCanceledEventAttributes> TIMER_CANCELED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<TimerCanceledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("timerCanceledEventAttributes")
            .getter(getter(HistoryEvent::timerCanceledEventAttributes))
            .setter(setter(Builder::timerCanceledEventAttributes))
            .constructor(TimerCanceledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerCanceledEventAttributes")
                    .build()).build();

    private static final SdkField<StartChildWorkflowExecutionInitiatedEventAttributes> START_CHILD_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<StartChildWorkflowExecutionInitiatedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("startChildWorkflowExecutionInitiatedEventAttributes")
            .getter(getter(HistoryEvent::startChildWorkflowExecutionInitiatedEventAttributes))
            .setter(setter(Builder::startChildWorkflowExecutionInitiatedEventAttributes))
            .constructor(StartChildWorkflowExecutionInitiatedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("startChildWorkflowExecutionInitiatedEventAttributes").build()).build();

    private static final SdkField<ChildWorkflowExecutionStartedEventAttributes> CHILD_WORKFLOW_EXECUTION_STARTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ChildWorkflowExecutionStartedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("childWorkflowExecutionStartedEventAttributes")
            .getter(getter(HistoryEvent::childWorkflowExecutionStartedEventAttributes))
            .setter(setter(Builder::childWorkflowExecutionStartedEventAttributes))
            .constructor(ChildWorkflowExecutionStartedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("childWorkflowExecutionStartedEventAttributes").build()).build();

    private static final SdkField<ChildWorkflowExecutionCompletedEventAttributes> CHILD_WORKFLOW_EXECUTION_COMPLETED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ChildWorkflowExecutionCompletedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("childWorkflowExecutionCompletedEventAttributes")
            .getter(getter(HistoryEvent::childWorkflowExecutionCompletedEventAttributes))
            .setter(setter(Builder::childWorkflowExecutionCompletedEventAttributes))
            .constructor(ChildWorkflowExecutionCompletedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("childWorkflowExecutionCompletedEventAttributes").build()).build();

    private static final SdkField<ChildWorkflowExecutionFailedEventAttributes> CHILD_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ChildWorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("childWorkflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::childWorkflowExecutionFailedEventAttributes))
            .setter(setter(Builder::childWorkflowExecutionFailedEventAttributes))
            .constructor(ChildWorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("childWorkflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<ChildWorkflowExecutionTimedOutEventAttributes> CHILD_WORKFLOW_EXECUTION_TIMED_OUT_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ChildWorkflowExecutionTimedOutEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("childWorkflowExecutionTimedOutEventAttributes")
            .getter(getter(HistoryEvent::childWorkflowExecutionTimedOutEventAttributes))
            .setter(setter(Builder::childWorkflowExecutionTimedOutEventAttributes))
            .constructor(ChildWorkflowExecutionTimedOutEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("childWorkflowExecutionTimedOutEventAttributes").build()).build();

    private static final SdkField<ChildWorkflowExecutionCanceledEventAttributes> CHILD_WORKFLOW_EXECUTION_CANCELED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ChildWorkflowExecutionCanceledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("childWorkflowExecutionCanceledEventAttributes")
            .getter(getter(HistoryEvent::childWorkflowExecutionCanceledEventAttributes))
            .setter(setter(Builder::childWorkflowExecutionCanceledEventAttributes))
            .constructor(ChildWorkflowExecutionCanceledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("childWorkflowExecutionCanceledEventAttributes").build()).build();

    private static final SdkField<ChildWorkflowExecutionTerminatedEventAttributes> CHILD_WORKFLOW_EXECUTION_TERMINATED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ChildWorkflowExecutionTerminatedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("childWorkflowExecutionTerminatedEventAttributes")
            .getter(getter(HistoryEvent::childWorkflowExecutionTerminatedEventAttributes))
            .setter(setter(Builder::childWorkflowExecutionTerminatedEventAttributes))
            .constructor(ChildWorkflowExecutionTerminatedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("childWorkflowExecutionTerminatedEventAttributes").build()).build();

    private static final SdkField<SignalExternalWorkflowExecutionInitiatedEventAttributes> SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<SignalExternalWorkflowExecutionInitiatedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("signalExternalWorkflowExecutionInitiatedEventAttributes")
            .getter(getter(HistoryEvent::signalExternalWorkflowExecutionInitiatedEventAttributes))
            .setter(setter(Builder::signalExternalWorkflowExecutionInitiatedEventAttributes))
            .constructor(SignalExternalWorkflowExecutionInitiatedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("signalExternalWorkflowExecutionInitiatedEventAttributes").build()).build();

    private static final SdkField<ExternalWorkflowExecutionSignaledEventAttributes> EXTERNAL_WORKFLOW_EXECUTION_SIGNALED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ExternalWorkflowExecutionSignaledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("externalWorkflowExecutionSignaledEventAttributes")
            .getter(getter(HistoryEvent::externalWorkflowExecutionSignaledEventAttributes))
            .setter(setter(Builder::externalWorkflowExecutionSignaledEventAttributes))
            .constructor(ExternalWorkflowExecutionSignaledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("externalWorkflowExecutionSignaledEventAttributes").build()).build();

    private static final SdkField<SignalExternalWorkflowExecutionFailedEventAttributes> SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<SignalExternalWorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("signalExternalWorkflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::signalExternalWorkflowExecutionFailedEventAttributes))
            .setter(setter(Builder::signalExternalWorkflowExecutionFailedEventAttributes))
            .constructor(SignalExternalWorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("signalExternalWorkflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<ExternalWorkflowExecutionCancelRequestedEventAttributes> EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ExternalWorkflowExecutionCancelRequestedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("externalWorkflowExecutionCancelRequestedEventAttributes")
            .getter(getter(HistoryEvent::externalWorkflowExecutionCancelRequestedEventAttributes))
            .setter(setter(Builder::externalWorkflowExecutionCancelRequestedEventAttributes))
            .constructor(ExternalWorkflowExecutionCancelRequestedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("externalWorkflowExecutionCancelRequestedEventAttributes").build()).build();

    private static final SdkField<RequestCancelExternalWorkflowExecutionInitiatedEventAttributes> REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<RequestCancelExternalWorkflowExecutionInitiatedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("requestCancelExternalWorkflowExecutionInitiatedEventAttributes")
            .getter(getter(HistoryEvent::requestCancelExternalWorkflowExecutionInitiatedEventAttributes))
            .setter(setter(Builder::requestCancelExternalWorkflowExecutionInitiatedEventAttributes))
            .constructor(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("requestCancelExternalWorkflowExecutionInitiatedEventAttributes").build()).build();

    private static final SdkField<RequestCancelExternalWorkflowExecutionFailedEventAttributes> REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<RequestCancelExternalWorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("requestCancelExternalWorkflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::requestCancelExternalWorkflowExecutionFailedEventAttributes))
            .setter(setter(Builder::requestCancelExternalWorkflowExecutionFailedEventAttributes))
            .constructor(RequestCancelExternalWorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("requestCancelExternalWorkflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<ScheduleActivityTaskFailedEventAttributes> SCHEDULE_ACTIVITY_TASK_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ScheduleActivityTaskFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("scheduleActivityTaskFailedEventAttributes")
            .getter(getter(HistoryEvent::scheduleActivityTaskFailedEventAttributes))
            .setter(setter(Builder::scheduleActivityTaskFailedEventAttributes))
            .constructor(ScheduleActivityTaskFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("scheduleActivityTaskFailedEventAttributes").build()).build();

    private static final SdkField<RequestCancelActivityTaskFailedEventAttributes> REQUEST_CANCEL_ACTIVITY_TASK_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<RequestCancelActivityTaskFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("requestCancelActivityTaskFailedEventAttributes")
            .getter(getter(HistoryEvent::requestCancelActivityTaskFailedEventAttributes))
            .setter(setter(Builder::requestCancelActivityTaskFailedEventAttributes))
            .constructor(RequestCancelActivityTaskFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("requestCancelActivityTaskFailedEventAttributes").build()).build();

    private static final SdkField<StartTimerFailedEventAttributes> START_TIMER_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<StartTimerFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("startTimerFailedEventAttributes")
            .getter(getter(HistoryEvent::startTimerFailedEventAttributes))
            .setter(setter(Builder::startTimerFailedEventAttributes))
            .constructor(StartTimerFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimerFailedEventAttributes")
                    .build()).build();

    private static final SdkField<CancelTimerFailedEventAttributes> CANCEL_TIMER_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<CancelTimerFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("cancelTimerFailedEventAttributes")
            .getter(getter(HistoryEvent::cancelTimerFailedEventAttributes))
            .setter(setter(Builder::cancelTimerFailedEventAttributes))
            .constructor(CancelTimerFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancelTimerFailedEventAttributes")
                    .build()).build();

    private static final SdkField<StartChildWorkflowExecutionFailedEventAttributes> START_CHILD_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<StartChildWorkflowExecutionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("startChildWorkflowExecutionFailedEventAttributes")
            .getter(getter(HistoryEvent::startChildWorkflowExecutionFailedEventAttributes))
            .setter(setter(Builder::startChildWorkflowExecutionFailedEventAttributes))
            .constructor(StartChildWorkflowExecutionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("startChildWorkflowExecutionFailedEventAttributes").build()).build();

    private static final SdkField<LambdaFunctionScheduledEventAttributes> LAMBDA_FUNCTION_SCHEDULED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<LambdaFunctionScheduledEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaFunctionScheduledEventAttributes")
            .getter(getter(HistoryEvent::lambdaFunctionScheduledEventAttributes))
            .setter(setter(Builder::lambdaFunctionScheduledEventAttributes))
            .constructor(LambdaFunctionScheduledEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionScheduledEventAttributes").build()).build();

    private static final SdkField<LambdaFunctionStartedEventAttributes> LAMBDA_FUNCTION_STARTED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<LambdaFunctionStartedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaFunctionStartedEventAttributes")
            .getter(getter(HistoryEvent::lambdaFunctionStartedEventAttributes))
            .setter(setter(Builder::lambdaFunctionStartedEventAttributes))
            .constructor(LambdaFunctionStartedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionStartedEventAttributes").build()).build();

    private static final SdkField<LambdaFunctionCompletedEventAttributes> LAMBDA_FUNCTION_COMPLETED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<LambdaFunctionCompletedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaFunctionCompletedEventAttributes")
            .getter(getter(HistoryEvent::lambdaFunctionCompletedEventAttributes))
            .setter(setter(Builder::lambdaFunctionCompletedEventAttributes))
            .constructor(LambdaFunctionCompletedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionCompletedEventAttributes").build()).build();

    private static final SdkField<LambdaFunctionFailedEventAttributes> LAMBDA_FUNCTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<LambdaFunctionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaFunctionFailedEventAttributes")
            .getter(getter(HistoryEvent::lambdaFunctionFailedEventAttributes))
            .setter(setter(Builder::lambdaFunctionFailedEventAttributes))
            .constructor(LambdaFunctionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionFailedEventAttributes").build()).build();

    private static final SdkField<LambdaFunctionTimedOutEventAttributes> LAMBDA_FUNCTION_TIMED_OUT_EVENT_ATTRIBUTES_FIELD = SdkField
            .<LambdaFunctionTimedOutEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaFunctionTimedOutEventAttributes")
            .getter(getter(HistoryEvent::lambdaFunctionTimedOutEventAttributes))
            .setter(setter(Builder::lambdaFunctionTimedOutEventAttributes))
            .constructor(LambdaFunctionTimedOutEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionTimedOutEventAttributes").build()).build();

    private static final SdkField<ScheduleLambdaFunctionFailedEventAttributes> SCHEDULE_LAMBDA_FUNCTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<ScheduleLambdaFunctionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("scheduleLambdaFunctionFailedEventAttributes")
            .getter(getter(HistoryEvent::scheduleLambdaFunctionFailedEventAttributes))
            .setter(setter(Builder::scheduleLambdaFunctionFailedEventAttributes))
            .constructor(ScheduleLambdaFunctionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("scheduleLambdaFunctionFailedEventAttributes").build()).build();

    private static final SdkField<StartLambdaFunctionFailedEventAttributes> START_LAMBDA_FUNCTION_FAILED_EVENT_ATTRIBUTES_FIELD = SdkField
            .<StartLambdaFunctionFailedEventAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("startLambdaFunctionFailedEventAttributes")
            .getter(getter(HistoryEvent::startLambdaFunctionFailedEventAttributes))
            .setter(setter(Builder::startLambdaFunctionFailedEventAttributes))
            .constructor(StartLambdaFunctionFailedEventAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("startLambdaFunctionFailedEventAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TIMESTAMP_FIELD,
            EVENT_TYPE_FIELD, EVENT_ID_FIELD, WORKFLOW_EXECUTION_STARTED_EVENT_ATTRIBUTES_FIELD,
            WORKFLOW_EXECUTION_COMPLETED_EVENT_ATTRIBUTES_FIELD, COMPLETE_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD,
            WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD, FAIL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD,
            WORKFLOW_EXECUTION_TIMED_OUT_EVENT_ATTRIBUTES_FIELD, WORKFLOW_EXECUTION_CANCELED_EVENT_ATTRIBUTES_FIELD,
            CANCEL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD, WORKFLOW_EXECUTION_CONTINUED_AS_NEW_EVENT_ATTRIBUTES_FIELD,
            CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD,
            WORKFLOW_EXECUTION_TERMINATED_EVENT_ATTRIBUTES_FIELD, WORKFLOW_EXECUTION_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD,
            DECISION_TASK_SCHEDULED_EVENT_ATTRIBUTES_FIELD, DECISION_TASK_STARTED_EVENT_ATTRIBUTES_FIELD,
            DECISION_TASK_COMPLETED_EVENT_ATTRIBUTES_FIELD, DECISION_TASK_TIMED_OUT_EVENT_ATTRIBUTES_FIELD,
            ACTIVITY_TASK_SCHEDULED_EVENT_ATTRIBUTES_FIELD, ACTIVITY_TASK_STARTED_EVENT_ATTRIBUTES_FIELD,
            ACTIVITY_TASK_COMPLETED_EVENT_ATTRIBUTES_FIELD, ACTIVITY_TASK_FAILED_EVENT_ATTRIBUTES_FIELD,
            ACTIVITY_TASK_TIMED_OUT_EVENT_ATTRIBUTES_FIELD, ACTIVITY_TASK_CANCELED_EVENT_ATTRIBUTES_FIELD,
            ACTIVITY_TASK_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD, WORKFLOW_EXECUTION_SIGNALED_EVENT_ATTRIBUTES_FIELD,
            MARKER_RECORDED_EVENT_ATTRIBUTES_FIELD, RECORD_MARKER_FAILED_EVENT_ATTRIBUTES_FIELD,
            TIMER_STARTED_EVENT_ATTRIBUTES_FIELD, TIMER_FIRED_EVENT_ATTRIBUTES_FIELD, TIMER_CANCELED_EVENT_ATTRIBUTES_FIELD,
            START_CHILD_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD,
            CHILD_WORKFLOW_EXECUTION_STARTED_EVENT_ATTRIBUTES_FIELD, CHILD_WORKFLOW_EXECUTION_COMPLETED_EVENT_ATTRIBUTES_FIELD,
            CHILD_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD, CHILD_WORKFLOW_EXECUTION_TIMED_OUT_EVENT_ATTRIBUTES_FIELD,
            CHILD_WORKFLOW_EXECUTION_CANCELED_EVENT_ATTRIBUTES_FIELD, CHILD_WORKFLOW_EXECUTION_TERMINATED_EVENT_ATTRIBUTES_FIELD,
            SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD,
            EXTERNAL_WORKFLOW_EXECUTION_SIGNALED_EVENT_ATTRIBUTES_FIELD,
            SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD,
            EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD,
            REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD,
            REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD,
            SCHEDULE_ACTIVITY_TASK_FAILED_EVENT_ATTRIBUTES_FIELD, REQUEST_CANCEL_ACTIVITY_TASK_FAILED_EVENT_ATTRIBUTES_FIELD,
            START_TIMER_FAILED_EVENT_ATTRIBUTES_FIELD, CANCEL_TIMER_FAILED_EVENT_ATTRIBUTES_FIELD,
            START_CHILD_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD, LAMBDA_FUNCTION_SCHEDULED_EVENT_ATTRIBUTES_FIELD,
            LAMBDA_FUNCTION_STARTED_EVENT_ATTRIBUTES_FIELD, LAMBDA_FUNCTION_COMPLETED_EVENT_ATTRIBUTES_FIELD,
            LAMBDA_FUNCTION_FAILED_EVENT_ATTRIBUTES_FIELD, LAMBDA_FUNCTION_TIMED_OUT_EVENT_ATTRIBUTES_FIELD,
            SCHEDULE_LAMBDA_FUNCTION_FAILED_EVENT_ATTRIBUTES_FIELD, START_LAMBDA_FUNCTION_FAILED_EVENT_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant eventTimestamp;

    private final String eventType;

    private final Long eventId;

    private final WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes;

    private final WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes;

    private final CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes;

    private final WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes;

    private final FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes;

    private final WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes;

    private final WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes;

    private final CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes;

    private final WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes;

    private final ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes;

    private final WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes;

    private final WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes;

    private final DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes;

    private final DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes;

    private final DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes;

    private final DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes;

    private final ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes;

    private final ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes;

    private final ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes;

    private final ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes;

    private final ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes;

    private final ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes;

    private final ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes;

    private final WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes;

    private final MarkerRecordedEventAttributes markerRecordedEventAttributes;

    private final RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes;

    private final TimerStartedEventAttributes timerStartedEventAttributes;

    private final TimerFiredEventAttributes timerFiredEventAttributes;

    private final TimerCanceledEventAttributes timerCanceledEventAttributes;

    private final StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes;

    private final ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes;

    private final ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes;

    private final ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes;

    private final ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes;

    private final ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes;

    private final ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes;

    private final SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes;

    private final ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes;

    private final SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes;

    private final ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes;

    private final RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes;

    private final RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes;

    private final ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes;

    private final RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes;

    private final StartTimerFailedEventAttributes startTimerFailedEventAttributes;

    private final CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes;

    private final StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes;

    private final LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes;

    private final LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes;

    private final LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes;

    private final LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes;

    private final LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes;

    private final ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes;

    private final StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes;

    private HistoryEvent(BuilderImpl builder) {
        this.eventTimestamp = builder.eventTimestamp;
        this.eventType = builder.eventType;
        this.eventId = builder.eventId;
        this.workflowExecutionStartedEventAttributes = builder.workflowExecutionStartedEventAttributes;
        this.workflowExecutionCompletedEventAttributes = builder.workflowExecutionCompletedEventAttributes;
        this.completeWorkflowExecutionFailedEventAttributes = builder.completeWorkflowExecutionFailedEventAttributes;
        this.workflowExecutionFailedEventAttributes = builder.workflowExecutionFailedEventAttributes;
        this.failWorkflowExecutionFailedEventAttributes = builder.failWorkflowExecutionFailedEventAttributes;
        this.workflowExecutionTimedOutEventAttributes = builder.workflowExecutionTimedOutEventAttributes;
        this.workflowExecutionCanceledEventAttributes = builder.workflowExecutionCanceledEventAttributes;
        this.cancelWorkflowExecutionFailedEventAttributes = builder.cancelWorkflowExecutionFailedEventAttributes;
        this.workflowExecutionContinuedAsNewEventAttributes = builder.workflowExecutionContinuedAsNewEventAttributes;
        this.continueAsNewWorkflowExecutionFailedEventAttributes = builder.continueAsNewWorkflowExecutionFailedEventAttributes;
        this.workflowExecutionTerminatedEventAttributes = builder.workflowExecutionTerminatedEventAttributes;
        this.workflowExecutionCancelRequestedEventAttributes = builder.workflowExecutionCancelRequestedEventAttributes;
        this.decisionTaskScheduledEventAttributes = builder.decisionTaskScheduledEventAttributes;
        this.decisionTaskStartedEventAttributes = builder.decisionTaskStartedEventAttributes;
        this.decisionTaskCompletedEventAttributes = builder.decisionTaskCompletedEventAttributes;
        this.decisionTaskTimedOutEventAttributes = builder.decisionTaskTimedOutEventAttributes;
        this.activityTaskScheduledEventAttributes = builder.activityTaskScheduledEventAttributes;
        this.activityTaskStartedEventAttributes = builder.activityTaskStartedEventAttributes;
        this.activityTaskCompletedEventAttributes = builder.activityTaskCompletedEventAttributes;
        this.activityTaskFailedEventAttributes = builder.activityTaskFailedEventAttributes;
        this.activityTaskTimedOutEventAttributes = builder.activityTaskTimedOutEventAttributes;
        this.activityTaskCanceledEventAttributes = builder.activityTaskCanceledEventAttributes;
        this.activityTaskCancelRequestedEventAttributes = builder.activityTaskCancelRequestedEventAttributes;
        this.workflowExecutionSignaledEventAttributes = builder.workflowExecutionSignaledEventAttributes;
        this.markerRecordedEventAttributes = builder.markerRecordedEventAttributes;
        this.recordMarkerFailedEventAttributes = builder.recordMarkerFailedEventAttributes;
        this.timerStartedEventAttributes = builder.timerStartedEventAttributes;
        this.timerFiredEventAttributes = builder.timerFiredEventAttributes;
        this.timerCanceledEventAttributes = builder.timerCanceledEventAttributes;
        this.startChildWorkflowExecutionInitiatedEventAttributes = builder.startChildWorkflowExecutionInitiatedEventAttributes;
        this.childWorkflowExecutionStartedEventAttributes = builder.childWorkflowExecutionStartedEventAttributes;
        this.childWorkflowExecutionCompletedEventAttributes = builder.childWorkflowExecutionCompletedEventAttributes;
        this.childWorkflowExecutionFailedEventAttributes = builder.childWorkflowExecutionFailedEventAttributes;
        this.childWorkflowExecutionTimedOutEventAttributes = builder.childWorkflowExecutionTimedOutEventAttributes;
        this.childWorkflowExecutionCanceledEventAttributes = builder.childWorkflowExecutionCanceledEventAttributes;
        this.childWorkflowExecutionTerminatedEventAttributes = builder.childWorkflowExecutionTerminatedEventAttributes;
        this.signalExternalWorkflowExecutionInitiatedEventAttributes = builder.signalExternalWorkflowExecutionInitiatedEventAttributes;
        this.externalWorkflowExecutionSignaledEventAttributes = builder.externalWorkflowExecutionSignaledEventAttributes;
        this.signalExternalWorkflowExecutionFailedEventAttributes = builder.signalExternalWorkflowExecutionFailedEventAttributes;
        this.externalWorkflowExecutionCancelRequestedEventAttributes = builder.externalWorkflowExecutionCancelRequestedEventAttributes;
        this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes = builder.requestCancelExternalWorkflowExecutionInitiatedEventAttributes;
        this.requestCancelExternalWorkflowExecutionFailedEventAttributes = builder.requestCancelExternalWorkflowExecutionFailedEventAttributes;
        this.scheduleActivityTaskFailedEventAttributes = builder.scheduleActivityTaskFailedEventAttributes;
        this.requestCancelActivityTaskFailedEventAttributes = builder.requestCancelActivityTaskFailedEventAttributes;
        this.startTimerFailedEventAttributes = builder.startTimerFailedEventAttributes;
        this.cancelTimerFailedEventAttributes = builder.cancelTimerFailedEventAttributes;
        this.startChildWorkflowExecutionFailedEventAttributes = builder.startChildWorkflowExecutionFailedEventAttributes;
        this.lambdaFunctionScheduledEventAttributes = builder.lambdaFunctionScheduledEventAttributes;
        this.lambdaFunctionStartedEventAttributes = builder.lambdaFunctionStartedEventAttributes;
        this.lambdaFunctionCompletedEventAttributes = builder.lambdaFunctionCompletedEventAttributes;
        this.lambdaFunctionFailedEventAttributes = builder.lambdaFunctionFailedEventAttributes;
        this.lambdaFunctionTimedOutEventAttributes = builder.lambdaFunctionTimedOutEventAttributes;
        this.scheduleLambdaFunctionFailedEventAttributes = builder.scheduleLambdaFunctionFailedEventAttributes;
        this.startLambdaFunctionFailedEventAttributes = builder.startLambdaFunctionFailedEventAttributes;
    }

    /**
     * <p>
     * The date and time when the event occurred.
     * </p>
     * 
     * @return The date and time when the event occurred.
     */
    public final Instant eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The type of the history event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of the history event.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of the history event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of the history event.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution
     * history.
     * </p>
     * 
     * @return The system generated ID of the event. This ID uniquely identifies the event with in the workflow
     *         execution history.
     */
    public final Long eventId() {
        return eventId;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes() {
        return workflowExecutionStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes() {
        return workflowExecutionCompletedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes() {
        return completeWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes() {
        return workflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes() {
        return failWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes() {
        return workflowExecutionTimedOutEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes() {
        return workflowExecutionCanceledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes() {
        return cancelWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes() {
        return workflowExecutionContinuedAsNewEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes() {
        return continueAsNewWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes() {
        return workflowExecutionTerminatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes() {
        return workflowExecutionCancelRequestedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes() {
        return decisionTaskScheduledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes() {
        return decisionTaskStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes() {
        return decisionTaskCompletedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes() {
        return decisionTaskTimedOutEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes() {
        return activityTaskScheduledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes() {
        return activityTaskStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes() {
        return activityTaskCompletedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed information
     * about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes() {
        return activityTaskFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes() {
        return activityTaskTimedOutEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes() {
        return activityTaskCanceledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes() {
        return activityTaskCancelRequestedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes() {
        return workflowExecutionSignaledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
     * about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final MarkerRecordedEventAttributes markerRecordedEventAttributes() {
        return markerRecordedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed information
     * about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes() {
        return recordMarkerFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information about
     * the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>TimerStarted</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final TimerStartedEventAttributes timerStartedEventAttributes() {
        return timerStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>TimerFired</code> then this member is set and provides detailed information about
     * the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>TimerFired</code> then this member is set and provides detailed information
     *         about the event. It isn't set for other event types.
     */
    public final TimerFiredEventAttributes timerFiredEventAttributes() {
        return timerFiredEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
     * about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final TimerCanceledEventAttributes timerCanceledEventAttributes() {
        return timerCanceledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes() {
        return startChildWorkflowExecutionInitiatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes() {
        return childWorkflowExecutionStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes() {
        return childWorkflowExecutionCompletedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes() {
        return childWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes() {
        return childWorkflowExecutionTimedOutEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes() {
        return childWorkflowExecutionCanceledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes() {
        return childWorkflowExecutionTerminatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
     * provides detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes() {
        return signalExternalWorkflowExecutionInitiatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes() {
        return externalWorkflowExecutionSignaledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes() {
        return signalExternalWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
     * provides detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes() {
        return externalWorkflowExecutionCancelRequestedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set and
     * provides detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is
     *         set and provides detailed information about the event. It isn't set for other event types.
     */
    public final RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes() {
        return requestCancelExternalWorkflowExecutionInitiatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
     * provides detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set
     *         and provides detailed information about the event. It isn't set for other event types.
     */
    public final RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes() {
        return requestCancelExternalWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
     * information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes() {
        return scheduleActivityTaskFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
     *         detailed information about the event. It isn't set for other event types.
     */
    public final RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes() {
        return requestCancelActivityTaskFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed information
     * about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final StartTimerFailedEventAttributes startTimerFailedEventAttributes() {
        return startTimerFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed information
     * about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed
     *         information about the event. It isn't set for other event types.
     */
    public final CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes() {
        return cancelTimerFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
     * detailed information about the event. It isn't set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and
     *         provides detailed information about the event. It isn't set for other event types.
     */
    public final StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes() {
        return startChildWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set for other event types.
     * </p>
     * 
     * @return Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set for other event
     *         types.
     */
    public final LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes() {
        return lambdaFunctionScheduledEventAttributes;
    }

    /**
     * <p>
     * Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for other event types.
     * </p>
     * 
     * @return Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for other event types.
     */
    public final LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes() {
        return lambdaFunctionStartedEventAttributes;
    }

    /**
     * <p>
     * Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set for other event types.
     * </p>
     * 
     * @return Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set for other event
     *         types.
     */
    public final LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes() {
        return lambdaFunctionCompletedEventAttributes;
    }

    /**
     * <p>
     * Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for other event types.
     * </p>
     * 
     * @return Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for other event types.
     */
    public final LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes() {
        return lambdaFunctionFailedEventAttributes;
    }

    /**
     * <p>
     * Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for other event types.
     * </p>
     * 
     * @return Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for other event
     *         types.
     */
    public final LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes() {
        return lambdaFunctionTimedOutEventAttributes;
    }

    /**
     * <p>
     * Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't set for other event types.
     * </p>
     * 
     * @return Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't set for other event
     *         types.
     */
    public final ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes() {
        return scheduleLambdaFunctionFailedEventAttributes;
    }

    /**
     * <p>
     * Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set for other event types.
     * </p>
     * 
     * @return Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set for other event
     *         types.
     */
    public final StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes() {
        return startLambdaFunctionFailedEventAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionStartedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionCompletedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(completeWorkflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(failWorkflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionTimedOutEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionCanceledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(cancelWorkflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionContinuedAsNewEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(continueAsNewWorkflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionTerminatedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionCancelRequestedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskScheduledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskStartedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskTimedOutEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(activityTaskScheduledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(activityTaskStartedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(activityTaskCompletedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(activityTaskFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(activityTaskTimedOutEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(activityTaskCanceledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(activityTaskCancelRequestedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionSignaledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(markerRecordedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(recordMarkerFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(timerStartedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(timerFiredEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(timerCanceledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(startChildWorkflowExecutionInitiatedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(childWorkflowExecutionStartedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(childWorkflowExecutionCompletedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(childWorkflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(childWorkflowExecutionTimedOutEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(childWorkflowExecutionCanceledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(childWorkflowExecutionTerminatedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(signalExternalWorkflowExecutionInitiatedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(externalWorkflowExecutionSignaledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(signalExternalWorkflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(externalWorkflowExecutionCancelRequestedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(requestCancelExternalWorkflowExecutionInitiatedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(requestCancelExternalWorkflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleActivityTaskFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(requestCancelActivityTaskFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(startTimerFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(cancelTimerFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(startChildWorkflowExecutionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionScheduledEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionStartedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionCompletedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionTimedOutEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleLambdaFunctionFailedEventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(startLambdaFunctionFailedEventAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryEvent)) {
            return false;
        }
        HistoryEvent other = (HistoryEvent) obj;
        return Objects.equals(eventTimestamp(), other.eventTimestamp())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(eventId(), other.eventId())
                && Objects.equals(workflowExecutionStartedEventAttributes(), other.workflowExecutionStartedEventAttributes())
                && Objects.equals(workflowExecutionCompletedEventAttributes(), other.workflowExecutionCompletedEventAttributes())
                && Objects.equals(completeWorkflowExecutionFailedEventAttributes(),
                        other.completeWorkflowExecutionFailedEventAttributes())
                && Objects.equals(workflowExecutionFailedEventAttributes(), other.workflowExecutionFailedEventAttributes())
                && Objects.equals(failWorkflowExecutionFailedEventAttributes(),
                        other.failWorkflowExecutionFailedEventAttributes())
                && Objects.equals(workflowExecutionTimedOutEventAttributes(), other.workflowExecutionTimedOutEventAttributes())
                && Objects.equals(workflowExecutionCanceledEventAttributes(), other.workflowExecutionCanceledEventAttributes())
                && Objects.equals(cancelWorkflowExecutionFailedEventAttributes(),
                        other.cancelWorkflowExecutionFailedEventAttributes())
                && Objects.equals(workflowExecutionContinuedAsNewEventAttributes(),
                        other.workflowExecutionContinuedAsNewEventAttributes())
                && Objects.equals(continueAsNewWorkflowExecutionFailedEventAttributes(),
                        other.continueAsNewWorkflowExecutionFailedEventAttributes())
                && Objects.equals(workflowExecutionTerminatedEventAttributes(),
                        other.workflowExecutionTerminatedEventAttributes())
                && Objects.equals(workflowExecutionCancelRequestedEventAttributes(),
                        other.workflowExecutionCancelRequestedEventAttributes())
                && Objects.equals(decisionTaskScheduledEventAttributes(), other.decisionTaskScheduledEventAttributes())
                && Objects.equals(decisionTaskStartedEventAttributes(), other.decisionTaskStartedEventAttributes())
                && Objects.equals(decisionTaskCompletedEventAttributes(), other.decisionTaskCompletedEventAttributes())
                && Objects.equals(decisionTaskTimedOutEventAttributes(), other.decisionTaskTimedOutEventAttributes())
                && Objects.equals(activityTaskScheduledEventAttributes(), other.activityTaskScheduledEventAttributes())
                && Objects.equals(activityTaskStartedEventAttributes(), other.activityTaskStartedEventAttributes())
                && Objects.equals(activityTaskCompletedEventAttributes(), other.activityTaskCompletedEventAttributes())
                && Objects.equals(activityTaskFailedEventAttributes(), other.activityTaskFailedEventAttributes())
                && Objects.equals(activityTaskTimedOutEventAttributes(), other.activityTaskTimedOutEventAttributes())
                && Objects.equals(activityTaskCanceledEventAttributes(), other.activityTaskCanceledEventAttributes())
                && Objects.equals(activityTaskCancelRequestedEventAttributes(),
                        other.activityTaskCancelRequestedEventAttributes())
                && Objects.equals(workflowExecutionSignaledEventAttributes(), other.workflowExecutionSignaledEventAttributes())
                && Objects.equals(markerRecordedEventAttributes(), other.markerRecordedEventAttributes())
                && Objects.equals(recordMarkerFailedEventAttributes(), other.recordMarkerFailedEventAttributes())
                && Objects.equals(timerStartedEventAttributes(), other.timerStartedEventAttributes())
                && Objects.equals(timerFiredEventAttributes(), other.timerFiredEventAttributes())
                && Objects.equals(timerCanceledEventAttributes(), other.timerCanceledEventAttributes())
                && Objects.equals(startChildWorkflowExecutionInitiatedEventAttributes(),
                        other.startChildWorkflowExecutionInitiatedEventAttributes())
                && Objects.equals(childWorkflowExecutionStartedEventAttributes(),
                        other.childWorkflowExecutionStartedEventAttributes())
                && Objects.equals(childWorkflowExecutionCompletedEventAttributes(),
                        other.childWorkflowExecutionCompletedEventAttributes())
                && Objects.equals(childWorkflowExecutionFailedEventAttributes(),
                        other.childWorkflowExecutionFailedEventAttributes())
                && Objects.equals(childWorkflowExecutionTimedOutEventAttributes(),
                        other.childWorkflowExecutionTimedOutEventAttributes())
                && Objects.equals(childWorkflowExecutionCanceledEventAttributes(),
                        other.childWorkflowExecutionCanceledEventAttributes())
                && Objects.equals(childWorkflowExecutionTerminatedEventAttributes(),
                        other.childWorkflowExecutionTerminatedEventAttributes())
                && Objects.equals(signalExternalWorkflowExecutionInitiatedEventAttributes(),
                        other.signalExternalWorkflowExecutionInitiatedEventAttributes())
                && Objects.equals(externalWorkflowExecutionSignaledEventAttributes(),
                        other.externalWorkflowExecutionSignaledEventAttributes())
                && Objects.equals(signalExternalWorkflowExecutionFailedEventAttributes(),
                        other.signalExternalWorkflowExecutionFailedEventAttributes())
                && Objects.equals(externalWorkflowExecutionCancelRequestedEventAttributes(),
                        other.externalWorkflowExecutionCancelRequestedEventAttributes())
                && Objects.equals(requestCancelExternalWorkflowExecutionInitiatedEventAttributes(),
                        other.requestCancelExternalWorkflowExecutionInitiatedEventAttributes())
                && Objects.equals(requestCancelExternalWorkflowExecutionFailedEventAttributes(),
                        other.requestCancelExternalWorkflowExecutionFailedEventAttributes())
                && Objects.equals(scheduleActivityTaskFailedEventAttributes(), other.scheduleActivityTaskFailedEventAttributes())
                && Objects.equals(requestCancelActivityTaskFailedEventAttributes(),
                        other.requestCancelActivityTaskFailedEventAttributes())
                && Objects.equals(startTimerFailedEventAttributes(), other.startTimerFailedEventAttributes())
                && Objects.equals(cancelTimerFailedEventAttributes(), other.cancelTimerFailedEventAttributes())
                && Objects.equals(startChildWorkflowExecutionFailedEventAttributes(),
                        other.startChildWorkflowExecutionFailedEventAttributes())
                && Objects.equals(lambdaFunctionScheduledEventAttributes(), other.lambdaFunctionScheduledEventAttributes())
                && Objects.equals(lambdaFunctionStartedEventAttributes(), other.lambdaFunctionStartedEventAttributes())
                && Objects.equals(lambdaFunctionCompletedEventAttributes(), other.lambdaFunctionCompletedEventAttributes())
                && Objects.equals(lambdaFunctionFailedEventAttributes(), other.lambdaFunctionFailedEventAttributes())
                && Objects.equals(lambdaFunctionTimedOutEventAttributes(), other.lambdaFunctionTimedOutEventAttributes())
                && Objects.equals(scheduleLambdaFunctionFailedEventAttributes(),
                        other.scheduleLambdaFunctionFailedEventAttributes())
                && Objects.equals(startLambdaFunctionFailedEventAttributes(), other.startLambdaFunctionFailedEventAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("HistoryEvent")
                .add("EventTimestamp", eventTimestamp())
                .add("EventType", eventTypeAsString())
                .add("EventId", eventId())
                .add("WorkflowExecutionStartedEventAttributes", workflowExecutionStartedEventAttributes())
                .add("WorkflowExecutionCompletedEventAttributes", workflowExecutionCompletedEventAttributes())
                .add("CompleteWorkflowExecutionFailedEventAttributes", completeWorkflowExecutionFailedEventAttributes())
                .add("WorkflowExecutionFailedEventAttributes", workflowExecutionFailedEventAttributes())
                .add("FailWorkflowExecutionFailedEventAttributes", failWorkflowExecutionFailedEventAttributes())
                .add("WorkflowExecutionTimedOutEventAttributes", workflowExecutionTimedOutEventAttributes())
                .add("WorkflowExecutionCanceledEventAttributes", workflowExecutionCanceledEventAttributes())
                .add("CancelWorkflowExecutionFailedEventAttributes", cancelWorkflowExecutionFailedEventAttributes())
                .add("WorkflowExecutionContinuedAsNewEventAttributes", workflowExecutionContinuedAsNewEventAttributes())
                .add("ContinueAsNewWorkflowExecutionFailedEventAttributes", continueAsNewWorkflowExecutionFailedEventAttributes())
                .add("WorkflowExecutionTerminatedEventAttributes", workflowExecutionTerminatedEventAttributes())
                .add("WorkflowExecutionCancelRequestedEventAttributes", workflowExecutionCancelRequestedEventAttributes())
                .add("DecisionTaskScheduledEventAttributes", decisionTaskScheduledEventAttributes())
                .add("DecisionTaskStartedEventAttributes", decisionTaskStartedEventAttributes())
                .add("DecisionTaskCompletedEventAttributes", decisionTaskCompletedEventAttributes())
                .add("DecisionTaskTimedOutEventAttributes", decisionTaskTimedOutEventAttributes())
                .add("ActivityTaskScheduledEventAttributes", activityTaskScheduledEventAttributes())
                .add("ActivityTaskStartedEventAttributes", activityTaskStartedEventAttributes())
                .add("ActivityTaskCompletedEventAttributes", activityTaskCompletedEventAttributes())
                .add("ActivityTaskFailedEventAttributes", activityTaskFailedEventAttributes())
                .add("ActivityTaskTimedOutEventAttributes", activityTaskTimedOutEventAttributes())
                .add("ActivityTaskCanceledEventAttributes", activityTaskCanceledEventAttributes())
                .add("ActivityTaskCancelRequestedEventAttributes", activityTaskCancelRequestedEventAttributes())
                .add("WorkflowExecutionSignaledEventAttributes", workflowExecutionSignaledEventAttributes())
                .add("MarkerRecordedEventAttributes", markerRecordedEventAttributes())
                .add("RecordMarkerFailedEventAttributes", recordMarkerFailedEventAttributes())
                .add("TimerStartedEventAttributes", timerStartedEventAttributes())
                .add("TimerFiredEventAttributes", timerFiredEventAttributes())
                .add("TimerCanceledEventAttributes", timerCanceledEventAttributes())
                .add("StartChildWorkflowExecutionInitiatedEventAttributes", startChildWorkflowExecutionInitiatedEventAttributes())
                .add("ChildWorkflowExecutionStartedEventAttributes", childWorkflowExecutionStartedEventAttributes())
                .add("ChildWorkflowExecutionCompletedEventAttributes", childWorkflowExecutionCompletedEventAttributes())
                .add("ChildWorkflowExecutionFailedEventAttributes", childWorkflowExecutionFailedEventAttributes())
                .add("ChildWorkflowExecutionTimedOutEventAttributes", childWorkflowExecutionTimedOutEventAttributes())
                .add("ChildWorkflowExecutionCanceledEventAttributes", childWorkflowExecutionCanceledEventAttributes())
                .add("ChildWorkflowExecutionTerminatedEventAttributes", childWorkflowExecutionTerminatedEventAttributes())
                .add("SignalExternalWorkflowExecutionInitiatedEventAttributes",
                        signalExternalWorkflowExecutionInitiatedEventAttributes())
                .add("ExternalWorkflowExecutionSignaledEventAttributes", externalWorkflowExecutionSignaledEventAttributes())
                .add("SignalExternalWorkflowExecutionFailedEventAttributes",
                        signalExternalWorkflowExecutionFailedEventAttributes())
                .add("ExternalWorkflowExecutionCancelRequestedEventAttributes",
                        externalWorkflowExecutionCancelRequestedEventAttributes())
                .add("RequestCancelExternalWorkflowExecutionInitiatedEventAttributes",
                        requestCancelExternalWorkflowExecutionInitiatedEventAttributes())
                .add("RequestCancelExternalWorkflowExecutionFailedEventAttributes",
                        requestCancelExternalWorkflowExecutionFailedEventAttributes())
                .add("ScheduleActivityTaskFailedEventAttributes", scheduleActivityTaskFailedEventAttributes())
                .add("RequestCancelActivityTaskFailedEventAttributes", requestCancelActivityTaskFailedEventAttributes())
                .add("StartTimerFailedEventAttributes", startTimerFailedEventAttributes())
                .add("CancelTimerFailedEventAttributes", cancelTimerFailedEventAttributes())
                .add("StartChildWorkflowExecutionFailedEventAttributes", startChildWorkflowExecutionFailedEventAttributes())
                .add("LambdaFunctionScheduledEventAttributes", lambdaFunctionScheduledEventAttributes())
                .add("LambdaFunctionStartedEventAttributes", lambdaFunctionStartedEventAttributes())
                .add("LambdaFunctionCompletedEventAttributes", lambdaFunctionCompletedEventAttributes())
                .add("LambdaFunctionFailedEventAttributes", lambdaFunctionFailedEventAttributes())
                .add("LambdaFunctionTimedOutEventAttributes", lambdaFunctionTimedOutEventAttributes())
                .add("ScheduleLambdaFunctionFailedEventAttributes", scheduleLambdaFunctionFailedEventAttributes())
                .add("StartLambdaFunctionFailedEventAttributes", startLambdaFunctionFailedEventAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "workflowExecutionStartedEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionStartedEventAttributes()));
        case "workflowExecutionCompletedEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionCompletedEventAttributes()));
        case "completeWorkflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(completeWorkflowExecutionFailedEventAttributes()));
        case "workflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionFailedEventAttributes()));
        case "failWorkflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(failWorkflowExecutionFailedEventAttributes()));
        case "workflowExecutionTimedOutEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionTimedOutEventAttributes()));
        case "workflowExecutionCanceledEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionCanceledEventAttributes()));
        case "cancelWorkflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(cancelWorkflowExecutionFailedEventAttributes()));
        case "workflowExecutionContinuedAsNewEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionContinuedAsNewEventAttributes()));
        case "continueAsNewWorkflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(continueAsNewWorkflowExecutionFailedEventAttributes()));
        case "workflowExecutionTerminatedEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionTerminatedEventAttributes()));
        case "workflowExecutionCancelRequestedEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionCancelRequestedEventAttributes()));
        case "decisionTaskScheduledEventAttributes":
            return Optional.ofNullable(clazz.cast(decisionTaskScheduledEventAttributes()));
        case "decisionTaskStartedEventAttributes":
            return Optional.ofNullable(clazz.cast(decisionTaskStartedEventAttributes()));
        case "decisionTaskCompletedEventAttributes":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventAttributes()));
        case "decisionTaskTimedOutEventAttributes":
            return Optional.ofNullable(clazz.cast(decisionTaskTimedOutEventAttributes()));
        case "activityTaskScheduledEventAttributes":
            return Optional.ofNullable(clazz.cast(activityTaskScheduledEventAttributes()));
        case "activityTaskStartedEventAttributes":
            return Optional.ofNullable(clazz.cast(activityTaskStartedEventAttributes()));
        case "activityTaskCompletedEventAttributes":
            return Optional.ofNullable(clazz.cast(activityTaskCompletedEventAttributes()));
        case "activityTaskFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(activityTaskFailedEventAttributes()));
        case "activityTaskTimedOutEventAttributes":
            return Optional.ofNullable(clazz.cast(activityTaskTimedOutEventAttributes()));
        case "activityTaskCanceledEventAttributes":
            return Optional.ofNullable(clazz.cast(activityTaskCanceledEventAttributes()));
        case "activityTaskCancelRequestedEventAttributes":
            return Optional.ofNullable(clazz.cast(activityTaskCancelRequestedEventAttributes()));
        case "workflowExecutionSignaledEventAttributes":
            return Optional.ofNullable(clazz.cast(workflowExecutionSignaledEventAttributes()));
        case "markerRecordedEventAttributes":
            return Optional.ofNullable(clazz.cast(markerRecordedEventAttributes()));
        case "recordMarkerFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(recordMarkerFailedEventAttributes()));
        case "timerStartedEventAttributes":
            return Optional.ofNullable(clazz.cast(timerStartedEventAttributes()));
        case "timerFiredEventAttributes":
            return Optional.ofNullable(clazz.cast(timerFiredEventAttributes()));
        case "timerCanceledEventAttributes":
            return Optional.ofNullable(clazz.cast(timerCanceledEventAttributes()));
        case "startChildWorkflowExecutionInitiatedEventAttributes":
            return Optional.ofNullable(clazz.cast(startChildWorkflowExecutionInitiatedEventAttributes()));
        case "childWorkflowExecutionStartedEventAttributes":
            return Optional.ofNullable(clazz.cast(childWorkflowExecutionStartedEventAttributes()));
        case "childWorkflowExecutionCompletedEventAttributes":
            return Optional.ofNullable(clazz.cast(childWorkflowExecutionCompletedEventAttributes()));
        case "childWorkflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(childWorkflowExecutionFailedEventAttributes()));
        case "childWorkflowExecutionTimedOutEventAttributes":
            return Optional.ofNullable(clazz.cast(childWorkflowExecutionTimedOutEventAttributes()));
        case "childWorkflowExecutionCanceledEventAttributes":
            return Optional.ofNullable(clazz.cast(childWorkflowExecutionCanceledEventAttributes()));
        case "childWorkflowExecutionTerminatedEventAttributes":
            return Optional.ofNullable(clazz.cast(childWorkflowExecutionTerminatedEventAttributes()));
        case "signalExternalWorkflowExecutionInitiatedEventAttributes":
            return Optional.ofNullable(clazz.cast(signalExternalWorkflowExecutionInitiatedEventAttributes()));
        case "externalWorkflowExecutionSignaledEventAttributes":
            return Optional.ofNullable(clazz.cast(externalWorkflowExecutionSignaledEventAttributes()));
        case "signalExternalWorkflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(signalExternalWorkflowExecutionFailedEventAttributes()));
        case "externalWorkflowExecutionCancelRequestedEventAttributes":
            return Optional.ofNullable(clazz.cast(externalWorkflowExecutionCancelRequestedEventAttributes()));
        case "requestCancelExternalWorkflowExecutionInitiatedEventAttributes":
            return Optional.ofNullable(clazz.cast(requestCancelExternalWorkflowExecutionInitiatedEventAttributes()));
        case "requestCancelExternalWorkflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(requestCancelExternalWorkflowExecutionFailedEventAttributes()));
        case "scheduleActivityTaskFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(scheduleActivityTaskFailedEventAttributes()));
        case "requestCancelActivityTaskFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(requestCancelActivityTaskFailedEventAttributes()));
        case "startTimerFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(startTimerFailedEventAttributes()));
        case "cancelTimerFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(cancelTimerFailedEventAttributes()));
        case "startChildWorkflowExecutionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(startChildWorkflowExecutionFailedEventAttributes()));
        case "lambdaFunctionScheduledEventAttributes":
            return Optional.ofNullable(clazz.cast(lambdaFunctionScheduledEventAttributes()));
        case "lambdaFunctionStartedEventAttributes":
            return Optional.ofNullable(clazz.cast(lambdaFunctionStartedEventAttributes()));
        case "lambdaFunctionCompletedEventAttributes":
            return Optional.ofNullable(clazz.cast(lambdaFunctionCompletedEventAttributes()));
        case "lambdaFunctionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(lambdaFunctionFailedEventAttributes()));
        case "lambdaFunctionTimedOutEventAttributes":
            return Optional.ofNullable(clazz.cast(lambdaFunctionTimedOutEventAttributes()));
        case "scheduleLambdaFunctionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(scheduleLambdaFunctionFailedEventAttributes()));
        case "startLambdaFunctionFailedEventAttributes":
            return Optional.ofNullable(clazz.cast(startLambdaFunctionFailedEventAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoryEvent, T> g) {
        return obj -> g.apply((HistoryEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistoryEvent> {
        /**
         * <p>
         * The date and time when the event occurred.
         * </p>
         * 
         * @param eventTimestamp
         *        The date and time when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(Instant eventTimestamp);

        /**
         * <p>
         * The type of the history event.
         * </p>
         * 
         * @param eventType
         *        The type of the history event.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of the history event.
         * </p>
         * 
         * @param eventType
         *        The type of the history event.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution
         * history.
         * </p>
         * 
         * @param eventId
         *        The system generated ID of the event. This ID uniquely identifies the event with in the workflow
         *        execution history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(Long eventId);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionStartedEventAttributes
         *        If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionStartedEventAttributes(
                WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionStartedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionStartedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionStartedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #workflowExecutionStartedEventAttributes(WorkflowExecutionStartedEventAttributes)}.
         * 
         * @param workflowExecutionStartedEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionStartedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionStartedEventAttributes(WorkflowExecutionStartedEventAttributes)
         */
        default Builder workflowExecutionStartedEventAttributes(
                Consumer<WorkflowExecutionStartedEventAttributes.Builder> workflowExecutionStartedEventAttributes) {
            return workflowExecutionStartedEventAttributes(WorkflowExecutionStartedEventAttributes.builder()
                    .applyMutation(workflowExecutionStartedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionCompletedEventAttributes
         *        If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionCompletedEventAttributes(
                WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionCompletedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionCompletedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionCompletedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #workflowExecutionCompletedEventAttributes(WorkflowExecutionCompletedEventAttributes)}.
         * 
         * @param workflowExecutionCompletedEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionCompletedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionCompletedEventAttributes(WorkflowExecutionCompletedEventAttributes)
         */
        default Builder workflowExecutionCompletedEventAttributes(
                Consumer<WorkflowExecutionCompletedEventAttributes.Builder> workflowExecutionCompletedEventAttributes) {
            return workflowExecutionCompletedEventAttributes(WorkflowExecutionCompletedEventAttributes.builder()
                    .applyMutation(workflowExecutionCompletedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param completeWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completeWorkflowExecutionFailedEventAttributes(
                CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CompleteWorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link CompleteWorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompleteWorkflowExecutionFailedEventAttributes.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #completeWorkflowExecutionFailedEventAttributes(CompleteWorkflowExecutionFailedEventAttributes)}.
         * 
         * @param completeWorkflowExecutionFailedEventAttributes
         *        a consumer that will call methods on {@link CompleteWorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completeWorkflowExecutionFailedEventAttributes(CompleteWorkflowExecutionFailedEventAttributes)
         */
        default Builder completeWorkflowExecutionFailedEventAttributes(
                Consumer<CompleteWorkflowExecutionFailedEventAttributes.Builder> completeWorkflowExecutionFailedEventAttributes) {
            return completeWorkflowExecutionFailedEventAttributes(CompleteWorkflowExecutionFailedEventAttributes.builder()
                    .applyMutation(completeWorkflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionFailedEventAttributes
         *        If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionFailedEventAttributes(
                WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionFailedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #workflowExecutionFailedEventAttributes(WorkflowExecutionFailedEventAttributes)}.
         * 
         * @param workflowExecutionFailedEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionFailedEventAttributes(WorkflowExecutionFailedEventAttributes)
         */
        default Builder workflowExecutionFailedEventAttributes(
                Consumer<WorkflowExecutionFailedEventAttributes.Builder> workflowExecutionFailedEventAttributes) {
            return workflowExecutionFailedEventAttributes(WorkflowExecutionFailedEventAttributes.builder()
                    .applyMutation(workflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param failWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failWorkflowExecutionFailedEventAttributes(
                FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FailWorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link FailWorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailWorkflowExecutionFailedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #failWorkflowExecutionFailedEventAttributes(FailWorkflowExecutionFailedEventAttributes)}.
         * 
         * @param failWorkflowExecutionFailedEventAttributes
         *        a consumer that will call methods on {@link FailWorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failWorkflowExecutionFailedEventAttributes(FailWorkflowExecutionFailedEventAttributes)
         */
        default Builder failWorkflowExecutionFailedEventAttributes(
                Consumer<FailWorkflowExecutionFailedEventAttributes.Builder> failWorkflowExecutionFailedEventAttributes) {
            return failWorkflowExecutionFailedEventAttributes(FailWorkflowExecutionFailedEventAttributes.builder()
                    .applyMutation(failWorkflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionTimedOutEventAttributes
         *        If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionTimedOutEventAttributes(
                WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionTimedOutEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionTimedOutEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionTimedOutEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #workflowExecutionTimedOutEventAttributes(WorkflowExecutionTimedOutEventAttributes)}.
         * 
         * @param workflowExecutionTimedOutEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionTimedOutEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionTimedOutEventAttributes(WorkflowExecutionTimedOutEventAttributes)
         */
        default Builder workflowExecutionTimedOutEventAttributes(
                Consumer<WorkflowExecutionTimedOutEventAttributes.Builder> workflowExecutionTimedOutEventAttributes) {
            return workflowExecutionTimedOutEventAttributes(WorkflowExecutionTimedOutEventAttributes.builder()
                    .applyMutation(workflowExecutionTimedOutEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionCanceledEventAttributes
         *        If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionCanceledEventAttributes(
                WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionCanceledEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionCanceledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionCanceledEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #workflowExecutionCanceledEventAttributes(WorkflowExecutionCanceledEventAttributes)}.
         * 
         * @param workflowExecutionCanceledEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionCanceledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionCanceledEventAttributes(WorkflowExecutionCanceledEventAttributes)
         */
        default Builder workflowExecutionCanceledEventAttributes(
                Consumer<WorkflowExecutionCanceledEventAttributes.Builder> workflowExecutionCanceledEventAttributes) {
            return workflowExecutionCanceledEventAttributes(WorkflowExecutionCanceledEventAttributes.builder()
                    .applyMutation(workflowExecutionCanceledEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param cancelWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelWorkflowExecutionFailedEventAttributes(
                CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CancelWorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link CancelWorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CancelWorkflowExecutionFailedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #cancelWorkflowExecutionFailedEventAttributes(CancelWorkflowExecutionFailedEventAttributes)}.
         * 
         * @param cancelWorkflowExecutionFailedEventAttributes
         *        a consumer that will call methods on {@link CancelWorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cancelWorkflowExecutionFailedEventAttributes(CancelWorkflowExecutionFailedEventAttributes)
         */
        default Builder cancelWorkflowExecutionFailedEventAttributes(
                Consumer<CancelWorkflowExecutionFailedEventAttributes.Builder> cancelWorkflowExecutionFailedEventAttributes) {
            return cancelWorkflowExecutionFailedEventAttributes(CancelWorkflowExecutionFailedEventAttributes.builder()
                    .applyMutation(cancelWorkflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionContinuedAsNewEventAttributes
         *        If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionContinuedAsNewEventAttributes(
                WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionContinuedAsNewEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionContinuedAsNewEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionContinuedAsNewEventAttributes.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #workflowExecutionContinuedAsNewEventAttributes(WorkflowExecutionContinuedAsNewEventAttributes)}.
         * 
         * @param workflowExecutionContinuedAsNewEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionContinuedAsNewEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionContinuedAsNewEventAttributes(WorkflowExecutionContinuedAsNewEventAttributes)
         */
        default Builder workflowExecutionContinuedAsNewEventAttributes(
                Consumer<WorkflowExecutionContinuedAsNewEventAttributes.Builder> workflowExecutionContinuedAsNewEventAttributes) {
            return workflowExecutionContinuedAsNewEventAttributes(WorkflowExecutionContinuedAsNewEventAttributes.builder()
                    .applyMutation(workflowExecutionContinuedAsNewEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param continueAsNewWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continueAsNewWorkflowExecutionFailedEventAttributes(
                ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContinueAsNewWorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one manually
         * via {@link ContinueAsNewWorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link ContinueAsNewWorkflowExecutionFailedEventAttributes.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #continueAsNewWorkflowExecutionFailedEventAttributes(ContinueAsNewWorkflowExecutionFailedEventAttributes)}.
         * 
         * @param continueAsNewWorkflowExecutionFailedEventAttributes
         *        a consumer that will call methods on
         *        {@link ContinueAsNewWorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continueAsNewWorkflowExecutionFailedEventAttributes(ContinueAsNewWorkflowExecutionFailedEventAttributes)
         */
        default Builder continueAsNewWorkflowExecutionFailedEventAttributes(
                Consumer<ContinueAsNewWorkflowExecutionFailedEventAttributes.Builder> continueAsNewWorkflowExecutionFailedEventAttributes) {
            return continueAsNewWorkflowExecutionFailedEventAttributes(ContinueAsNewWorkflowExecutionFailedEventAttributes
                    .builder().applyMutation(continueAsNewWorkflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionTerminatedEventAttributes
         *        If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionTerminatedEventAttributes(
                WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionTerminatedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionTerminatedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionTerminatedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #workflowExecutionTerminatedEventAttributes(WorkflowExecutionTerminatedEventAttributes)}.
         * 
         * @param workflowExecutionTerminatedEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionTerminatedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionTerminatedEventAttributes(WorkflowExecutionTerminatedEventAttributes)
         */
        default Builder workflowExecutionTerminatedEventAttributes(
                Consumer<WorkflowExecutionTerminatedEventAttributes.Builder> workflowExecutionTerminatedEventAttributes) {
            return workflowExecutionTerminatedEventAttributes(WorkflowExecutionTerminatedEventAttributes.builder()
                    .applyMutation(workflowExecutionTerminatedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionCancelRequestedEventAttributes
         *        If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionCancelRequestedEventAttributes(
                WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionCancelRequestedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionCancelRequestedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionCancelRequestedEventAttributes.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #workflowExecutionCancelRequestedEventAttributes(WorkflowExecutionCancelRequestedEventAttributes)}.
         * 
         * @param workflowExecutionCancelRequestedEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionCancelRequestedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionCancelRequestedEventAttributes(WorkflowExecutionCancelRequestedEventAttributes)
         */
        default Builder workflowExecutionCancelRequestedEventAttributes(
                Consumer<WorkflowExecutionCancelRequestedEventAttributes.Builder> workflowExecutionCancelRequestedEventAttributes) {
            return workflowExecutionCancelRequestedEventAttributes(WorkflowExecutionCancelRequestedEventAttributes.builder()
                    .applyMutation(workflowExecutionCancelRequestedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param decisionTaskScheduledEventAttributes
         *        If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskScheduledEventAttributes(DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DecisionTaskScheduledEventAttributes.Builder} avoiding the need to create one manually via
         * {@link DecisionTaskScheduledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecisionTaskScheduledEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #decisionTaskScheduledEventAttributes(DecisionTaskScheduledEventAttributes)}.
         * 
         * @param decisionTaskScheduledEventAttributes
         *        a consumer that will call methods on {@link DecisionTaskScheduledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decisionTaskScheduledEventAttributes(DecisionTaskScheduledEventAttributes)
         */
        default Builder decisionTaskScheduledEventAttributes(
                Consumer<DecisionTaskScheduledEventAttributes.Builder> decisionTaskScheduledEventAttributes) {
            return decisionTaskScheduledEventAttributes(DecisionTaskScheduledEventAttributes.builder()
                    .applyMutation(decisionTaskScheduledEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param decisionTaskStartedEventAttributes
         *        If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskStartedEventAttributes(DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DecisionTaskStartedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link DecisionTaskStartedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecisionTaskStartedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #decisionTaskStartedEventAttributes(DecisionTaskStartedEventAttributes)}.
         * 
         * @param decisionTaskStartedEventAttributes
         *        a consumer that will call methods on {@link DecisionTaskStartedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decisionTaskStartedEventAttributes(DecisionTaskStartedEventAttributes)
         */
        default Builder decisionTaskStartedEventAttributes(
                Consumer<DecisionTaskStartedEventAttributes.Builder> decisionTaskStartedEventAttributes) {
            return decisionTaskStartedEventAttributes(DecisionTaskStartedEventAttributes.builder()
                    .applyMutation(decisionTaskStartedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param decisionTaskCompletedEventAttributes
         *        If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventAttributes(DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DecisionTaskCompletedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link DecisionTaskCompletedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecisionTaskCompletedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #decisionTaskCompletedEventAttributes(DecisionTaskCompletedEventAttributes)}.
         * 
         * @param decisionTaskCompletedEventAttributes
         *        a consumer that will call methods on {@link DecisionTaskCompletedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decisionTaskCompletedEventAttributes(DecisionTaskCompletedEventAttributes)
         */
        default Builder decisionTaskCompletedEventAttributes(
                Consumer<DecisionTaskCompletedEventAttributes.Builder> decisionTaskCompletedEventAttributes) {
            return decisionTaskCompletedEventAttributes(DecisionTaskCompletedEventAttributes.builder()
                    .applyMutation(decisionTaskCompletedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param decisionTaskTimedOutEventAttributes
         *        If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskTimedOutEventAttributes(DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DecisionTaskTimedOutEventAttributes.Builder} avoiding the need to create one manually via
         * {@link DecisionTaskTimedOutEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecisionTaskTimedOutEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #decisionTaskTimedOutEventAttributes(DecisionTaskTimedOutEventAttributes)}.
         * 
         * @param decisionTaskTimedOutEventAttributes
         *        a consumer that will call methods on {@link DecisionTaskTimedOutEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decisionTaskTimedOutEventAttributes(DecisionTaskTimedOutEventAttributes)
         */
        default Builder decisionTaskTimedOutEventAttributes(
                Consumer<DecisionTaskTimedOutEventAttributes.Builder> decisionTaskTimedOutEventAttributes) {
            return decisionTaskTimedOutEventAttributes(DecisionTaskTimedOutEventAttributes.builder()
                    .applyMutation(decisionTaskTimedOutEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param activityTaskScheduledEventAttributes
         *        If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskScheduledEventAttributes(ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ActivityTaskScheduledEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ActivityTaskScheduledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityTaskScheduledEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activityTaskScheduledEventAttributes(ActivityTaskScheduledEventAttributes)}.
         * 
         * @param activityTaskScheduledEventAttributes
         *        a consumer that will call methods on {@link ActivityTaskScheduledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityTaskScheduledEventAttributes(ActivityTaskScheduledEventAttributes)
         */
        default Builder activityTaskScheduledEventAttributes(
                Consumer<ActivityTaskScheduledEventAttributes.Builder> activityTaskScheduledEventAttributes) {
            return activityTaskScheduledEventAttributes(ActivityTaskScheduledEventAttributes.builder()
                    .applyMutation(activityTaskScheduledEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param activityTaskStartedEventAttributes
         *        If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskStartedEventAttributes(ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ActivityTaskStartedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ActivityTaskStartedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityTaskStartedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activityTaskStartedEventAttributes(ActivityTaskStartedEventAttributes)}.
         * 
         * @param activityTaskStartedEventAttributes
         *        a consumer that will call methods on {@link ActivityTaskStartedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityTaskStartedEventAttributes(ActivityTaskStartedEventAttributes)
         */
        default Builder activityTaskStartedEventAttributes(
                Consumer<ActivityTaskStartedEventAttributes.Builder> activityTaskStartedEventAttributes) {
            return activityTaskStartedEventAttributes(ActivityTaskStartedEventAttributes.builder()
                    .applyMutation(activityTaskStartedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param activityTaskCompletedEventAttributes
         *        If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskCompletedEventAttributes(ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ActivityTaskCompletedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ActivityTaskCompletedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityTaskCompletedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activityTaskCompletedEventAttributes(ActivityTaskCompletedEventAttributes)}.
         * 
         * @param activityTaskCompletedEventAttributes
         *        a consumer that will call methods on {@link ActivityTaskCompletedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityTaskCompletedEventAttributes(ActivityTaskCompletedEventAttributes)
         */
        default Builder activityTaskCompletedEventAttributes(
                Consumer<ActivityTaskCompletedEventAttributes.Builder> activityTaskCompletedEventAttributes) {
            return activityTaskCompletedEventAttributes(ActivityTaskCompletedEventAttributes.builder()
                    .applyMutation(activityTaskCompletedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param activityTaskFailedEventAttributes
         *        If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskFailedEventAttributes(ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ActivityTaskFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ActivityTaskFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityTaskFailedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activityTaskFailedEventAttributes(ActivityTaskFailedEventAttributes)}.
         * 
         * @param activityTaskFailedEventAttributes
         *        a consumer that will call methods on {@link ActivityTaskFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityTaskFailedEventAttributes(ActivityTaskFailedEventAttributes)
         */
        default Builder activityTaskFailedEventAttributes(
                Consumer<ActivityTaskFailedEventAttributes.Builder> activityTaskFailedEventAttributes) {
            return activityTaskFailedEventAttributes(ActivityTaskFailedEventAttributes.builder()
                    .applyMutation(activityTaskFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param activityTaskTimedOutEventAttributes
         *        If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskTimedOutEventAttributes(ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ActivityTaskTimedOutEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ActivityTaskTimedOutEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityTaskTimedOutEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activityTaskTimedOutEventAttributes(ActivityTaskTimedOutEventAttributes)}.
         * 
         * @param activityTaskTimedOutEventAttributes
         *        a consumer that will call methods on {@link ActivityTaskTimedOutEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityTaskTimedOutEventAttributes(ActivityTaskTimedOutEventAttributes)
         */
        default Builder activityTaskTimedOutEventAttributes(
                Consumer<ActivityTaskTimedOutEventAttributes.Builder> activityTaskTimedOutEventAttributes) {
            return activityTaskTimedOutEventAttributes(ActivityTaskTimedOutEventAttributes.builder()
                    .applyMutation(activityTaskTimedOutEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param activityTaskCanceledEventAttributes
         *        If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskCanceledEventAttributes(ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ActivityTaskCanceledEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ActivityTaskCanceledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityTaskCanceledEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activityTaskCanceledEventAttributes(ActivityTaskCanceledEventAttributes)}.
         * 
         * @param activityTaskCanceledEventAttributes
         *        a consumer that will call methods on {@link ActivityTaskCanceledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityTaskCanceledEventAttributes(ActivityTaskCanceledEventAttributes)
         */
        default Builder activityTaskCanceledEventAttributes(
                Consumer<ActivityTaskCanceledEventAttributes.Builder> activityTaskCanceledEventAttributes) {
            return activityTaskCanceledEventAttributes(ActivityTaskCanceledEventAttributes.builder()
                    .applyMutation(activityTaskCanceledEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param activityTaskCancelRequestedEventAttributes
         *        If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskCancelRequestedEventAttributes(
                ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ActivityTaskCancelRequestedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ActivityTaskCancelRequestedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityTaskCancelRequestedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #activityTaskCancelRequestedEventAttributes(ActivityTaskCancelRequestedEventAttributes)}.
         * 
         * @param activityTaskCancelRequestedEventAttributes
         *        a consumer that will call methods on {@link ActivityTaskCancelRequestedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityTaskCancelRequestedEventAttributes(ActivityTaskCancelRequestedEventAttributes)
         */
        default Builder activityTaskCancelRequestedEventAttributes(
                Consumer<ActivityTaskCancelRequestedEventAttributes.Builder> activityTaskCancelRequestedEventAttributes) {
            return activityTaskCancelRequestedEventAttributes(ActivityTaskCancelRequestedEventAttributes.builder()
                    .applyMutation(activityTaskCancelRequestedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param workflowExecutionSignaledEventAttributes
         *        If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionSignaledEventAttributes(
                WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowExecutionSignaledEventAttributes.Builder} avoiding the need to create one manually via
         * {@link WorkflowExecutionSignaledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionSignaledEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #workflowExecutionSignaledEventAttributes(WorkflowExecutionSignaledEventAttributes)}.
         * 
         * @param workflowExecutionSignaledEventAttributes
         *        a consumer that will call methods on {@link WorkflowExecutionSignaledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutionSignaledEventAttributes(WorkflowExecutionSignaledEventAttributes)
         */
        default Builder workflowExecutionSignaledEventAttributes(
                Consumer<WorkflowExecutionSignaledEventAttributes.Builder> workflowExecutionSignaledEventAttributes) {
            return workflowExecutionSignaledEventAttributes(WorkflowExecutionSignaledEventAttributes.builder()
                    .applyMutation(workflowExecutionSignaledEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
         * about the event. It isn't set for other event types.
         * </p>
         * 
         * @param markerRecordedEventAttributes
         *        If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markerRecordedEventAttributes(MarkerRecordedEventAttributes markerRecordedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
         * about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the {@link MarkerRecordedEventAttributes.Builder}
         * avoiding the need to create one manually via {@link MarkerRecordedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MarkerRecordedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #markerRecordedEventAttributes(MarkerRecordedEventAttributes)}.
         * 
         * @param markerRecordedEventAttributes
         *        a consumer that will call methods on {@link MarkerRecordedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #markerRecordedEventAttributes(MarkerRecordedEventAttributes)
         */
        default Builder markerRecordedEventAttributes(
                Consumer<MarkerRecordedEventAttributes.Builder> markerRecordedEventAttributes) {
            return markerRecordedEventAttributes(MarkerRecordedEventAttributes.builder()
                    .applyMutation(markerRecordedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param recordMarkerFailedEventAttributes
         *        If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecordMarkerFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link RecordMarkerFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordMarkerFailedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #recordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributes)}.
         * 
         * @param recordMarkerFailedEventAttributes
         *        a consumer that will call methods on {@link RecordMarkerFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributes)
         */
        default Builder recordMarkerFailedEventAttributes(
                Consumer<RecordMarkerFailedEventAttributes.Builder> recordMarkerFailedEventAttributes) {
            return recordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributes.builder()
                    .applyMutation(recordMarkerFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information
         * about the event. It isn't set for other event types.
         * </p>
         * 
         * @param timerStartedEventAttributes
         *        If the event is of type <code>TimerStarted</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerStartedEventAttributes(TimerStartedEventAttributes timerStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information
         * about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimerStartedEventAttributes.Builder}
         * avoiding the need to create one manually via {@link TimerStartedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimerStartedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #timerStartedEventAttributes(TimerStartedEventAttributes)}.
         * 
         * @param timerStartedEventAttributes
         *        a consumer that will call methods on {@link TimerStartedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timerStartedEventAttributes(TimerStartedEventAttributes)
         */
        default Builder timerStartedEventAttributes(Consumer<TimerStartedEventAttributes.Builder> timerStartedEventAttributes) {
            return timerStartedEventAttributes(TimerStartedEventAttributes.builder().applyMutation(timerStartedEventAttributes)
                    .build());
        }

        /**
         * <p>
         * If the event is of type <code>TimerFired</code> then this member is set and provides detailed information
         * about the event. It isn't set for other event types.
         * </p>
         * 
         * @param timerFiredEventAttributes
         *        If the event is of type <code>TimerFired</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerFiredEventAttributes(TimerFiredEventAttributes timerFiredEventAttributes);

        /**
         * <p>
         * If the event is of type <code>TimerFired</code> then this member is set and provides detailed information
         * about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimerFiredEventAttributes.Builder}
         * avoiding the need to create one manually via {@link TimerFiredEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimerFiredEventAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #timerFiredEventAttributes(TimerFiredEventAttributes)}.
         * 
         * @param timerFiredEventAttributes
         *        a consumer that will call methods on {@link TimerFiredEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timerFiredEventAttributes(TimerFiredEventAttributes)
         */
        default Builder timerFiredEventAttributes(Consumer<TimerFiredEventAttributes.Builder> timerFiredEventAttributes) {
            return timerFiredEventAttributes(TimerFiredEventAttributes.builder().applyMutation(timerFiredEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
         * about the event. It isn't set for other event types.
         * </p>
         * 
         * @param timerCanceledEventAttributes
         *        If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerCanceledEventAttributes(TimerCanceledEventAttributes timerCanceledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
         * about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimerCanceledEventAttributes.Builder}
         * avoiding the need to create one manually via {@link TimerCanceledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimerCanceledEventAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #timerCanceledEventAttributes(TimerCanceledEventAttributes)}.
         * 
         * @param timerCanceledEventAttributes
         *        a consumer that will call methods on {@link TimerCanceledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timerCanceledEventAttributes(TimerCanceledEventAttributes)
         */
        default Builder timerCanceledEventAttributes(Consumer<TimerCanceledEventAttributes.Builder> timerCanceledEventAttributes) {
            return timerCanceledEventAttributes(TimerCanceledEventAttributes.builder()
                    .applyMutation(timerCanceledEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param startChildWorkflowExecutionInitiatedEventAttributes
         *        If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startChildWorkflowExecutionInitiatedEventAttributes(
                StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StartChildWorkflowExecutionInitiatedEventAttributes.Builder} avoiding the need to create one manually
         * via {@link StartChildWorkflowExecutionInitiatedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link StartChildWorkflowExecutionInitiatedEventAttributes.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #startChildWorkflowExecutionInitiatedEventAttributes(StartChildWorkflowExecutionInitiatedEventAttributes)}.
         * 
         * @param startChildWorkflowExecutionInitiatedEventAttributes
         *        a consumer that will call methods on
         *        {@link StartChildWorkflowExecutionInitiatedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startChildWorkflowExecutionInitiatedEventAttributes(StartChildWorkflowExecutionInitiatedEventAttributes)
         */
        default Builder startChildWorkflowExecutionInitiatedEventAttributes(
                Consumer<StartChildWorkflowExecutionInitiatedEventAttributes.Builder> startChildWorkflowExecutionInitiatedEventAttributes) {
            return startChildWorkflowExecutionInitiatedEventAttributes(StartChildWorkflowExecutionInitiatedEventAttributes
                    .builder().applyMutation(startChildWorkflowExecutionInitiatedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionStartedEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionStartedEventAttributes(
                ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChildWorkflowExecutionStartedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ChildWorkflowExecutionStartedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChildWorkflowExecutionStartedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #childWorkflowExecutionStartedEventAttributes(ChildWorkflowExecutionStartedEventAttributes)}.
         * 
         * @param childWorkflowExecutionStartedEventAttributes
         *        a consumer that will call methods on {@link ChildWorkflowExecutionStartedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childWorkflowExecutionStartedEventAttributes(ChildWorkflowExecutionStartedEventAttributes)
         */
        default Builder childWorkflowExecutionStartedEventAttributes(
                Consumer<ChildWorkflowExecutionStartedEventAttributes.Builder> childWorkflowExecutionStartedEventAttributes) {
            return childWorkflowExecutionStartedEventAttributes(ChildWorkflowExecutionStartedEventAttributes.builder()
                    .applyMutation(childWorkflowExecutionStartedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionCompletedEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionCompletedEventAttributes(
                ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChildWorkflowExecutionCompletedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ChildWorkflowExecutionCompletedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChildWorkflowExecutionCompletedEventAttributes.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #childWorkflowExecutionCompletedEventAttributes(ChildWorkflowExecutionCompletedEventAttributes)}.
         * 
         * @param childWorkflowExecutionCompletedEventAttributes
         *        a consumer that will call methods on {@link ChildWorkflowExecutionCompletedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childWorkflowExecutionCompletedEventAttributes(ChildWorkflowExecutionCompletedEventAttributes)
         */
        default Builder childWorkflowExecutionCompletedEventAttributes(
                Consumer<ChildWorkflowExecutionCompletedEventAttributes.Builder> childWorkflowExecutionCompletedEventAttributes) {
            return childWorkflowExecutionCompletedEventAttributes(ChildWorkflowExecutionCompletedEventAttributes.builder()
                    .applyMutation(childWorkflowExecutionCompletedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionFailedEventAttributes(
                ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChildWorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ChildWorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChildWorkflowExecutionFailedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #childWorkflowExecutionFailedEventAttributes(ChildWorkflowExecutionFailedEventAttributes)}.
         * 
         * @param childWorkflowExecutionFailedEventAttributes
         *        a consumer that will call methods on {@link ChildWorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childWorkflowExecutionFailedEventAttributes(ChildWorkflowExecutionFailedEventAttributes)
         */
        default Builder childWorkflowExecutionFailedEventAttributes(
                Consumer<ChildWorkflowExecutionFailedEventAttributes.Builder> childWorkflowExecutionFailedEventAttributes) {
            return childWorkflowExecutionFailedEventAttributes(ChildWorkflowExecutionFailedEventAttributes.builder()
                    .applyMutation(childWorkflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionTimedOutEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionTimedOutEventAttributes(
                ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChildWorkflowExecutionTimedOutEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ChildWorkflowExecutionTimedOutEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChildWorkflowExecutionTimedOutEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #childWorkflowExecutionTimedOutEventAttributes(ChildWorkflowExecutionTimedOutEventAttributes)}.
         * 
         * @param childWorkflowExecutionTimedOutEventAttributes
         *        a consumer that will call methods on {@link ChildWorkflowExecutionTimedOutEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childWorkflowExecutionTimedOutEventAttributes(ChildWorkflowExecutionTimedOutEventAttributes)
         */
        default Builder childWorkflowExecutionTimedOutEventAttributes(
                Consumer<ChildWorkflowExecutionTimedOutEventAttributes.Builder> childWorkflowExecutionTimedOutEventAttributes) {
            return childWorkflowExecutionTimedOutEventAttributes(ChildWorkflowExecutionTimedOutEventAttributes.builder()
                    .applyMutation(childWorkflowExecutionTimedOutEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionCanceledEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionCanceledEventAttributes(
                ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChildWorkflowExecutionCanceledEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ChildWorkflowExecutionCanceledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChildWorkflowExecutionCanceledEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #childWorkflowExecutionCanceledEventAttributes(ChildWorkflowExecutionCanceledEventAttributes)}.
         * 
         * @param childWorkflowExecutionCanceledEventAttributes
         *        a consumer that will call methods on {@link ChildWorkflowExecutionCanceledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childWorkflowExecutionCanceledEventAttributes(ChildWorkflowExecutionCanceledEventAttributes)
         */
        default Builder childWorkflowExecutionCanceledEventAttributes(
                Consumer<ChildWorkflowExecutionCanceledEventAttributes.Builder> childWorkflowExecutionCanceledEventAttributes) {
            return childWorkflowExecutionCanceledEventAttributes(ChildWorkflowExecutionCanceledEventAttributes.builder()
                    .applyMutation(childWorkflowExecutionCanceledEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionTerminatedEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionTerminatedEventAttributes(
                ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChildWorkflowExecutionTerminatedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ChildWorkflowExecutionTerminatedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChildWorkflowExecutionTerminatedEventAttributes.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #childWorkflowExecutionTerminatedEventAttributes(ChildWorkflowExecutionTerminatedEventAttributes)}.
         * 
         * @param childWorkflowExecutionTerminatedEventAttributes
         *        a consumer that will call methods on {@link ChildWorkflowExecutionTerminatedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childWorkflowExecutionTerminatedEventAttributes(ChildWorkflowExecutionTerminatedEventAttributes)
         */
        default Builder childWorkflowExecutionTerminatedEventAttributes(
                Consumer<ChildWorkflowExecutionTerminatedEventAttributes.Builder> childWorkflowExecutionTerminatedEventAttributes) {
            return childWorkflowExecutionTerminatedEventAttributes(ChildWorkflowExecutionTerminatedEventAttributes.builder()
                    .applyMutation(childWorkflowExecutionTerminatedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param signalExternalWorkflowExecutionInitiatedEventAttributes
         *        If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set
         *        and provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalExternalWorkflowExecutionInitiatedEventAttributes(
                SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SignalExternalWorkflowExecutionInitiatedEventAttributes.Builder} avoiding the need to create one
         * manually via {@link SignalExternalWorkflowExecutionInitiatedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link SignalExternalWorkflowExecutionInitiatedEventAttributes.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #signalExternalWorkflowExecutionInitiatedEventAttributes(SignalExternalWorkflowExecutionInitiatedEventAttributes)}.
         * 
         * @param signalExternalWorkflowExecutionInitiatedEventAttributes
         *        a consumer that will call methods on
         *        {@link SignalExternalWorkflowExecutionInitiatedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalExternalWorkflowExecutionInitiatedEventAttributes(SignalExternalWorkflowExecutionInitiatedEventAttributes)
         */
        default Builder signalExternalWorkflowExecutionInitiatedEventAttributes(
                Consumer<SignalExternalWorkflowExecutionInitiatedEventAttributes.Builder> signalExternalWorkflowExecutionInitiatedEventAttributes) {
            return signalExternalWorkflowExecutionInitiatedEventAttributes(SignalExternalWorkflowExecutionInitiatedEventAttributes
                    .builder().applyMutation(signalExternalWorkflowExecutionInitiatedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param externalWorkflowExecutionSignaledEventAttributes
         *        If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalWorkflowExecutionSignaledEventAttributes(
                ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExternalWorkflowExecutionSignaledEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ExternalWorkflowExecutionSignaledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalWorkflowExecutionSignaledEventAttributes.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #externalWorkflowExecutionSignaledEventAttributes(ExternalWorkflowExecutionSignaledEventAttributes)}.
         * 
         * @param externalWorkflowExecutionSignaledEventAttributes
         *        a consumer that will call methods on {@link ExternalWorkflowExecutionSignaledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalWorkflowExecutionSignaledEventAttributes(ExternalWorkflowExecutionSignaledEventAttributes)
         */
        default Builder externalWorkflowExecutionSignaledEventAttributes(
                Consumer<ExternalWorkflowExecutionSignaledEventAttributes.Builder> externalWorkflowExecutionSignaledEventAttributes) {
            return externalWorkflowExecutionSignaledEventAttributes(ExternalWorkflowExecutionSignaledEventAttributes.builder()
                    .applyMutation(externalWorkflowExecutionSignaledEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param signalExternalWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalExternalWorkflowExecutionFailedEventAttributes(
                SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SignalExternalWorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one manually
         * via {@link SignalExternalWorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link SignalExternalWorkflowExecutionFailedEventAttributes.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #signalExternalWorkflowExecutionFailedEventAttributes(SignalExternalWorkflowExecutionFailedEventAttributes)}.
         * 
         * @param signalExternalWorkflowExecutionFailedEventAttributes
         *        a consumer that will call methods on
         *        {@link SignalExternalWorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalExternalWorkflowExecutionFailedEventAttributes(SignalExternalWorkflowExecutionFailedEventAttributes)
         */
        default Builder signalExternalWorkflowExecutionFailedEventAttributes(
                Consumer<SignalExternalWorkflowExecutionFailedEventAttributes.Builder> signalExternalWorkflowExecutionFailedEventAttributes) {
            return signalExternalWorkflowExecutionFailedEventAttributes(SignalExternalWorkflowExecutionFailedEventAttributes
                    .builder().applyMutation(signalExternalWorkflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param externalWorkflowExecutionCancelRequestedEventAttributes
         *        If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set
         *        and provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalWorkflowExecutionCancelRequestedEventAttributes(
                ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder} avoiding the need to create one
         * manually via {@link ExternalWorkflowExecutionCancelRequestedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #externalWorkflowExecutionCancelRequestedEventAttributes(ExternalWorkflowExecutionCancelRequestedEventAttributes)}.
         * 
         * @param externalWorkflowExecutionCancelRequestedEventAttributes
         *        a consumer that will call methods on
         *        {@link ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalWorkflowExecutionCancelRequestedEventAttributes(ExternalWorkflowExecutionCancelRequestedEventAttributes)
         */
        default Builder externalWorkflowExecutionCancelRequestedEventAttributes(
                Consumer<ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder> externalWorkflowExecutionCancelRequestedEventAttributes) {
            return externalWorkflowExecutionCancelRequestedEventAttributes(ExternalWorkflowExecutionCancelRequestedEventAttributes
                    .builder().applyMutation(externalWorkflowExecutionCancelRequestedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set
         * and provides detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param requestCancelExternalWorkflowExecutionInitiatedEventAttributes
         *        If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member
         *        is set and provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCancelExternalWorkflowExecutionInitiatedEventAttributes(
                RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set
         * and provides detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Builder} avoiding the need to create
         * one manually via {@link RequestCancelExternalWorkflowExecutionInitiatedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #requestCancelExternalWorkflowExecutionInitiatedEventAttributes(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes)}.
         * 
         * @param requestCancelExternalWorkflowExecutionInitiatedEventAttributes
         *        a consumer that will call methods on
         *        {@link RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestCancelExternalWorkflowExecutionInitiatedEventAttributes(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes)
         */
        default Builder requestCancelExternalWorkflowExecutionInitiatedEventAttributes(
                Consumer<RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Builder> requestCancelExternalWorkflowExecutionInitiatedEventAttributes) {
            return requestCancelExternalWorkflowExecutionInitiatedEventAttributes(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
                    .builder().applyMutation(requestCancelExternalWorkflowExecutionInitiatedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param requestCancelExternalWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is
         *        set and provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCancelExternalWorkflowExecutionFailedEventAttributes(
                RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RequestCancelExternalWorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one
         * manually via {@link RequestCancelExternalWorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link RequestCancelExternalWorkflowExecutionFailedEventAttributes.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #requestCancelExternalWorkflowExecutionFailedEventAttributes(RequestCancelExternalWorkflowExecutionFailedEventAttributes)}.
         * 
         * @param requestCancelExternalWorkflowExecutionFailedEventAttributes
         *        a consumer that will call methods on
         *        {@link RequestCancelExternalWorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestCancelExternalWorkflowExecutionFailedEventAttributes(RequestCancelExternalWorkflowExecutionFailedEventAttributes)
         */
        default Builder requestCancelExternalWorkflowExecutionFailedEventAttributes(
                Consumer<RequestCancelExternalWorkflowExecutionFailedEventAttributes.Builder> requestCancelExternalWorkflowExecutionFailedEventAttributes) {
            return requestCancelExternalWorkflowExecutionFailedEventAttributes(RequestCancelExternalWorkflowExecutionFailedEventAttributes
                    .builder().applyMutation(requestCancelExternalWorkflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param scheduleActivityTaskFailedEventAttributes
         *        If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides
         *        detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActivityTaskFailedEventAttributes(
                ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ScheduleActivityTaskFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ScheduleActivityTaskFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleActivityTaskFailedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #scheduleActivityTaskFailedEventAttributes(ScheduleActivityTaskFailedEventAttributes)}.
         * 
         * @param scheduleActivityTaskFailedEventAttributes
         *        a consumer that will call methods on {@link ScheduleActivityTaskFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleActivityTaskFailedEventAttributes(ScheduleActivityTaskFailedEventAttributes)
         */
        default Builder scheduleActivityTaskFailedEventAttributes(
                Consumer<ScheduleActivityTaskFailedEventAttributes.Builder> scheduleActivityTaskFailedEventAttributes) {
            return scheduleActivityTaskFailedEventAttributes(ScheduleActivityTaskFailedEventAttributes.builder()
                    .applyMutation(scheduleActivityTaskFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param requestCancelActivityTaskFailedEventAttributes
         *        If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCancelActivityTaskFailedEventAttributes(
                RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RequestCancelActivityTaskFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link RequestCancelActivityTaskFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestCancelActivityTaskFailedEventAttributes.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #requestCancelActivityTaskFailedEventAttributes(RequestCancelActivityTaskFailedEventAttributes)}.
         * 
         * @param requestCancelActivityTaskFailedEventAttributes
         *        a consumer that will call methods on {@link RequestCancelActivityTaskFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestCancelActivityTaskFailedEventAttributes(RequestCancelActivityTaskFailedEventAttributes)
         */
        default Builder requestCancelActivityTaskFailedEventAttributes(
                Consumer<RequestCancelActivityTaskFailedEventAttributes.Builder> requestCancelActivityTaskFailedEventAttributes) {
            return requestCancelActivityTaskFailedEventAttributes(RequestCancelActivityTaskFailedEventAttributes.builder()
                    .applyMutation(requestCancelActivityTaskFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param startTimerFailedEventAttributes
         *        If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimerFailedEventAttributes(StartTimerFailedEventAttributes startTimerFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartTimerFailedEventAttributes.Builder}
         * avoiding the need to create one manually via {@link StartTimerFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartTimerFailedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #startTimerFailedEventAttributes(StartTimerFailedEventAttributes)}.
         * 
         * @param startTimerFailedEventAttributes
         *        a consumer that will call methods on {@link StartTimerFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimerFailedEventAttributes(StartTimerFailedEventAttributes)
         */
        default Builder startTimerFailedEventAttributes(
                Consumer<StartTimerFailedEventAttributes.Builder> startTimerFailedEventAttributes) {
            return startTimerFailedEventAttributes(StartTimerFailedEventAttributes.builder()
                    .applyMutation(startTimerFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param cancelTimerFailedEventAttributes
         *        If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed
         *        information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelTimerFailedEventAttributes(CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed
         * information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the {@link CancelTimerFailedEventAttributes.Builder}
         * avoiding the need to create one manually via {@link CancelTimerFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CancelTimerFailedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cancelTimerFailedEventAttributes(CancelTimerFailedEventAttributes)}.
         * 
         * @param cancelTimerFailedEventAttributes
         *        a consumer that will call methods on {@link CancelTimerFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cancelTimerFailedEventAttributes(CancelTimerFailedEventAttributes)
         */
        default Builder cancelTimerFailedEventAttributes(
                Consumer<CancelTimerFailedEventAttributes.Builder> cancelTimerFailedEventAttributes) {
            return cancelTimerFailedEventAttributes(CancelTimerFailedEventAttributes.builder()
                    .applyMutation(cancelTimerFailedEventAttributes).build());
        }

        /**
         * <p>
         * If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * 
         * @param startChildWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It isn't set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startChildWorkflowExecutionFailedEventAttributes(
                StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StartChildWorkflowExecutionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link StartChildWorkflowExecutionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartChildWorkflowExecutionFailedEventAttributes.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #startChildWorkflowExecutionFailedEventAttributes(StartChildWorkflowExecutionFailedEventAttributes)}.
         * 
         * @param startChildWorkflowExecutionFailedEventAttributes
         *        a consumer that will call methods on {@link StartChildWorkflowExecutionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startChildWorkflowExecutionFailedEventAttributes(StartChildWorkflowExecutionFailedEventAttributes)
         */
        default Builder startChildWorkflowExecutionFailedEventAttributes(
                Consumer<StartChildWorkflowExecutionFailedEventAttributes.Builder> startChildWorkflowExecutionFailedEventAttributes) {
            return startChildWorkflowExecutionFailedEventAttributes(StartChildWorkflowExecutionFailedEventAttributes.builder()
                    .applyMutation(startChildWorkflowExecutionFailedEventAttributes).build());
        }

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set for other event types.
         * </p>
         * 
         * @param lambdaFunctionScheduledEventAttributes
         *        Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set for other event
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionScheduledEventAttributes(
                LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes);

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LambdaFunctionScheduledEventAttributes.Builder} avoiding the need to create one manually via
         * {@link LambdaFunctionScheduledEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionScheduledEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionScheduledEventAttributes(LambdaFunctionScheduledEventAttributes)}.
         * 
         * @param lambdaFunctionScheduledEventAttributes
         *        a consumer that will call methods on {@link LambdaFunctionScheduledEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionScheduledEventAttributes(LambdaFunctionScheduledEventAttributes)
         */
        default Builder lambdaFunctionScheduledEventAttributes(
                Consumer<LambdaFunctionScheduledEventAttributes.Builder> lambdaFunctionScheduledEventAttributes) {
            return lambdaFunctionScheduledEventAttributes(LambdaFunctionScheduledEventAttributes.builder()
                    .applyMutation(lambdaFunctionScheduledEventAttributes).build());
        }

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for other event types.
         * </p>
         * 
         * @param lambdaFunctionStartedEventAttributes
         *        Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for other event
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionStartedEventAttributes(LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes);

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LambdaFunctionStartedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link LambdaFunctionStartedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionStartedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionStartedEventAttributes(LambdaFunctionStartedEventAttributes)}.
         * 
         * @param lambdaFunctionStartedEventAttributes
         *        a consumer that will call methods on {@link LambdaFunctionStartedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionStartedEventAttributes(LambdaFunctionStartedEventAttributes)
         */
        default Builder lambdaFunctionStartedEventAttributes(
                Consumer<LambdaFunctionStartedEventAttributes.Builder> lambdaFunctionStartedEventAttributes) {
            return lambdaFunctionStartedEventAttributes(LambdaFunctionStartedEventAttributes.builder()
                    .applyMutation(lambdaFunctionStartedEventAttributes).build());
        }

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set for other event types.
         * </p>
         * 
         * @param lambdaFunctionCompletedEventAttributes
         *        Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set for other event
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionCompletedEventAttributes(
                LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes);

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionCompleted</code> event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LambdaFunctionCompletedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link LambdaFunctionCompletedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionCompletedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionCompletedEventAttributes(LambdaFunctionCompletedEventAttributes)}.
         * 
         * @param lambdaFunctionCompletedEventAttributes
         *        a consumer that will call methods on {@link LambdaFunctionCompletedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionCompletedEventAttributes(LambdaFunctionCompletedEventAttributes)
         */
        default Builder lambdaFunctionCompletedEventAttributes(
                Consumer<LambdaFunctionCompletedEventAttributes.Builder> lambdaFunctionCompletedEventAttributes) {
            return lambdaFunctionCompletedEventAttributes(LambdaFunctionCompletedEventAttributes.builder()
                    .applyMutation(lambdaFunctionCompletedEventAttributes).build());
        }

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for other event types.
         * </p>
         * 
         * @param lambdaFunctionFailedEventAttributes
         *        Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for other event
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionFailedEventAttributes(LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes);

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionFailed</code> event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LambdaFunctionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link LambdaFunctionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionFailedEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionFailedEventAttributes(LambdaFunctionFailedEventAttributes)}.
         * 
         * @param lambdaFunctionFailedEventAttributes
         *        a consumer that will call methods on {@link LambdaFunctionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionFailedEventAttributes(LambdaFunctionFailedEventAttributes)
         */
        default Builder lambdaFunctionFailedEventAttributes(
                Consumer<LambdaFunctionFailedEventAttributes.Builder> lambdaFunctionFailedEventAttributes) {
            return lambdaFunctionFailedEventAttributes(LambdaFunctionFailedEventAttributes.builder()
                    .applyMutation(lambdaFunctionFailedEventAttributes).build());
        }

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for other event types.
         * </p>
         * 
         * @param lambdaFunctionTimedOutEventAttributes
         *        Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for other event
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionTimedOutEventAttributes(LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes);

        /**
         * <p>
         * Provides the details of the <code>LambdaFunctionTimedOut</code> event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LambdaFunctionTimedOutEventAttributes.Builder} avoiding the need to create one manually via
         * {@link LambdaFunctionTimedOutEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionTimedOutEventAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionTimedOutEventAttributes(LambdaFunctionTimedOutEventAttributes)}.
         * 
         * @param lambdaFunctionTimedOutEventAttributes
         *        a consumer that will call methods on {@link LambdaFunctionTimedOutEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionTimedOutEventAttributes(LambdaFunctionTimedOutEventAttributes)
         */
        default Builder lambdaFunctionTimedOutEventAttributes(
                Consumer<LambdaFunctionTimedOutEventAttributes.Builder> lambdaFunctionTimedOutEventAttributes) {
            return lambdaFunctionTimedOutEventAttributes(LambdaFunctionTimedOutEventAttributes.builder()
                    .applyMutation(lambdaFunctionTimedOutEventAttributes).build());
        }

        /**
         * <p>
         * Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't set for other event
         * types.
         * </p>
         * 
         * @param scheduleLambdaFunctionFailedEventAttributes
         *        Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't set for other
         *        event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleLambdaFunctionFailedEventAttributes(
                ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes);

        /**
         * <p>
         * Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't set for other event
         * types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ScheduleLambdaFunctionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link ScheduleLambdaFunctionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleLambdaFunctionFailedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #scheduleLambdaFunctionFailedEventAttributes(ScheduleLambdaFunctionFailedEventAttributes)}.
         * 
         * @param scheduleLambdaFunctionFailedEventAttributes
         *        a consumer that will call methods on {@link ScheduleLambdaFunctionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleLambdaFunctionFailedEventAttributes(ScheduleLambdaFunctionFailedEventAttributes)
         */
        default Builder scheduleLambdaFunctionFailedEventAttributes(
                Consumer<ScheduleLambdaFunctionFailedEventAttributes.Builder> scheduleLambdaFunctionFailedEventAttributes) {
            return scheduleLambdaFunctionFailedEventAttributes(ScheduleLambdaFunctionFailedEventAttributes.builder()
                    .applyMutation(scheduleLambdaFunctionFailedEventAttributes).build());
        }

        /**
         * <p>
         * Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set for other event types.
         * </p>
         * 
         * @param startLambdaFunctionFailedEventAttributes
         *        Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set for other event
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startLambdaFunctionFailedEventAttributes(
                StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes);

        /**
         * <p>
         * Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set for other event types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StartLambdaFunctionFailedEventAttributes.Builder} avoiding the need to create one manually via
         * {@link StartLambdaFunctionFailedEventAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartLambdaFunctionFailedEventAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #startLambdaFunctionFailedEventAttributes(StartLambdaFunctionFailedEventAttributes)}.
         * 
         * @param startLambdaFunctionFailedEventAttributes
         *        a consumer that will call methods on {@link StartLambdaFunctionFailedEventAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startLambdaFunctionFailedEventAttributes(StartLambdaFunctionFailedEventAttributes)
         */
        default Builder startLambdaFunctionFailedEventAttributes(
                Consumer<StartLambdaFunctionFailedEventAttributes.Builder> startLambdaFunctionFailedEventAttributes) {
            return startLambdaFunctionFailedEventAttributes(StartLambdaFunctionFailedEventAttributes.builder()
                    .applyMutation(startLambdaFunctionFailedEventAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant eventTimestamp;

        private String eventType;

        private Long eventId;

        private WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes;

        private WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes;

        private CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes;

        private WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes;

        private FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes;

        private WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes;

        private WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes;

        private CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes;

        private WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes;

        private ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes;

        private WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes;

        private WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes;

        private DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes;

        private DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes;

        private DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes;

        private DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes;

        private ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes;

        private ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes;

        private ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes;

        private ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes;

        private ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes;

        private ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes;

        private ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes;

        private WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes;

        private MarkerRecordedEventAttributes markerRecordedEventAttributes;

        private RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes;

        private TimerStartedEventAttributes timerStartedEventAttributes;

        private TimerFiredEventAttributes timerFiredEventAttributes;

        private TimerCanceledEventAttributes timerCanceledEventAttributes;

        private StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes;

        private ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes;

        private ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes;

        private ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes;

        private ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes;

        private ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes;

        private ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes;

        private SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes;

        private ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes;

        private SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes;

        private ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes;

        private RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes;

        private RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes;

        private ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes;

        private RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes;

        private StartTimerFailedEventAttributes startTimerFailedEventAttributes;

        private CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes;

        private StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes;

        private LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes;

        private LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes;

        private LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes;

        private LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes;

        private LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes;

        private ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes;

        private StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryEvent model) {
            eventTimestamp(model.eventTimestamp);
            eventType(model.eventType);
            eventId(model.eventId);
            workflowExecutionStartedEventAttributes(model.workflowExecutionStartedEventAttributes);
            workflowExecutionCompletedEventAttributes(model.workflowExecutionCompletedEventAttributes);
            completeWorkflowExecutionFailedEventAttributes(model.completeWorkflowExecutionFailedEventAttributes);
            workflowExecutionFailedEventAttributes(model.workflowExecutionFailedEventAttributes);
            failWorkflowExecutionFailedEventAttributes(model.failWorkflowExecutionFailedEventAttributes);
            workflowExecutionTimedOutEventAttributes(model.workflowExecutionTimedOutEventAttributes);
            workflowExecutionCanceledEventAttributes(model.workflowExecutionCanceledEventAttributes);
            cancelWorkflowExecutionFailedEventAttributes(model.cancelWorkflowExecutionFailedEventAttributes);
            workflowExecutionContinuedAsNewEventAttributes(model.workflowExecutionContinuedAsNewEventAttributes);
            continueAsNewWorkflowExecutionFailedEventAttributes(model.continueAsNewWorkflowExecutionFailedEventAttributes);
            workflowExecutionTerminatedEventAttributes(model.workflowExecutionTerminatedEventAttributes);
            workflowExecutionCancelRequestedEventAttributes(model.workflowExecutionCancelRequestedEventAttributes);
            decisionTaskScheduledEventAttributes(model.decisionTaskScheduledEventAttributes);
            decisionTaskStartedEventAttributes(model.decisionTaskStartedEventAttributes);
            decisionTaskCompletedEventAttributes(model.decisionTaskCompletedEventAttributes);
            decisionTaskTimedOutEventAttributes(model.decisionTaskTimedOutEventAttributes);
            activityTaskScheduledEventAttributes(model.activityTaskScheduledEventAttributes);
            activityTaskStartedEventAttributes(model.activityTaskStartedEventAttributes);
            activityTaskCompletedEventAttributes(model.activityTaskCompletedEventAttributes);
            activityTaskFailedEventAttributes(model.activityTaskFailedEventAttributes);
            activityTaskTimedOutEventAttributes(model.activityTaskTimedOutEventAttributes);
            activityTaskCanceledEventAttributes(model.activityTaskCanceledEventAttributes);
            activityTaskCancelRequestedEventAttributes(model.activityTaskCancelRequestedEventAttributes);
            workflowExecutionSignaledEventAttributes(model.workflowExecutionSignaledEventAttributes);
            markerRecordedEventAttributes(model.markerRecordedEventAttributes);
            recordMarkerFailedEventAttributes(model.recordMarkerFailedEventAttributes);
            timerStartedEventAttributes(model.timerStartedEventAttributes);
            timerFiredEventAttributes(model.timerFiredEventAttributes);
            timerCanceledEventAttributes(model.timerCanceledEventAttributes);
            startChildWorkflowExecutionInitiatedEventAttributes(model.startChildWorkflowExecutionInitiatedEventAttributes);
            childWorkflowExecutionStartedEventAttributes(model.childWorkflowExecutionStartedEventAttributes);
            childWorkflowExecutionCompletedEventAttributes(model.childWorkflowExecutionCompletedEventAttributes);
            childWorkflowExecutionFailedEventAttributes(model.childWorkflowExecutionFailedEventAttributes);
            childWorkflowExecutionTimedOutEventAttributes(model.childWorkflowExecutionTimedOutEventAttributes);
            childWorkflowExecutionCanceledEventAttributes(model.childWorkflowExecutionCanceledEventAttributes);
            childWorkflowExecutionTerminatedEventAttributes(model.childWorkflowExecutionTerminatedEventAttributes);
            signalExternalWorkflowExecutionInitiatedEventAttributes(model.signalExternalWorkflowExecutionInitiatedEventAttributes);
            externalWorkflowExecutionSignaledEventAttributes(model.externalWorkflowExecutionSignaledEventAttributes);
            signalExternalWorkflowExecutionFailedEventAttributes(model.signalExternalWorkflowExecutionFailedEventAttributes);
            externalWorkflowExecutionCancelRequestedEventAttributes(model.externalWorkflowExecutionCancelRequestedEventAttributes);
            requestCancelExternalWorkflowExecutionInitiatedEventAttributes(model.requestCancelExternalWorkflowExecutionInitiatedEventAttributes);
            requestCancelExternalWorkflowExecutionFailedEventAttributes(model.requestCancelExternalWorkflowExecutionFailedEventAttributes);
            scheduleActivityTaskFailedEventAttributes(model.scheduleActivityTaskFailedEventAttributes);
            requestCancelActivityTaskFailedEventAttributes(model.requestCancelActivityTaskFailedEventAttributes);
            startTimerFailedEventAttributes(model.startTimerFailedEventAttributes);
            cancelTimerFailedEventAttributes(model.cancelTimerFailedEventAttributes);
            startChildWorkflowExecutionFailedEventAttributes(model.startChildWorkflowExecutionFailedEventAttributes);
            lambdaFunctionScheduledEventAttributes(model.lambdaFunctionScheduledEventAttributes);
            lambdaFunctionStartedEventAttributes(model.lambdaFunctionStartedEventAttributes);
            lambdaFunctionCompletedEventAttributes(model.lambdaFunctionCompletedEventAttributes);
            lambdaFunctionFailedEventAttributes(model.lambdaFunctionFailedEventAttributes);
            lambdaFunctionTimedOutEventAttributes(model.lambdaFunctionTimedOutEventAttributes);
            scheduleLambdaFunctionFailedEventAttributes(model.scheduleLambdaFunctionFailedEventAttributes);
            startLambdaFunctionFailedEventAttributes(model.startLambdaFunctionFailedEventAttributes);
        }

        public final Instant getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Long getEventId() {
            return eventId;
        }

        public final void setEventId(Long eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(Long eventId) {
            this.eventId = eventId;
            return this;
        }

        public final WorkflowExecutionStartedEventAttributes.Builder getWorkflowExecutionStartedEventAttributes() {
            return workflowExecutionStartedEventAttributes != null ? workflowExecutionStartedEventAttributes.toBuilder() : null;
        }

        public final void setWorkflowExecutionStartedEventAttributes(
                WorkflowExecutionStartedEventAttributes.BuilderImpl workflowExecutionStartedEventAttributes) {
            this.workflowExecutionStartedEventAttributes = workflowExecutionStartedEventAttributes != null ? workflowExecutionStartedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionStartedEventAttributes(
                WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes) {
            this.workflowExecutionStartedEventAttributes = workflowExecutionStartedEventAttributes;
            return this;
        }

        public final WorkflowExecutionCompletedEventAttributes.Builder getWorkflowExecutionCompletedEventAttributes() {
            return workflowExecutionCompletedEventAttributes != null ? workflowExecutionCompletedEventAttributes.toBuilder()
                    : null;
        }

        public final void setWorkflowExecutionCompletedEventAttributes(
                WorkflowExecutionCompletedEventAttributes.BuilderImpl workflowExecutionCompletedEventAttributes) {
            this.workflowExecutionCompletedEventAttributes = workflowExecutionCompletedEventAttributes != null ? workflowExecutionCompletedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionCompletedEventAttributes(
                WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes) {
            this.workflowExecutionCompletedEventAttributes = workflowExecutionCompletedEventAttributes;
            return this;
        }

        public final CompleteWorkflowExecutionFailedEventAttributes.Builder getCompleteWorkflowExecutionFailedEventAttributes() {
            return completeWorkflowExecutionFailedEventAttributes != null ? completeWorkflowExecutionFailedEventAttributes
                    .toBuilder() : null;
        }

        public final void setCompleteWorkflowExecutionFailedEventAttributes(
                CompleteWorkflowExecutionFailedEventAttributes.BuilderImpl completeWorkflowExecutionFailedEventAttributes) {
            this.completeWorkflowExecutionFailedEventAttributes = completeWorkflowExecutionFailedEventAttributes != null ? completeWorkflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder completeWorkflowExecutionFailedEventAttributes(
                CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes) {
            this.completeWorkflowExecutionFailedEventAttributes = completeWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final WorkflowExecutionFailedEventAttributes.Builder getWorkflowExecutionFailedEventAttributes() {
            return workflowExecutionFailedEventAttributes != null ? workflowExecutionFailedEventAttributes.toBuilder() : null;
        }

        public final void setWorkflowExecutionFailedEventAttributes(
                WorkflowExecutionFailedEventAttributes.BuilderImpl workflowExecutionFailedEventAttributes) {
            this.workflowExecutionFailedEventAttributes = workflowExecutionFailedEventAttributes != null ? workflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionFailedEventAttributes(
                WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes) {
            this.workflowExecutionFailedEventAttributes = workflowExecutionFailedEventAttributes;
            return this;
        }

        public final FailWorkflowExecutionFailedEventAttributes.Builder getFailWorkflowExecutionFailedEventAttributes() {
            return failWorkflowExecutionFailedEventAttributes != null ? failWorkflowExecutionFailedEventAttributes.toBuilder()
                    : null;
        }

        public final void setFailWorkflowExecutionFailedEventAttributes(
                FailWorkflowExecutionFailedEventAttributes.BuilderImpl failWorkflowExecutionFailedEventAttributes) {
            this.failWorkflowExecutionFailedEventAttributes = failWorkflowExecutionFailedEventAttributes != null ? failWorkflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder failWorkflowExecutionFailedEventAttributes(
                FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes) {
            this.failWorkflowExecutionFailedEventAttributes = failWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final WorkflowExecutionTimedOutEventAttributes.Builder getWorkflowExecutionTimedOutEventAttributes() {
            return workflowExecutionTimedOutEventAttributes != null ? workflowExecutionTimedOutEventAttributes.toBuilder() : null;
        }

        public final void setWorkflowExecutionTimedOutEventAttributes(
                WorkflowExecutionTimedOutEventAttributes.BuilderImpl workflowExecutionTimedOutEventAttributes) {
            this.workflowExecutionTimedOutEventAttributes = workflowExecutionTimedOutEventAttributes != null ? workflowExecutionTimedOutEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionTimedOutEventAttributes(
                WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes) {
            this.workflowExecutionTimedOutEventAttributes = workflowExecutionTimedOutEventAttributes;
            return this;
        }

        public final WorkflowExecutionCanceledEventAttributes.Builder getWorkflowExecutionCanceledEventAttributes() {
            return workflowExecutionCanceledEventAttributes != null ? workflowExecutionCanceledEventAttributes.toBuilder() : null;
        }

        public final void setWorkflowExecutionCanceledEventAttributes(
                WorkflowExecutionCanceledEventAttributes.BuilderImpl workflowExecutionCanceledEventAttributes) {
            this.workflowExecutionCanceledEventAttributes = workflowExecutionCanceledEventAttributes != null ? workflowExecutionCanceledEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionCanceledEventAttributes(
                WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes) {
            this.workflowExecutionCanceledEventAttributes = workflowExecutionCanceledEventAttributes;
            return this;
        }

        public final CancelWorkflowExecutionFailedEventAttributes.Builder getCancelWorkflowExecutionFailedEventAttributes() {
            return cancelWorkflowExecutionFailedEventAttributes != null ? cancelWorkflowExecutionFailedEventAttributes
                    .toBuilder() : null;
        }

        public final void setCancelWorkflowExecutionFailedEventAttributes(
                CancelWorkflowExecutionFailedEventAttributes.BuilderImpl cancelWorkflowExecutionFailedEventAttributes) {
            this.cancelWorkflowExecutionFailedEventAttributes = cancelWorkflowExecutionFailedEventAttributes != null ? cancelWorkflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder cancelWorkflowExecutionFailedEventAttributes(
                CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes) {
            this.cancelWorkflowExecutionFailedEventAttributes = cancelWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final WorkflowExecutionContinuedAsNewEventAttributes.Builder getWorkflowExecutionContinuedAsNewEventAttributes() {
            return workflowExecutionContinuedAsNewEventAttributes != null ? workflowExecutionContinuedAsNewEventAttributes
                    .toBuilder() : null;
        }

        public final void setWorkflowExecutionContinuedAsNewEventAttributes(
                WorkflowExecutionContinuedAsNewEventAttributes.BuilderImpl workflowExecutionContinuedAsNewEventAttributes) {
            this.workflowExecutionContinuedAsNewEventAttributes = workflowExecutionContinuedAsNewEventAttributes != null ? workflowExecutionContinuedAsNewEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionContinuedAsNewEventAttributes(
                WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes) {
            this.workflowExecutionContinuedAsNewEventAttributes = workflowExecutionContinuedAsNewEventAttributes;
            return this;
        }

        public final ContinueAsNewWorkflowExecutionFailedEventAttributes.Builder getContinueAsNewWorkflowExecutionFailedEventAttributes() {
            return continueAsNewWorkflowExecutionFailedEventAttributes != null ? continueAsNewWorkflowExecutionFailedEventAttributes
                    .toBuilder() : null;
        }

        public final void setContinueAsNewWorkflowExecutionFailedEventAttributes(
                ContinueAsNewWorkflowExecutionFailedEventAttributes.BuilderImpl continueAsNewWorkflowExecutionFailedEventAttributes) {
            this.continueAsNewWorkflowExecutionFailedEventAttributes = continueAsNewWorkflowExecutionFailedEventAttributes != null ? continueAsNewWorkflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder continueAsNewWorkflowExecutionFailedEventAttributes(
                ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes) {
            this.continueAsNewWorkflowExecutionFailedEventAttributes = continueAsNewWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final WorkflowExecutionTerminatedEventAttributes.Builder getWorkflowExecutionTerminatedEventAttributes() {
            return workflowExecutionTerminatedEventAttributes != null ? workflowExecutionTerminatedEventAttributes.toBuilder()
                    : null;
        }

        public final void setWorkflowExecutionTerminatedEventAttributes(
                WorkflowExecutionTerminatedEventAttributes.BuilderImpl workflowExecutionTerminatedEventAttributes) {
            this.workflowExecutionTerminatedEventAttributes = workflowExecutionTerminatedEventAttributes != null ? workflowExecutionTerminatedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionTerminatedEventAttributes(
                WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes) {
            this.workflowExecutionTerminatedEventAttributes = workflowExecutionTerminatedEventAttributes;
            return this;
        }

        public final WorkflowExecutionCancelRequestedEventAttributes.Builder getWorkflowExecutionCancelRequestedEventAttributes() {
            return workflowExecutionCancelRequestedEventAttributes != null ? workflowExecutionCancelRequestedEventAttributes
                    .toBuilder() : null;
        }

        public final void setWorkflowExecutionCancelRequestedEventAttributes(
                WorkflowExecutionCancelRequestedEventAttributes.BuilderImpl workflowExecutionCancelRequestedEventAttributes) {
            this.workflowExecutionCancelRequestedEventAttributes = workflowExecutionCancelRequestedEventAttributes != null ? workflowExecutionCancelRequestedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionCancelRequestedEventAttributes(
                WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes) {
            this.workflowExecutionCancelRequestedEventAttributes = workflowExecutionCancelRequestedEventAttributes;
            return this;
        }

        public final DecisionTaskScheduledEventAttributes.Builder getDecisionTaskScheduledEventAttributes() {
            return decisionTaskScheduledEventAttributes != null ? decisionTaskScheduledEventAttributes.toBuilder() : null;
        }

        public final void setDecisionTaskScheduledEventAttributes(
                DecisionTaskScheduledEventAttributes.BuilderImpl decisionTaskScheduledEventAttributes) {
            this.decisionTaskScheduledEventAttributes = decisionTaskScheduledEventAttributes != null ? decisionTaskScheduledEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder decisionTaskScheduledEventAttributes(
                DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes) {
            this.decisionTaskScheduledEventAttributes = decisionTaskScheduledEventAttributes;
            return this;
        }

        public final DecisionTaskStartedEventAttributes.Builder getDecisionTaskStartedEventAttributes() {
            return decisionTaskStartedEventAttributes != null ? decisionTaskStartedEventAttributes.toBuilder() : null;
        }

        public final void setDecisionTaskStartedEventAttributes(
                DecisionTaskStartedEventAttributes.BuilderImpl decisionTaskStartedEventAttributes) {
            this.decisionTaskStartedEventAttributes = decisionTaskStartedEventAttributes != null ? decisionTaskStartedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder decisionTaskStartedEventAttributes(
                DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes) {
            this.decisionTaskStartedEventAttributes = decisionTaskStartedEventAttributes;
            return this;
        }

        public final DecisionTaskCompletedEventAttributes.Builder getDecisionTaskCompletedEventAttributes() {
            return decisionTaskCompletedEventAttributes != null ? decisionTaskCompletedEventAttributes.toBuilder() : null;
        }

        public final void setDecisionTaskCompletedEventAttributes(
                DecisionTaskCompletedEventAttributes.BuilderImpl decisionTaskCompletedEventAttributes) {
            this.decisionTaskCompletedEventAttributes = decisionTaskCompletedEventAttributes != null ? decisionTaskCompletedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder decisionTaskCompletedEventAttributes(
                DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes) {
            this.decisionTaskCompletedEventAttributes = decisionTaskCompletedEventAttributes;
            return this;
        }

        public final DecisionTaskTimedOutEventAttributes.Builder getDecisionTaskTimedOutEventAttributes() {
            return decisionTaskTimedOutEventAttributes != null ? decisionTaskTimedOutEventAttributes.toBuilder() : null;
        }

        public final void setDecisionTaskTimedOutEventAttributes(
                DecisionTaskTimedOutEventAttributes.BuilderImpl decisionTaskTimedOutEventAttributes) {
            this.decisionTaskTimedOutEventAttributes = decisionTaskTimedOutEventAttributes != null ? decisionTaskTimedOutEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder decisionTaskTimedOutEventAttributes(
                DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes) {
            this.decisionTaskTimedOutEventAttributes = decisionTaskTimedOutEventAttributes;
            return this;
        }

        public final ActivityTaskScheduledEventAttributes.Builder getActivityTaskScheduledEventAttributes() {
            return activityTaskScheduledEventAttributes != null ? activityTaskScheduledEventAttributes.toBuilder() : null;
        }

        public final void setActivityTaskScheduledEventAttributes(
                ActivityTaskScheduledEventAttributes.BuilderImpl activityTaskScheduledEventAttributes) {
            this.activityTaskScheduledEventAttributes = activityTaskScheduledEventAttributes != null ? activityTaskScheduledEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder activityTaskScheduledEventAttributes(
                ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes) {
            this.activityTaskScheduledEventAttributes = activityTaskScheduledEventAttributes;
            return this;
        }

        public final ActivityTaskStartedEventAttributes.Builder getActivityTaskStartedEventAttributes() {
            return activityTaskStartedEventAttributes != null ? activityTaskStartedEventAttributes.toBuilder() : null;
        }

        public final void setActivityTaskStartedEventAttributes(
                ActivityTaskStartedEventAttributes.BuilderImpl activityTaskStartedEventAttributes) {
            this.activityTaskStartedEventAttributes = activityTaskStartedEventAttributes != null ? activityTaskStartedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder activityTaskStartedEventAttributes(
                ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes) {
            this.activityTaskStartedEventAttributes = activityTaskStartedEventAttributes;
            return this;
        }

        public final ActivityTaskCompletedEventAttributes.Builder getActivityTaskCompletedEventAttributes() {
            return activityTaskCompletedEventAttributes != null ? activityTaskCompletedEventAttributes.toBuilder() : null;
        }

        public final void setActivityTaskCompletedEventAttributes(
                ActivityTaskCompletedEventAttributes.BuilderImpl activityTaskCompletedEventAttributes) {
            this.activityTaskCompletedEventAttributes = activityTaskCompletedEventAttributes != null ? activityTaskCompletedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder activityTaskCompletedEventAttributes(
                ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes) {
            this.activityTaskCompletedEventAttributes = activityTaskCompletedEventAttributes;
            return this;
        }

        public final ActivityTaskFailedEventAttributes.Builder getActivityTaskFailedEventAttributes() {
            return activityTaskFailedEventAttributes != null ? activityTaskFailedEventAttributes.toBuilder() : null;
        }

        public final void setActivityTaskFailedEventAttributes(
                ActivityTaskFailedEventAttributes.BuilderImpl activityTaskFailedEventAttributes) {
            this.activityTaskFailedEventAttributes = activityTaskFailedEventAttributes != null ? activityTaskFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder activityTaskFailedEventAttributes(ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes) {
            this.activityTaskFailedEventAttributes = activityTaskFailedEventAttributes;
            return this;
        }

        public final ActivityTaskTimedOutEventAttributes.Builder getActivityTaskTimedOutEventAttributes() {
            return activityTaskTimedOutEventAttributes != null ? activityTaskTimedOutEventAttributes.toBuilder() : null;
        }

        public final void setActivityTaskTimedOutEventAttributes(
                ActivityTaskTimedOutEventAttributes.BuilderImpl activityTaskTimedOutEventAttributes) {
            this.activityTaskTimedOutEventAttributes = activityTaskTimedOutEventAttributes != null ? activityTaskTimedOutEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder activityTaskTimedOutEventAttributes(
                ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes) {
            this.activityTaskTimedOutEventAttributes = activityTaskTimedOutEventAttributes;
            return this;
        }

        public final ActivityTaskCanceledEventAttributes.Builder getActivityTaskCanceledEventAttributes() {
            return activityTaskCanceledEventAttributes != null ? activityTaskCanceledEventAttributes.toBuilder() : null;
        }

        public final void setActivityTaskCanceledEventAttributes(
                ActivityTaskCanceledEventAttributes.BuilderImpl activityTaskCanceledEventAttributes) {
            this.activityTaskCanceledEventAttributes = activityTaskCanceledEventAttributes != null ? activityTaskCanceledEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder activityTaskCanceledEventAttributes(
                ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes) {
            this.activityTaskCanceledEventAttributes = activityTaskCanceledEventAttributes;
            return this;
        }

        public final ActivityTaskCancelRequestedEventAttributes.Builder getActivityTaskCancelRequestedEventAttributes() {
            return activityTaskCancelRequestedEventAttributes != null ? activityTaskCancelRequestedEventAttributes.toBuilder()
                    : null;
        }

        public final void setActivityTaskCancelRequestedEventAttributes(
                ActivityTaskCancelRequestedEventAttributes.BuilderImpl activityTaskCancelRequestedEventAttributes) {
            this.activityTaskCancelRequestedEventAttributes = activityTaskCancelRequestedEventAttributes != null ? activityTaskCancelRequestedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder activityTaskCancelRequestedEventAttributes(
                ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes) {
            this.activityTaskCancelRequestedEventAttributes = activityTaskCancelRequestedEventAttributes;
            return this;
        }

        public final WorkflowExecutionSignaledEventAttributes.Builder getWorkflowExecutionSignaledEventAttributes() {
            return workflowExecutionSignaledEventAttributes != null ? workflowExecutionSignaledEventAttributes.toBuilder() : null;
        }

        public final void setWorkflowExecutionSignaledEventAttributes(
                WorkflowExecutionSignaledEventAttributes.BuilderImpl workflowExecutionSignaledEventAttributes) {
            this.workflowExecutionSignaledEventAttributes = workflowExecutionSignaledEventAttributes != null ? workflowExecutionSignaledEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder workflowExecutionSignaledEventAttributes(
                WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes) {
            this.workflowExecutionSignaledEventAttributes = workflowExecutionSignaledEventAttributes;
            return this;
        }

        public final MarkerRecordedEventAttributes.Builder getMarkerRecordedEventAttributes() {
            return markerRecordedEventAttributes != null ? markerRecordedEventAttributes.toBuilder() : null;
        }

        public final void setMarkerRecordedEventAttributes(MarkerRecordedEventAttributes.BuilderImpl markerRecordedEventAttributes) {
            this.markerRecordedEventAttributes = markerRecordedEventAttributes != null ? markerRecordedEventAttributes.build()
                    : null;
        }

        @Override
        public final Builder markerRecordedEventAttributes(MarkerRecordedEventAttributes markerRecordedEventAttributes) {
            this.markerRecordedEventAttributes = markerRecordedEventAttributes;
            return this;
        }

        public final RecordMarkerFailedEventAttributes.Builder getRecordMarkerFailedEventAttributes() {
            return recordMarkerFailedEventAttributes != null ? recordMarkerFailedEventAttributes.toBuilder() : null;
        }

        public final void setRecordMarkerFailedEventAttributes(
                RecordMarkerFailedEventAttributes.BuilderImpl recordMarkerFailedEventAttributes) {
            this.recordMarkerFailedEventAttributes = recordMarkerFailedEventAttributes != null ? recordMarkerFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder recordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes) {
            this.recordMarkerFailedEventAttributes = recordMarkerFailedEventAttributes;
            return this;
        }

        public final TimerStartedEventAttributes.Builder getTimerStartedEventAttributes() {
            return timerStartedEventAttributes != null ? timerStartedEventAttributes.toBuilder() : null;
        }

        public final void setTimerStartedEventAttributes(TimerStartedEventAttributes.BuilderImpl timerStartedEventAttributes) {
            this.timerStartedEventAttributes = timerStartedEventAttributes != null ? timerStartedEventAttributes.build() : null;
        }

        @Override
        public final Builder timerStartedEventAttributes(TimerStartedEventAttributes timerStartedEventAttributes) {
            this.timerStartedEventAttributes = timerStartedEventAttributes;
            return this;
        }

        public final TimerFiredEventAttributes.Builder getTimerFiredEventAttributes() {
            return timerFiredEventAttributes != null ? timerFiredEventAttributes.toBuilder() : null;
        }

        public final void setTimerFiredEventAttributes(TimerFiredEventAttributes.BuilderImpl timerFiredEventAttributes) {
            this.timerFiredEventAttributes = timerFiredEventAttributes != null ? timerFiredEventAttributes.build() : null;
        }

        @Override
        public final Builder timerFiredEventAttributes(TimerFiredEventAttributes timerFiredEventAttributes) {
            this.timerFiredEventAttributes = timerFiredEventAttributes;
            return this;
        }

        public final TimerCanceledEventAttributes.Builder getTimerCanceledEventAttributes() {
            return timerCanceledEventAttributes != null ? timerCanceledEventAttributes.toBuilder() : null;
        }

        public final void setTimerCanceledEventAttributes(TimerCanceledEventAttributes.BuilderImpl timerCanceledEventAttributes) {
            this.timerCanceledEventAttributes = timerCanceledEventAttributes != null ? timerCanceledEventAttributes.build()
                    : null;
        }

        @Override
        public final Builder timerCanceledEventAttributes(TimerCanceledEventAttributes timerCanceledEventAttributes) {
            this.timerCanceledEventAttributes = timerCanceledEventAttributes;
            return this;
        }

        public final StartChildWorkflowExecutionInitiatedEventAttributes.Builder getStartChildWorkflowExecutionInitiatedEventAttributes() {
            return startChildWorkflowExecutionInitiatedEventAttributes != null ? startChildWorkflowExecutionInitiatedEventAttributes
                    .toBuilder() : null;
        }

        public final void setStartChildWorkflowExecutionInitiatedEventAttributes(
                StartChildWorkflowExecutionInitiatedEventAttributes.BuilderImpl startChildWorkflowExecutionInitiatedEventAttributes) {
            this.startChildWorkflowExecutionInitiatedEventAttributes = startChildWorkflowExecutionInitiatedEventAttributes != null ? startChildWorkflowExecutionInitiatedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder startChildWorkflowExecutionInitiatedEventAttributes(
                StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes) {
            this.startChildWorkflowExecutionInitiatedEventAttributes = startChildWorkflowExecutionInitiatedEventAttributes;
            return this;
        }

        public final ChildWorkflowExecutionStartedEventAttributes.Builder getChildWorkflowExecutionStartedEventAttributes() {
            return childWorkflowExecutionStartedEventAttributes != null ? childWorkflowExecutionStartedEventAttributes
                    .toBuilder() : null;
        }

        public final void setChildWorkflowExecutionStartedEventAttributes(
                ChildWorkflowExecutionStartedEventAttributes.BuilderImpl childWorkflowExecutionStartedEventAttributes) {
            this.childWorkflowExecutionStartedEventAttributes = childWorkflowExecutionStartedEventAttributes != null ? childWorkflowExecutionStartedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder childWorkflowExecutionStartedEventAttributes(
                ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes) {
            this.childWorkflowExecutionStartedEventAttributes = childWorkflowExecutionStartedEventAttributes;
            return this;
        }

        public final ChildWorkflowExecutionCompletedEventAttributes.Builder getChildWorkflowExecutionCompletedEventAttributes() {
            return childWorkflowExecutionCompletedEventAttributes != null ? childWorkflowExecutionCompletedEventAttributes
                    .toBuilder() : null;
        }

        public final void setChildWorkflowExecutionCompletedEventAttributes(
                ChildWorkflowExecutionCompletedEventAttributes.BuilderImpl childWorkflowExecutionCompletedEventAttributes) {
            this.childWorkflowExecutionCompletedEventAttributes = childWorkflowExecutionCompletedEventAttributes != null ? childWorkflowExecutionCompletedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder childWorkflowExecutionCompletedEventAttributes(
                ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes) {
            this.childWorkflowExecutionCompletedEventAttributes = childWorkflowExecutionCompletedEventAttributes;
            return this;
        }

        public final ChildWorkflowExecutionFailedEventAttributes.Builder getChildWorkflowExecutionFailedEventAttributes() {
            return childWorkflowExecutionFailedEventAttributes != null ? childWorkflowExecutionFailedEventAttributes.toBuilder()
                    : null;
        }

        public final void setChildWorkflowExecutionFailedEventAttributes(
                ChildWorkflowExecutionFailedEventAttributes.BuilderImpl childWorkflowExecutionFailedEventAttributes) {
            this.childWorkflowExecutionFailedEventAttributes = childWorkflowExecutionFailedEventAttributes != null ? childWorkflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder childWorkflowExecutionFailedEventAttributes(
                ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes) {
            this.childWorkflowExecutionFailedEventAttributes = childWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final ChildWorkflowExecutionTimedOutEventAttributes.Builder getChildWorkflowExecutionTimedOutEventAttributes() {
            return childWorkflowExecutionTimedOutEventAttributes != null ? childWorkflowExecutionTimedOutEventAttributes
                    .toBuilder() : null;
        }

        public final void setChildWorkflowExecutionTimedOutEventAttributes(
                ChildWorkflowExecutionTimedOutEventAttributes.BuilderImpl childWorkflowExecutionTimedOutEventAttributes) {
            this.childWorkflowExecutionTimedOutEventAttributes = childWorkflowExecutionTimedOutEventAttributes != null ? childWorkflowExecutionTimedOutEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder childWorkflowExecutionTimedOutEventAttributes(
                ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes) {
            this.childWorkflowExecutionTimedOutEventAttributes = childWorkflowExecutionTimedOutEventAttributes;
            return this;
        }

        public final ChildWorkflowExecutionCanceledEventAttributes.Builder getChildWorkflowExecutionCanceledEventAttributes() {
            return childWorkflowExecutionCanceledEventAttributes != null ? childWorkflowExecutionCanceledEventAttributes
                    .toBuilder() : null;
        }

        public final void setChildWorkflowExecutionCanceledEventAttributes(
                ChildWorkflowExecutionCanceledEventAttributes.BuilderImpl childWorkflowExecutionCanceledEventAttributes) {
            this.childWorkflowExecutionCanceledEventAttributes = childWorkflowExecutionCanceledEventAttributes != null ? childWorkflowExecutionCanceledEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder childWorkflowExecutionCanceledEventAttributes(
                ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes) {
            this.childWorkflowExecutionCanceledEventAttributes = childWorkflowExecutionCanceledEventAttributes;
            return this;
        }

        public final ChildWorkflowExecutionTerminatedEventAttributes.Builder getChildWorkflowExecutionTerminatedEventAttributes() {
            return childWorkflowExecutionTerminatedEventAttributes != null ? childWorkflowExecutionTerminatedEventAttributes
                    .toBuilder() : null;
        }

        public final void setChildWorkflowExecutionTerminatedEventAttributes(
                ChildWorkflowExecutionTerminatedEventAttributes.BuilderImpl childWorkflowExecutionTerminatedEventAttributes) {
            this.childWorkflowExecutionTerminatedEventAttributes = childWorkflowExecutionTerminatedEventAttributes != null ? childWorkflowExecutionTerminatedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder childWorkflowExecutionTerminatedEventAttributes(
                ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes) {
            this.childWorkflowExecutionTerminatedEventAttributes = childWorkflowExecutionTerminatedEventAttributes;
            return this;
        }

        public final SignalExternalWorkflowExecutionInitiatedEventAttributes.Builder getSignalExternalWorkflowExecutionInitiatedEventAttributes() {
            return signalExternalWorkflowExecutionInitiatedEventAttributes != null ? signalExternalWorkflowExecutionInitiatedEventAttributes
                    .toBuilder() : null;
        }

        public final void setSignalExternalWorkflowExecutionInitiatedEventAttributes(
                SignalExternalWorkflowExecutionInitiatedEventAttributes.BuilderImpl signalExternalWorkflowExecutionInitiatedEventAttributes) {
            this.signalExternalWorkflowExecutionInitiatedEventAttributes = signalExternalWorkflowExecutionInitiatedEventAttributes != null ? signalExternalWorkflowExecutionInitiatedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder signalExternalWorkflowExecutionInitiatedEventAttributes(
                SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes) {
            this.signalExternalWorkflowExecutionInitiatedEventAttributes = signalExternalWorkflowExecutionInitiatedEventAttributes;
            return this;
        }

        public final ExternalWorkflowExecutionSignaledEventAttributes.Builder getExternalWorkflowExecutionSignaledEventAttributes() {
            return externalWorkflowExecutionSignaledEventAttributes != null ? externalWorkflowExecutionSignaledEventAttributes
                    .toBuilder() : null;
        }

        public final void setExternalWorkflowExecutionSignaledEventAttributes(
                ExternalWorkflowExecutionSignaledEventAttributes.BuilderImpl externalWorkflowExecutionSignaledEventAttributes) {
            this.externalWorkflowExecutionSignaledEventAttributes = externalWorkflowExecutionSignaledEventAttributes != null ? externalWorkflowExecutionSignaledEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder externalWorkflowExecutionSignaledEventAttributes(
                ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes) {
            this.externalWorkflowExecutionSignaledEventAttributes = externalWorkflowExecutionSignaledEventAttributes;
            return this;
        }

        public final SignalExternalWorkflowExecutionFailedEventAttributes.Builder getSignalExternalWorkflowExecutionFailedEventAttributes() {
            return signalExternalWorkflowExecutionFailedEventAttributes != null ? signalExternalWorkflowExecutionFailedEventAttributes
                    .toBuilder() : null;
        }

        public final void setSignalExternalWorkflowExecutionFailedEventAttributes(
                SignalExternalWorkflowExecutionFailedEventAttributes.BuilderImpl signalExternalWorkflowExecutionFailedEventAttributes) {
            this.signalExternalWorkflowExecutionFailedEventAttributes = signalExternalWorkflowExecutionFailedEventAttributes != null ? signalExternalWorkflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder signalExternalWorkflowExecutionFailedEventAttributes(
                SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes) {
            this.signalExternalWorkflowExecutionFailedEventAttributes = signalExternalWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder getExternalWorkflowExecutionCancelRequestedEventAttributes() {
            return externalWorkflowExecutionCancelRequestedEventAttributes != null ? externalWorkflowExecutionCancelRequestedEventAttributes
                    .toBuilder() : null;
        }

        public final void setExternalWorkflowExecutionCancelRequestedEventAttributes(
                ExternalWorkflowExecutionCancelRequestedEventAttributes.BuilderImpl externalWorkflowExecutionCancelRequestedEventAttributes) {
            this.externalWorkflowExecutionCancelRequestedEventAttributes = externalWorkflowExecutionCancelRequestedEventAttributes != null ? externalWorkflowExecutionCancelRequestedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder externalWorkflowExecutionCancelRequestedEventAttributes(
                ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes) {
            this.externalWorkflowExecutionCancelRequestedEventAttributes = externalWorkflowExecutionCancelRequestedEventAttributes;
            return this;
        }

        public final RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Builder getRequestCancelExternalWorkflowExecutionInitiatedEventAttributes() {
            return requestCancelExternalWorkflowExecutionInitiatedEventAttributes != null ? requestCancelExternalWorkflowExecutionInitiatedEventAttributes
                    .toBuilder() : null;
        }

        public final void setRequestCancelExternalWorkflowExecutionInitiatedEventAttributes(
                RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.BuilderImpl requestCancelExternalWorkflowExecutionInitiatedEventAttributes) {
            this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes = requestCancelExternalWorkflowExecutionInitiatedEventAttributes != null ? requestCancelExternalWorkflowExecutionInitiatedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder requestCancelExternalWorkflowExecutionInitiatedEventAttributes(
                RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes) {
            this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes = requestCancelExternalWorkflowExecutionInitiatedEventAttributes;
            return this;
        }

        public final RequestCancelExternalWorkflowExecutionFailedEventAttributes.Builder getRequestCancelExternalWorkflowExecutionFailedEventAttributes() {
            return requestCancelExternalWorkflowExecutionFailedEventAttributes != null ? requestCancelExternalWorkflowExecutionFailedEventAttributes
                    .toBuilder() : null;
        }

        public final void setRequestCancelExternalWorkflowExecutionFailedEventAttributes(
                RequestCancelExternalWorkflowExecutionFailedEventAttributes.BuilderImpl requestCancelExternalWorkflowExecutionFailedEventAttributes) {
            this.requestCancelExternalWorkflowExecutionFailedEventAttributes = requestCancelExternalWorkflowExecutionFailedEventAttributes != null ? requestCancelExternalWorkflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder requestCancelExternalWorkflowExecutionFailedEventAttributes(
                RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes) {
            this.requestCancelExternalWorkflowExecutionFailedEventAttributes = requestCancelExternalWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final ScheduleActivityTaskFailedEventAttributes.Builder getScheduleActivityTaskFailedEventAttributes() {
            return scheduleActivityTaskFailedEventAttributes != null ? scheduleActivityTaskFailedEventAttributes.toBuilder()
                    : null;
        }

        public final void setScheduleActivityTaskFailedEventAttributes(
                ScheduleActivityTaskFailedEventAttributes.BuilderImpl scheduleActivityTaskFailedEventAttributes) {
            this.scheduleActivityTaskFailedEventAttributes = scheduleActivityTaskFailedEventAttributes != null ? scheduleActivityTaskFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder scheduleActivityTaskFailedEventAttributes(
                ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes) {
            this.scheduleActivityTaskFailedEventAttributes = scheduleActivityTaskFailedEventAttributes;
            return this;
        }

        public final RequestCancelActivityTaskFailedEventAttributes.Builder getRequestCancelActivityTaskFailedEventAttributes() {
            return requestCancelActivityTaskFailedEventAttributes != null ? requestCancelActivityTaskFailedEventAttributes
                    .toBuilder() : null;
        }

        public final void setRequestCancelActivityTaskFailedEventAttributes(
                RequestCancelActivityTaskFailedEventAttributes.BuilderImpl requestCancelActivityTaskFailedEventAttributes) {
            this.requestCancelActivityTaskFailedEventAttributes = requestCancelActivityTaskFailedEventAttributes != null ? requestCancelActivityTaskFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder requestCancelActivityTaskFailedEventAttributes(
                RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes) {
            this.requestCancelActivityTaskFailedEventAttributes = requestCancelActivityTaskFailedEventAttributes;
            return this;
        }

        public final StartTimerFailedEventAttributes.Builder getStartTimerFailedEventAttributes() {
            return startTimerFailedEventAttributes != null ? startTimerFailedEventAttributes.toBuilder() : null;
        }

        public final void setStartTimerFailedEventAttributes(
                StartTimerFailedEventAttributes.BuilderImpl startTimerFailedEventAttributes) {
            this.startTimerFailedEventAttributes = startTimerFailedEventAttributes != null ? startTimerFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder startTimerFailedEventAttributes(StartTimerFailedEventAttributes startTimerFailedEventAttributes) {
            this.startTimerFailedEventAttributes = startTimerFailedEventAttributes;
            return this;
        }

        public final CancelTimerFailedEventAttributes.Builder getCancelTimerFailedEventAttributes() {
            return cancelTimerFailedEventAttributes != null ? cancelTimerFailedEventAttributes.toBuilder() : null;
        }

        public final void setCancelTimerFailedEventAttributes(
                CancelTimerFailedEventAttributes.BuilderImpl cancelTimerFailedEventAttributes) {
            this.cancelTimerFailedEventAttributes = cancelTimerFailedEventAttributes != null ? cancelTimerFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder cancelTimerFailedEventAttributes(CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes) {
            this.cancelTimerFailedEventAttributes = cancelTimerFailedEventAttributes;
            return this;
        }

        public final StartChildWorkflowExecutionFailedEventAttributes.Builder getStartChildWorkflowExecutionFailedEventAttributes() {
            return startChildWorkflowExecutionFailedEventAttributes != null ? startChildWorkflowExecutionFailedEventAttributes
                    .toBuilder() : null;
        }

        public final void setStartChildWorkflowExecutionFailedEventAttributes(
                StartChildWorkflowExecutionFailedEventAttributes.BuilderImpl startChildWorkflowExecutionFailedEventAttributes) {
            this.startChildWorkflowExecutionFailedEventAttributes = startChildWorkflowExecutionFailedEventAttributes != null ? startChildWorkflowExecutionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder startChildWorkflowExecutionFailedEventAttributes(
                StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes) {
            this.startChildWorkflowExecutionFailedEventAttributes = startChildWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final LambdaFunctionScheduledEventAttributes.Builder getLambdaFunctionScheduledEventAttributes() {
            return lambdaFunctionScheduledEventAttributes != null ? lambdaFunctionScheduledEventAttributes.toBuilder() : null;
        }

        public final void setLambdaFunctionScheduledEventAttributes(
                LambdaFunctionScheduledEventAttributes.BuilderImpl lambdaFunctionScheduledEventAttributes) {
            this.lambdaFunctionScheduledEventAttributes = lambdaFunctionScheduledEventAttributes != null ? lambdaFunctionScheduledEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder lambdaFunctionScheduledEventAttributes(
                LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes) {
            this.lambdaFunctionScheduledEventAttributes = lambdaFunctionScheduledEventAttributes;
            return this;
        }

        public final LambdaFunctionStartedEventAttributes.Builder getLambdaFunctionStartedEventAttributes() {
            return lambdaFunctionStartedEventAttributes != null ? lambdaFunctionStartedEventAttributes.toBuilder() : null;
        }

        public final void setLambdaFunctionStartedEventAttributes(
                LambdaFunctionStartedEventAttributes.BuilderImpl lambdaFunctionStartedEventAttributes) {
            this.lambdaFunctionStartedEventAttributes = lambdaFunctionStartedEventAttributes != null ? lambdaFunctionStartedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder lambdaFunctionStartedEventAttributes(
                LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes) {
            this.lambdaFunctionStartedEventAttributes = lambdaFunctionStartedEventAttributes;
            return this;
        }

        public final LambdaFunctionCompletedEventAttributes.Builder getLambdaFunctionCompletedEventAttributes() {
            return lambdaFunctionCompletedEventAttributes != null ? lambdaFunctionCompletedEventAttributes.toBuilder() : null;
        }

        public final void setLambdaFunctionCompletedEventAttributes(
                LambdaFunctionCompletedEventAttributes.BuilderImpl lambdaFunctionCompletedEventAttributes) {
            this.lambdaFunctionCompletedEventAttributes = lambdaFunctionCompletedEventAttributes != null ? lambdaFunctionCompletedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder lambdaFunctionCompletedEventAttributes(
                LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes) {
            this.lambdaFunctionCompletedEventAttributes = lambdaFunctionCompletedEventAttributes;
            return this;
        }

        public final LambdaFunctionFailedEventAttributes.Builder getLambdaFunctionFailedEventAttributes() {
            return lambdaFunctionFailedEventAttributes != null ? lambdaFunctionFailedEventAttributes.toBuilder() : null;
        }

        public final void setLambdaFunctionFailedEventAttributes(
                LambdaFunctionFailedEventAttributes.BuilderImpl lambdaFunctionFailedEventAttributes) {
            this.lambdaFunctionFailedEventAttributes = lambdaFunctionFailedEventAttributes != null ? lambdaFunctionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder lambdaFunctionFailedEventAttributes(
                LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes) {
            this.lambdaFunctionFailedEventAttributes = lambdaFunctionFailedEventAttributes;
            return this;
        }

        public final LambdaFunctionTimedOutEventAttributes.Builder getLambdaFunctionTimedOutEventAttributes() {
            return lambdaFunctionTimedOutEventAttributes != null ? lambdaFunctionTimedOutEventAttributes.toBuilder() : null;
        }

        public final void setLambdaFunctionTimedOutEventAttributes(
                LambdaFunctionTimedOutEventAttributes.BuilderImpl lambdaFunctionTimedOutEventAttributes) {
            this.lambdaFunctionTimedOutEventAttributes = lambdaFunctionTimedOutEventAttributes != null ? lambdaFunctionTimedOutEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder lambdaFunctionTimedOutEventAttributes(
                LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes) {
            this.lambdaFunctionTimedOutEventAttributes = lambdaFunctionTimedOutEventAttributes;
            return this;
        }

        public final ScheduleLambdaFunctionFailedEventAttributes.Builder getScheduleLambdaFunctionFailedEventAttributes() {
            return scheduleLambdaFunctionFailedEventAttributes != null ? scheduleLambdaFunctionFailedEventAttributes.toBuilder()
                    : null;
        }

        public final void setScheduleLambdaFunctionFailedEventAttributes(
                ScheduleLambdaFunctionFailedEventAttributes.BuilderImpl scheduleLambdaFunctionFailedEventAttributes) {
            this.scheduleLambdaFunctionFailedEventAttributes = scheduleLambdaFunctionFailedEventAttributes != null ? scheduleLambdaFunctionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder scheduleLambdaFunctionFailedEventAttributes(
                ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes) {
            this.scheduleLambdaFunctionFailedEventAttributes = scheduleLambdaFunctionFailedEventAttributes;
            return this;
        }

        public final StartLambdaFunctionFailedEventAttributes.Builder getStartLambdaFunctionFailedEventAttributes() {
            return startLambdaFunctionFailedEventAttributes != null ? startLambdaFunctionFailedEventAttributes.toBuilder() : null;
        }

        public final void setStartLambdaFunctionFailedEventAttributes(
                StartLambdaFunctionFailedEventAttributes.BuilderImpl startLambdaFunctionFailedEventAttributes) {
            this.startLambdaFunctionFailedEventAttributes = startLambdaFunctionFailedEventAttributes != null ? startLambdaFunctionFailedEventAttributes
                    .build() : null;
        }

        @Override
        public final Builder startLambdaFunctionFailedEventAttributes(
                StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes) {
            this.startLambdaFunctionFailedEventAttributes = startLambdaFunctionFailedEventAttributes;
            return this;
        }

        @Override
        public HistoryEvent build() {
            return new HistoryEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
