/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.DateInterval;
import software.amazon.awssdk.services.support.model.DatesWithoutSupportListCopier;
import software.amazon.awssdk.services.support.model.SupportedHour;
import software.amazon.awssdk.services.support.model.SupportedHoursListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommunicationTypeOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommunicationTypeOptions> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CommunicationTypeOptions.getter(CommunicationTypeOptions::type)).setter(CommunicationTypeOptions.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<SupportedHour>> SUPPORTED_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedHours").getter(CommunicationTypeOptions.getter(CommunicationTypeOptions::supportedHours)).setter(CommunicationTypeOptions.setter(Builder::supportedHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedHours").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportedHour::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DateInterval>> DATES_WITHOUT_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datesWithoutSupport").getter(CommunicationTypeOptions.getter(CommunicationTypeOptions::datesWithoutSupport)).setter(CommunicationTypeOptions.setter(Builder::datesWithoutSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datesWithoutSupport").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SUPPORTED_HOURS_FIELD, DATES_WITHOUT_SUPPORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<SupportedHour> supportedHours;
    private final List<DateInterval> datesWithoutSupport;

    private CommunicationTypeOptions(BuilderImpl builder) {
        this.type = builder.type;
        this.supportedHours = builder.supportedHours;
        this.datesWithoutSupport = builder.datesWithoutSupport;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasSupportedHours() {
        return this.supportedHours != null && !(this.supportedHours instanceof SdkAutoConstructList);
    }

    public final List<SupportedHour> supportedHours() {
        return this.supportedHours;
    }

    public final boolean hasDatesWithoutSupport() {
        return this.datesWithoutSupport != null && !(this.datesWithoutSupport instanceof SdkAutoConstructList);
    }

    public final List<DateInterval> datesWithoutSupport() {
        return this.datesWithoutSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedHours() ? this.supportedHours() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatesWithoutSupport() ? this.datesWithoutSupport() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommunicationTypeOptions)) {
            return false;
        }
        CommunicationTypeOptions other = (CommunicationTypeOptions)obj;
        return Objects.equals(this.type(), other.type()) && this.hasSupportedHours() == other.hasSupportedHours() && Objects.equals(this.supportedHours(), other.supportedHours()) && this.hasDatesWithoutSupport() == other.hasDatesWithoutSupport() && Objects.equals(this.datesWithoutSupport(), other.datesWithoutSupport());
    }

    public final String toString() {
        return ToString.builder((String)"CommunicationTypeOptions").add("Type", (Object)this.type()).add("SupportedHours", this.hasSupportedHours() ? this.supportedHours() : null).add("DatesWithoutSupport", this.hasDatesWithoutSupport() ? this.datesWithoutSupport() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "supportedHours": {
                return Optional.ofNullable(clazz.cast(this.supportedHours()));
            }
            case "datesWithoutSupport": {
                return Optional.ofNullable(clazz.cast(this.datesWithoutSupport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommunicationTypeOptions, T> g) {
        return obj -> g.apply((CommunicationTypeOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<SupportedHour> supportedHours = DefaultSdkAutoConstructList.getInstance();
        private List<DateInterval> datesWithoutSupport = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CommunicationTypeOptions model) {
            this.type(model.type);
            this.supportedHours(model.supportedHours);
            this.datesWithoutSupport(model.datesWithoutSupport);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<SupportedHour.Builder> getSupportedHours() {
            List<SupportedHour.Builder> result = SupportedHoursListCopier.copyToBuilder(this.supportedHours);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedHours(Collection<SupportedHour.BuilderImpl> supportedHours) {
            this.supportedHours = SupportedHoursListCopier.copyFromBuilder(supportedHours);
        }

        @Override
        public final Builder supportedHours(Collection<SupportedHour> supportedHours) {
            this.supportedHours = SupportedHoursListCopier.copy(supportedHours);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedHours(SupportedHour ... supportedHours) {
            this.supportedHours(Arrays.asList(supportedHours));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedHours(Consumer<SupportedHour.Builder> ... supportedHours) {
            this.supportedHours(Stream.of(supportedHours).map(c -> (SupportedHour)((SupportedHour.Builder)SupportedHour.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DateInterval.Builder> getDatesWithoutSupport() {
            List<DateInterval.Builder> result = DatesWithoutSupportListCopier.copyToBuilder(this.datesWithoutSupport);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatesWithoutSupport(Collection<DateInterval.BuilderImpl> datesWithoutSupport) {
            this.datesWithoutSupport = DatesWithoutSupportListCopier.copyFromBuilder(datesWithoutSupport);
        }

        @Override
        public final Builder datesWithoutSupport(Collection<DateInterval> datesWithoutSupport) {
            this.datesWithoutSupport = DatesWithoutSupportListCopier.copy(datesWithoutSupport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datesWithoutSupport(DateInterval ... datesWithoutSupport) {
            this.datesWithoutSupport(Arrays.asList(datesWithoutSupport));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datesWithoutSupport(Consumer<DateInterval.Builder> ... datesWithoutSupport) {
            this.datesWithoutSupport(Stream.of(datesWithoutSupport).map(c -> (DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CommunicationTypeOptions build() {
            return new CommunicationTypeOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommunicationTypeOptions> {
        public Builder type(String var1);

        public Builder supportedHours(Collection<SupportedHour> var1);

        public Builder supportedHours(SupportedHour ... var1);

        public Builder supportedHours(Consumer<SupportedHour.Builder> ... var1);

        public Builder datesWithoutSupport(Collection<DateInterval> var1);

        public Builder datesWithoutSupport(DateInterval ... var1);

        public Builder datesWithoutSupport(Consumer<DateInterval.Builder> ... var1);
    }
}

